# Welcome

Clojure library for Weather Underground

<a href="https://www.wunderground.com">
  <img src="https://icons.wxug.com/logos/PNG/wundergroundLogo_4c_horz.png" height="50" />
</a>

## Latest version [![CircleCI](https://circleci.com/gh/sultanov-team/clj-weather-underground/tree/master.svg?style=svg)](https://circleci.com/gh/sultanov-team/clj-weather-underground/tree/master)

[![Clojars Project](https://img.shields.io/clojars/v/team.sultanov/clj-weather-underground.svg)](https://clojars.org/team.sultanov/clj-weather-underground)



## Getting Started

Add the necessary dependency to your project:

### Leiningen/Boot
```clojure
[team.sultanov/clj-weather-underground "0.1.0"]
```

### Clojure CLI/deps.edn
```clojure
team.sultanov/clj-weather-underground {:mvn/version "0.1.0"}
```


## Quick Start

### Requirements

```bash
#!/bin/bash
export WEATHER_UNDERGROUND_API_URL="http://api.wunderground.com/api"
export WEATHER_UNDERGROUND_API_FORMAT="json"            # JSON FORMAT ONLY
export WEATHER_UNDERGROUND_API_KEY="ABCDEFGHIJKLMN"     # YOUR API KEY
export WEATHER_UNDERGROUND_API_MAX_CALLS_PER_DAY=500    # YOUR PLAN MAX CALLS PER DAY
export WEATHER_UNDERGROUND_API_MAX_CALLS_PER_MINUTE=10  # YOUR PLAN MAX CALLS PER MINUTE
```


### Weather Underground API

```clojure
(ns example
  (:require [clj-weather-underground.core :as weather-underground]))

(weather-underground/fetch :alerts         "zmw:00000.4.27612")
(weather-underground/fetch :almanac        "zmw:00000.4.27612")
(weather-underground/fetch :astronomy      "zmw:00000.4.27612")
(weather-underground/fetch :conditions     "zmw:00000.4.27612")

(weather-underground/fetch :current-hurricane)

(weather-underground/fetch :forecast       "zmw:00000.4.27612")
(weather-underground/fetch :forecast-10day "zmw:00000.4.27612")

(weather-underground/fetch :geolookup       55.755826 37.6172999)

(weather-underground/fetch :history        "zmw:00000.4.27612" "20180101")
(weather-underground/fetch :hourly         "zmw:00000.4.27612")
(weather-underground/fetch :hourly-10day   "zmw:00000.4.27612")
(weather-underground/fetch :planner        "zmw:00000.4.27612" "0101" "0131")
(weather-underground/fetch :raw-tide       "zmw:00000.4.27612")
(weather-underground/fetch :satellite      "zmw:00000.4.27612")
(weather-underground/fetch :tide           "zmw:00000.4.27612")
(weather-underground/fetch :webcams        "zmw:00000.4.27612")
(weather-underground/fetch :yesterday      "zmw:00000.4.27612")
```



## License

Copyright © 2018 Sultanov Team

[![MIT License](https://img.shields.io/github/license/mashape/apistatus.svg)](LICENSE)
