(defproject team.sultanov/clj-weather-underground "0.1.0"
  :description    "Clojure library for Weather Underground"
  :url            "https://github.com/sultanov-team/clj-weather-underground"
  :license        {:name "MIT License"
                   :url  "https://github.com/sultanov-team/clj-weather-underground/blob/master/LICENSE"}

  :dependencies   [[org.clojure/clojure "1.9.0"]
                   [clj-http            "3.7.0"]]

  :profiles       {:dev {:plugins      [[lein-ancient                      "0.6.15"]
                                        [com.jakemccrary/lein-test-refresh "0.22.0"]]
                         :repl-options {:host "0.0.0.0"
                                        :port 7000}}}
  :scm            {:name "git"
                   :url  "https://github.com/sultanov-team/clj-weather-underground"}

  :deploy-branches     ["master"]
  :deploy-repositories [["snapshots" {:url      "https://clojars.org/repo"
                                      :username [:gpg :env/sultanov_team_clojars_username]
                                      :password [:gpg :env/sultanov_team_clojars_password]}]
                        ["releases"  {:url      "https://clojars.org/repo"
                                      :username [:gpg :env/sultanov_team_clojars_username]
                                      :password [:gpg :env/sultanov_team_clojars_password]}]])
