(ns clj-weather-underground.config)

;;
;; helpers
;;

(defn- get-env-variable [key]
  (or (System/getenv key)
      (throw (IllegalArgumentException. (format "\"%s\" not found in your environment variables." key)))))


;;
;; weather underground api configuration
;;

(def ^:const api-url                  (get-env-variable "WEATHER_UNDERGROUND_API_URL"))
(def ^:const api-key                  (get-env-variable "WEATHER_UNDERGROUND_API_KEY"))
(def ^:const api-format               (get-env-variable "WEATHER_UNDERGROUND_API_FORMAT"))
(def ^:const api-max-calls-per-day    (get-env-variable "WEATHER_UNDERGROUND_API_MAX_CALLS_PER_DAY"))
(def ^:const api-max-calls-per-minute (get-env-variable "WEATHER_UNDERGROUND_API_MAX_CALLS_PER_MINUTE"))
