### Welcome

Event tree tracking interceptor for [re-frame](https://github.com/Day8/re-frame)


#### Latest version [![CircleCI](https://circleci.com/gh/sultanov-team/event-tree-tracker/tree/master.svg?style=svg)](https://circleci.com/gh/sultanov-team/event-tree-tracker/tree/master)

[![Clojars Project](https://img.shields.io/clojars/v/team.sultanov/event-tree-tracker.svg)](https://clojars.org/team.sultanov/event-tree-tracker)


#### Getting Started

Add the necessary dependency to your project:

##### Leiningen/Boot
```clojure
[team.sultanov/event-tree-tracker "0.1.1"]
```

##### deps.edn
```clojure
team.sultanov/event-tree-tracker {:mvn/version "0.1.1"}
```

##### Usage
```clojure
(ns example
  (:require [re-frame.core :as rf]
            [event-tree-tracker.core :refer [tracker]]))
  
(rf/reg-event-fx
  :event-with-default-wrappers
  [(tracker)]
  (fn [cofx event-v]
    ;; ...
    ))

(rf/reg-event-fx
  :event-with-all-wrappers
  [(tracker [all-wrapper-fn-1 all-wrapper-fn-2])]
  (fn [cofx event-v]
    ;; ...
    ))

(rf/reg-event-fx
  :event-with-before-wrappers
  [(tracker :before [before-wrapper-fn-1 before-wrapper-fn-2])]
  (fn [cofx event-v]
    ;; ...
    ))

(rf/reg-event-fx
  :event-with-after-wrappers
  [(tracker :after [after-wrapper-fn-1 after-wrapper-2])]
  (fn [cofx event-v]
    ;; ...
    ))
  
```

#### License

Copyright © 2018 Sultanov Team

[![MIT License](https://img.shields.io/github/license/mashape/apistatus.svg)](LICENSE)
