(ns event-tree-tracker.core
  (:require [re-frame.core :as rf]))

;;
;; Wrappers
;;

(defn- wrap-before [context wrappers]
  context)


(defn- wrap-after [context wrappers]
  context)


;;
;; Event tree tracking interceptor
;;

(defn- wrap-with! [& [before after]]
  (rf/->interceptor
    :id :event-tree-tracker
    :before #(wrap-before % before)
    :after  #(wrap-after % after)))


(defmulti tracker

  "Returns an interceptor which track context, coeffects and effects and then
  wraps their by the vector of wrappers. Your event handlers will look like this:

  (rf/reg-event-fx
    :event-with-default-wrappers
    [(tracker)]
    (fn [cofx event-v]
      ...))

  (rf/reg-event-fx
    :event-with-all-wrappers
    [(tracker [all-wrapper-fn-1 all-wrapper-fn-2])]
    (fn [cofx event-v]
      ...))

  (rf/reg-event-fx
    :event-with-before-wrappers
    [(tracker :before [before-wrapper-fn-1 before-wrapper-fn-2])]
    (fn [cofx event-v]
      ...))

  (rf/reg-event-fx
    :event-with-after-wrappers
    [(tracker :after [after-wrapper-fn-1 after-wrapper-2])]
    (fn [cofx event-v]
      ...))"

  (fn [& [type wrappers]]
    type))


(defmethod tracker :before [_ before-wrappers]
  (wrap-with! before-wrappers []))


(defmethod tracker :after [_ after-wrappers]
  (wrap-with! [] after-wrappers))


(defmethod tracker :default [all-wrappers]
  (wrap-with! all-wrappers all-wrappers))


(def ^:const ^:private default-before-wrappers [])
(def ^:const ^:private default-after-wrappers [])

(defmethod tracker nil []
  (wrap-with! default-before-wrappers default-after-wrappers))
