(ns versioniq.fs
  (:require
    [clojure.java.io :as io])
  (:import
    (java.io
      File)
    (java.net
      URI)
    (java.nio.file
      Path
      Paths)))


(set! *warn-on-reflection* true)


(defn- ^File as-file
  "Returns `path` as an instance of `java.io.File`."
  {:added "0.0.1"}
  [path]
  (if (instance? Path path)
    (.toFile ^Path path)
    (io/file path)))


(defn ^Path as-path
  "Returns `path` as an instance of `java.nio.file.Path`."
  {:added "0.0.1"}
  [path]
  (if (instance? Path path)
    path
    (.toPath (io/file path))))


(defn ^URI as-uri
  "Returns `path` as an instance of `java.net.URI`."
  {:added "0.0.1"}
  [path]
  (if (instance? URI path)
    path
    (.toURI (io/file path))))


(defn ^Path path
  "Returns `path` as an instance of `java.nio.file.Path`."
  {:added "0.0.1"}
  ([path]
    (as-path path))
  ([parent child]
    (as-path (io/file (as-file parent) (as-file child))))
  ([parent child & more]
    (reduce path (path parent child) more)))


(defn ^String absolute-path
  "Returns `path` with an absolute path as an instance of `java.nio.file.Path`."
  {:added "0.0.1"}
  [path]
  (some-> path
    as-uri
    (Paths/get)
    (.toAbsolutePath)
    (.normalize)))
