# think.logging [![Build Status](https://travis-ci.com/thinktopic/think.logging.svg?token=7tRgUUBCZK9RWENbkrKF&branch=master)](https://travis-ci.com/thinktopic/think.logging)

A library for doing structured logging.

```
[thinktopic/think.logging "0.1.7"]
```

By default, we log to stdout. Typically, in a production environment,
it is preferable to send the logs through something like `riemann` or
`logstash` and then forward the logs on to ElasticSearch; so,
appenders are provided.

Configure to send information to riemann using the following environment variables:

    LOG_HOST=localhost LOG_PORT=5555 LOG_SYSTEM=riemann lein run

Or alternativly logstash by using these environment variables:

    LOG_HOST=localhost LOG_PORT=5555 LOG_SYSTEM=logstash lein run

This will tell the system to use either the riemann log appender, or
the logstash appender, and send the logs to the appropriate port on
`localhost`.

Alternatively, `think.config` can be used to configure:

```clojure
{:log-host "localhost"
 :log-port 5555
 :log-system "riemann"
 :log-level :trace}
```

To get human-readable output in your dev environment, use this config:

```clojure
{:log-system "pretty"}
```

Usage:

Call `think.logging.core/add-appenders!` at start-of-day.

Then,

```clojure
(require '[taoensso.timbre :as log])
(log/info :api-request :_time 0.45 :message "this is a log message")
```

In the above example, the `:api-request` is the event type which is
appended to each log event. This allows the log events to be properly
organized, searched and the like when placed into elasticsearch. By 
adding additional fields to the log message, each of them will be 
indexed and thus provide a potential filter when the logs are
either placed in elastic search, or rules are setup in `riemann` to
respond to a particular event or log entry.

The rules for writing structured logs to logstash is a bit
different. This library will probably be in flux for a bit as we
consolidate on a common set of infrastructure, and a common signature
for all logging backends.
