(defproject techascent/tech.logging "0.1.14"
  :description "A logging library."
  :url "http://github.com/thinktopic/think.logging"

  :dependencies [[org.clojure/clojure "1.9.0"]
                 [com.taoensso/timbre "4.10.0"]
                 [techascent/tech.config "0.3.5"]
                 [riemann-clojure-client "0.4.5"
                  :excludes [aphyr/less-awful-ssl]]
                 [less-awful-ssl "1.0.3"]
                 [aprint "0.1.3"]
                 [io.aviso/pretty "0.1.26"]
                 [cheshire "5.7.1"]]

  :plugins [[codox "0.8.12"]
            [s3-wagon-private "1.3.1"]]

  :repositories {"releases" {:url "s3p://techascent.jars/releases/"
                             :no-auth true
                             :sign-releases false
                             :snapshots false}}

  :profiles {:uberjar {:aot :all}
             :tools {:plugins [[lein-environ "1.1.0"]]
                     :dependencies [[thinktopic/think.release "0.1.0-2017-05-11-10-20"]]
                     :env {:date-version "false"}}}

  :think.meta {:type :library
               :tags #{:clj}}

  :aliases {"release" ["with-profile" "tools" "run" "-m" "think.release.main"]})
