(ns tech.logging.pretty
  (:require [aprint.core :as aprint]
            [aprint.tty]
            [io.aviso.exception :as exception]))

(defn log-fn
  [output-fn]
  (fn [data]
    (->> data
         output-fn
         ((fn [x] (dissoc x :host :level :trace-id (keyword "@timestamp"))))
         ((fn [x]
            (if (= "exception" (:event x))
              (do
                (println "Handled exception:")
                (println (exception/format-exception (:exception x))))
              (with-redefs [aprint.tty/clear-screen (fn [] (println))]
                (aprint/aprint x))))))))
