(ns tech.logging.riemann
  (:require [riemann.client :as r]))

(defn riemann-log-edn
  [data]
  (->> data
       (map
        (fn [[k v]]
          (cond (and (number? v) (not= (first (name k)) "_"))
                [(keyword (str "_" (name k))) v]

                (and (map? v) (not= (first (name k)) "_"))
                [(keyword (str "_" (name k))) v]

                (and (or (vector? v) (seq? v)) (not= (first (name k)) "_"))
                [(keyword (str "_" (name k))) (doall (mapv str v))]

                :else [k v])))
       (into {})))

(defn riemann-log
  [conn data]
  (-> conn
      (r/send-event data)
      (deref 2500 ::timeout)))

(defn log-fn
  [host port output-fn]
  (let [conn (r/tcp-client {:host host :port port})]
    (fn [data]
      (->> data
           (output-fn)
           (riemann-log-edn)
           (riemann-log conn)))))

(defn riemann-appender
  [{:keys [host port output-fn]
    :or {host "127.0.0.1"
         port 5555}}]
  {:enabled?   true
   :async?     false
   :min-level  nil
   :rate-limit nil
   :output-fn  :inherit
   :fn (log-fn host port output-fn)})
