// Compiled by ClojureScript 1.10.238 {}
goog.provide('re_frame.trace');
goog.require('cljs.core');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
goog.require('goog.functions');
re_frame.trace.id = cljs.core.atom.call(null,(0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_.call(null,re_frame.trace.id,(0));
});

/** @define {boolean} */
goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
if(typeof re_frame.trace.traces !== 'undefined'){
} else {
re_frame.trace.traces = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
if(typeof re_frame.trace.next_delivery !== 'undefined'){
} else {
re_frame.trace.next_delivery = cljs.core.atom.call(null,(0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.call(null,re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/Day8/re-frame-trace#installation.");
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.call(null,re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.call(null,re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__36183){
var map__36184 = p__36183;
var map__36184__$1 = ((((!((map__36184 == null)))?(((((map__36184.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36184.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36184):map__36184);
var operation = cljs.core.get.call(null,map__36184__$1,new cljs.core.Keyword(null,"operation","operation",-1267664310));
var op_type = cljs.core.get.call(null,map__36184__$1,new cljs.core.Keyword(null,"op-type","op-type",-1636141668));
var tags = cljs.core.get.call(null,map__36184__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
var child_of = cljs.core.get.call(null,map__36184__$1,new cljs.core.Keyword(null,"child-of","child-of",-903376662));
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),re_frame.trace.next_id.call(null),new cljs.core.Keyword(null,"operation","operation",-1267664310),operation,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),op_type,new cljs.core.Keyword(null,"tags","tags",1771418977),tags,new cljs.core.Keyword(null,"child-of","child-of",-903376662),(function (){var or__3922__auto__ = child_of;
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),new cljs.core.Keyword(null,"start","start",-355208981),re_frame.interop.now.call(null)], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce.call(null,(function re_frame$trace$tracing_cb_debounced(){
var seq__36186_36198 = cljs.core.seq.call(null,cljs.core.deref.call(null,re_frame.trace.trace_cbs));
var chunk__36187_36199 = null;
var count__36188_36200 = (0);
var i__36189_36201 = (0);
while(true){
if((i__36189_36201 < count__36188_36200)){
var vec__36190_36202 = cljs.core._nth.call(null,chunk__36187_36199,i__36189_36201);
var k_36203 = cljs.core.nth.call(null,vec__36190_36202,(0),null);
var cb_36204 = cljs.core.nth.call(null,vec__36190_36202,(1),null);
try{cb_36204.call(null,cljs.core.deref.call(null,re_frame.trace.traces));
}catch (e36193){var e_36205 = e36193;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k_36203,"while storing",cljs.core.deref.call(null,re_frame.trace.traces),e_36205);
}

var G__36206 = seq__36186_36198;
var G__36207 = chunk__36187_36199;
var G__36208 = count__36188_36200;
var G__36209 = (i__36189_36201 + (1));
seq__36186_36198 = G__36206;
chunk__36187_36199 = G__36207;
count__36188_36200 = G__36208;
i__36189_36201 = G__36209;
continue;
} else {
var temp__5457__auto___36210 = cljs.core.seq.call(null,seq__36186_36198);
if(temp__5457__auto___36210){
var seq__36186_36211__$1 = temp__5457__auto___36210;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36186_36211__$1)){
var c__4319__auto___36212 = cljs.core.chunk_first.call(null,seq__36186_36211__$1);
var G__36213 = cljs.core.chunk_rest.call(null,seq__36186_36211__$1);
var G__36214 = c__4319__auto___36212;
var G__36215 = cljs.core.count.call(null,c__4319__auto___36212);
var G__36216 = (0);
seq__36186_36198 = G__36213;
chunk__36187_36199 = G__36214;
count__36188_36200 = G__36215;
i__36189_36201 = G__36216;
continue;
} else {
var vec__36194_36217 = cljs.core.first.call(null,seq__36186_36211__$1);
var k_36218 = cljs.core.nth.call(null,vec__36194_36217,(0),null);
var cb_36219 = cljs.core.nth.call(null,vec__36194_36217,(1),null);
try{cb_36219.call(null,cljs.core.deref.call(null,re_frame.trace.traces));
}catch (e36197){var e_36220 = e36197;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k_36218,"while storing",cljs.core.deref.call(null,re_frame.trace.traces),e_36220);
}

var G__36221 = cljs.core.next.call(null,seq__36186_36211__$1);
var G__36222 = null;
var G__36223 = (0);
var G__36224 = (0);
seq__36186_36198 = G__36221;
chunk__36187_36199 = G__36222;
count__36188_36200 = G__36223;
i__36189_36201 = G__36224;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_.call(null,re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref.call(null,re_frame.trace.next_delivery) - (10)) < now)){
re_frame.trace.schedule_debounce.call(null);

return cljs.core.reset_BANG_.call(null,re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});

//# sourceMappingURL=trace.js.map?rel=1524514174073
