// Compiled by ClojureScript 1.10.238 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__36655 = arguments.length;
switch (G__36655) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async36656 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36656 = (function (f,blockable,meta36657){
this.f = f;
this.blockable = blockable;
this.meta36657 = meta36657;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async36656.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_36658,meta36657__$1){
var self__ = this;
var _36658__$1 = this;
return (new cljs.core.async.t_cljs$core$async36656(self__.f,self__.blockable,meta36657__$1));
});

cljs.core.async.t_cljs$core$async36656.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_36658){
var self__ = this;
var _36658__$1 = this;
return self__.meta36657;
});

cljs.core.async.t_cljs$core$async36656.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async36656.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async36656.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async36656.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async36656.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta36657","meta36657",479903374,null)], null);
});

cljs.core.async.t_cljs$core$async36656.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async36656.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36656";

cljs.core.async.t_cljs$core$async36656.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async36656");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async36656.
 */
cljs.core.async.__GT_t_cljs$core$async36656 = (function cljs$core$async$__GT_t_cljs$core$async36656(f__$1,blockable__$1,meta36657){
return (new cljs.core.async.t_cljs$core$async36656(f__$1,blockable__$1,meta36657));
});

}

return (new cljs.core.async.t_cljs$core$async36656(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__36662 = arguments.length;
switch (G__36662) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__36665 = arguments.length;
switch (G__36665) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__36668 = arguments.length;
switch (G__36668) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_36670 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_36670);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_36670,ret){
return (function (){
return fn1.call(null,val_36670);
});})(val_36670,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__36672 = arguments.length;
switch (G__36672) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4376__auto___36674 = n;
var x_36675 = (0);
while(true){
if((x_36675 < n__4376__auto___36674)){
(a[x_36675] = (0));

var G__36676 = (x_36675 + (1));
x_36675 = G__36676;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__36677 = (i + (1));
i = G__36677;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async36678 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36678 = (function (flag,meta36679){
this.flag = flag;
this.meta36679 = meta36679;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async36678.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_36680,meta36679__$1){
var self__ = this;
var _36680__$1 = this;
return (new cljs.core.async.t_cljs$core$async36678(self__.flag,meta36679__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async36678.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_36680){
var self__ = this;
var _36680__$1 = this;
return self__.meta36679;
});})(flag))
;

cljs.core.async.t_cljs$core$async36678.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async36678.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async36678.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async36678.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async36678.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta36679","meta36679",-2042732047,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async36678.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async36678.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36678";

cljs.core.async.t_cljs$core$async36678.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async36678");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async36678.
 */
cljs.core.async.__GT_t_cljs$core$async36678 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async36678(flag__$1,meta36679){
return (new cljs.core.async.t_cljs$core$async36678(flag__$1,meta36679));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async36678(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async36681 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36681 = (function (flag,cb,meta36682){
this.flag = flag;
this.cb = cb;
this.meta36682 = meta36682;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async36681.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_36683,meta36682__$1){
var self__ = this;
var _36683__$1 = this;
return (new cljs.core.async.t_cljs$core$async36681(self__.flag,self__.cb,meta36682__$1));
});

cljs.core.async.t_cljs$core$async36681.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_36683){
var self__ = this;
var _36683__$1 = this;
return self__.meta36682;
});

cljs.core.async.t_cljs$core$async36681.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async36681.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async36681.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async36681.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async36681.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta36682","meta36682",-1866814854,null)], null);
});

cljs.core.async.t_cljs$core$async36681.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async36681.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36681";

cljs.core.async.t_cljs$core$async36681.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async36681");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async36681.
 */
cljs.core.async.__GT_t_cljs$core$async36681 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async36681(flag__$1,cb__$1,meta36682){
return (new cljs.core.async.t_cljs$core$async36681(flag__$1,cb__$1,meta36682));
});

}

return (new cljs.core.async.t_cljs$core$async36681(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__36684_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__36684_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__36685_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__36685_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__3922__auto__ = wport;
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return port;
}
})()], null));
} else {
var G__36686 = (i + (1));
i = G__36686;
continue;
}
} else {
return null;
}
break;
}
})();
var or__3922__auto__ = ret;
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__3911__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__3911__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__3911__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4502__auto__ = [];
var len__4499__auto___36692 = arguments.length;
var i__4500__auto___36693 = (0);
while(true){
if((i__4500__auto___36693 < len__4499__auto___36692)){
args__4502__auto__.push((arguments[i__4500__auto___36693]));

var G__36694 = (i__4500__auto___36693 + (1));
i__4500__auto___36693 = G__36694;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((1) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4503__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__36689){
var map__36690 = p__36689;
var map__36690__$1 = ((((!((map__36690 == null)))?(((((map__36690.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36690.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36690):map__36690);
var opts = map__36690__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq36687){
var G__36688 = cljs.core.first.call(null,seq36687);
var seq36687__$1 = cljs.core.next.call(null,seq36687);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__36688,seq36687__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__36696 = arguments.length;
switch (G__36696) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__36609__auto___36742 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto___36742){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto___36742){
return (function (state_36720){
var state_val_36721 = (state_36720[(1)]);
if((state_val_36721 === (7))){
var inst_36716 = (state_36720[(2)]);
var state_36720__$1 = state_36720;
var statearr_36722_36743 = state_36720__$1;
(statearr_36722_36743[(2)] = inst_36716);

(statearr_36722_36743[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36721 === (1))){
var state_36720__$1 = state_36720;
var statearr_36723_36744 = state_36720__$1;
(statearr_36723_36744[(2)] = null);

(statearr_36723_36744[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36721 === (4))){
var inst_36699 = (state_36720[(7)]);
var inst_36699__$1 = (state_36720[(2)]);
var inst_36700 = (inst_36699__$1 == null);
var state_36720__$1 = (function (){var statearr_36724 = state_36720;
(statearr_36724[(7)] = inst_36699__$1);

return statearr_36724;
})();
if(cljs.core.truth_(inst_36700)){
var statearr_36725_36745 = state_36720__$1;
(statearr_36725_36745[(1)] = (5));

} else {
var statearr_36726_36746 = state_36720__$1;
(statearr_36726_36746[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36721 === (13))){
var state_36720__$1 = state_36720;
var statearr_36727_36747 = state_36720__$1;
(statearr_36727_36747[(2)] = null);

(statearr_36727_36747[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36721 === (6))){
var inst_36699 = (state_36720[(7)]);
var state_36720__$1 = state_36720;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_36720__$1,(11),to,inst_36699);
} else {
if((state_val_36721 === (3))){
var inst_36718 = (state_36720[(2)]);
var state_36720__$1 = state_36720;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36720__$1,inst_36718);
} else {
if((state_val_36721 === (12))){
var state_36720__$1 = state_36720;
var statearr_36728_36748 = state_36720__$1;
(statearr_36728_36748[(2)] = null);

(statearr_36728_36748[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36721 === (2))){
var state_36720__$1 = state_36720;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36720__$1,(4),from);
} else {
if((state_val_36721 === (11))){
var inst_36709 = (state_36720[(2)]);
var state_36720__$1 = state_36720;
if(cljs.core.truth_(inst_36709)){
var statearr_36729_36749 = state_36720__$1;
(statearr_36729_36749[(1)] = (12));

} else {
var statearr_36730_36750 = state_36720__$1;
(statearr_36730_36750[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36721 === (9))){
var state_36720__$1 = state_36720;
var statearr_36731_36751 = state_36720__$1;
(statearr_36731_36751[(2)] = null);

(statearr_36731_36751[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36721 === (5))){
var state_36720__$1 = state_36720;
if(cljs.core.truth_(close_QMARK_)){
var statearr_36732_36752 = state_36720__$1;
(statearr_36732_36752[(1)] = (8));

} else {
var statearr_36733_36753 = state_36720__$1;
(statearr_36733_36753[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36721 === (14))){
var inst_36714 = (state_36720[(2)]);
var state_36720__$1 = state_36720;
var statearr_36734_36754 = state_36720__$1;
(statearr_36734_36754[(2)] = inst_36714);

(statearr_36734_36754[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36721 === (10))){
var inst_36706 = (state_36720[(2)]);
var state_36720__$1 = state_36720;
var statearr_36735_36755 = state_36720__$1;
(statearr_36735_36755[(2)] = inst_36706);

(statearr_36735_36755[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36721 === (8))){
var inst_36703 = cljs.core.async.close_BANG_.call(null,to);
var state_36720__$1 = state_36720;
var statearr_36736_36756 = state_36720__$1;
(statearr_36736_36756[(2)] = inst_36703);

(statearr_36736_36756[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36609__auto___36742))
;
return ((function (switch__36521__auto__,c__36609__auto___36742){
return (function() {
var cljs$core$async$state_machine__36522__auto__ = null;
var cljs$core$async$state_machine__36522__auto____0 = (function (){
var statearr_36737 = [null,null,null,null,null,null,null,null];
(statearr_36737[(0)] = cljs$core$async$state_machine__36522__auto__);

(statearr_36737[(1)] = (1));

return statearr_36737;
});
var cljs$core$async$state_machine__36522__auto____1 = (function (state_36720){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_36720);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e36738){if((e36738 instanceof Object)){
var ex__36525__auto__ = e36738;
var statearr_36739_36757 = state_36720;
(statearr_36739_36757[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36720);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36738;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36758 = state_36720;
state_36720 = G__36758;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
cljs$core$async$state_machine__36522__auto__ = function(state_36720){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36522__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36522__auto____1.call(this,state_36720);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36522__auto____0;
cljs$core$async$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36522__auto____1;
return cljs$core$async$state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto___36742))
})();
var state__36611__auto__ = (function (){var statearr_36740 = f__36610__auto__.call(null);
(statearr_36740[(6)] = c__36609__auto___36742);

return statearr_36740;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto___36742))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__36759){
var vec__36760 = p__36759;
var v = cljs.core.nth.call(null,vec__36760,(0),null);
var p = cljs.core.nth.call(null,vec__36760,(1),null);
var job = vec__36760;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__36609__auto___36931 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto___36931,res,vec__36760,v,p,job,jobs,results){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto___36931,res,vec__36760,v,p,job,jobs,results){
return (function (state_36767){
var state_val_36768 = (state_36767[(1)]);
if((state_val_36768 === (1))){
var state_36767__$1 = state_36767;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_36767__$1,(2),res,v);
} else {
if((state_val_36768 === (2))){
var inst_36764 = (state_36767[(2)]);
var inst_36765 = cljs.core.async.close_BANG_.call(null,res);
var state_36767__$1 = (function (){var statearr_36769 = state_36767;
(statearr_36769[(7)] = inst_36764);

return statearr_36769;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36767__$1,inst_36765);
} else {
return null;
}
}
});})(c__36609__auto___36931,res,vec__36760,v,p,job,jobs,results))
;
return ((function (switch__36521__auto__,c__36609__auto___36931,res,vec__36760,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____0 = (function (){
var statearr_36770 = [null,null,null,null,null,null,null,null];
(statearr_36770[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__);

(statearr_36770[(1)] = (1));

return statearr_36770;
});
var cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____1 = (function (state_36767){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_36767);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e36771){if((e36771 instanceof Object)){
var ex__36525__auto__ = e36771;
var statearr_36772_36932 = state_36767;
(statearr_36772_36932[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36767);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36771;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36933 = state_36767;
state_36767 = G__36933;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__ = function(state_36767){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____1.call(this,state_36767);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto___36931,res,vec__36760,v,p,job,jobs,results))
})();
var state__36611__auto__ = (function (){var statearr_36773 = f__36610__auto__.call(null);
(statearr_36773[(6)] = c__36609__auto___36931);

return statearr_36773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto___36931,res,vec__36760,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__36774){
var vec__36775 = p__36774;
var v = cljs.core.nth.call(null,vec__36775,(0),null);
var p = cljs.core.nth.call(null,vec__36775,(1),null);
var job = vec__36775;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__4376__auto___36934 = n;
var __36935 = (0);
while(true){
if((__36935 < n__4376__auto___36934)){
var G__36778_36936 = type;
var G__36778_36937__$1 = (((G__36778_36936 instanceof cljs.core.Keyword))?G__36778_36936.fqn:null);
switch (G__36778_36937__$1) {
case "compute":
var c__36609__auto___36939 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__36935,c__36609__auto___36939,G__36778_36936,G__36778_36937__$1,n__4376__auto___36934,jobs,results,process,async){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (__36935,c__36609__auto___36939,G__36778_36936,G__36778_36937__$1,n__4376__auto___36934,jobs,results,process,async){
return (function (state_36791){
var state_val_36792 = (state_36791[(1)]);
if((state_val_36792 === (1))){
var state_36791__$1 = state_36791;
var statearr_36793_36940 = state_36791__$1;
(statearr_36793_36940[(2)] = null);

(statearr_36793_36940[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36792 === (2))){
var state_36791__$1 = state_36791;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36791__$1,(4),jobs);
} else {
if((state_val_36792 === (3))){
var inst_36789 = (state_36791[(2)]);
var state_36791__$1 = state_36791;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36791__$1,inst_36789);
} else {
if((state_val_36792 === (4))){
var inst_36781 = (state_36791[(2)]);
var inst_36782 = process.call(null,inst_36781);
var state_36791__$1 = state_36791;
if(cljs.core.truth_(inst_36782)){
var statearr_36794_36941 = state_36791__$1;
(statearr_36794_36941[(1)] = (5));

} else {
var statearr_36795_36942 = state_36791__$1;
(statearr_36795_36942[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36792 === (5))){
var state_36791__$1 = state_36791;
var statearr_36796_36943 = state_36791__$1;
(statearr_36796_36943[(2)] = null);

(statearr_36796_36943[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36792 === (6))){
var state_36791__$1 = state_36791;
var statearr_36797_36944 = state_36791__$1;
(statearr_36797_36944[(2)] = null);

(statearr_36797_36944[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36792 === (7))){
var inst_36787 = (state_36791[(2)]);
var state_36791__$1 = state_36791;
var statearr_36798_36945 = state_36791__$1;
(statearr_36798_36945[(2)] = inst_36787);

(statearr_36798_36945[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__36935,c__36609__auto___36939,G__36778_36936,G__36778_36937__$1,n__4376__auto___36934,jobs,results,process,async))
;
return ((function (__36935,switch__36521__auto__,c__36609__auto___36939,G__36778_36936,G__36778_36937__$1,n__4376__auto___36934,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____0 = (function (){
var statearr_36799 = [null,null,null,null,null,null,null];
(statearr_36799[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__);

(statearr_36799[(1)] = (1));

return statearr_36799;
});
var cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____1 = (function (state_36791){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_36791);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e36800){if((e36800 instanceof Object)){
var ex__36525__auto__ = e36800;
var statearr_36801_36946 = state_36791;
(statearr_36801_36946[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36791);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36800;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36947 = state_36791;
state_36791 = G__36947;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__ = function(state_36791){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____1.call(this,state_36791);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__;
})()
;})(__36935,switch__36521__auto__,c__36609__auto___36939,G__36778_36936,G__36778_36937__$1,n__4376__auto___36934,jobs,results,process,async))
})();
var state__36611__auto__ = (function (){var statearr_36802 = f__36610__auto__.call(null);
(statearr_36802[(6)] = c__36609__auto___36939);

return statearr_36802;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(__36935,c__36609__auto___36939,G__36778_36936,G__36778_36937__$1,n__4376__auto___36934,jobs,results,process,async))
);


break;
case "async":
var c__36609__auto___36948 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__36935,c__36609__auto___36948,G__36778_36936,G__36778_36937__$1,n__4376__auto___36934,jobs,results,process,async){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (__36935,c__36609__auto___36948,G__36778_36936,G__36778_36937__$1,n__4376__auto___36934,jobs,results,process,async){
return (function (state_36815){
var state_val_36816 = (state_36815[(1)]);
if((state_val_36816 === (1))){
var state_36815__$1 = state_36815;
var statearr_36817_36949 = state_36815__$1;
(statearr_36817_36949[(2)] = null);

(statearr_36817_36949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36816 === (2))){
var state_36815__$1 = state_36815;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36815__$1,(4),jobs);
} else {
if((state_val_36816 === (3))){
var inst_36813 = (state_36815[(2)]);
var state_36815__$1 = state_36815;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36815__$1,inst_36813);
} else {
if((state_val_36816 === (4))){
var inst_36805 = (state_36815[(2)]);
var inst_36806 = async.call(null,inst_36805);
var state_36815__$1 = state_36815;
if(cljs.core.truth_(inst_36806)){
var statearr_36818_36950 = state_36815__$1;
(statearr_36818_36950[(1)] = (5));

} else {
var statearr_36819_36951 = state_36815__$1;
(statearr_36819_36951[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36816 === (5))){
var state_36815__$1 = state_36815;
var statearr_36820_36952 = state_36815__$1;
(statearr_36820_36952[(2)] = null);

(statearr_36820_36952[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36816 === (6))){
var state_36815__$1 = state_36815;
var statearr_36821_36953 = state_36815__$1;
(statearr_36821_36953[(2)] = null);

(statearr_36821_36953[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36816 === (7))){
var inst_36811 = (state_36815[(2)]);
var state_36815__$1 = state_36815;
var statearr_36822_36954 = state_36815__$1;
(statearr_36822_36954[(2)] = inst_36811);

(statearr_36822_36954[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__36935,c__36609__auto___36948,G__36778_36936,G__36778_36937__$1,n__4376__auto___36934,jobs,results,process,async))
;
return ((function (__36935,switch__36521__auto__,c__36609__auto___36948,G__36778_36936,G__36778_36937__$1,n__4376__auto___36934,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____0 = (function (){
var statearr_36823 = [null,null,null,null,null,null,null];
(statearr_36823[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__);

(statearr_36823[(1)] = (1));

return statearr_36823;
});
var cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____1 = (function (state_36815){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_36815);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e36824){if((e36824 instanceof Object)){
var ex__36525__auto__ = e36824;
var statearr_36825_36955 = state_36815;
(statearr_36825_36955[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36815);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36824;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36956 = state_36815;
state_36815 = G__36956;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__ = function(state_36815){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____1.call(this,state_36815);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__;
})()
;})(__36935,switch__36521__auto__,c__36609__auto___36948,G__36778_36936,G__36778_36937__$1,n__4376__auto___36934,jobs,results,process,async))
})();
var state__36611__auto__ = (function (){var statearr_36826 = f__36610__auto__.call(null);
(statearr_36826[(6)] = c__36609__auto___36948);

return statearr_36826;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(__36935,c__36609__auto___36948,G__36778_36936,G__36778_36937__$1,n__4376__auto___36934,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__36778_36937__$1)].join('')));

}

var G__36957 = (__36935 + (1));
__36935 = G__36957;
continue;
} else {
}
break;
}

var c__36609__auto___36958 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto___36958,jobs,results,process,async){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto___36958,jobs,results,process,async){
return (function (state_36848){
var state_val_36849 = (state_36848[(1)]);
if((state_val_36849 === (1))){
var state_36848__$1 = state_36848;
var statearr_36850_36959 = state_36848__$1;
(statearr_36850_36959[(2)] = null);

(statearr_36850_36959[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36849 === (2))){
var state_36848__$1 = state_36848;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36848__$1,(4),from);
} else {
if((state_val_36849 === (3))){
var inst_36846 = (state_36848[(2)]);
var state_36848__$1 = state_36848;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36848__$1,inst_36846);
} else {
if((state_val_36849 === (4))){
var inst_36829 = (state_36848[(7)]);
var inst_36829__$1 = (state_36848[(2)]);
var inst_36830 = (inst_36829__$1 == null);
var state_36848__$1 = (function (){var statearr_36851 = state_36848;
(statearr_36851[(7)] = inst_36829__$1);

return statearr_36851;
})();
if(cljs.core.truth_(inst_36830)){
var statearr_36852_36960 = state_36848__$1;
(statearr_36852_36960[(1)] = (5));

} else {
var statearr_36853_36961 = state_36848__$1;
(statearr_36853_36961[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36849 === (5))){
var inst_36832 = cljs.core.async.close_BANG_.call(null,jobs);
var state_36848__$1 = state_36848;
var statearr_36854_36962 = state_36848__$1;
(statearr_36854_36962[(2)] = inst_36832);

(statearr_36854_36962[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36849 === (6))){
var inst_36829 = (state_36848[(7)]);
var inst_36834 = (state_36848[(8)]);
var inst_36834__$1 = cljs.core.async.chan.call(null,(1));
var inst_36835 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36836 = [inst_36829,inst_36834__$1];
var inst_36837 = (new cljs.core.PersistentVector(null,2,(5),inst_36835,inst_36836,null));
var state_36848__$1 = (function (){var statearr_36855 = state_36848;
(statearr_36855[(8)] = inst_36834__$1);

return statearr_36855;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_36848__$1,(8),jobs,inst_36837);
} else {
if((state_val_36849 === (7))){
var inst_36844 = (state_36848[(2)]);
var state_36848__$1 = state_36848;
var statearr_36856_36963 = state_36848__$1;
(statearr_36856_36963[(2)] = inst_36844);

(statearr_36856_36963[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36849 === (8))){
var inst_36834 = (state_36848[(8)]);
var inst_36839 = (state_36848[(2)]);
var state_36848__$1 = (function (){var statearr_36857 = state_36848;
(statearr_36857[(9)] = inst_36839);

return statearr_36857;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_36848__$1,(9),results,inst_36834);
} else {
if((state_val_36849 === (9))){
var inst_36841 = (state_36848[(2)]);
var state_36848__$1 = (function (){var statearr_36858 = state_36848;
(statearr_36858[(10)] = inst_36841);

return statearr_36858;
})();
var statearr_36859_36964 = state_36848__$1;
(statearr_36859_36964[(2)] = null);

(statearr_36859_36964[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__36609__auto___36958,jobs,results,process,async))
;
return ((function (switch__36521__auto__,c__36609__auto___36958,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____0 = (function (){
var statearr_36860 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_36860[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__);

(statearr_36860[(1)] = (1));

return statearr_36860;
});
var cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____1 = (function (state_36848){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_36848);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e36861){if((e36861 instanceof Object)){
var ex__36525__auto__ = e36861;
var statearr_36862_36965 = state_36848;
(statearr_36862_36965[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36848);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36861;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36966 = state_36848;
state_36848 = G__36966;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__ = function(state_36848){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____1.call(this,state_36848);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto___36958,jobs,results,process,async))
})();
var state__36611__auto__ = (function (){var statearr_36863 = f__36610__auto__.call(null);
(statearr_36863[(6)] = c__36609__auto___36958);

return statearr_36863;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto___36958,jobs,results,process,async))
);


var c__36609__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto__,jobs,results,process,async){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto__,jobs,results,process,async){
return (function (state_36901){
var state_val_36902 = (state_36901[(1)]);
if((state_val_36902 === (7))){
var inst_36897 = (state_36901[(2)]);
var state_36901__$1 = state_36901;
var statearr_36903_36967 = state_36901__$1;
(statearr_36903_36967[(2)] = inst_36897);

(statearr_36903_36967[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36902 === (20))){
var state_36901__$1 = state_36901;
var statearr_36904_36968 = state_36901__$1;
(statearr_36904_36968[(2)] = null);

(statearr_36904_36968[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36902 === (1))){
var state_36901__$1 = state_36901;
var statearr_36905_36969 = state_36901__$1;
(statearr_36905_36969[(2)] = null);

(statearr_36905_36969[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36902 === (4))){
var inst_36866 = (state_36901[(7)]);
var inst_36866__$1 = (state_36901[(2)]);
var inst_36867 = (inst_36866__$1 == null);
var state_36901__$1 = (function (){var statearr_36906 = state_36901;
(statearr_36906[(7)] = inst_36866__$1);

return statearr_36906;
})();
if(cljs.core.truth_(inst_36867)){
var statearr_36907_36970 = state_36901__$1;
(statearr_36907_36970[(1)] = (5));

} else {
var statearr_36908_36971 = state_36901__$1;
(statearr_36908_36971[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36902 === (15))){
var inst_36879 = (state_36901[(8)]);
var state_36901__$1 = state_36901;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_36901__$1,(18),to,inst_36879);
} else {
if((state_val_36902 === (21))){
var inst_36892 = (state_36901[(2)]);
var state_36901__$1 = state_36901;
var statearr_36909_36972 = state_36901__$1;
(statearr_36909_36972[(2)] = inst_36892);

(statearr_36909_36972[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36902 === (13))){
var inst_36894 = (state_36901[(2)]);
var state_36901__$1 = (function (){var statearr_36910 = state_36901;
(statearr_36910[(9)] = inst_36894);

return statearr_36910;
})();
var statearr_36911_36973 = state_36901__$1;
(statearr_36911_36973[(2)] = null);

(statearr_36911_36973[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36902 === (6))){
var inst_36866 = (state_36901[(7)]);
var state_36901__$1 = state_36901;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36901__$1,(11),inst_36866);
} else {
if((state_val_36902 === (17))){
var inst_36887 = (state_36901[(2)]);
var state_36901__$1 = state_36901;
if(cljs.core.truth_(inst_36887)){
var statearr_36912_36974 = state_36901__$1;
(statearr_36912_36974[(1)] = (19));

} else {
var statearr_36913_36975 = state_36901__$1;
(statearr_36913_36975[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36902 === (3))){
var inst_36899 = (state_36901[(2)]);
var state_36901__$1 = state_36901;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36901__$1,inst_36899);
} else {
if((state_val_36902 === (12))){
var inst_36876 = (state_36901[(10)]);
var state_36901__$1 = state_36901;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36901__$1,(14),inst_36876);
} else {
if((state_val_36902 === (2))){
var state_36901__$1 = state_36901;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36901__$1,(4),results);
} else {
if((state_val_36902 === (19))){
var state_36901__$1 = state_36901;
var statearr_36914_36976 = state_36901__$1;
(statearr_36914_36976[(2)] = null);

(statearr_36914_36976[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36902 === (11))){
var inst_36876 = (state_36901[(2)]);
var state_36901__$1 = (function (){var statearr_36915 = state_36901;
(statearr_36915[(10)] = inst_36876);

return statearr_36915;
})();
var statearr_36916_36977 = state_36901__$1;
(statearr_36916_36977[(2)] = null);

(statearr_36916_36977[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36902 === (9))){
var state_36901__$1 = state_36901;
var statearr_36917_36978 = state_36901__$1;
(statearr_36917_36978[(2)] = null);

(statearr_36917_36978[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36902 === (5))){
var state_36901__$1 = state_36901;
if(cljs.core.truth_(close_QMARK_)){
var statearr_36918_36979 = state_36901__$1;
(statearr_36918_36979[(1)] = (8));

} else {
var statearr_36919_36980 = state_36901__$1;
(statearr_36919_36980[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36902 === (14))){
var inst_36879 = (state_36901[(8)]);
var inst_36881 = (state_36901[(11)]);
var inst_36879__$1 = (state_36901[(2)]);
var inst_36880 = (inst_36879__$1 == null);
var inst_36881__$1 = cljs.core.not.call(null,inst_36880);
var state_36901__$1 = (function (){var statearr_36920 = state_36901;
(statearr_36920[(8)] = inst_36879__$1);

(statearr_36920[(11)] = inst_36881__$1);

return statearr_36920;
})();
if(inst_36881__$1){
var statearr_36921_36981 = state_36901__$1;
(statearr_36921_36981[(1)] = (15));

} else {
var statearr_36922_36982 = state_36901__$1;
(statearr_36922_36982[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36902 === (16))){
var inst_36881 = (state_36901[(11)]);
var state_36901__$1 = state_36901;
var statearr_36923_36983 = state_36901__$1;
(statearr_36923_36983[(2)] = inst_36881);

(statearr_36923_36983[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36902 === (10))){
var inst_36873 = (state_36901[(2)]);
var state_36901__$1 = state_36901;
var statearr_36924_36984 = state_36901__$1;
(statearr_36924_36984[(2)] = inst_36873);

(statearr_36924_36984[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36902 === (18))){
var inst_36884 = (state_36901[(2)]);
var state_36901__$1 = state_36901;
var statearr_36925_36985 = state_36901__$1;
(statearr_36925_36985[(2)] = inst_36884);

(statearr_36925_36985[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36902 === (8))){
var inst_36870 = cljs.core.async.close_BANG_.call(null,to);
var state_36901__$1 = state_36901;
var statearr_36926_36986 = state_36901__$1;
(statearr_36926_36986[(2)] = inst_36870);

(statearr_36926_36986[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36609__auto__,jobs,results,process,async))
;
return ((function (switch__36521__auto__,c__36609__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____0 = (function (){
var statearr_36927 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36927[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__);

(statearr_36927[(1)] = (1));

return statearr_36927;
});
var cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____1 = (function (state_36901){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_36901);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e36928){if((e36928 instanceof Object)){
var ex__36525__auto__ = e36928;
var statearr_36929_36987 = state_36901;
(statearr_36929_36987[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36901);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36928;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36988 = state_36901;
state_36901 = G__36988;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__ = function(state_36901){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____1.call(this,state_36901);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__36522__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto__,jobs,results,process,async))
})();
var state__36611__auto__ = (function (){var statearr_36930 = f__36610__auto__.call(null);
(statearr_36930[(6)] = c__36609__auto__);

return statearr_36930;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto__,jobs,results,process,async))
);

return c__36609__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__36990 = arguments.length;
switch (G__36990) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__36993 = arguments.length;
switch (G__36993) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__36996 = arguments.length;
switch (G__36996) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__36609__auto___37045 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto___37045,tc,fc){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto___37045,tc,fc){
return (function (state_37022){
var state_val_37023 = (state_37022[(1)]);
if((state_val_37023 === (7))){
var inst_37018 = (state_37022[(2)]);
var state_37022__$1 = state_37022;
var statearr_37024_37046 = state_37022__$1;
(statearr_37024_37046[(2)] = inst_37018);

(statearr_37024_37046[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37023 === (1))){
var state_37022__$1 = state_37022;
var statearr_37025_37047 = state_37022__$1;
(statearr_37025_37047[(2)] = null);

(statearr_37025_37047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37023 === (4))){
var inst_36999 = (state_37022[(7)]);
var inst_36999__$1 = (state_37022[(2)]);
var inst_37000 = (inst_36999__$1 == null);
var state_37022__$1 = (function (){var statearr_37026 = state_37022;
(statearr_37026[(7)] = inst_36999__$1);

return statearr_37026;
})();
if(cljs.core.truth_(inst_37000)){
var statearr_37027_37048 = state_37022__$1;
(statearr_37027_37048[(1)] = (5));

} else {
var statearr_37028_37049 = state_37022__$1;
(statearr_37028_37049[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37023 === (13))){
var state_37022__$1 = state_37022;
var statearr_37029_37050 = state_37022__$1;
(statearr_37029_37050[(2)] = null);

(statearr_37029_37050[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37023 === (6))){
var inst_36999 = (state_37022[(7)]);
var inst_37005 = p.call(null,inst_36999);
var state_37022__$1 = state_37022;
if(cljs.core.truth_(inst_37005)){
var statearr_37030_37051 = state_37022__$1;
(statearr_37030_37051[(1)] = (9));

} else {
var statearr_37031_37052 = state_37022__$1;
(statearr_37031_37052[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37023 === (3))){
var inst_37020 = (state_37022[(2)]);
var state_37022__$1 = state_37022;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37022__$1,inst_37020);
} else {
if((state_val_37023 === (12))){
var state_37022__$1 = state_37022;
var statearr_37032_37053 = state_37022__$1;
(statearr_37032_37053[(2)] = null);

(statearr_37032_37053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37023 === (2))){
var state_37022__$1 = state_37022;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37022__$1,(4),ch);
} else {
if((state_val_37023 === (11))){
var inst_36999 = (state_37022[(7)]);
var inst_37009 = (state_37022[(2)]);
var state_37022__$1 = state_37022;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_37022__$1,(8),inst_37009,inst_36999);
} else {
if((state_val_37023 === (9))){
var state_37022__$1 = state_37022;
var statearr_37033_37054 = state_37022__$1;
(statearr_37033_37054[(2)] = tc);

(statearr_37033_37054[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37023 === (5))){
var inst_37002 = cljs.core.async.close_BANG_.call(null,tc);
var inst_37003 = cljs.core.async.close_BANG_.call(null,fc);
var state_37022__$1 = (function (){var statearr_37034 = state_37022;
(statearr_37034[(8)] = inst_37002);

return statearr_37034;
})();
var statearr_37035_37055 = state_37022__$1;
(statearr_37035_37055[(2)] = inst_37003);

(statearr_37035_37055[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37023 === (14))){
var inst_37016 = (state_37022[(2)]);
var state_37022__$1 = state_37022;
var statearr_37036_37056 = state_37022__$1;
(statearr_37036_37056[(2)] = inst_37016);

(statearr_37036_37056[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37023 === (10))){
var state_37022__$1 = state_37022;
var statearr_37037_37057 = state_37022__$1;
(statearr_37037_37057[(2)] = fc);

(statearr_37037_37057[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37023 === (8))){
var inst_37011 = (state_37022[(2)]);
var state_37022__$1 = state_37022;
if(cljs.core.truth_(inst_37011)){
var statearr_37038_37058 = state_37022__$1;
(statearr_37038_37058[(1)] = (12));

} else {
var statearr_37039_37059 = state_37022__$1;
(statearr_37039_37059[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36609__auto___37045,tc,fc))
;
return ((function (switch__36521__auto__,c__36609__auto___37045,tc,fc){
return (function() {
var cljs$core$async$state_machine__36522__auto__ = null;
var cljs$core$async$state_machine__36522__auto____0 = (function (){
var statearr_37040 = [null,null,null,null,null,null,null,null,null];
(statearr_37040[(0)] = cljs$core$async$state_machine__36522__auto__);

(statearr_37040[(1)] = (1));

return statearr_37040;
});
var cljs$core$async$state_machine__36522__auto____1 = (function (state_37022){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_37022);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e37041){if((e37041 instanceof Object)){
var ex__36525__auto__ = e37041;
var statearr_37042_37060 = state_37022;
(statearr_37042_37060[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37022);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37041;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37061 = state_37022;
state_37022 = G__37061;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
cljs$core$async$state_machine__36522__auto__ = function(state_37022){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36522__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36522__auto____1.call(this,state_37022);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36522__auto____0;
cljs$core$async$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36522__auto____1;
return cljs$core$async$state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto___37045,tc,fc))
})();
var state__36611__auto__ = (function (){var statearr_37043 = f__36610__auto__.call(null);
(statearr_37043[(6)] = c__36609__auto___37045);

return statearr_37043;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto___37045,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__36609__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto__){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto__){
return (function (state_37082){
var state_val_37083 = (state_37082[(1)]);
if((state_val_37083 === (7))){
var inst_37078 = (state_37082[(2)]);
var state_37082__$1 = state_37082;
var statearr_37084_37102 = state_37082__$1;
(statearr_37084_37102[(2)] = inst_37078);

(statearr_37084_37102[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37083 === (1))){
var inst_37062 = init;
var state_37082__$1 = (function (){var statearr_37085 = state_37082;
(statearr_37085[(7)] = inst_37062);

return statearr_37085;
})();
var statearr_37086_37103 = state_37082__$1;
(statearr_37086_37103[(2)] = null);

(statearr_37086_37103[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37083 === (4))){
var inst_37065 = (state_37082[(8)]);
var inst_37065__$1 = (state_37082[(2)]);
var inst_37066 = (inst_37065__$1 == null);
var state_37082__$1 = (function (){var statearr_37087 = state_37082;
(statearr_37087[(8)] = inst_37065__$1);

return statearr_37087;
})();
if(cljs.core.truth_(inst_37066)){
var statearr_37088_37104 = state_37082__$1;
(statearr_37088_37104[(1)] = (5));

} else {
var statearr_37089_37105 = state_37082__$1;
(statearr_37089_37105[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37083 === (6))){
var inst_37062 = (state_37082[(7)]);
var inst_37069 = (state_37082[(9)]);
var inst_37065 = (state_37082[(8)]);
var inst_37069__$1 = f.call(null,inst_37062,inst_37065);
var inst_37070 = cljs.core.reduced_QMARK_.call(null,inst_37069__$1);
var state_37082__$1 = (function (){var statearr_37090 = state_37082;
(statearr_37090[(9)] = inst_37069__$1);

return statearr_37090;
})();
if(inst_37070){
var statearr_37091_37106 = state_37082__$1;
(statearr_37091_37106[(1)] = (8));

} else {
var statearr_37092_37107 = state_37082__$1;
(statearr_37092_37107[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37083 === (3))){
var inst_37080 = (state_37082[(2)]);
var state_37082__$1 = state_37082;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37082__$1,inst_37080);
} else {
if((state_val_37083 === (2))){
var state_37082__$1 = state_37082;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37082__$1,(4),ch);
} else {
if((state_val_37083 === (9))){
var inst_37069 = (state_37082[(9)]);
var inst_37062 = inst_37069;
var state_37082__$1 = (function (){var statearr_37093 = state_37082;
(statearr_37093[(7)] = inst_37062);

return statearr_37093;
})();
var statearr_37094_37108 = state_37082__$1;
(statearr_37094_37108[(2)] = null);

(statearr_37094_37108[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37083 === (5))){
var inst_37062 = (state_37082[(7)]);
var state_37082__$1 = state_37082;
var statearr_37095_37109 = state_37082__$1;
(statearr_37095_37109[(2)] = inst_37062);

(statearr_37095_37109[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37083 === (10))){
var inst_37076 = (state_37082[(2)]);
var state_37082__$1 = state_37082;
var statearr_37096_37110 = state_37082__$1;
(statearr_37096_37110[(2)] = inst_37076);

(statearr_37096_37110[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37083 === (8))){
var inst_37069 = (state_37082[(9)]);
var inst_37072 = cljs.core.deref.call(null,inst_37069);
var state_37082__$1 = state_37082;
var statearr_37097_37111 = state_37082__$1;
(statearr_37097_37111[(2)] = inst_37072);

(statearr_37097_37111[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__36609__auto__))
;
return ((function (switch__36521__auto__,c__36609__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__36522__auto__ = null;
var cljs$core$async$reduce_$_state_machine__36522__auto____0 = (function (){
var statearr_37098 = [null,null,null,null,null,null,null,null,null,null];
(statearr_37098[(0)] = cljs$core$async$reduce_$_state_machine__36522__auto__);

(statearr_37098[(1)] = (1));

return statearr_37098;
});
var cljs$core$async$reduce_$_state_machine__36522__auto____1 = (function (state_37082){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_37082);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e37099){if((e37099 instanceof Object)){
var ex__36525__auto__ = e37099;
var statearr_37100_37112 = state_37082;
(statearr_37100_37112[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37082);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37099;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37113 = state_37082;
state_37082 = G__37113;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__36522__auto__ = function(state_37082){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__36522__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__36522__auto____1.call(this,state_37082);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__36522__auto____0;
cljs$core$async$reduce_$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__36522__auto____1;
return cljs$core$async$reduce_$_state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto__))
})();
var state__36611__auto__ = (function (){var statearr_37101 = f__36610__auto__.call(null);
(statearr_37101[(6)] = c__36609__auto__);

return statearr_37101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto__))
);

return c__36609__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__36609__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto__,f__$1){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto__,f__$1){
return (function (state_37119){
var state_val_37120 = (state_37119[(1)]);
if((state_val_37120 === (1))){
var inst_37114 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_37119__$1 = state_37119;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37119__$1,(2),inst_37114);
} else {
if((state_val_37120 === (2))){
var inst_37116 = (state_37119[(2)]);
var inst_37117 = f__$1.call(null,inst_37116);
var state_37119__$1 = state_37119;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37119__$1,inst_37117);
} else {
return null;
}
}
});})(c__36609__auto__,f__$1))
;
return ((function (switch__36521__auto__,c__36609__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__36522__auto__ = null;
var cljs$core$async$transduce_$_state_machine__36522__auto____0 = (function (){
var statearr_37121 = [null,null,null,null,null,null,null];
(statearr_37121[(0)] = cljs$core$async$transduce_$_state_machine__36522__auto__);

(statearr_37121[(1)] = (1));

return statearr_37121;
});
var cljs$core$async$transduce_$_state_machine__36522__auto____1 = (function (state_37119){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_37119);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e37122){if((e37122 instanceof Object)){
var ex__36525__auto__ = e37122;
var statearr_37123_37125 = state_37119;
(statearr_37123_37125[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37119);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37122;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37126 = state_37119;
state_37119 = G__37126;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__36522__auto__ = function(state_37119){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__36522__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__36522__auto____1.call(this,state_37119);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__36522__auto____0;
cljs$core$async$transduce_$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__36522__auto____1;
return cljs$core$async$transduce_$_state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto__,f__$1))
})();
var state__36611__auto__ = (function (){var statearr_37124 = f__36610__auto__.call(null);
(statearr_37124[(6)] = c__36609__auto__);

return statearr_37124;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto__,f__$1))
);

return c__36609__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__37128 = arguments.length;
switch (G__37128) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__36609__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto__){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto__){
return (function (state_37153){
var state_val_37154 = (state_37153[(1)]);
if((state_val_37154 === (7))){
var inst_37135 = (state_37153[(2)]);
var state_37153__$1 = state_37153;
var statearr_37155_37176 = state_37153__$1;
(statearr_37155_37176[(2)] = inst_37135);

(statearr_37155_37176[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37154 === (1))){
var inst_37129 = cljs.core.seq.call(null,coll);
var inst_37130 = inst_37129;
var state_37153__$1 = (function (){var statearr_37156 = state_37153;
(statearr_37156[(7)] = inst_37130);

return statearr_37156;
})();
var statearr_37157_37177 = state_37153__$1;
(statearr_37157_37177[(2)] = null);

(statearr_37157_37177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37154 === (4))){
var inst_37130 = (state_37153[(7)]);
var inst_37133 = cljs.core.first.call(null,inst_37130);
var state_37153__$1 = state_37153;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_37153__$1,(7),ch,inst_37133);
} else {
if((state_val_37154 === (13))){
var inst_37147 = (state_37153[(2)]);
var state_37153__$1 = state_37153;
var statearr_37158_37178 = state_37153__$1;
(statearr_37158_37178[(2)] = inst_37147);

(statearr_37158_37178[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37154 === (6))){
var inst_37138 = (state_37153[(2)]);
var state_37153__$1 = state_37153;
if(cljs.core.truth_(inst_37138)){
var statearr_37159_37179 = state_37153__$1;
(statearr_37159_37179[(1)] = (8));

} else {
var statearr_37160_37180 = state_37153__$1;
(statearr_37160_37180[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37154 === (3))){
var inst_37151 = (state_37153[(2)]);
var state_37153__$1 = state_37153;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37153__$1,inst_37151);
} else {
if((state_val_37154 === (12))){
var state_37153__$1 = state_37153;
var statearr_37161_37181 = state_37153__$1;
(statearr_37161_37181[(2)] = null);

(statearr_37161_37181[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37154 === (2))){
var inst_37130 = (state_37153[(7)]);
var state_37153__$1 = state_37153;
if(cljs.core.truth_(inst_37130)){
var statearr_37162_37182 = state_37153__$1;
(statearr_37162_37182[(1)] = (4));

} else {
var statearr_37163_37183 = state_37153__$1;
(statearr_37163_37183[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37154 === (11))){
var inst_37144 = cljs.core.async.close_BANG_.call(null,ch);
var state_37153__$1 = state_37153;
var statearr_37164_37184 = state_37153__$1;
(statearr_37164_37184[(2)] = inst_37144);

(statearr_37164_37184[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37154 === (9))){
var state_37153__$1 = state_37153;
if(cljs.core.truth_(close_QMARK_)){
var statearr_37165_37185 = state_37153__$1;
(statearr_37165_37185[(1)] = (11));

} else {
var statearr_37166_37186 = state_37153__$1;
(statearr_37166_37186[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37154 === (5))){
var inst_37130 = (state_37153[(7)]);
var state_37153__$1 = state_37153;
var statearr_37167_37187 = state_37153__$1;
(statearr_37167_37187[(2)] = inst_37130);

(statearr_37167_37187[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37154 === (10))){
var inst_37149 = (state_37153[(2)]);
var state_37153__$1 = state_37153;
var statearr_37168_37188 = state_37153__$1;
(statearr_37168_37188[(2)] = inst_37149);

(statearr_37168_37188[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37154 === (8))){
var inst_37130 = (state_37153[(7)]);
var inst_37140 = cljs.core.next.call(null,inst_37130);
var inst_37130__$1 = inst_37140;
var state_37153__$1 = (function (){var statearr_37169 = state_37153;
(statearr_37169[(7)] = inst_37130__$1);

return statearr_37169;
})();
var statearr_37170_37189 = state_37153__$1;
(statearr_37170_37189[(2)] = null);

(statearr_37170_37189[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36609__auto__))
;
return ((function (switch__36521__auto__,c__36609__auto__){
return (function() {
var cljs$core$async$state_machine__36522__auto__ = null;
var cljs$core$async$state_machine__36522__auto____0 = (function (){
var statearr_37171 = [null,null,null,null,null,null,null,null];
(statearr_37171[(0)] = cljs$core$async$state_machine__36522__auto__);

(statearr_37171[(1)] = (1));

return statearr_37171;
});
var cljs$core$async$state_machine__36522__auto____1 = (function (state_37153){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_37153);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e37172){if((e37172 instanceof Object)){
var ex__36525__auto__ = e37172;
var statearr_37173_37190 = state_37153;
(statearr_37173_37190[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37153);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37172;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37191 = state_37153;
state_37153 = G__37191;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
cljs$core$async$state_machine__36522__auto__ = function(state_37153){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36522__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36522__auto____1.call(this,state_37153);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36522__auto____0;
cljs$core$async$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36522__auto____1;
return cljs$core$async$state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto__))
})();
var state__36611__auto__ = (function (){var statearr_37174 = f__36610__auto__.call(null);
(statearr_37174[(6)] = c__36609__auto__);

return statearr_37174;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto__))
);

return c__36609__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if(((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4211__auto__ = (((_ == null))?null:_);
var m__4212__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,_);
} else {
var m__4212__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4212__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m,ch);
} else {
var m__4212__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m);
} else {
var m__4212__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async37192 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37192 = (function (ch,cs,meta37193){
this.ch = ch;
this.cs = cs;
this.meta37193 = meta37193;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async37192.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_37194,meta37193__$1){
var self__ = this;
var _37194__$1 = this;
return (new cljs.core.async.t_cljs$core$async37192(self__.ch,self__.cs,meta37193__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async37192.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_37194){
var self__ = this;
var _37194__$1 = this;
return self__.meta37193;
});})(cs))
;

cljs.core.async.t_cljs$core$async37192.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async37192.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async37192.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async37192.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async37192.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async37192.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async37192.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta37193","meta37193",1612415329,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async37192.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async37192.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37192";

cljs.core.async.t_cljs$core$async37192.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async37192");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37192.
 */
cljs.core.async.__GT_t_cljs$core$async37192 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async37192(ch__$1,cs__$1,meta37193){
return (new cljs.core.async.t_cljs$core$async37192(ch__$1,cs__$1,meta37193));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async37192(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__36609__auto___37414 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto___37414,cs,m,dchan,dctr,done){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto___37414,cs,m,dchan,dctr,done){
return (function (state_37329){
var state_val_37330 = (state_37329[(1)]);
if((state_val_37330 === (7))){
var inst_37325 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
var statearr_37331_37415 = state_37329__$1;
(statearr_37331_37415[(2)] = inst_37325);

(statearr_37331_37415[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (20))){
var inst_37228 = (state_37329[(7)]);
var inst_37240 = cljs.core.first.call(null,inst_37228);
var inst_37241 = cljs.core.nth.call(null,inst_37240,(0),null);
var inst_37242 = cljs.core.nth.call(null,inst_37240,(1),null);
var state_37329__$1 = (function (){var statearr_37332 = state_37329;
(statearr_37332[(8)] = inst_37241);

return statearr_37332;
})();
if(cljs.core.truth_(inst_37242)){
var statearr_37333_37416 = state_37329__$1;
(statearr_37333_37416[(1)] = (22));

} else {
var statearr_37334_37417 = state_37329__$1;
(statearr_37334_37417[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (27))){
var inst_37270 = (state_37329[(9)]);
var inst_37272 = (state_37329[(10)]);
var inst_37197 = (state_37329[(11)]);
var inst_37277 = (state_37329[(12)]);
var inst_37277__$1 = cljs.core._nth.call(null,inst_37270,inst_37272);
var inst_37278 = cljs.core.async.put_BANG_.call(null,inst_37277__$1,inst_37197,done);
var state_37329__$1 = (function (){var statearr_37335 = state_37329;
(statearr_37335[(12)] = inst_37277__$1);

return statearr_37335;
})();
if(cljs.core.truth_(inst_37278)){
var statearr_37336_37418 = state_37329__$1;
(statearr_37336_37418[(1)] = (30));

} else {
var statearr_37337_37419 = state_37329__$1;
(statearr_37337_37419[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (1))){
var state_37329__$1 = state_37329;
var statearr_37338_37420 = state_37329__$1;
(statearr_37338_37420[(2)] = null);

(statearr_37338_37420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (24))){
var inst_37228 = (state_37329[(7)]);
var inst_37247 = (state_37329[(2)]);
var inst_37248 = cljs.core.next.call(null,inst_37228);
var inst_37206 = inst_37248;
var inst_37207 = null;
var inst_37208 = (0);
var inst_37209 = (0);
var state_37329__$1 = (function (){var statearr_37339 = state_37329;
(statearr_37339[(13)] = inst_37209);

(statearr_37339[(14)] = inst_37206);

(statearr_37339[(15)] = inst_37247);

(statearr_37339[(16)] = inst_37207);

(statearr_37339[(17)] = inst_37208);

return statearr_37339;
})();
var statearr_37340_37421 = state_37329__$1;
(statearr_37340_37421[(2)] = null);

(statearr_37340_37421[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (39))){
var state_37329__$1 = state_37329;
var statearr_37344_37422 = state_37329__$1;
(statearr_37344_37422[(2)] = null);

(statearr_37344_37422[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (4))){
var inst_37197 = (state_37329[(11)]);
var inst_37197__$1 = (state_37329[(2)]);
var inst_37198 = (inst_37197__$1 == null);
var state_37329__$1 = (function (){var statearr_37345 = state_37329;
(statearr_37345[(11)] = inst_37197__$1);

return statearr_37345;
})();
if(cljs.core.truth_(inst_37198)){
var statearr_37346_37423 = state_37329__$1;
(statearr_37346_37423[(1)] = (5));

} else {
var statearr_37347_37424 = state_37329__$1;
(statearr_37347_37424[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (15))){
var inst_37209 = (state_37329[(13)]);
var inst_37206 = (state_37329[(14)]);
var inst_37207 = (state_37329[(16)]);
var inst_37208 = (state_37329[(17)]);
var inst_37224 = (state_37329[(2)]);
var inst_37225 = (inst_37209 + (1));
var tmp37341 = inst_37206;
var tmp37342 = inst_37207;
var tmp37343 = inst_37208;
var inst_37206__$1 = tmp37341;
var inst_37207__$1 = tmp37342;
var inst_37208__$1 = tmp37343;
var inst_37209__$1 = inst_37225;
var state_37329__$1 = (function (){var statearr_37348 = state_37329;
(statearr_37348[(13)] = inst_37209__$1);

(statearr_37348[(14)] = inst_37206__$1);

(statearr_37348[(16)] = inst_37207__$1);

(statearr_37348[(17)] = inst_37208__$1);

(statearr_37348[(18)] = inst_37224);

return statearr_37348;
})();
var statearr_37349_37425 = state_37329__$1;
(statearr_37349_37425[(2)] = null);

(statearr_37349_37425[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (21))){
var inst_37251 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
var statearr_37353_37426 = state_37329__$1;
(statearr_37353_37426[(2)] = inst_37251);

(statearr_37353_37426[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (31))){
var inst_37277 = (state_37329[(12)]);
var inst_37281 = done.call(null,null);
var inst_37282 = cljs.core.async.untap_STAR_.call(null,m,inst_37277);
var state_37329__$1 = (function (){var statearr_37354 = state_37329;
(statearr_37354[(19)] = inst_37281);

return statearr_37354;
})();
var statearr_37355_37427 = state_37329__$1;
(statearr_37355_37427[(2)] = inst_37282);

(statearr_37355_37427[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (32))){
var inst_37270 = (state_37329[(9)]);
var inst_37271 = (state_37329[(20)]);
var inst_37272 = (state_37329[(10)]);
var inst_37269 = (state_37329[(21)]);
var inst_37284 = (state_37329[(2)]);
var inst_37285 = (inst_37272 + (1));
var tmp37350 = inst_37270;
var tmp37351 = inst_37271;
var tmp37352 = inst_37269;
var inst_37269__$1 = tmp37352;
var inst_37270__$1 = tmp37350;
var inst_37271__$1 = tmp37351;
var inst_37272__$1 = inst_37285;
var state_37329__$1 = (function (){var statearr_37356 = state_37329;
(statearr_37356[(9)] = inst_37270__$1);

(statearr_37356[(20)] = inst_37271__$1);

(statearr_37356[(10)] = inst_37272__$1);

(statearr_37356[(21)] = inst_37269__$1);

(statearr_37356[(22)] = inst_37284);

return statearr_37356;
})();
var statearr_37357_37428 = state_37329__$1;
(statearr_37357_37428[(2)] = null);

(statearr_37357_37428[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (40))){
var inst_37297 = (state_37329[(23)]);
var inst_37301 = done.call(null,null);
var inst_37302 = cljs.core.async.untap_STAR_.call(null,m,inst_37297);
var state_37329__$1 = (function (){var statearr_37358 = state_37329;
(statearr_37358[(24)] = inst_37301);

return statearr_37358;
})();
var statearr_37359_37429 = state_37329__$1;
(statearr_37359_37429[(2)] = inst_37302);

(statearr_37359_37429[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (33))){
var inst_37288 = (state_37329[(25)]);
var inst_37290 = cljs.core.chunked_seq_QMARK_.call(null,inst_37288);
var state_37329__$1 = state_37329;
if(inst_37290){
var statearr_37360_37430 = state_37329__$1;
(statearr_37360_37430[(1)] = (36));

} else {
var statearr_37361_37431 = state_37329__$1;
(statearr_37361_37431[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (13))){
var inst_37218 = (state_37329[(26)]);
var inst_37221 = cljs.core.async.close_BANG_.call(null,inst_37218);
var state_37329__$1 = state_37329;
var statearr_37362_37432 = state_37329__$1;
(statearr_37362_37432[(2)] = inst_37221);

(statearr_37362_37432[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (22))){
var inst_37241 = (state_37329[(8)]);
var inst_37244 = cljs.core.async.close_BANG_.call(null,inst_37241);
var state_37329__$1 = state_37329;
var statearr_37363_37433 = state_37329__$1;
(statearr_37363_37433[(2)] = inst_37244);

(statearr_37363_37433[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (36))){
var inst_37288 = (state_37329[(25)]);
var inst_37292 = cljs.core.chunk_first.call(null,inst_37288);
var inst_37293 = cljs.core.chunk_rest.call(null,inst_37288);
var inst_37294 = cljs.core.count.call(null,inst_37292);
var inst_37269 = inst_37293;
var inst_37270 = inst_37292;
var inst_37271 = inst_37294;
var inst_37272 = (0);
var state_37329__$1 = (function (){var statearr_37364 = state_37329;
(statearr_37364[(9)] = inst_37270);

(statearr_37364[(20)] = inst_37271);

(statearr_37364[(10)] = inst_37272);

(statearr_37364[(21)] = inst_37269);

return statearr_37364;
})();
var statearr_37365_37434 = state_37329__$1;
(statearr_37365_37434[(2)] = null);

(statearr_37365_37434[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (41))){
var inst_37288 = (state_37329[(25)]);
var inst_37304 = (state_37329[(2)]);
var inst_37305 = cljs.core.next.call(null,inst_37288);
var inst_37269 = inst_37305;
var inst_37270 = null;
var inst_37271 = (0);
var inst_37272 = (0);
var state_37329__$1 = (function (){var statearr_37366 = state_37329;
(statearr_37366[(9)] = inst_37270);

(statearr_37366[(20)] = inst_37271);

(statearr_37366[(10)] = inst_37272);

(statearr_37366[(21)] = inst_37269);

(statearr_37366[(27)] = inst_37304);

return statearr_37366;
})();
var statearr_37367_37435 = state_37329__$1;
(statearr_37367_37435[(2)] = null);

(statearr_37367_37435[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (43))){
var state_37329__$1 = state_37329;
var statearr_37368_37436 = state_37329__$1;
(statearr_37368_37436[(2)] = null);

(statearr_37368_37436[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (29))){
var inst_37313 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
var statearr_37369_37437 = state_37329__$1;
(statearr_37369_37437[(2)] = inst_37313);

(statearr_37369_37437[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (44))){
var inst_37322 = (state_37329[(2)]);
var state_37329__$1 = (function (){var statearr_37370 = state_37329;
(statearr_37370[(28)] = inst_37322);

return statearr_37370;
})();
var statearr_37371_37438 = state_37329__$1;
(statearr_37371_37438[(2)] = null);

(statearr_37371_37438[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (6))){
var inst_37261 = (state_37329[(29)]);
var inst_37260 = cljs.core.deref.call(null,cs);
var inst_37261__$1 = cljs.core.keys.call(null,inst_37260);
var inst_37262 = cljs.core.count.call(null,inst_37261__$1);
var inst_37263 = cljs.core.reset_BANG_.call(null,dctr,inst_37262);
var inst_37268 = cljs.core.seq.call(null,inst_37261__$1);
var inst_37269 = inst_37268;
var inst_37270 = null;
var inst_37271 = (0);
var inst_37272 = (0);
var state_37329__$1 = (function (){var statearr_37372 = state_37329;
(statearr_37372[(9)] = inst_37270);

(statearr_37372[(20)] = inst_37271);

(statearr_37372[(29)] = inst_37261__$1);

(statearr_37372[(30)] = inst_37263);

(statearr_37372[(10)] = inst_37272);

(statearr_37372[(21)] = inst_37269);

return statearr_37372;
})();
var statearr_37373_37439 = state_37329__$1;
(statearr_37373_37439[(2)] = null);

(statearr_37373_37439[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (28))){
var inst_37288 = (state_37329[(25)]);
var inst_37269 = (state_37329[(21)]);
var inst_37288__$1 = cljs.core.seq.call(null,inst_37269);
var state_37329__$1 = (function (){var statearr_37374 = state_37329;
(statearr_37374[(25)] = inst_37288__$1);

return statearr_37374;
})();
if(inst_37288__$1){
var statearr_37375_37440 = state_37329__$1;
(statearr_37375_37440[(1)] = (33));

} else {
var statearr_37376_37441 = state_37329__$1;
(statearr_37376_37441[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (25))){
var inst_37271 = (state_37329[(20)]);
var inst_37272 = (state_37329[(10)]);
var inst_37274 = (inst_37272 < inst_37271);
var inst_37275 = inst_37274;
var state_37329__$1 = state_37329;
if(cljs.core.truth_(inst_37275)){
var statearr_37377_37442 = state_37329__$1;
(statearr_37377_37442[(1)] = (27));

} else {
var statearr_37378_37443 = state_37329__$1;
(statearr_37378_37443[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (34))){
var state_37329__$1 = state_37329;
var statearr_37379_37444 = state_37329__$1;
(statearr_37379_37444[(2)] = null);

(statearr_37379_37444[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (17))){
var state_37329__$1 = state_37329;
var statearr_37380_37445 = state_37329__$1;
(statearr_37380_37445[(2)] = null);

(statearr_37380_37445[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (3))){
var inst_37327 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37329__$1,inst_37327);
} else {
if((state_val_37330 === (12))){
var inst_37256 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
var statearr_37381_37446 = state_37329__$1;
(statearr_37381_37446[(2)] = inst_37256);

(statearr_37381_37446[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (2))){
var state_37329__$1 = state_37329;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37329__$1,(4),ch);
} else {
if((state_val_37330 === (23))){
var state_37329__$1 = state_37329;
var statearr_37382_37447 = state_37329__$1;
(statearr_37382_37447[(2)] = null);

(statearr_37382_37447[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (35))){
var inst_37311 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
var statearr_37383_37448 = state_37329__$1;
(statearr_37383_37448[(2)] = inst_37311);

(statearr_37383_37448[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (19))){
var inst_37228 = (state_37329[(7)]);
var inst_37232 = cljs.core.chunk_first.call(null,inst_37228);
var inst_37233 = cljs.core.chunk_rest.call(null,inst_37228);
var inst_37234 = cljs.core.count.call(null,inst_37232);
var inst_37206 = inst_37233;
var inst_37207 = inst_37232;
var inst_37208 = inst_37234;
var inst_37209 = (0);
var state_37329__$1 = (function (){var statearr_37384 = state_37329;
(statearr_37384[(13)] = inst_37209);

(statearr_37384[(14)] = inst_37206);

(statearr_37384[(16)] = inst_37207);

(statearr_37384[(17)] = inst_37208);

return statearr_37384;
})();
var statearr_37385_37449 = state_37329__$1;
(statearr_37385_37449[(2)] = null);

(statearr_37385_37449[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (11))){
var inst_37206 = (state_37329[(14)]);
var inst_37228 = (state_37329[(7)]);
var inst_37228__$1 = cljs.core.seq.call(null,inst_37206);
var state_37329__$1 = (function (){var statearr_37386 = state_37329;
(statearr_37386[(7)] = inst_37228__$1);

return statearr_37386;
})();
if(inst_37228__$1){
var statearr_37387_37450 = state_37329__$1;
(statearr_37387_37450[(1)] = (16));

} else {
var statearr_37388_37451 = state_37329__$1;
(statearr_37388_37451[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (9))){
var inst_37258 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
var statearr_37389_37452 = state_37329__$1;
(statearr_37389_37452[(2)] = inst_37258);

(statearr_37389_37452[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (5))){
var inst_37204 = cljs.core.deref.call(null,cs);
var inst_37205 = cljs.core.seq.call(null,inst_37204);
var inst_37206 = inst_37205;
var inst_37207 = null;
var inst_37208 = (0);
var inst_37209 = (0);
var state_37329__$1 = (function (){var statearr_37390 = state_37329;
(statearr_37390[(13)] = inst_37209);

(statearr_37390[(14)] = inst_37206);

(statearr_37390[(16)] = inst_37207);

(statearr_37390[(17)] = inst_37208);

return statearr_37390;
})();
var statearr_37391_37453 = state_37329__$1;
(statearr_37391_37453[(2)] = null);

(statearr_37391_37453[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (14))){
var state_37329__$1 = state_37329;
var statearr_37392_37454 = state_37329__$1;
(statearr_37392_37454[(2)] = null);

(statearr_37392_37454[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (45))){
var inst_37319 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
var statearr_37393_37455 = state_37329__$1;
(statearr_37393_37455[(2)] = inst_37319);

(statearr_37393_37455[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (26))){
var inst_37261 = (state_37329[(29)]);
var inst_37315 = (state_37329[(2)]);
var inst_37316 = cljs.core.seq.call(null,inst_37261);
var state_37329__$1 = (function (){var statearr_37394 = state_37329;
(statearr_37394[(31)] = inst_37315);

return statearr_37394;
})();
if(inst_37316){
var statearr_37395_37456 = state_37329__$1;
(statearr_37395_37456[(1)] = (42));

} else {
var statearr_37396_37457 = state_37329__$1;
(statearr_37396_37457[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (16))){
var inst_37228 = (state_37329[(7)]);
var inst_37230 = cljs.core.chunked_seq_QMARK_.call(null,inst_37228);
var state_37329__$1 = state_37329;
if(inst_37230){
var statearr_37397_37458 = state_37329__$1;
(statearr_37397_37458[(1)] = (19));

} else {
var statearr_37398_37459 = state_37329__$1;
(statearr_37398_37459[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (38))){
var inst_37308 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
var statearr_37399_37460 = state_37329__$1;
(statearr_37399_37460[(2)] = inst_37308);

(statearr_37399_37460[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (30))){
var state_37329__$1 = state_37329;
var statearr_37400_37461 = state_37329__$1;
(statearr_37400_37461[(2)] = null);

(statearr_37400_37461[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (10))){
var inst_37209 = (state_37329[(13)]);
var inst_37207 = (state_37329[(16)]);
var inst_37217 = cljs.core._nth.call(null,inst_37207,inst_37209);
var inst_37218 = cljs.core.nth.call(null,inst_37217,(0),null);
var inst_37219 = cljs.core.nth.call(null,inst_37217,(1),null);
var state_37329__$1 = (function (){var statearr_37401 = state_37329;
(statearr_37401[(26)] = inst_37218);

return statearr_37401;
})();
if(cljs.core.truth_(inst_37219)){
var statearr_37402_37462 = state_37329__$1;
(statearr_37402_37462[(1)] = (13));

} else {
var statearr_37403_37463 = state_37329__$1;
(statearr_37403_37463[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (18))){
var inst_37254 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
var statearr_37404_37464 = state_37329__$1;
(statearr_37404_37464[(2)] = inst_37254);

(statearr_37404_37464[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (42))){
var state_37329__$1 = state_37329;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37329__$1,(45),dchan);
} else {
if((state_val_37330 === (37))){
var inst_37288 = (state_37329[(25)]);
var inst_37197 = (state_37329[(11)]);
var inst_37297 = (state_37329[(23)]);
var inst_37297__$1 = cljs.core.first.call(null,inst_37288);
var inst_37298 = cljs.core.async.put_BANG_.call(null,inst_37297__$1,inst_37197,done);
var state_37329__$1 = (function (){var statearr_37405 = state_37329;
(statearr_37405[(23)] = inst_37297__$1);

return statearr_37405;
})();
if(cljs.core.truth_(inst_37298)){
var statearr_37406_37465 = state_37329__$1;
(statearr_37406_37465[(1)] = (39));

} else {
var statearr_37407_37466 = state_37329__$1;
(statearr_37407_37466[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37330 === (8))){
var inst_37209 = (state_37329[(13)]);
var inst_37208 = (state_37329[(17)]);
var inst_37211 = (inst_37209 < inst_37208);
var inst_37212 = inst_37211;
var state_37329__$1 = state_37329;
if(cljs.core.truth_(inst_37212)){
var statearr_37408_37467 = state_37329__$1;
(statearr_37408_37467[(1)] = (10));

} else {
var statearr_37409_37468 = state_37329__$1;
(statearr_37409_37468[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36609__auto___37414,cs,m,dchan,dctr,done))
;
return ((function (switch__36521__auto__,c__36609__auto___37414,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__36522__auto__ = null;
var cljs$core$async$mult_$_state_machine__36522__auto____0 = (function (){
var statearr_37410 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37410[(0)] = cljs$core$async$mult_$_state_machine__36522__auto__);

(statearr_37410[(1)] = (1));

return statearr_37410;
});
var cljs$core$async$mult_$_state_machine__36522__auto____1 = (function (state_37329){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_37329);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e37411){if((e37411 instanceof Object)){
var ex__36525__auto__ = e37411;
var statearr_37412_37469 = state_37329;
(statearr_37412_37469[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37329);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37411;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37470 = state_37329;
state_37329 = G__37470;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__36522__auto__ = function(state_37329){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__36522__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__36522__auto____1.call(this,state_37329);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__36522__auto____0;
cljs$core$async$mult_$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__36522__auto____1;
return cljs$core$async$mult_$_state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto___37414,cs,m,dchan,dctr,done))
})();
var state__36611__auto__ = (function (){var statearr_37413 = f__36610__auto__.call(null);
(statearr_37413[(6)] = c__36609__auto___37414);

return statearr_37413;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto___37414,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__37472 = arguments.length;
switch (G__37472) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m,ch);
} else {
var m__4212__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m,ch);
} else {
var m__4212__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m);
} else {
var m__4212__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m,state_map);
} else {
var m__4212__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m,mode);
} else {
var m__4212__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4502__auto__ = [];
var len__4499__auto___37484 = arguments.length;
var i__4500__auto___37485 = (0);
while(true){
if((i__4500__auto___37485 < len__4499__auto___37484)){
args__4502__auto__.push((arguments[i__4500__auto___37485]));

var G__37486 = (i__4500__auto___37485 + (1));
i__4500__auto___37485 = G__37486;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((3) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4503__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__37478){
var map__37479 = p__37478;
var map__37479__$1 = ((((!((map__37479 == null)))?(((((map__37479.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37479.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37479):map__37479);
var opts = map__37479__$1;
var statearr_37481_37487 = state;
(statearr_37481_37487[(1)] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__37479,map__37479__$1,opts){
return (function (val){
var statearr_37482_37488 = state;
(statearr_37482_37488[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__37479,map__37479__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_37483_37489 = state;
(statearr_37483_37489[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq37474){
var G__37475 = cljs.core.first.call(null,seq37474);
var seq37474__$1 = cljs.core.next.call(null,seq37474);
var G__37476 = cljs.core.first.call(null,seq37474__$1);
var seq37474__$2 = cljs.core.next.call(null,seq37474__$1);
var G__37477 = cljs.core.first.call(null,seq37474__$2);
var seq37474__$3 = cljs.core.next.call(null,seq37474__$2);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37475,G__37476,G__37477,seq37474__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos)))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async37490 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37490 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta37491){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta37491 = meta37491;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async37490.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_37492,meta37491__$1){
var self__ = this;
var _37492__$1 = this;
return (new cljs.core.async.t_cljs$core$async37490(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta37491__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37490.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_37492){
var self__ = this;
var _37492__$1 = this;
return self__.meta37491;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37490.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async37490.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37490.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async37490.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37490.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37490.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37490.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37490.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37490.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta37491","meta37491",-772516061,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37490.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async37490.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37490";

cljs.core.async.t_cljs$core$async37490.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async37490");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37490.
 */
cljs.core.async.__GT_t_cljs$core$async37490 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async37490(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta37491){
return (new cljs.core.async.t_cljs$core$async37490(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta37491));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async37490(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__36609__auto___37654 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto___37654,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto___37654,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_37594){
var state_val_37595 = (state_37594[(1)]);
if((state_val_37595 === (7))){
var inst_37509 = (state_37594[(2)]);
var state_37594__$1 = state_37594;
var statearr_37596_37655 = state_37594__$1;
(statearr_37596_37655[(2)] = inst_37509);

(statearr_37596_37655[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (20))){
var inst_37521 = (state_37594[(7)]);
var state_37594__$1 = state_37594;
var statearr_37597_37656 = state_37594__$1;
(statearr_37597_37656[(2)] = inst_37521);

(statearr_37597_37656[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (27))){
var state_37594__$1 = state_37594;
var statearr_37598_37657 = state_37594__$1;
(statearr_37598_37657[(2)] = null);

(statearr_37598_37657[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (1))){
var inst_37496 = (state_37594[(8)]);
var inst_37496__$1 = calc_state.call(null);
var inst_37498 = (inst_37496__$1 == null);
var inst_37499 = cljs.core.not.call(null,inst_37498);
var state_37594__$1 = (function (){var statearr_37599 = state_37594;
(statearr_37599[(8)] = inst_37496__$1);

return statearr_37599;
})();
if(inst_37499){
var statearr_37600_37658 = state_37594__$1;
(statearr_37600_37658[(1)] = (2));

} else {
var statearr_37601_37659 = state_37594__$1;
(statearr_37601_37659[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (24))){
var inst_37554 = (state_37594[(9)]);
var inst_37568 = (state_37594[(10)]);
var inst_37545 = (state_37594[(11)]);
var inst_37568__$1 = inst_37545.call(null,inst_37554);
var state_37594__$1 = (function (){var statearr_37602 = state_37594;
(statearr_37602[(10)] = inst_37568__$1);

return statearr_37602;
})();
if(cljs.core.truth_(inst_37568__$1)){
var statearr_37603_37660 = state_37594__$1;
(statearr_37603_37660[(1)] = (29));

} else {
var statearr_37604_37661 = state_37594__$1;
(statearr_37604_37661[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (4))){
var inst_37512 = (state_37594[(2)]);
var state_37594__$1 = state_37594;
if(cljs.core.truth_(inst_37512)){
var statearr_37605_37662 = state_37594__$1;
(statearr_37605_37662[(1)] = (8));

} else {
var statearr_37606_37663 = state_37594__$1;
(statearr_37606_37663[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (15))){
var inst_37539 = (state_37594[(2)]);
var state_37594__$1 = state_37594;
if(cljs.core.truth_(inst_37539)){
var statearr_37607_37664 = state_37594__$1;
(statearr_37607_37664[(1)] = (19));

} else {
var statearr_37608_37665 = state_37594__$1;
(statearr_37608_37665[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (21))){
var inst_37544 = (state_37594[(12)]);
var inst_37544__$1 = (state_37594[(2)]);
var inst_37545 = cljs.core.get.call(null,inst_37544__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_37546 = cljs.core.get.call(null,inst_37544__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_37547 = cljs.core.get.call(null,inst_37544__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_37594__$1 = (function (){var statearr_37609 = state_37594;
(statearr_37609[(12)] = inst_37544__$1);

(statearr_37609[(13)] = inst_37546);

(statearr_37609[(11)] = inst_37545);

return statearr_37609;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_37594__$1,(22),inst_37547);
} else {
if((state_val_37595 === (31))){
var inst_37576 = (state_37594[(2)]);
var state_37594__$1 = state_37594;
if(cljs.core.truth_(inst_37576)){
var statearr_37610_37666 = state_37594__$1;
(statearr_37610_37666[(1)] = (32));

} else {
var statearr_37611_37667 = state_37594__$1;
(statearr_37611_37667[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (32))){
var inst_37553 = (state_37594[(14)]);
var state_37594__$1 = state_37594;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_37594__$1,(35),out,inst_37553);
} else {
if((state_val_37595 === (33))){
var inst_37544 = (state_37594[(12)]);
var inst_37521 = inst_37544;
var state_37594__$1 = (function (){var statearr_37612 = state_37594;
(statearr_37612[(7)] = inst_37521);

return statearr_37612;
})();
var statearr_37613_37668 = state_37594__$1;
(statearr_37613_37668[(2)] = null);

(statearr_37613_37668[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (13))){
var inst_37521 = (state_37594[(7)]);
var inst_37528 = inst_37521.cljs$lang$protocol_mask$partition0$;
var inst_37529 = (inst_37528 & (64));
var inst_37530 = inst_37521.cljs$core$ISeq$;
var inst_37531 = (cljs.core.PROTOCOL_SENTINEL === inst_37530);
var inst_37532 = ((inst_37529) || (inst_37531));
var state_37594__$1 = state_37594;
if(cljs.core.truth_(inst_37532)){
var statearr_37614_37669 = state_37594__$1;
(statearr_37614_37669[(1)] = (16));

} else {
var statearr_37615_37670 = state_37594__$1;
(statearr_37615_37670[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (22))){
var inst_37554 = (state_37594[(9)]);
var inst_37553 = (state_37594[(14)]);
var inst_37552 = (state_37594[(2)]);
var inst_37553__$1 = cljs.core.nth.call(null,inst_37552,(0),null);
var inst_37554__$1 = cljs.core.nth.call(null,inst_37552,(1),null);
var inst_37555 = (inst_37553__$1 == null);
var inst_37556 = cljs.core._EQ_.call(null,inst_37554__$1,change);
var inst_37557 = ((inst_37555) || (inst_37556));
var state_37594__$1 = (function (){var statearr_37616 = state_37594;
(statearr_37616[(9)] = inst_37554__$1);

(statearr_37616[(14)] = inst_37553__$1);

return statearr_37616;
})();
if(cljs.core.truth_(inst_37557)){
var statearr_37617_37671 = state_37594__$1;
(statearr_37617_37671[(1)] = (23));

} else {
var statearr_37618_37672 = state_37594__$1;
(statearr_37618_37672[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (36))){
var inst_37544 = (state_37594[(12)]);
var inst_37521 = inst_37544;
var state_37594__$1 = (function (){var statearr_37619 = state_37594;
(statearr_37619[(7)] = inst_37521);

return statearr_37619;
})();
var statearr_37620_37673 = state_37594__$1;
(statearr_37620_37673[(2)] = null);

(statearr_37620_37673[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (29))){
var inst_37568 = (state_37594[(10)]);
var state_37594__$1 = state_37594;
var statearr_37621_37674 = state_37594__$1;
(statearr_37621_37674[(2)] = inst_37568);

(statearr_37621_37674[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (6))){
var state_37594__$1 = state_37594;
var statearr_37622_37675 = state_37594__$1;
(statearr_37622_37675[(2)] = false);

(statearr_37622_37675[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (28))){
var inst_37564 = (state_37594[(2)]);
var inst_37565 = calc_state.call(null);
var inst_37521 = inst_37565;
var state_37594__$1 = (function (){var statearr_37623 = state_37594;
(statearr_37623[(15)] = inst_37564);

(statearr_37623[(7)] = inst_37521);

return statearr_37623;
})();
var statearr_37624_37676 = state_37594__$1;
(statearr_37624_37676[(2)] = null);

(statearr_37624_37676[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (25))){
var inst_37590 = (state_37594[(2)]);
var state_37594__$1 = state_37594;
var statearr_37625_37677 = state_37594__$1;
(statearr_37625_37677[(2)] = inst_37590);

(statearr_37625_37677[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (34))){
var inst_37588 = (state_37594[(2)]);
var state_37594__$1 = state_37594;
var statearr_37626_37678 = state_37594__$1;
(statearr_37626_37678[(2)] = inst_37588);

(statearr_37626_37678[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (17))){
var state_37594__$1 = state_37594;
var statearr_37627_37679 = state_37594__$1;
(statearr_37627_37679[(2)] = false);

(statearr_37627_37679[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (3))){
var state_37594__$1 = state_37594;
var statearr_37628_37680 = state_37594__$1;
(statearr_37628_37680[(2)] = false);

(statearr_37628_37680[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (12))){
var inst_37592 = (state_37594[(2)]);
var state_37594__$1 = state_37594;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37594__$1,inst_37592);
} else {
if((state_val_37595 === (2))){
var inst_37496 = (state_37594[(8)]);
var inst_37501 = inst_37496.cljs$lang$protocol_mask$partition0$;
var inst_37502 = (inst_37501 & (64));
var inst_37503 = inst_37496.cljs$core$ISeq$;
var inst_37504 = (cljs.core.PROTOCOL_SENTINEL === inst_37503);
var inst_37505 = ((inst_37502) || (inst_37504));
var state_37594__$1 = state_37594;
if(cljs.core.truth_(inst_37505)){
var statearr_37629_37681 = state_37594__$1;
(statearr_37629_37681[(1)] = (5));

} else {
var statearr_37630_37682 = state_37594__$1;
(statearr_37630_37682[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (23))){
var inst_37553 = (state_37594[(14)]);
var inst_37559 = (inst_37553 == null);
var state_37594__$1 = state_37594;
if(cljs.core.truth_(inst_37559)){
var statearr_37631_37683 = state_37594__$1;
(statearr_37631_37683[(1)] = (26));

} else {
var statearr_37632_37684 = state_37594__$1;
(statearr_37632_37684[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (35))){
var inst_37579 = (state_37594[(2)]);
var state_37594__$1 = state_37594;
if(cljs.core.truth_(inst_37579)){
var statearr_37633_37685 = state_37594__$1;
(statearr_37633_37685[(1)] = (36));

} else {
var statearr_37634_37686 = state_37594__$1;
(statearr_37634_37686[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (19))){
var inst_37521 = (state_37594[(7)]);
var inst_37541 = cljs.core.apply.call(null,cljs.core.hash_map,inst_37521);
var state_37594__$1 = state_37594;
var statearr_37635_37687 = state_37594__$1;
(statearr_37635_37687[(2)] = inst_37541);

(statearr_37635_37687[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (11))){
var inst_37521 = (state_37594[(7)]);
var inst_37525 = (inst_37521 == null);
var inst_37526 = cljs.core.not.call(null,inst_37525);
var state_37594__$1 = state_37594;
if(inst_37526){
var statearr_37636_37688 = state_37594__$1;
(statearr_37636_37688[(1)] = (13));

} else {
var statearr_37637_37689 = state_37594__$1;
(statearr_37637_37689[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (9))){
var inst_37496 = (state_37594[(8)]);
var state_37594__$1 = state_37594;
var statearr_37638_37690 = state_37594__$1;
(statearr_37638_37690[(2)] = inst_37496);

(statearr_37638_37690[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (5))){
var state_37594__$1 = state_37594;
var statearr_37639_37691 = state_37594__$1;
(statearr_37639_37691[(2)] = true);

(statearr_37639_37691[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (14))){
var state_37594__$1 = state_37594;
var statearr_37640_37692 = state_37594__$1;
(statearr_37640_37692[(2)] = false);

(statearr_37640_37692[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (26))){
var inst_37554 = (state_37594[(9)]);
var inst_37561 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_37554);
var state_37594__$1 = state_37594;
var statearr_37641_37693 = state_37594__$1;
(statearr_37641_37693[(2)] = inst_37561);

(statearr_37641_37693[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (16))){
var state_37594__$1 = state_37594;
var statearr_37642_37694 = state_37594__$1;
(statearr_37642_37694[(2)] = true);

(statearr_37642_37694[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (38))){
var inst_37584 = (state_37594[(2)]);
var state_37594__$1 = state_37594;
var statearr_37643_37695 = state_37594__$1;
(statearr_37643_37695[(2)] = inst_37584);

(statearr_37643_37695[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (30))){
var inst_37554 = (state_37594[(9)]);
var inst_37546 = (state_37594[(13)]);
var inst_37545 = (state_37594[(11)]);
var inst_37571 = cljs.core.empty_QMARK_.call(null,inst_37545);
var inst_37572 = inst_37546.call(null,inst_37554);
var inst_37573 = cljs.core.not.call(null,inst_37572);
var inst_37574 = ((inst_37571) && (inst_37573));
var state_37594__$1 = state_37594;
var statearr_37644_37696 = state_37594__$1;
(statearr_37644_37696[(2)] = inst_37574);

(statearr_37644_37696[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (10))){
var inst_37496 = (state_37594[(8)]);
var inst_37517 = (state_37594[(2)]);
var inst_37518 = cljs.core.get.call(null,inst_37517,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_37519 = cljs.core.get.call(null,inst_37517,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_37520 = cljs.core.get.call(null,inst_37517,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_37521 = inst_37496;
var state_37594__$1 = (function (){var statearr_37645 = state_37594;
(statearr_37645[(16)] = inst_37518);

(statearr_37645[(17)] = inst_37520);

(statearr_37645[(7)] = inst_37521);

(statearr_37645[(18)] = inst_37519);

return statearr_37645;
})();
var statearr_37646_37697 = state_37594__$1;
(statearr_37646_37697[(2)] = null);

(statearr_37646_37697[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (18))){
var inst_37536 = (state_37594[(2)]);
var state_37594__$1 = state_37594;
var statearr_37647_37698 = state_37594__$1;
(statearr_37647_37698[(2)] = inst_37536);

(statearr_37647_37698[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (37))){
var state_37594__$1 = state_37594;
var statearr_37648_37699 = state_37594__$1;
(statearr_37648_37699[(2)] = null);

(statearr_37648_37699[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37595 === (8))){
var inst_37496 = (state_37594[(8)]);
var inst_37514 = cljs.core.apply.call(null,cljs.core.hash_map,inst_37496);
var state_37594__$1 = state_37594;
var statearr_37649_37700 = state_37594__$1;
(statearr_37649_37700[(2)] = inst_37514);

(statearr_37649_37700[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36609__auto___37654,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__36521__auto__,c__36609__auto___37654,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__36522__auto__ = null;
var cljs$core$async$mix_$_state_machine__36522__auto____0 = (function (){
var statearr_37650 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37650[(0)] = cljs$core$async$mix_$_state_machine__36522__auto__);

(statearr_37650[(1)] = (1));

return statearr_37650;
});
var cljs$core$async$mix_$_state_machine__36522__auto____1 = (function (state_37594){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_37594);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e37651){if((e37651 instanceof Object)){
var ex__36525__auto__ = e37651;
var statearr_37652_37701 = state_37594;
(statearr_37652_37701[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37594);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37651;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37702 = state_37594;
state_37594 = G__37702;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__36522__auto__ = function(state_37594){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__36522__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__36522__auto____1.call(this,state_37594);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__36522__auto____0;
cljs$core$async$mix_$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__36522__auto____1;
return cljs$core$async$mix_$_state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto___37654,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__36611__auto__ = (function (){var statearr_37653 = f__36610__auto__.call(null);
(statearr_37653[(6)] = c__36609__auto___37654);

return statearr_37653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto___37654,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4211__auto__ = (((p == null))?null:p);
var m__4212__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4212__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4211__auto__ = (((p == null))?null:p);
var m__4212__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,p,v,ch);
} else {
var m__4212__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__37704 = arguments.length;
switch (G__37704) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4211__auto__ = (((p == null))?null:p);
var m__4212__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,p);
} else {
var m__4212__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4211__auto__ = (((p == null))?null:p);
var m__4212__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,p,v);
} else {
var m__4212__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__37708 = arguments.length;
switch (G__37708) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__3922__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__3922__auto__,mults){
return (function (p1__37706_SHARP_){
if(cljs.core.truth_(p1__37706_SHARP_.call(null,topic))){
return p1__37706_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__37706_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__3922__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async37709 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37709 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta37710){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta37710 = meta37710;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async37709.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_37711,meta37710__$1){
var self__ = this;
var _37711__$1 = this;
return (new cljs.core.async.t_cljs$core$async37709(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta37710__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37709.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_37711){
var self__ = this;
var _37711__$1 = this;
return self__.meta37710;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37709.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async37709.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37709.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async37709.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37709.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37709.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37709.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37709.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta37710","meta37710",-1360204673,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37709.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async37709.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37709";

cljs.core.async.t_cljs$core$async37709.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async37709");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37709.
 */
cljs.core.async.__GT_t_cljs$core$async37709 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async37709(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta37710){
return (new cljs.core.async.t_cljs$core$async37709(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta37710));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async37709(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__36609__auto___37829 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto___37829,mults,ensure_mult,p){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto___37829,mults,ensure_mult,p){
return (function (state_37783){
var state_val_37784 = (state_37783[(1)]);
if((state_val_37784 === (7))){
var inst_37779 = (state_37783[(2)]);
var state_37783__$1 = state_37783;
var statearr_37785_37830 = state_37783__$1;
(statearr_37785_37830[(2)] = inst_37779);

(statearr_37785_37830[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37784 === (20))){
var state_37783__$1 = state_37783;
var statearr_37786_37831 = state_37783__$1;
(statearr_37786_37831[(2)] = null);

(statearr_37786_37831[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37784 === (1))){
var state_37783__$1 = state_37783;
var statearr_37787_37832 = state_37783__$1;
(statearr_37787_37832[(2)] = null);

(statearr_37787_37832[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37784 === (24))){
var inst_37762 = (state_37783[(7)]);
var inst_37771 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_37762);
var state_37783__$1 = state_37783;
var statearr_37788_37833 = state_37783__$1;
(statearr_37788_37833[(2)] = inst_37771);

(statearr_37788_37833[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37784 === (4))){
var inst_37714 = (state_37783[(8)]);
var inst_37714__$1 = (state_37783[(2)]);
var inst_37715 = (inst_37714__$1 == null);
var state_37783__$1 = (function (){var statearr_37789 = state_37783;
(statearr_37789[(8)] = inst_37714__$1);

return statearr_37789;
})();
if(cljs.core.truth_(inst_37715)){
var statearr_37790_37834 = state_37783__$1;
(statearr_37790_37834[(1)] = (5));

} else {
var statearr_37791_37835 = state_37783__$1;
(statearr_37791_37835[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37784 === (15))){
var inst_37756 = (state_37783[(2)]);
var state_37783__$1 = state_37783;
var statearr_37792_37836 = state_37783__$1;
(statearr_37792_37836[(2)] = inst_37756);

(statearr_37792_37836[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37784 === (21))){
var inst_37776 = (state_37783[(2)]);
var state_37783__$1 = (function (){var statearr_37793 = state_37783;
(statearr_37793[(9)] = inst_37776);

return statearr_37793;
})();
var statearr_37794_37837 = state_37783__$1;
(statearr_37794_37837[(2)] = null);

(statearr_37794_37837[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37784 === (13))){
var inst_37738 = (state_37783[(10)]);
var inst_37740 = cljs.core.chunked_seq_QMARK_.call(null,inst_37738);
var state_37783__$1 = state_37783;
if(inst_37740){
var statearr_37795_37838 = state_37783__$1;
(statearr_37795_37838[(1)] = (16));

} else {
var statearr_37796_37839 = state_37783__$1;
(statearr_37796_37839[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37784 === (22))){
var inst_37768 = (state_37783[(2)]);
var state_37783__$1 = state_37783;
if(cljs.core.truth_(inst_37768)){
var statearr_37797_37840 = state_37783__$1;
(statearr_37797_37840[(1)] = (23));

} else {
var statearr_37798_37841 = state_37783__$1;
(statearr_37798_37841[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37784 === (6))){
var inst_37764 = (state_37783[(11)]);
var inst_37714 = (state_37783[(8)]);
var inst_37762 = (state_37783[(7)]);
var inst_37762__$1 = topic_fn.call(null,inst_37714);
var inst_37763 = cljs.core.deref.call(null,mults);
var inst_37764__$1 = cljs.core.get.call(null,inst_37763,inst_37762__$1);
var state_37783__$1 = (function (){var statearr_37799 = state_37783;
(statearr_37799[(11)] = inst_37764__$1);

(statearr_37799[(7)] = inst_37762__$1);

return statearr_37799;
})();
if(cljs.core.truth_(inst_37764__$1)){
var statearr_37800_37842 = state_37783__$1;
(statearr_37800_37842[(1)] = (19));

} else {
var statearr_37801_37843 = state_37783__$1;
(statearr_37801_37843[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37784 === (25))){
var inst_37773 = (state_37783[(2)]);
var state_37783__$1 = state_37783;
var statearr_37802_37844 = state_37783__$1;
(statearr_37802_37844[(2)] = inst_37773);

(statearr_37802_37844[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37784 === (17))){
var inst_37738 = (state_37783[(10)]);
var inst_37747 = cljs.core.first.call(null,inst_37738);
var inst_37748 = cljs.core.async.muxch_STAR_.call(null,inst_37747);
var inst_37749 = cljs.core.async.close_BANG_.call(null,inst_37748);
var inst_37750 = cljs.core.next.call(null,inst_37738);
var inst_37724 = inst_37750;
var inst_37725 = null;
var inst_37726 = (0);
var inst_37727 = (0);
var state_37783__$1 = (function (){var statearr_37803 = state_37783;
(statearr_37803[(12)] = inst_37727);

(statearr_37803[(13)] = inst_37724);

(statearr_37803[(14)] = inst_37726);

(statearr_37803[(15)] = inst_37725);

(statearr_37803[(16)] = inst_37749);

return statearr_37803;
})();
var statearr_37804_37845 = state_37783__$1;
(statearr_37804_37845[(2)] = null);

(statearr_37804_37845[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37784 === (3))){
var inst_37781 = (state_37783[(2)]);
var state_37783__$1 = state_37783;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37783__$1,inst_37781);
} else {
if((state_val_37784 === (12))){
var inst_37758 = (state_37783[(2)]);
var state_37783__$1 = state_37783;
var statearr_37805_37846 = state_37783__$1;
(statearr_37805_37846[(2)] = inst_37758);

(statearr_37805_37846[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37784 === (2))){
var state_37783__$1 = state_37783;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37783__$1,(4),ch);
} else {
if((state_val_37784 === (23))){
var state_37783__$1 = state_37783;
var statearr_37806_37847 = state_37783__$1;
(statearr_37806_37847[(2)] = null);

(statearr_37806_37847[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37784 === (19))){
var inst_37764 = (state_37783[(11)]);
var inst_37714 = (state_37783[(8)]);
var inst_37766 = cljs.core.async.muxch_STAR_.call(null,inst_37764);
var state_37783__$1 = state_37783;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_37783__$1,(22),inst_37766,inst_37714);
} else {
if((state_val_37784 === (11))){
var inst_37738 = (state_37783[(10)]);
var inst_37724 = (state_37783[(13)]);
var inst_37738__$1 = cljs.core.seq.call(null,inst_37724);
var state_37783__$1 = (function (){var statearr_37807 = state_37783;
(statearr_37807[(10)] = inst_37738__$1);

return statearr_37807;
})();
if(inst_37738__$1){
var statearr_37808_37848 = state_37783__$1;
(statearr_37808_37848[(1)] = (13));

} else {
var statearr_37809_37849 = state_37783__$1;
(statearr_37809_37849[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37784 === (9))){
var inst_37760 = (state_37783[(2)]);
var state_37783__$1 = state_37783;
var statearr_37810_37850 = state_37783__$1;
(statearr_37810_37850[(2)] = inst_37760);

(statearr_37810_37850[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37784 === (5))){
var inst_37721 = cljs.core.deref.call(null,mults);
var inst_37722 = cljs.core.vals.call(null,inst_37721);
var inst_37723 = cljs.core.seq.call(null,inst_37722);
var inst_37724 = inst_37723;
var inst_37725 = null;
var inst_37726 = (0);
var inst_37727 = (0);
var state_37783__$1 = (function (){var statearr_37811 = state_37783;
(statearr_37811[(12)] = inst_37727);

(statearr_37811[(13)] = inst_37724);

(statearr_37811[(14)] = inst_37726);

(statearr_37811[(15)] = inst_37725);

return statearr_37811;
})();
var statearr_37812_37851 = state_37783__$1;
(statearr_37812_37851[(2)] = null);

(statearr_37812_37851[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37784 === (14))){
var state_37783__$1 = state_37783;
var statearr_37816_37852 = state_37783__$1;
(statearr_37816_37852[(2)] = null);

(statearr_37816_37852[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37784 === (16))){
var inst_37738 = (state_37783[(10)]);
var inst_37742 = cljs.core.chunk_first.call(null,inst_37738);
var inst_37743 = cljs.core.chunk_rest.call(null,inst_37738);
var inst_37744 = cljs.core.count.call(null,inst_37742);
var inst_37724 = inst_37743;
var inst_37725 = inst_37742;
var inst_37726 = inst_37744;
var inst_37727 = (0);
var state_37783__$1 = (function (){var statearr_37817 = state_37783;
(statearr_37817[(12)] = inst_37727);

(statearr_37817[(13)] = inst_37724);

(statearr_37817[(14)] = inst_37726);

(statearr_37817[(15)] = inst_37725);

return statearr_37817;
})();
var statearr_37818_37853 = state_37783__$1;
(statearr_37818_37853[(2)] = null);

(statearr_37818_37853[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37784 === (10))){
var inst_37727 = (state_37783[(12)]);
var inst_37724 = (state_37783[(13)]);
var inst_37726 = (state_37783[(14)]);
var inst_37725 = (state_37783[(15)]);
var inst_37732 = cljs.core._nth.call(null,inst_37725,inst_37727);
var inst_37733 = cljs.core.async.muxch_STAR_.call(null,inst_37732);
var inst_37734 = cljs.core.async.close_BANG_.call(null,inst_37733);
var inst_37735 = (inst_37727 + (1));
var tmp37813 = inst_37724;
var tmp37814 = inst_37726;
var tmp37815 = inst_37725;
var inst_37724__$1 = tmp37813;
var inst_37725__$1 = tmp37815;
var inst_37726__$1 = tmp37814;
var inst_37727__$1 = inst_37735;
var state_37783__$1 = (function (){var statearr_37819 = state_37783;
(statearr_37819[(12)] = inst_37727__$1);

(statearr_37819[(17)] = inst_37734);

(statearr_37819[(13)] = inst_37724__$1);

(statearr_37819[(14)] = inst_37726__$1);

(statearr_37819[(15)] = inst_37725__$1);

return statearr_37819;
})();
var statearr_37820_37854 = state_37783__$1;
(statearr_37820_37854[(2)] = null);

(statearr_37820_37854[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37784 === (18))){
var inst_37753 = (state_37783[(2)]);
var state_37783__$1 = state_37783;
var statearr_37821_37855 = state_37783__$1;
(statearr_37821_37855[(2)] = inst_37753);

(statearr_37821_37855[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37784 === (8))){
var inst_37727 = (state_37783[(12)]);
var inst_37726 = (state_37783[(14)]);
var inst_37729 = (inst_37727 < inst_37726);
var inst_37730 = inst_37729;
var state_37783__$1 = state_37783;
if(cljs.core.truth_(inst_37730)){
var statearr_37822_37856 = state_37783__$1;
(statearr_37822_37856[(1)] = (10));

} else {
var statearr_37823_37857 = state_37783__$1;
(statearr_37823_37857[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36609__auto___37829,mults,ensure_mult,p))
;
return ((function (switch__36521__auto__,c__36609__auto___37829,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__36522__auto__ = null;
var cljs$core$async$state_machine__36522__auto____0 = (function (){
var statearr_37824 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37824[(0)] = cljs$core$async$state_machine__36522__auto__);

(statearr_37824[(1)] = (1));

return statearr_37824;
});
var cljs$core$async$state_machine__36522__auto____1 = (function (state_37783){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_37783);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e37825){if((e37825 instanceof Object)){
var ex__36525__auto__ = e37825;
var statearr_37826_37858 = state_37783;
(statearr_37826_37858[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37783);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37825;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37859 = state_37783;
state_37783 = G__37859;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
cljs$core$async$state_machine__36522__auto__ = function(state_37783){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36522__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36522__auto____1.call(this,state_37783);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36522__auto____0;
cljs$core$async$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36522__auto____1;
return cljs$core$async$state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto___37829,mults,ensure_mult,p))
})();
var state__36611__auto__ = (function (){var statearr_37827 = f__36610__auto__.call(null);
(statearr_37827[(6)] = c__36609__auto___37829);

return statearr_37827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto___37829,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__37861 = arguments.length;
switch (G__37861) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__37864 = arguments.length;
switch (G__37864) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__37867 = arguments.length;
switch (G__37867) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__36609__auto___37934 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto___37934,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto___37934,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_37906){
var state_val_37907 = (state_37906[(1)]);
if((state_val_37907 === (7))){
var state_37906__$1 = state_37906;
var statearr_37908_37935 = state_37906__$1;
(statearr_37908_37935[(2)] = null);

(statearr_37908_37935[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37907 === (1))){
var state_37906__$1 = state_37906;
var statearr_37909_37936 = state_37906__$1;
(statearr_37909_37936[(2)] = null);

(statearr_37909_37936[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37907 === (4))){
var inst_37870 = (state_37906[(7)]);
var inst_37872 = (inst_37870 < cnt);
var state_37906__$1 = state_37906;
if(cljs.core.truth_(inst_37872)){
var statearr_37910_37937 = state_37906__$1;
(statearr_37910_37937[(1)] = (6));

} else {
var statearr_37911_37938 = state_37906__$1;
(statearr_37911_37938[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37907 === (15))){
var inst_37902 = (state_37906[(2)]);
var state_37906__$1 = state_37906;
var statearr_37912_37939 = state_37906__$1;
(statearr_37912_37939[(2)] = inst_37902);

(statearr_37912_37939[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37907 === (13))){
var inst_37895 = cljs.core.async.close_BANG_.call(null,out);
var state_37906__$1 = state_37906;
var statearr_37913_37940 = state_37906__$1;
(statearr_37913_37940[(2)] = inst_37895);

(statearr_37913_37940[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37907 === (6))){
var state_37906__$1 = state_37906;
var statearr_37914_37941 = state_37906__$1;
(statearr_37914_37941[(2)] = null);

(statearr_37914_37941[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37907 === (3))){
var inst_37904 = (state_37906[(2)]);
var state_37906__$1 = state_37906;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37906__$1,inst_37904);
} else {
if((state_val_37907 === (12))){
var inst_37892 = (state_37906[(8)]);
var inst_37892__$1 = (state_37906[(2)]);
var inst_37893 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_37892__$1);
var state_37906__$1 = (function (){var statearr_37915 = state_37906;
(statearr_37915[(8)] = inst_37892__$1);

return statearr_37915;
})();
if(cljs.core.truth_(inst_37893)){
var statearr_37916_37942 = state_37906__$1;
(statearr_37916_37942[(1)] = (13));

} else {
var statearr_37917_37943 = state_37906__$1;
(statearr_37917_37943[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37907 === (2))){
var inst_37869 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_37870 = (0);
var state_37906__$1 = (function (){var statearr_37918 = state_37906;
(statearr_37918[(9)] = inst_37869);

(statearr_37918[(7)] = inst_37870);

return statearr_37918;
})();
var statearr_37919_37944 = state_37906__$1;
(statearr_37919_37944[(2)] = null);

(statearr_37919_37944[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37907 === (11))){
var inst_37870 = (state_37906[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_37906,(10),Object,null,(9));
var inst_37879 = chs__$1.call(null,inst_37870);
var inst_37880 = done.call(null,inst_37870);
var inst_37881 = cljs.core.async.take_BANG_.call(null,inst_37879,inst_37880);
var state_37906__$1 = state_37906;
var statearr_37920_37945 = state_37906__$1;
(statearr_37920_37945[(2)] = inst_37881);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37906__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37907 === (9))){
var inst_37870 = (state_37906[(7)]);
var inst_37883 = (state_37906[(2)]);
var inst_37884 = (inst_37870 + (1));
var inst_37870__$1 = inst_37884;
var state_37906__$1 = (function (){var statearr_37921 = state_37906;
(statearr_37921[(10)] = inst_37883);

(statearr_37921[(7)] = inst_37870__$1);

return statearr_37921;
})();
var statearr_37922_37946 = state_37906__$1;
(statearr_37922_37946[(2)] = null);

(statearr_37922_37946[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37907 === (5))){
var inst_37890 = (state_37906[(2)]);
var state_37906__$1 = (function (){var statearr_37923 = state_37906;
(statearr_37923[(11)] = inst_37890);

return statearr_37923;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37906__$1,(12),dchan);
} else {
if((state_val_37907 === (14))){
var inst_37892 = (state_37906[(8)]);
var inst_37897 = cljs.core.apply.call(null,f,inst_37892);
var state_37906__$1 = state_37906;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_37906__$1,(16),out,inst_37897);
} else {
if((state_val_37907 === (16))){
var inst_37899 = (state_37906[(2)]);
var state_37906__$1 = (function (){var statearr_37924 = state_37906;
(statearr_37924[(12)] = inst_37899);

return statearr_37924;
})();
var statearr_37925_37947 = state_37906__$1;
(statearr_37925_37947[(2)] = null);

(statearr_37925_37947[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37907 === (10))){
var inst_37874 = (state_37906[(2)]);
var inst_37875 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_37906__$1 = (function (){var statearr_37926 = state_37906;
(statearr_37926[(13)] = inst_37874);

return statearr_37926;
})();
var statearr_37927_37948 = state_37906__$1;
(statearr_37927_37948[(2)] = inst_37875);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37906__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37907 === (8))){
var inst_37888 = (state_37906[(2)]);
var state_37906__$1 = state_37906;
var statearr_37928_37949 = state_37906__$1;
(statearr_37928_37949[(2)] = inst_37888);

(statearr_37928_37949[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36609__auto___37934,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__36521__auto__,c__36609__auto___37934,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__36522__auto__ = null;
var cljs$core$async$state_machine__36522__auto____0 = (function (){
var statearr_37929 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37929[(0)] = cljs$core$async$state_machine__36522__auto__);

(statearr_37929[(1)] = (1));

return statearr_37929;
});
var cljs$core$async$state_machine__36522__auto____1 = (function (state_37906){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_37906);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e37930){if((e37930 instanceof Object)){
var ex__36525__auto__ = e37930;
var statearr_37931_37950 = state_37906;
(statearr_37931_37950[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37906);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37930;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37951 = state_37906;
state_37906 = G__37951;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
cljs$core$async$state_machine__36522__auto__ = function(state_37906){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36522__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36522__auto____1.call(this,state_37906);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36522__auto____0;
cljs$core$async$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36522__auto____1;
return cljs$core$async$state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto___37934,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__36611__auto__ = (function (){var statearr_37932 = f__36610__auto__.call(null);
(statearr_37932[(6)] = c__36609__auto___37934);

return statearr_37932;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto___37934,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__37954 = arguments.length;
switch (G__37954) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__36609__auto___38008 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto___38008,out){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto___38008,out){
return (function (state_37986){
var state_val_37987 = (state_37986[(1)]);
if((state_val_37987 === (7))){
var inst_37965 = (state_37986[(7)]);
var inst_37966 = (state_37986[(8)]);
var inst_37965__$1 = (state_37986[(2)]);
var inst_37966__$1 = cljs.core.nth.call(null,inst_37965__$1,(0),null);
var inst_37967 = cljs.core.nth.call(null,inst_37965__$1,(1),null);
var inst_37968 = (inst_37966__$1 == null);
var state_37986__$1 = (function (){var statearr_37988 = state_37986;
(statearr_37988[(7)] = inst_37965__$1);

(statearr_37988[(9)] = inst_37967);

(statearr_37988[(8)] = inst_37966__$1);

return statearr_37988;
})();
if(cljs.core.truth_(inst_37968)){
var statearr_37989_38009 = state_37986__$1;
(statearr_37989_38009[(1)] = (8));

} else {
var statearr_37990_38010 = state_37986__$1;
(statearr_37990_38010[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37987 === (1))){
var inst_37955 = cljs.core.vec.call(null,chs);
var inst_37956 = inst_37955;
var state_37986__$1 = (function (){var statearr_37991 = state_37986;
(statearr_37991[(10)] = inst_37956);

return statearr_37991;
})();
var statearr_37992_38011 = state_37986__$1;
(statearr_37992_38011[(2)] = null);

(statearr_37992_38011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37987 === (4))){
var inst_37956 = (state_37986[(10)]);
var state_37986__$1 = state_37986;
return cljs.core.async.ioc_alts_BANG_.call(null,state_37986__$1,(7),inst_37956);
} else {
if((state_val_37987 === (6))){
var inst_37982 = (state_37986[(2)]);
var state_37986__$1 = state_37986;
var statearr_37993_38012 = state_37986__$1;
(statearr_37993_38012[(2)] = inst_37982);

(statearr_37993_38012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37987 === (3))){
var inst_37984 = (state_37986[(2)]);
var state_37986__$1 = state_37986;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37986__$1,inst_37984);
} else {
if((state_val_37987 === (2))){
var inst_37956 = (state_37986[(10)]);
var inst_37958 = cljs.core.count.call(null,inst_37956);
var inst_37959 = (inst_37958 > (0));
var state_37986__$1 = state_37986;
if(cljs.core.truth_(inst_37959)){
var statearr_37995_38013 = state_37986__$1;
(statearr_37995_38013[(1)] = (4));

} else {
var statearr_37996_38014 = state_37986__$1;
(statearr_37996_38014[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37987 === (11))){
var inst_37956 = (state_37986[(10)]);
var inst_37975 = (state_37986[(2)]);
var tmp37994 = inst_37956;
var inst_37956__$1 = tmp37994;
var state_37986__$1 = (function (){var statearr_37997 = state_37986;
(statearr_37997[(11)] = inst_37975);

(statearr_37997[(10)] = inst_37956__$1);

return statearr_37997;
})();
var statearr_37998_38015 = state_37986__$1;
(statearr_37998_38015[(2)] = null);

(statearr_37998_38015[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37987 === (9))){
var inst_37966 = (state_37986[(8)]);
var state_37986__$1 = state_37986;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_37986__$1,(11),out,inst_37966);
} else {
if((state_val_37987 === (5))){
var inst_37980 = cljs.core.async.close_BANG_.call(null,out);
var state_37986__$1 = state_37986;
var statearr_37999_38016 = state_37986__$1;
(statearr_37999_38016[(2)] = inst_37980);

(statearr_37999_38016[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37987 === (10))){
var inst_37978 = (state_37986[(2)]);
var state_37986__$1 = state_37986;
var statearr_38000_38017 = state_37986__$1;
(statearr_38000_38017[(2)] = inst_37978);

(statearr_38000_38017[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37987 === (8))){
var inst_37965 = (state_37986[(7)]);
var inst_37967 = (state_37986[(9)]);
var inst_37966 = (state_37986[(8)]);
var inst_37956 = (state_37986[(10)]);
var inst_37970 = (function (){var cs = inst_37956;
var vec__37961 = inst_37965;
var v = inst_37966;
var c = inst_37967;
return ((function (cs,vec__37961,v,c,inst_37965,inst_37967,inst_37966,inst_37956,state_val_37987,c__36609__auto___38008,out){
return (function (p1__37952_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__37952_SHARP_);
});
;})(cs,vec__37961,v,c,inst_37965,inst_37967,inst_37966,inst_37956,state_val_37987,c__36609__auto___38008,out))
})();
var inst_37971 = cljs.core.filterv.call(null,inst_37970,inst_37956);
var inst_37956__$1 = inst_37971;
var state_37986__$1 = (function (){var statearr_38001 = state_37986;
(statearr_38001[(10)] = inst_37956__$1);

return statearr_38001;
})();
var statearr_38002_38018 = state_37986__$1;
(statearr_38002_38018[(2)] = null);

(statearr_38002_38018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__36609__auto___38008,out))
;
return ((function (switch__36521__auto__,c__36609__auto___38008,out){
return (function() {
var cljs$core$async$state_machine__36522__auto__ = null;
var cljs$core$async$state_machine__36522__auto____0 = (function (){
var statearr_38003 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38003[(0)] = cljs$core$async$state_machine__36522__auto__);

(statearr_38003[(1)] = (1));

return statearr_38003;
});
var cljs$core$async$state_machine__36522__auto____1 = (function (state_37986){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_37986);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e38004){if((e38004 instanceof Object)){
var ex__36525__auto__ = e38004;
var statearr_38005_38019 = state_37986;
(statearr_38005_38019[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37986);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38004;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38020 = state_37986;
state_37986 = G__38020;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
cljs$core$async$state_machine__36522__auto__ = function(state_37986){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36522__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36522__auto____1.call(this,state_37986);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36522__auto____0;
cljs$core$async$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36522__auto____1;
return cljs$core$async$state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto___38008,out))
})();
var state__36611__auto__ = (function (){var statearr_38006 = f__36610__auto__.call(null);
(statearr_38006[(6)] = c__36609__auto___38008);

return statearr_38006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto___38008,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__38022 = arguments.length;
switch (G__38022) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__36609__auto___38067 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto___38067,out){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto___38067,out){
return (function (state_38046){
var state_val_38047 = (state_38046[(1)]);
if((state_val_38047 === (7))){
var inst_38028 = (state_38046[(7)]);
var inst_38028__$1 = (state_38046[(2)]);
var inst_38029 = (inst_38028__$1 == null);
var inst_38030 = cljs.core.not.call(null,inst_38029);
var state_38046__$1 = (function (){var statearr_38048 = state_38046;
(statearr_38048[(7)] = inst_38028__$1);

return statearr_38048;
})();
if(inst_38030){
var statearr_38049_38068 = state_38046__$1;
(statearr_38049_38068[(1)] = (8));

} else {
var statearr_38050_38069 = state_38046__$1;
(statearr_38050_38069[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38047 === (1))){
var inst_38023 = (0);
var state_38046__$1 = (function (){var statearr_38051 = state_38046;
(statearr_38051[(8)] = inst_38023);

return statearr_38051;
})();
var statearr_38052_38070 = state_38046__$1;
(statearr_38052_38070[(2)] = null);

(statearr_38052_38070[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38047 === (4))){
var state_38046__$1 = state_38046;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38046__$1,(7),ch);
} else {
if((state_val_38047 === (6))){
var inst_38041 = (state_38046[(2)]);
var state_38046__$1 = state_38046;
var statearr_38053_38071 = state_38046__$1;
(statearr_38053_38071[(2)] = inst_38041);

(statearr_38053_38071[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38047 === (3))){
var inst_38043 = (state_38046[(2)]);
var inst_38044 = cljs.core.async.close_BANG_.call(null,out);
var state_38046__$1 = (function (){var statearr_38054 = state_38046;
(statearr_38054[(9)] = inst_38043);

return statearr_38054;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38046__$1,inst_38044);
} else {
if((state_val_38047 === (2))){
var inst_38023 = (state_38046[(8)]);
var inst_38025 = (inst_38023 < n);
var state_38046__$1 = state_38046;
if(cljs.core.truth_(inst_38025)){
var statearr_38055_38072 = state_38046__$1;
(statearr_38055_38072[(1)] = (4));

} else {
var statearr_38056_38073 = state_38046__$1;
(statearr_38056_38073[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38047 === (11))){
var inst_38023 = (state_38046[(8)]);
var inst_38033 = (state_38046[(2)]);
var inst_38034 = (inst_38023 + (1));
var inst_38023__$1 = inst_38034;
var state_38046__$1 = (function (){var statearr_38057 = state_38046;
(statearr_38057[(10)] = inst_38033);

(statearr_38057[(8)] = inst_38023__$1);

return statearr_38057;
})();
var statearr_38058_38074 = state_38046__$1;
(statearr_38058_38074[(2)] = null);

(statearr_38058_38074[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38047 === (9))){
var state_38046__$1 = state_38046;
var statearr_38059_38075 = state_38046__$1;
(statearr_38059_38075[(2)] = null);

(statearr_38059_38075[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38047 === (5))){
var state_38046__$1 = state_38046;
var statearr_38060_38076 = state_38046__$1;
(statearr_38060_38076[(2)] = null);

(statearr_38060_38076[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38047 === (10))){
var inst_38038 = (state_38046[(2)]);
var state_38046__$1 = state_38046;
var statearr_38061_38077 = state_38046__$1;
(statearr_38061_38077[(2)] = inst_38038);

(statearr_38061_38077[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38047 === (8))){
var inst_38028 = (state_38046[(7)]);
var state_38046__$1 = state_38046;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_38046__$1,(11),out,inst_38028);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__36609__auto___38067,out))
;
return ((function (switch__36521__auto__,c__36609__auto___38067,out){
return (function() {
var cljs$core$async$state_machine__36522__auto__ = null;
var cljs$core$async$state_machine__36522__auto____0 = (function (){
var statearr_38062 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38062[(0)] = cljs$core$async$state_machine__36522__auto__);

(statearr_38062[(1)] = (1));

return statearr_38062;
});
var cljs$core$async$state_machine__36522__auto____1 = (function (state_38046){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_38046);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e38063){if((e38063 instanceof Object)){
var ex__36525__auto__ = e38063;
var statearr_38064_38078 = state_38046;
(statearr_38064_38078[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38046);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38063;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38079 = state_38046;
state_38046 = G__38079;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
cljs$core$async$state_machine__36522__auto__ = function(state_38046){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36522__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36522__auto____1.call(this,state_38046);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36522__auto____0;
cljs$core$async$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36522__auto____1;
return cljs$core$async$state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto___38067,out))
})();
var state__36611__auto__ = (function (){var statearr_38065 = f__36610__auto__.call(null);
(statearr_38065[(6)] = c__36609__auto___38067);

return statearr_38065;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto___38067,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async38081 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38081 = (function (f,ch,meta38082){
this.f = f;
this.ch = ch;
this.meta38082 = meta38082;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async38081.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38083,meta38082__$1){
var self__ = this;
var _38083__$1 = this;
return (new cljs.core.async.t_cljs$core$async38081(self__.f,self__.ch,meta38082__$1));
});

cljs.core.async.t_cljs$core$async38081.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38083){
var self__ = this;
var _38083__$1 = this;
return self__.meta38082;
});

cljs.core.async.t_cljs$core$async38081.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38081.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async38081.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async38081.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38081.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async38084 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38084 = (function (f,ch,meta38082,_,fn1,meta38085){
this.f = f;
this.ch = ch;
this.meta38082 = meta38082;
this._ = _;
this.fn1 = fn1;
this.meta38085 = meta38085;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async38084.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_38086,meta38085__$1){
var self__ = this;
var _38086__$1 = this;
return (new cljs.core.async.t_cljs$core$async38084(self__.f,self__.ch,self__.meta38082,self__._,self__.fn1,meta38085__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async38084.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_38086){
var self__ = this;
var _38086__$1 = this;
return self__.meta38085;
});})(___$1))
;

cljs.core.async.t_cljs$core$async38084.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38084.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async38084.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async38084.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__38080_SHARP_){
return f1.call(null,(((p1__38080_SHARP_ == null))?null:self__.f.call(null,p1__38080_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async38084.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38082","meta38082",1636910537,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async38081","cljs.core.async/t_cljs$core$async38081",-1187225795,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta38085","meta38085",1160801193,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async38084.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38084.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38084";

cljs.core.async.t_cljs$core$async38084.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async38084");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38084.
 */
cljs.core.async.__GT_t_cljs$core$async38084 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async38084(f__$1,ch__$1,meta38082__$1,___$2,fn1__$1,meta38085){
return (new cljs.core.async.t_cljs$core$async38084(f__$1,ch__$1,meta38082__$1,___$2,fn1__$1,meta38085));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async38084(self__.f,self__.ch,self__.meta38082,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__3911__auto__ = ret;
if(cljs.core.truth_(and__3911__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__3911__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async38081.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38081.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async38081.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38082","meta38082",1636910537,null)], null);
});

cljs.core.async.t_cljs$core$async38081.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38081.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38081";

cljs.core.async.t_cljs$core$async38081.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async38081");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38081.
 */
cljs.core.async.__GT_t_cljs$core$async38081 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async38081(f__$1,ch__$1,meta38082){
return (new cljs.core.async.t_cljs$core$async38081(f__$1,ch__$1,meta38082));
});

}

return (new cljs.core.async.t_cljs$core$async38081(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async38087 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38087 = (function (f,ch,meta38088){
this.f = f;
this.ch = ch;
this.meta38088 = meta38088;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async38087.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38089,meta38088__$1){
var self__ = this;
var _38089__$1 = this;
return (new cljs.core.async.t_cljs$core$async38087(self__.f,self__.ch,meta38088__$1));
});

cljs.core.async.t_cljs$core$async38087.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38089){
var self__ = this;
var _38089__$1 = this;
return self__.meta38088;
});

cljs.core.async.t_cljs$core$async38087.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38087.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async38087.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38087.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async38087.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38087.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async38087.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38088","meta38088",57295016,null)], null);
});

cljs.core.async.t_cljs$core$async38087.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38087.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38087";

cljs.core.async.t_cljs$core$async38087.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async38087");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38087.
 */
cljs.core.async.__GT_t_cljs$core$async38087 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async38087(f__$1,ch__$1,meta38088){
return (new cljs.core.async.t_cljs$core$async38087(f__$1,ch__$1,meta38088));
});

}

return (new cljs.core.async.t_cljs$core$async38087(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async38090 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38090 = (function (p,ch,meta38091){
this.p = p;
this.ch = ch;
this.meta38091 = meta38091;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async38090.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38092,meta38091__$1){
var self__ = this;
var _38092__$1 = this;
return (new cljs.core.async.t_cljs$core$async38090(self__.p,self__.ch,meta38091__$1));
});

cljs.core.async.t_cljs$core$async38090.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38092){
var self__ = this;
var _38092__$1 = this;
return self__.meta38091;
});

cljs.core.async.t_cljs$core$async38090.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38090.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async38090.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async38090.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38090.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async38090.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38090.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async38090.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38091","meta38091",-1160565724,null)], null);
});

cljs.core.async.t_cljs$core$async38090.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38090.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38090";

cljs.core.async.t_cljs$core$async38090.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async38090");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38090.
 */
cljs.core.async.__GT_t_cljs$core$async38090 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async38090(p__$1,ch__$1,meta38091){
return (new cljs.core.async.t_cljs$core$async38090(p__$1,ch__$1,meta38091));
});

}

return (new cljs.core.async.t_cljs$core$async38090(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__38094 = arguments.length;
switch (G__38094) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__36609__auto___38134 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto___38134,out){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto___38134,out){
return (function (state_38115){
var state_val_38116 = (state_38115[(1)]);
if((state_val_38116 === (7))){
var inst_38111 = (state_38115[(2)]);
var state_38115__$1 = state_38115;
var statearr_38117_38135 = state_38115__$1;
(statearr_38117_38135[(2)] = inst_38111);

(statearr_38117_38135[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38116 === (1))){
var state_38115__$1 = state_38115;
var statearr_38118_38136 = state_38115__$1;
(statearr_38118_38136[(2)] = null);

(statearr_38118_38136[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38116 === (4))){
var inst_38097 = (state_38115[(7)]);
var inst_38097__$1 = (state_38115[(2)]);
var inst_38098 = (inst_38097__$1 == null);
var state_38115__$1 = (function (){var statearr_38119 = state_38115;
(statearr_38119[(7)] = inst_38097__$1);

return statearr_38119;
})();
if(cljs.core.truth_(inst_38098)){
var statearr_38120_38137 = state_38115__$1;
(statearr_38120_38137[(1)] = (5));

} else {
var statearr_38121_38138 = state_38115__$1;
(statearr_38121_38138[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38116 === (6))){
var inst_38097 = (state_38115[(7)]);
var inst_38102 = p.call(null,inst_38097);
var state_38115__$1 = state_38115;
if(cljs.core.truth_(inst_38102)){
var statearr_38122_38139 = state_38115__$1;
(statearr_38122_38139[(1)] = (8));

} else {
var statearr_38123_38140 = state_38115__$1;
(statearr_38123_38140[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38116 === (3))){
var inst_38113 = (state_38115[(2)]);
var state_38115__$1 = state_38115;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38115__$1,inst_38113);
} else {
if((state_val_38116 === (2))){
var state_38115__$1 = state_38115;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38115__$1,(4),ch);
} else {
if((state_val_38116 === (11))){
var inst_38105 = (state_38115[(2)]);
var state_38115__$1 = state_38115;
var statearr_38124_38141 = state_38115__$1;
(statearr_38124_38141[(2)] = inst_38105);

(statearr_38124_38141[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38116 === (9))){
var state_38115__$1 = state_38115;
var statearr_38125_38142 = state_38115__$1;
(statearr_38125_38142[(2)] = null);

(statearr_38125_38142[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38116 === (5))){
var inst_38100 = cljs.core.async.close_BANG_.call(null,out);
var state_38115__$1 = state_38115;
var statearr_38126_38143 = state_38115__$1;
(statearr_38126_38143[(2)] = inst_38100);

(statearr_38126_38143[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38116 === (10))){
var inst_38108 = (state_38115[(2)]);
var state_38115__$1 = (function (){var statearr_38127 = state_38115;
(statearr_38127[(8)] = inst_38108);

return statearr_38127;
})();
var statearr_38128_38144 = state_38115__$1;
(statearr_38128_38144[(2)] = null);

(statearr_38128_38144[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38116 === (8))){
var inst_38097 = (state_38115[(7)]);
var state_38115__$1 = state_38115;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_38115__$1,(11),out,inst_38097);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__36609__auto___38134,out))
;
return ((function (switch__36521__auto__,c__36609__auto___38134,out){
return (function() {
var cljs$core$async$state_machine__36522__auto__ = null;
var cljs$core$async$state_machine__36522__auto____0 = (function (){
var statearr_38129 = [null,null,null,null,null,null,null,null,null];
(statearr_38129[(0)] = cljs$core$async$state_machine__36522__auto__);

(statearr_38129[(1)] = (1));

return statearr_38129;
});
var cljs$core$async$state_machine__36522__auto____1 = (function (state_38115){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_38115);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e38130){if((e38130 instanceof Object)){
var ex__36525__auto__ = e38130;
var statearr_38131_38145 = state_38115;
(statearr_38131_38145[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38115);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38130;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38146 = state_38115;
state_38115 = G__38146;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
cljs$core$async$state_machine__36522__auto__ = function(state_38115){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36522__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36522__auto____1.call(this,state_38115);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36522__auto____0;
cljs$core$async$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36522__auto____1;
return cljs$core$async$state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto___38134,out))
})();
var state__36611__auto__ = (function (){var statearr_38132 = f__36610__auto__.call(null);
(statearr_38132[(6)] = c__36609__auto___38134);

return statearr_38132;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto___38134,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__38148 = arguments.length;
switch (G__38148) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__36609__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto__){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto__){
return (function (state_38211){
var state_val_38212 = (state_38211[(1)]);
if((state_val_38212 === (7))){
var inst_38207 = (state_38211[(2)]);
var state_38211__$1 = state_38211;
var statearr_38213_38251 = state_38211__$1;
(statearr_38213_38251[(2)] = inst_38207);

(statearr_38213_38251[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (20))){
var inst_38177 = (state_38211[(7)]);
var inst_38188 = (state_38211[(2)]);
var inst_38189 = cljs.core.next.call(null,inst_38177);
var inst_38163 = inst_38189;
var inst_38164 = null;
var inst_38165 = (0);
var inst_38166 = (0);
var state_38211__$1 = (function (){var statearr_38214 = state_38211;
(statearr_38214[(8)] = inst_38188);

(statearr_38214[(9)] = inst_38163);

(statearr_38214[(10)] = inst_38166);

(statearr_38214[(11)] = inst_38164);

(statearr_38214[(12)] = inst_38165);

return statearr_38214;
})();
var statearr_38215_38252 = state_38211__$1;
(statearr_38215_38252[(2)] = null);

(statearr_38215_38252[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (1))){
var state_38211__$1 = state_38211;
var statearr_38216_38253 = state_38211__$1;
(statearr_38216_38253[(2)] = null);

(statearr_38216_38253[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (4))){
var inst_38152 = (state_38211[(13)]);
var inst_38152__$1 = (state_38211[(2)]);
var inst_38153 = (inst_38152__$1 == null);
var state_38211__$1 = (function (){var statearr_38217 = state_38211;
(statearr_38217[(13)] = inst_38152__$1);

return statearr_38217;
})();
if(cljs.core.truth_(inst_38153)){
var statearr_38218_38254 = state_38211__$1;
(statearr_38218_38254[(1)] = (5));

} else {
var statearr_38219_38255 = state_38211__$1;
(statearr_38219_38255[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (15))){
var state_38211__$1 = state_38211;
var statearr_38223_38256 = state_38211__$1;
(statearr_38223_38256[(2)] = null);

(statearr_38223_38256[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (21))){
var state_38211__$1 = state_38211;
var statearr_38224_38257 = state_38211__$1;
(statearr_38224_38257[(2)] = null);

(statearr_38224_38257[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (13))){
var inst_38163 = (state_38211[(9)]);
var inst_38166 = (state_38211[(10)]);
var inst_38164 = (state_38211[(11)]);
var inst_38165 = (state_38211[(12)]);
var inst_38173 = (state_38211[(2)]);
var inst_38174 = (inst_38166 + (1));
var tmp38220 = inst_38163;
var tmp38221 = inst_38164;
var tmp38222 = inst_38165;
var inst_38163__$1 = tmp38220;
var inst_38164__$1 = tmp38221;
var inst_38165__$1 = tmp38222;
var inst_38166__$1 = inst_38174;
var state_38211__$1 = (function (){var statearr_38225 = state_38211;
(statearr_38225[(9)] = inst_38163__$1);

(statearr_38225[(14)] = inst_38173);

(statearr_38225[(10)] = inst_38166__$1);

(statearr_38225[(11)] = inst_38164__$1);

(statearr_38225[(12)] = inst_38165__$1);

return statearr_38225;
})();
var statearr_38226_38258 = state_38211__$1;
(statearr_38226_38258[(2)] = null);

(statearr_38226_38258[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (22))){
var state_38211__$1 = state_38211;
var statearr_38227_38259 = state_38211__$1;
(statearr_38227_38259[(2)] = null);

(statearr_38227_38259[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (6))){
var inst_38152 = (state_38211[(13)]);
var inst_38161 = f.call(null,inst_38152);
var inst_38162 = cljs.core.seq.call(null,inst_38161);
var inst_38163 = inst_38162;
var inst_38164 = null;
var inst_38165 = (0);
var inst_38166 = (0);
var state_38211__$1 = (function (){var statearr_38228 = state_38211;
(statearr_38228[(9)] = inst_38163);

(statearr_38228[(10)] = inst_38166);

(statearr_38228[(11)] = inst_38164);

(statearr_38228[(12)] = inst_38165);

return statearr_38228;
})();
var statearr_38229_38260 = state_38211__$1;
(statearr_38229_38260[(2)] = null);

(statearr_38229_38260[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (17))){
var inst_38177 = (state_38211[(7)]);
var inst_38181 = cljs.core.chunk_first.call(null,inst_38177);
var inst_38182 = cljs.core.chunk_rest.call(null,inst_38177);
var inst_38183 = cljs.core.count.call(null,inst_38181);
var inst_38163 = inst_38182;
var inst_38164 = inst_38181;
var inst_38165 = inst_38183;
var inst_38166 = (0);
var state_38211__$1 = (function (){var statearr_38230 = state_38211;
(statearr_38230[(9)] = inst_38163);

(statearr_38230[(10)] = inst_38166);

(statearr_38230[(11)] = inst_38164);

(statearr_38230[(12)] = inst_38165);

return statearr_38230;
})();
var statearr_38231_38261 = state_38211__$1;
(statearr_38231_38261[(2)] = null);

(statearr_38231_38261[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (3))){
var inst_38209 = (state_38211[(2)]);
var state_38211__$1 = state_38211;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38211__$1,inst_38209);
} else {
if((state_val_38212 === (12))){
var inst_38197 = (state_38211[(2)]);
var state_38211__$1 = state_38211;
var statearr_38232_38262 = state_38211__$1;
(statearr_38232_38262[(2)] = inst_38197);

(statearr_38232_38262[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (2))){
var state_38211__$1 = state_38211;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38211__$1,(4),in$);
} else {
if((state_val_38212 === (23))){
var inst_38205 = (state_38211[(2)]);
var state_38211__$1 = state_38211;
var statearr_38233_38263 = state_38211__$1;
(statearr_38233_38263[(2)] = inst_38205);

(statearr_38233_38263[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (19))){
var inst_38192 = (state_38211[(2)]);
var state_38211__$1 = state_38211;
var statearr_38234_38264 = state_38211__$1;
(statearr_38234_38264[(2)] = inst_38192);

(statearr_38234_38264[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (11))){
var inst_38163 = (state_38211[(9)]);
var inst_38177 = (state_38211[(7)]);
var inst_38177__$1 = cljs.core.seq.call(null,inst_38163);
var state_38211__$1 = (function (){var statearr_38235 = state_38211;
(statearr_38235[(7)] = inst_38177__$1);

return statearr_38235;
})();
if(inst_38177__$1){
var statearr_38236_38265 = state_38211__$1;
(statearr_38236_38265[(1)] = (14));

} else {
var statearr_38237_38266 = state_38211__$1;
(statearr_38237_38266[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (9))){
var inst_38199 = (state_38211[(2)]);
var inst_38200 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_38211__$1 = (function (){var statearr_38238 = state_38211;
(statearr_38238[(15)] = inst_38199);

return statearr_38238;
})();
if(cljs.core.truth_(inst_38200)){
var statearr_38239_38267 = state_38211__$1;
(statearr_38239_38267[(1)] = (21));

} else {
var statearr_38240_38268 = state_38211__$1;
(statearr_38240_38268[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (5))){
var inst_38155 = cljs.core.async.close_BANG_.call(null,out);
var state_38211__$1 = state_38211;
var statearr_38241_38269 = state_38211__$1;
(statearr_38241_38269[(2)] = inst_38155);

(statearr_38241_38269[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (14))){
var inst_38177 = (state_38211[(7)]);
var inst_38179 = cljs.core.chunked_seq_QMARK_.call(null,inst_38177);
var state_38211__$1 = state_38211;
if(inst_38179){
var statearr_38242_38270 = state_38211__$1;
(statearr_38242_38270[(1)] = (17));

} else {
var statearr_38243_38271 = state_38211__$1;
(statearr_38243_38271[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (16))){
var inst_38195 = (state_38211[(2)]);
var state_38211__$1 = state_38211;
var statearr_38244_38272 = state_38211__$1;
(statearr_38244_38272[(2)] = inst_38195);

(statearr_38244_38272[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (10))){
var inst_38166 = (state_38211[(10)]);
var inst_38164 = (state_38211[(11)]);
var inst_38171 = cljs.core._nth.call(null,inst_38164,inst_38166);
var state_38211__$1 = state_38211;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_38211__$1,(13),out,inst_38171);
} else {
if((state_val_38212 === (18))){
var inst_38177 = (state_38211[(7)]);
var inst_38186 = cljs.core.first.call(null,inst_38177);
var state_38211__$1 = state_38211;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_38211__$1,(20),out,inst_38186);
} else {
if((state_val_38212 === (8))){
var inst_38166 = (state_38211[(10)]);
var inst_38165 = (state_38211[(12)]);
var inst_38168 = (inst_38166 < inst_38165);
var inst_38169 = inst_38168;
var state_38211__$1 = state_38211;
if(cljs.core.truth_(inst_38169)){
var statearr_38245_38273 = state_38211__$1;
(statearr_38245_38273[(1)] = (10));

} else {
var statearr_38246_38274 = state_38211__$1;
(statearr_38246_38274[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36609__auto__))
;
return ((function (switch__36521__auto__,c__36609__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__36522__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__36522__auto____0 = (function (){
var statearr_38247 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38247[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__36522__auto__);

(statearr_38247[(1)] = (1));

return statearr_38247;
});
var cljs$core$async$mapcat_STAR__$_state_machine__36522__auto____1 = (function (state_38211){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_38211);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e38248){if((e38248 instanceof Object)){
var ex__36525__auto__ = e38248;
var statearr_38249_38275 = state_38211;
(statearr_38249_38275[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38211);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38248;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38276 = state_38211;
state_38211 = G__38276;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__36522__auto__ = function(state_38211){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__36522__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__36522__auto____1.call(this,state_38211);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__36522__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__36522__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto__))
})();
var state__36611__auto__ = (function (){var statearr_38250 = f__36610__auto__.call(null);
(statearr_38250[(6)] = c__36609__auto__);

return statearr_38250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto__))
);

return c__36609__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__38278 = arguments.length;
switch (G__38278) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__38281 = arguments.length;
switch (G__38281) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__38284 = arguments.length;
switch (G__38284) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__36609__auto___38331 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto___38331,out){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto___38331,out){
return (function (state_38308){
var state_val_38309 = (state_38308[(1)]);
if((state_val_38309 === (7))){
var inst_38303 = (state_38308[(2)]);
var state_38308__$1 = state_38308;
var statearr_38310_38332 = state_38308__$1;
(statearr_38310_38332[(2)] = inst_38303);

(statearr_38310_38332[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38309 === (1))){
var inst_38285 = null;
var state_38308__$1 = (function (){var statearr_38311 = state_38308;
(statearr_38311[(7)] = inst_38285);

return statearr_38311;
})();
var statearr_38312_38333 = state_38308__$1;
(statearr_38312_38333[(2)] = null);

(statearr_38312_38333[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38309 === (4))){
var inst_38288 = (state_38308[(8)]);
var inst_38288__$1 = (state_38308[(2)]);
var inst_38289 = (inst_38288__$1 == null);
var inst_38290 = cljs.core.not.call(null,inst_38289);
var state_38308__$1 = (function (){var statearr_38313 = state_38308;
(statearr_38313[(8)] = inst_38288__$1);

return statearr_38313;
})();
if(inst_38290){
var statearr_38314_38334 = state_38308__$1;
(statearr_38314_38334[(1)] = (5));

} else {
var statearr_38315_38335 = state_38308__$1;
(statearr_38315_38335[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38309 === (6))){
var state_38308__$1 = state_38308;
var statearr_38316_38336 = state_38308__$1;
(statearr_38316_38336[(2)] = null);

(statearr_38316_38336[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38309 === (3))){
var inst_38305 = (state_38308[(2)]);
var inst_38306 = cljs.core.async.close_BANG_.call(null,out);
var state_38308__$1 = (function (){var statearr_38317 = state_38308;
(statearr_38317[(9)] = inst_38305);

return statearr_38317;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38308__$1,inst_38306);
} else {
if((state_val_38309 === (2))){
var state_38308__$1 = state_38308;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38308__$1,(4),ch);
} else {
if((state_val_38309 === (11))){
var inst_38288 = (state_38308[(8)]);
var inst_38297 = (state_38308[(2)]);
var inst_38285 = inst_38288;
var state_38308__$1 = (function (){var statearr_38318 = state_38308;
(statearr_38318[(10)] = inst_38297);

(statearr_38318[(7)] = inst_38285);

return statearr_38318;
})();
var statearr_38319_38337 = state_38308__$1;
(statearr_38319_38337[(2)] = null);

(statearr_38319_38337[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38309 === (9))){
var inst_38288 = (state_38308[(8)]);
var state_38308__$1 = state_38308;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_38308__$1,(11),out,inst_38288);
} else {
if((state_val_38309 === (5))){
var inst_38288 = (state_38308[(8)]);
var inst_38285 = (state_38308[(7)]);
var inst_38292 = cljs.core._EQ_.call(null,inst_38288,inst_38285);
var state_38308__$1 = state_38308;
if(inst_38292){
var statearr_38321_38338 = state_38308__$1;
(statearr_38321_38338[(1)] = (8));

} else {
var statearr_38322_38339 = state_38308__$1;
(statearr_38322_38339[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38309 === (10))){
var inst_38300 = (state_38308[(2)]);
var state_38308__$1 = state_38308;
var statearr_38323_38340 = state_38308__$1;
(statearr_38323_38340[(2)] = inst_38300);

(statearr_38323_38340[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38309 === (8))){
var inst_38285 = (state_38308[(7)]);
var tmp38320 = inst_38285;
var inst_38285__$1 = tmp38320;
var state_38308__$1 = (function (){var statearr_38324 = state_38308;
(statearr_38324[(7)] = inst_38285__$1);

return statearr_38324;
})();
var statearr_38325_38341 = state_38308__$1;
(statearr_38325_38341[(2)] = null);

(statearr_38325_38341[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__36609__auto___38331,out))
;
return ((function (switch__36521__auto__,c__36609__auto___38331,out){
return (function() {
var cljs$core$async$state_machine__36522__auto__ = null;
var cljs$core$async$state_machine__36522__auto____0 = (function (){
var statearr_38326 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38326[(0)] = cljs$core$async$state_machine__36522__auto__);

(statearr_38326[(1)] = (1));

return statearr_38326;
});
var cljs$core$async$state_machine__36522__auto____1 = (function (state_38308){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_38308);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e38327){if((e38327 instanceof Object)){
var ex__36525__auto__ = e38327;
var statearr_38328_38342 = state_38308;
(statearr_38328_38342[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38308);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38327;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38343 = state_38308;
state_38308 = G__38343;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
cljs$core$async$state_machine__36522__auto__ = function(state_38308){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36522__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36522__auto____1.call(this,state_38308);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36522__auto____0;
cljs$core$async$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36522__auto____1;
return cljs$core$async$state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto___38331,out))
})();
var state__36611__auto__ = (function (){var statearr_38329 = f__36610__auto__.call(null);
(statearr_38329[(6)] = c__36609__auto___38331);

return statearr_38329;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto___38331,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__38345 = arguments.length;
switch (G__38345) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__36609__auto___38411 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto___38411,out){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto___38411,out){
return (function (state_38383){
var state_val_38384 = (state_38383[(1)]);
if((state_val_38384 === (7))){
var inst_38379 = (state_38383[(2)]);
var state_38383__$1 = state_38383;
var statearr_38385_38412 = state_38383__$1;
(statearr_38385_38412[(2)] = inst_38379);

(statearr_38385_38412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38384 === (1))){
var inst_38346 = (new Array(n));
var inst_38347 = inst_38346;
var inst_38348 = (0);
var state_38383__$1 = (function (){var statearr_38386 = state_38383;
(statearr_38386[(7)] = inst_38347);

(statearr_38386[(8)] = inst_38348);

return statearr_38386;
})();
var statearr_38387_38413 = state_38383__$1;
(statearr_38387_38413[(2)] = null);

(statearr_38387_38413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38384 === (4))){
var inst_38351 = (state_38383[(9)]);
var inst_38351__$1 = (state_38383[(2)]);
var inst_38352 = (inst_38351__$1 == null);
var inst_38353 = cljs.core.not.call(null,inst_38352);
var state_38383__$1 = (function (){var statearr_38388 = state_38383;
(statearr_38388[(9)] = inst_38351__$1);

return statearr_38388;
})();
if(inst_38353){
var statearr_38389_38414 = state_38383__$1;
(statearr_38389_38414[(1)] = (5));

} else {
var statearr_38390_38415 = state_38383__$1;
(statearr_38390_38415[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38384 === (15))){
var inst_38373 = (state_38383[(2)]);
var state_38383__$1 = state_38383;
var statearr_38391_38416 = state_38383__$1;
(statearr_38391_38416[(2)] = inst_38373);

(statearr_38391_38416[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38384 === (13))){
var state_38383__$1 = state_38383;
var statearr_38392_38417 = state_38383__$1;
(statearr_38392_38417[(2)] = null);

(statearr_38392_38417[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38384 === (6))){
var inst_38348 = (state_38383[(8)]);
var inst_38369 = (inst_38348 > (0));
var state_38383__$1 = state_38383;
if(cljs.core.truth_(inst_38369)){
var statearr_38393_38418 = state_38383__$1;
(statearr_38393_38418[(1)] = (12));

} else {
var statearr_38394_38419 = state_38383__$1;
(statearr_38394_38419[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38384 === (3))){
var inst_38381 = (state_38383[(2)]);
var state_38383__$1 = state_38383;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38383__$1,inst_38381);
} else {
if((state_val_38384 === (12))){
var inst_38347 = (state_38383[(7)]);
var inst_38371 = cljs.core.vec.call(null,inst_38347);
var state_38383__$1 = state_38383;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_38383__$1,(15),out,inst_38371);
} else {
if((state_val_38384 === (2))){
var state_38383__$1 = state_38383;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38383__$1,(4),ch);
} else {
if((state_val_38384 === (11))){
var inst_38363 = (state_38383[(2)]);
var inst_38364 = (new Array(n));
var inst_38347 = inst_38364;
var inst_38348 = (0);
var state_38383__$1 = (function (){var statearr_38395 = state_38383;
(statearr_38395[(7)] = inst_38347);

(statearr_38395[(8)] = inst_38348);

(statearr_38395[(10)] = inst_38363);

return statearr_38395;
})();
var statearr_38396_38420 = state_38383__$1;
(statearr_38396_38420[(2)] = null);

(statearr_38396_38420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38384 === (9))){
var inst_38347 = (state_38383[(7)]);
var inst_38361 = cljs.core.vec.call(null,inst_38347);
var state_38383__$1 = state_38383;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_38383__$1,(11),out,inst_38361);
} else {
if((state_val_38384 === (5))){
var inst_38347 = (state_38383[(7)]);
var inst_38348 = (state_38383[(8)]);
var inst_38356 = (state_38383[(11)]);
var inst_38351 = (state_38383[(9)]);
var inst_38355 = (inst_38347[inst_38348] = inst_38351);
var inst_38356__$1 = (inst_38348 + (1));
var inst_38357 = (inst_38356__$1 < n);
var state_38383__$1 = (function (){var statearr_38397 = state_38383;
(statearr_38397[(11)] = inst_38356__$1);

(statearr_38397[(12)] = inst_38355);

return statearr_38397;
})();
if(cljs.core.truth_(inst_38357)){
var statearr_38398_38421 = state_38383__$1;
(statearr_38398_38421[(1)] = (8));

} else {
var statearr_38399_38422 = state_38383__$1;
(statearr_38399_38422[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38384 === (14))){
var inst_38376 = (state_38383[(2)]);
var inst_38377 = cljs.core.async.close_BANG_.call(null,out);
var state_38383__$1 = (function (){var statearr_38401 = state_38383;
(statearr_38401[(13)] = inst_38376);

return statearr_38401;
})();
var statearr_38402_38423 = state_38383__$1;
(statearr_38402_38423[(2)] = inst_38377);

(statearr_38402_38423[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38384 === (10))){
var inst_38367 = (state_38383[(2)]);
var state_38383__$1 = state_38383;
var statearr_38403_38424 = state_38383__$1;
(statearr_38403_38424[(2)] = inst_38367);

(statearr_38403_38424[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38384 === (8))){
var inst_38347 = (state_38383[(7)]);
var inst_38356 = (state_38383[(11)]);
var tmp38400 = inst_38347;
var inst_38347__$1 = tmp38400;
var inst_38348 = inst_38356;
var state_38383__$1 = (function (){var statearr_38404 = state_38383;
(statearr_38404[(7)] = inst_38347__$1);

(statearr_38404[(8)] = inst_38348);

return statearr_38404;
})();
var statearr_38405_38425 = state_38383__$1;
(statearr_38405_38425[(2)] = null);

(statearr_38405_38425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36609__auto___38411,out))
;
return ((function (switch__36521__auto__,c__36609__auto___38411,out){
return (function() {
var cljs$core$async$state_machine__36522__auto__ = null;
var cljs$core$async$state_machine__36522__auto____0 = (function (){
var statearr_38406 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38406[(0)] = cljs$core$async$state_machine__36522__auto__);

(statearr_38406[(1)] = (1));

return statearr_38406;
});
var cljs$core$async$state_machine__36522__auto____1 = (function (state_38383){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_38383);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e38407){if((e38407 instanceof Object)){
var ex__36525__auto__ = e38407;
var statearr_38408_38426 = state_38383;
(statearr_38408_38426[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38383);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38407;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38427 = state_38383;
state_38383 = G__38427;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
cljs$core$async$state_machine__36522__auto__ = function(state_38383){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36522__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36522__auto____1.call(this,state_38383);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36522__auto____0;
cljs$core$async$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36522__auto____1;
return cljs$core$async$state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto___38411,out))
})();
var state__36611__auto__ = (function (){var statearr_38409 = f__36610__auto__.call(null);
(statearr_38409[(6)] = c__36609__auto___38411);

return statearr_38409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto___38411,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__38429 = arguments.length;
switch (G__38429) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__36609__auto___38499 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto___38499,out){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto___38499,out){
return (function (state_38471){
var state_val_38472 = (state_38471[(1)]);
if((state_val_38472 === (7))){
var inst_38467 = (state_38471[(2)]);
var state_38471__$1 = state_38471;
var statearr_38473_38500 = state_38471__$1;
(statearr_38473_38500[(2)] = inst_38467);

(statearr_38473_38500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38472 === (1))){
var inst_38430 = [];
var inst_38431 = inst_38430;
var inst_38432 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_38471__$1 = (function (){var statearr_38474 = state_38471;
(statearr_38474[(7)] = inst_38432);

(statearr_38474[(8)] = inst_38431);

return statearr_38474;
})();
var statearr_38475_38501 = state_38471__$1;
(statearr_38475_38501[(2)] = null);

(statearr_38475_38501[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38472 === (4))){
var inst_38435 = (state_38471[(9)]);
var inst_38435__$1 = (state_38471[(2)]);
var inst_38436 = (inst_38435__$1 == null);
var inst_38437 = cljs.core.not.call(null,inst_38436);
var state_38471__$1 = (function (){var statearr_38476 = state_38471;
(statearr_38476[(9)] = inst_38435__$1);

return statearr_38476;
})();
if(inst_38437){
var statearr_38477_38502 = state_38471__$1;
(statearr_38477_38502[(1)] = (5));

} else {
var statearr_38478_38503 = state_38471__$1;
(statearr_38478_38503[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38472 === (15))){
var inst_38461 = (state_38471[(2)]);
var state_38471__$1 = state_38471;
var statearr_38479_38504 = state_38471__$1;
(statearr_38479_38504[(2)] = inst_38461);

(statearr_38479_38504[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38472 === (13))){
var state_38471__$1 = state_38471;
var statearr_38480_38505 = state_38471__$1;
(statearr_38480_38505[(2)] = null);

(statearr_38480_38505[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38472 === (6))){
var inst_38431 = (state_38471[(8)]);
var inst_38456 = inst_38431.length;
var inst_38457 = (inst_38456 > (0));
var state_38471__$1 = state_38471;
if(cljs.core.truth_(inst_38457)){
var statearr_38481_38506 = state_38471__$1;
(statearr_38481_38506[(1)] = (12));

} else {
var statearr_38482_38507 = state_38471__$1;
(statearr_38482_38507[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38472 === (3))){
var inst_38469 = (state_38471[(2)]);
var state_38471__$1 = state_38471;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38471__$1,inst_38469);
} else {
if((state_val_38472 === (12))){
var inst_38431 = (state_38471[(8)]);
var inst_38459 = cljs.core.vec.call(null,inst_38431);
var state_38471__$1 = state_38471;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_38471__$1,(15),out,inst_38459);
} else {
if((state_val_38472 === (2))){
var state_38471__$1 = state_38471;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38471__$1,(4),ch);
} else {
if((state_val_38472 === (11))){
var inst_38439 = (state_38471[(10)]);
var inst_38435 = (state_38471[(9)]);
var inst_38449 = (state_38471[(2)]);
var inst_38450 = [];
var inst_38451 = inst_38450.push(inst_38435);
var inst_38431 = inst_38450;
var inst_38432 = inst_38439;
var state_38471__$1 = (function (){var statearr_38483 = state_38471;
(statearr_38483[(7)] = inst_38432);

(statearr_38483[(11)] = inst_38451);

(statearr_38483[(8)] = inst_38431);

(statearr_38483[(12)] = inst_38449);

return statearr_38483;
})();
var statearr_38484_38508 = state_38471__$1;
(statearr_38484_38508[(2)] = null);

(statearr_38484_38508[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38472 === (9))){
var inst_38431 = (state_38471[(8)]);
var inst_38447 = cljs.core.vec.call(null,inst_38431);
var state_38471__$1 = state_38471;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_38471__$1,(11),out,inst_38447);
} else {
if((state_val_38472 === (5))){
var inst_38439 = (state_38471[(10)]);
var inst_38432 = (state_38471[(7)]);
var inst_38435 = (state_38471[(9)]);
var inst_38439__$1 = f.call(null,inst_38435);
var inst_38440 = cljs.core._EQ_.call(null,inst_38439__$1,inst_38432);
var inst_38441 = cljs.core.keyword_identical_QMARK_.call(null,inst_38432,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_38442 = ((inst_38440) || (inst_38441));
var state_38471__$1 = (function (){var statearr_38485 = state_38471;
(statearr_38485[(10)] = inst_38439__$1);

return statearr_38485;
})();
if(cljs.core.truth_(inst_38442)){
var statearr_38486_38509 = state_38471__$1;
(statearr_38486_38509[(1)] = (8));

} else {
var statearr_38487_38510 = state_38471__$1;
(statearr_38487_38510[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38472 === (14))){
var inst_38464 = (state_38471[(2)]);
var inst_38465 = cljs.core.async.close_BANG_.call(null,out);
var state_38471__$1 = (function (){var statearr_38489 = state_38471;
(statearr_38489[(13)] = inst_38464);

return statearr_38489;
})();
var statearr_38490_38511 = state_38471__$1;
(statearr_38490_38511[(2)] = inst_38465);

(statearr_38490_38511[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38472 === (10))){
var inst_38454 = (state_38471[(2)]);
var state_38471__$1 = state_38471;
var statearr_38491_38512 = state_38471__$1;
(statearr_38491_38512[(2)] = inst_38454);

(statearr_38491_38512[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38472 === (8))){
var inst_38439 = (state_38471[(10)]);
var inst_38435 = (state_38471[(9)]);
var inst_38431 = (state_38471[(8)]);
var inst_38444 = inst_38431.push(inst_38435);
var tmp38488 = inst_38431;
var inst_38431__$1 = tmp38488;
var inst_38432 = inst_38439;
var state_38471__$1 = (function (){var statearr_38492 = state_38471;
(statearr_38492[(7)] = inst_38432);

(statearr_38492[(14)] = inst_38444);

(statearr_38492[(8)] = inst_38431__$1);

return statearr_38492;
})();
var statearr_38493_38513 = state_38471__$1;
(statearr_38493_38513[(2)] = null);

(statearr_38493_38513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36609__auto___38499,out))
;
return ((function (switch__36521__auto__,c__36609__auto___38499,out){
return (function() {
var cljs$core$async$state_machine__36522__auto__ = null;
var cljs$core$async$state_machine__36522__auto____0 = (function (){
var statearr_38494 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38494[(0)] = cljs$core$async$state_machine__36522__auto__);

(statearr_38494[(1)] = (1));

return statearr_38494;
});
var cljs$core$async$state_machine__36522__auto____1 = (function (state_38471){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_38471);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e38495){if((e38495 instanceof Object)){
var ex__36525__auto__ = e38495;
var statearr_38496_38514 = state_38471;
(statearr_38496_38514[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38471);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38495;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38515 = state_38471;
state_38471 = G__38515;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
cljs$core$async$state_machine__36522__auto__ = function(state_38471){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36522__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36522__auto____1.call(this,state_38471);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36522__auto____0;
cljs$core$async$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36522__auto____1;
return cljs$core$async$state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto___38499,out))
})();
var state__36611__auto__ = (function (){var statearr_38497 = f__36610__auto__.call(null);
(statearr_38497[(6)] = c__36609__auto___38499);

return statearr_38497;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto___38499,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1522271998041
