// Compiled by ClojureScript 1.10.238 {}
goog.provide('pine.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.spec.alpha');
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("pine.core","full-path","pine.core/full-path",1254479403),new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null),cljs.core.string_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("pine.core","routes","pine.core/routes",-25112795),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Keyword("pine.core","route","pine.core/route",-1237586670)),cljs.spec.alpha.every_impl.call(null,new cljs.core.Keyword("pine.core","route","pine.core/route",-1237586670),new cljs.core.Keyword("pine.core","route","pine.core/route",-1237586670),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),null,new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__36510){
return cljs.core.coll_QMARK_.call(null,G__36510);
}),new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Keyword("pine.core","route","pine.core/route",-1237586670))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("pine.core","route","pine.core/route",-1237586670),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("pine.core","route-id","pine.core/route-id",1898868218),new cljs.core.Keyword("pine.core","test-path","pine.core/test-path",-1035062578)], null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("pine.core","children","pine.core/children",-1431439457)], null)),cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("pine.core","route-id","pine.core/route-id",1898868218),new cljs.core.Keyword("pine.core","test-path","pine.core/test-path",-1035062578)], null),null,null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__36511){
return cljs.core.map_QMARK_.call(null,G__36511);
}),(function (G__36511){
return cljs.core.contains_QMARK_.call(null,G__36511,new cljs.core.Keyword(null,"route-id","route-id",-1804166443));
}),(function (G__36511){
return cljs.core.contains_QMARK_.call(null,G__36511,new cljs.core.Keyword(null,"test-path","test-path",-678164055));
})], null),(function (G__36511){
return ((cljs.core.map_QMARK_.call(null,G__36511)) && (cljs.core.contains_QMARK_.call(null,G__36511,new cljs.core.Keyword(null,"route-id","route-id",-1804166443))) && (cljs.core.contains_QMARK_.call(null,G__36511,new cljs.core.Keyword(null,"test-path","test-path",-678164055))));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("pine.core","children","pine.core/children",-1431439457)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("pine.core","route-id","pine.core/route-id",1898868218),new cljs.core.Keyword("pine.core","test-path","pine.core/test-path",-1035062578)], null),null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"route-id","route-id",-1804166443),new cljs.core.Keyword(null,"test-path","test-path",-678164055)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("pine.core","children","pine.core/children",-1431439457)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword(null,"route-id","route-id",-1804166443))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword(null,"test-path","test-path",-678164055)))], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("pine.core","children","pine.core/children",-1431439457)], null)])));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("pine.core","route-id","pine.core/route-id",1898868218),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),cljs.core.keyword_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("pine.core","string-test","pine.core/string-test",64224382),new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null),cljs.core.string_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("pine.core","vector-test","pine.core/vector-test",-1278104953),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),cljs.core.vector_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("pine.core","params","pine.core/params",-19927898),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),cljs.core.map_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("pine.core","test-path","pine.core/test-path",-1035062578),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"vector-test","vector-test",395018532),new cljs.core.Keyword("pine.core","vector-test","pine.core/vector-test",-1278104953),new cljs.core.Keyword(null,"string-test","string-test",-562418141),new cljs.core.Keyword("pine.core","string-test","pine.core/string-test",64224382)),cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"vector-test","vector-test",395018532),new cljs.core.Keyword(null,"string-test","string-test",-562418141)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("pine.core","vector-test","pine.core/vector-test",-1278104953),new cljs.core.Keyword("pine.core","string-test","pine.core/string-test",64224382)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("pine.core","vector-test","pine.core/vector-test",-1278104953),new cljs.core.Keyword("pine.core","string-test","pine.core/string-test",64224382)], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("pine.core","match-result","pine.core/match-result",-684107257),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("pine.core","active","pine.core/active",-1817697161)], null),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("pine.core","params","pine.core/params",-19927898)], null)),cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("pine.core","active","pine.core/active",-1817697161)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("pine.core","params","pine.core/params",-19927898)], null),null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__36512){
return cljs.core.map_QMARK_.call(null,G__36512);
}),(function (G__36512){
return cljs.core.contains_QMARK_.call(null,G__36512,new cljs.core.Keyword(null,"active","active",1895962068));
})], null),(function (G__36512){
return ((cljs.core.map_QMARK_.call(null,G__36512)) && (cljs.core.contains_QMARK_.call(null,G__36512,new cljs.core.Keyword(null,"active","active",1895962068))));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"params","params",710516235)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("pine.core","active","pine.core/active",-1817697161)], null),null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"active","active",1895962068)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("pine.core","params","pine.core/params",-19927898)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword(null,"active","active",1895962068)))], null),null])));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("pine.core","active","pine.core/active",-1817697161),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","set?","cljs.core/set?",-1176684971,null),new cljs.core.Keyword(null,"min-count","min-count",1594709013),(1)),cljs.spec.alpha.every_impl.call(null,new cljs.core.Symbol(null,"keyword?","keyword?",1917797069,null),cljs.core.keyword_QMARK_,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","set?","cljs.core/set?",-1176684971,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__36513){
return ((cljs.core.set_QMARK_.call(null,G__36513)) && (((((function (){var or__3922__auto__ = (1);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return (0);
}
})() <= cljs.core.bounded_count.call(null,(1)
,G__36513))) && ((cljs.core.bounded_count.call(null,(1)
,G__36513) <= (function (){var or__3922__auto__ = null;
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return (9007199254740991);
}
})())))));
}),new cljs.core.Keyword(null,"min-count","min-count",1594709013),(1),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.set_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Keyword(null,"min-count","min-count",1594709013),(1),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","set?","cljs.core/set?",-1176684971,null))], null),null));







cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("pine.core","match-route","pine.core/match-route",-1720969862,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.Keyword("pine.core","full-path","pine.core/full-path",1254479403),new cljs.core.Keyword(null,"routes","routes",457900162),new cljs.core.Keyword("pine.core","routes","pine.core/routes",-25112795)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword("pine.core","match-result","pine.core/match-result",-684107257)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.Keyword("pine.core","full-path","pine.core/full-path",1254479403),new cljs.core.Keyword(null,"routes","routes",457900162),new cljs.core.Keyword("pine.core","routes","pine.core/routes",-25112795)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.Keyword(null,"routes","routes",457900162)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("pine.core","full-path","pine.core/full-path",1254479403),new cljs.core.Keyword("pine.core","routes","pine.core/routes",-25112795)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("pine.core","full-path","pine.core/full-path",1254479403),new cljs.core.Keyword("pine.core","routes","pine.core/routes",-25112795)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.Keyword("pine.core","full-path","pine.core/full-path",1254479403),new cljs.core.Keyword(null,"routes","routes",457900162),new cljs.core.Keyword("pine.core","routes","pine.core/routes",-25112795)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Keyword("pine.core","match-result","pine.core/match-result",-684107257),new cljs.core.Keyword("pine.core","match-result","pine.core/match-result",-684107257),null,null),new cljs.core.Keyword("pine.core","match-result","pine.core/match-result",-684107257),null,null,null));
pine.core.match_route = (function pine$core$match_route(path,routes){
return pine.core.match_route_STAR_.call(null,pine.core.push_children.call(null,cljs.core.PersistentVector.EMPTY,routes),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [pine.core.make_result.call(null,path,null,null)], null));
});
pine.core.match_route_STAR_ = (function pine$core$match_route_STAR_(routes,result_stack){
while(true){
var temp__5457__auto__ = cljs.core.first.call(null,routes);
if(cljs.core.truth_(temp__5457__auto__)){
var child_set = temp__5457__auto__;
var last_result = cljs.core.peek.call(null,result_stack);
var current_route = cljs.core.first.call(null,child_set);
var remaining_routes = cljs.core.update_in.call(null,routes,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),((function (routes,result_stack,last_result,current_route,child_set,temp__5457__auto__){
return (function (p1__36514_SHARP_){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.rest.call(null,p1__36514_SHARP_));
});})(routes,result_stack,last_result,current_route,child_set,temp__5457__auto__))
);
if(cljs.core.empty_QMARK_.call(null,child_set)){
var G__36515 = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.rest.call(null,remaining_routes));
var G__36516 = pine.core.pop_result.call(null,result_stack);
routes = G__36515;
result_stack = G__36516;
continue;
} else {
var temp__5455__auto__ = pine.core.match_subpath.call(null,new cljs.core.Keyword(null,"test-path","test-path",-678164055).cljs$core$IFn$_invoke$arity$1(current_route),new cljs.core.Keyword(null,"remaining-path","remaining-path",-873222296).cljs$core$IFn$_invoke$arity$1(last_result));
if(cljs.core.truth_(temp__5455__auto__)){
var match_result = temp__5455__auto__;
var new_result = pine.core.make_result.call(null,new cljs.core.Keyword(null,"remaining-path","remaining-path",-873222296).cljs$core$IFn$_invoke$arity$1(match_result),new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(match_result),new cljs.core.Keyword(null,"route-id","route-id",-1804166443).cljs$core$IFn$_invoke$arity$1(current_route));
if((new cljs.core.Keyword(null,"remaining-path","remaining-path",-873222296).cljs$core$IFn$_invoke$arity$1(match_result) == null)){
return pine.core.reduce_results.call(null,cljs.core.rest.call(null,cljs.core.conj.call(null,result_stack,new_result)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"routes","routes",457900162).cljs$core$IFn$_invoke$arity$1(current_route))){
var G__36517 = pine.core.push_children.call(null,remaining_routes,new cljs.core.Keyword(null,"routes","routes",457900162).cljs$core$IFn$_invoke$arity$1(current_route));
var G__36518 = pine.core.push_result.call(null,result_stack,new_result);
routes = G__36517;
result_stack = G__36518;
continue;
} else {
var G__36519 = remaining_routes;
var G__36520 = result_stack;
routes = G__36519;
result_stack = G__36520;
continue;
}
}
} else {
var G__36521 = remaining_routes;
var G__36522 = result_stack;
routes = G__36521;
result_stack = G__36522;
continue;
}
}
} else {
return null;
}
break;
}
});
pine.core.pop_result = (function pine$core$pop_result(result_stack){
return cljs.core.pop.call(null,result_stack);
});
pine.core.push_result = (function pine$core$push_result(result_stack,result){
return cljs.core.conj.call(null,result_stack,result);
});
pine.core.make_result = (function pine$core$make_result(path,params,route_id){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"remaining-path","remaining-path",-873222296),path,new cljs.core.Keyword(null,"params","params",710516235),params,new cljs.core.Keyword(null,"route-id","route-id",-1804166443),route_id], null);
});
pine.core.push_children = (function pine$core$push_children(routes,children){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [children], null),routes));
});
pine.core.reduce_results = (function pine$core$reduce_results(results){
return cljs.core.reduce.call(null,(function (p1__36523_SHARP_,p2__36524_SHARP_){
var G__36525 = p1__36523_SHARP_;
var G__36525__$1 = ((!((new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(p2__36524_SHARP_) == null)))?cljs.core.update_in.call(null,G__36525,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"params","params",710516235)], null),cljs.core.merge,cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"route-id","route-id",-1804166443).cljs$core$IFn$_invoke$arity$1(p2__36524_SHARP_),new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(p2__36524_SHARP_)])):G__36525);
return cljs.core.update_in.call(null,G__36525__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"active","active",1895962068)], null),cljs.core.conj,new cljs.core.Keyword(null,"route-id","route-id",-1804166443).cljs$core$IFn$_invoke$arity$1(p2__36524_SHARP_));

}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"active","active",1895962068),cljs.core.PersistentHashSet.EMPTY], null),results);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
pine.core.SubpathMatch = (function (remaining_path,params,__meta,__extmap,__hash){
this.remaining_path = remaining_path;
this.params = params;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
pine.core.SubpathMatch.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4172__auto__,k__4173__auto__){
var self__ = this;
var this__4172__auto____$1 = this;
return this__4172__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4173__auto__,null);
});

pine.core.SubpathMatch.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4174__auto__,k36527,else__4175__auto__){
var self__ = this;
var this__4174__auto____$1 = this;
var G__36531 = k36527;
var G__36531__$1 = (((G__36531 instanceof cljs.core.Keyword))?G__36531.fqn:null);
switch (G__36531__$1) {
case "remaining-path":
return self__.remaining_path;

break;
case "params":
return self__.params;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k36527,else__4175__auto__);

}
});

pine.core.SubpathMatch.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4186__auto__,writer__4187__auto__,opts__4188__auto__){
var self__ = this;
var this__4186__auto____$1 = this;
var pr_pair__4189__auto__ = ((function (this__4186__auto____$1){
return (function (keyval__4190__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4187__auto__,cljs.core.pr_writer,""," ","",opts__4188__auto__,keyval__4190__auto__);
});})(this__4186__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4187__auto__,pr_pair__4189__auto__,"#pine.core.SubpathMatch{",", ","}",opts__4188__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remaining-path","remaining-path",-873222296),self__.remaining_path],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null))], null),self__.__extmap));
});

pine.core.SubpathMatch.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__36526){
var self__ = this;
var G__36526__$1 = this;
return (new cljs.core.RecordIter((0),G__36526__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"remaining-path","remaining-path",-873222296),new cljs.core.Keyword(null,"params","params",710516235)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

pine.core.SubpathMatch.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4170__auto__){
var self__ = this;
var this__4170__auto____$1 = this;
return self__.__meta;
});

pine.core.SubpathMatch.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4167__auto__){
var self__ = this;
var this__4167__auto____$1 = this;
return (new pine.core.SubpathMatch(self__.remaining_path,self__.params,self__.__meta,self__.__extmap,self__.__hash));
});

pine.core.SubpathMatch.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4176__auto__){
var self__ = this;
var this__4176__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

pine.core.SubpathMatch.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4168__auto__){
var self__ = this;
var this__4168__auto____$1 = this;
var h__4030__auto__ = self__.__hash;
if(!((h__4030__auto__ == null))){
return h__4030__auto__;
} else {
var h__4030__auto____$1 = ((function (h__4030__auto__,this__4168__auto____$1){
return (function (coll__4169__auto__){
return (-1688174162 ^ cljs.core.hash_unordered_coll.call(null,coll__4169__auto__));
});})(h__4030__auto__,this__4168__auto____$1))
.call(null,this__4168__auto____$1);
self__.__hash = h__4030__auto____$1;

return h__4030__auto____$1;
}
});

pine.core.SubpathMatch.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this36528,other36529){
var self__ = this;
var this36528__$1 = this;
return ((!((other36529 == null))) && ((this36528__$1.constructor === other36529.constructor)) && (cljs.core._EQ_.call(null,this36528__$1.remaining_path,other36529.remaining_path)) && (cljs.core._EQ_.call(null,this36528__$1.params,other36529.params)) && (cljs.core._EQ_.call(null,this36528__$1.__extmap,other36529.__extmap)));
});

pine.core.SubpathMatch.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4181__auto__,k__4182__auto__){
var self__ = this;
var this__4181__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"remaining-path","remaining-path",-873222296),null,new cljs.core.Keyword(null,"params","params",710516235),null], null), null),k__4182__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4181__auto____$1),self__.__meta),k__4182__auto__);
} else {
return (new pine.core.SubpathMatch(self__.remaining_path,self__.params,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4182__auto__)),null));
}
});

pine.core.SubpathMatch.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4179__auto__,k__4180__auto__,G__36526){
var self__ = this;
var this__4179__auto____$1 = this;
var pred__36532 = cljs.core.keyword_identical_QMARK_;
var expr__36533 = k__4180__auto__;
if(cljs.core.truth_(pred__36532.call(null,new cljs.core.Keyword(null,"remaining-path","remaining-path",-873222296),expr__36533))){
return (new pine.core.SubpathMatch(G__36526,self__.params,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__36532.call(null,new cljs.core.Keyword(null,"params","params",710516235),expr__36533))){
return (new pine.core.SubpathMatch(self__.remaining_path,G__36526,self__.__meta,self__.__extmap,null));
} else {
return (new pine.core.SubpathMatch(self__.remaining_path,self__.params,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4180__auto__,G__36526),null));
}
}
});

pine.core.SubpathMatch.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4184__auto__){
var self__ = this;
var this__4184__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remaining-path","remaining-path",-873222296),self__.remaining_path,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"params","params",710516235),self__.params,null))], null),self__.__extmap));
});

pine.core.SubpathMatch.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4171__auto__,G__36526){
var self__ = this;
var this__4171__auto____$1 = this;
return (new pine.core.SubpathMatch(self__.remaining_path,self__.params,G__36526,self__.__extmap,self__.__hash));
});

pine.core.SubpathMatch.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4177__auto__,entry__4178__auto__){
var self__ = this;
var this__4177__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4178__auto__)){
return this__4177__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4178__auto__,(0)),cljs.core._nth.call(null,entry__4178__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4177__auto____$1,entry__4178__auto__);
}
});

pine.core.SubpathMatch.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"remaining-path","remaining-path",767309231,null),new cljs.core.Symbol(null,"params","params",-1943919534,null)], null);
});

pine.core.SubpathMatch.cljs$lang$type = true;

pine.core.SubpathMatch.cljs$lang$ctorPrSeq = (function (this__4208__auto__){
return (new cljs.core.List(null,"pine.core/SubpathMatch",null,(1),null));
});

pine.core.SubpathMatch.cljs$lang$ctorPrWriter = (function (this__4208__auto__,writer__4209__auto__){
return cljs.core._write.call(null,writer__4209__auto__,"pine.core/SubpathMatch");
});

/**
 * Positional factory function for pine.core/SubpathMatch.
 */
pine.core.__GT_SubpathMatch = (function pine$core$__GT_SubpathMatch(remaining_path,params){
return (new pine.core.SubpathMatch(remaining_path,params,null,null,null));
});

/**
 * Factory function for pine.core/SubpathMatch, taking a map of keywords to field values.
 */
pine.core.map__GT_SubpathMatch = (function pine$core$map__GT_SubpathMatch(G__36530){
return (new pine.core.SubpathMatch(new cljs.core.Keyword(null,"remaining-path","remaining-path",-873222296).cljs$core$IFn$_invoke$arity$1(G__36530),new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(G__36530),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__36530,new cljs.core.Keyword(null,"remaining-path","remaining-path",-873222296),new cljs.core.Keyword(null,"params","params",710516235))),null));
});

cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("pine.core","match-subpath","pine.core/match-subpath",1246031390,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("pine.core","test-path","pine.core/test-path",-1035062578),new cljs.core.Keyword(null,"subpath","subpath",2019069344),new cljs.core.Keyword("pine.core","full-path","pine.core/full-path",1254479403)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword("pine.core","match-result","pine.core/match-result",-684107257)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("pine.core","test-path","pine.core/test-path",-1035062578),new cljs.core.Keyword(null,"subpath","subpath",2019069344),new cljs.core.Keyword("pine.core","full-path","pine.core/full-path",1254479403)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword(null,"subpath","subpath",2019069344)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("pine.core","test-path","pine.core/test-path",-1035062578),new cljs.core.Keyword("pine.core","full-path","pine.core/full-path",1254479403)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("pine.core","test-path","pine.core/test-path",-1035062578),new cljs.core.Keyword("pine.core","full-path","pine.core/full-path",1254479403)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("pine.core","test-path","pine.core/test-path",-1035062578),new cljs.core.Keyword(null,"subpath","subpath",2019069344),new cljs.core.Keyword("pine.core","full-path","pine.core/full-path",1254479403)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Keyword("pine.core","match-result","pine.core/match-result",-684107257),new cljs.core.Keyword("pine.core","match-result","pine.core/match-result",-684107257),null,null),new cljs.core.Keyword("pine.core","match-result","pine.core/match-result",-684107257),null,null,null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("pine.core","build-subpath","pine.core/build-subpath",-1100541426,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("pine.core","test-path","pine.core/test-path",-1035062578),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword("pine.core","params","pine.core/params",-19927898))),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("pine.core","test-path","pine.core/test-path",-1035062578),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword("pine.core","params","pine.core/params",-19927898)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword(null,"params","params",710516235)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("pine.core","test-path","pine.core/test-path",-1035062578),new cljs.core.Keyword("pine.core","params","pine.core/params",-19927898)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("pine.core","test-path","pine.core/test-path",-1035062578),new cljs.core.Keyword("pine.core","params","pine.core/params",-19927898)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("pine.core","test-path","pine.core/test-path",-1035062578),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword("pine.core","params","pine.core/params",-19927898)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_,null,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),null,null,null));

/**
 * @interface
 */
pine.core.TestPath = function(){};

/**
 * Check to see if a `subpath` matches a `test`.
 * 
 *   If the subpath matches the test, break down the test
 *   params and return an object with a next-subpath and
 *   the params.
 * 
 *   returns nil if not a match.
 * 
 *   If `test` is a string, match against that string.
 * 
 *   If `test` is a vector, match against strings in the vector,
 *   and transform :keywords into route parameters.
 *   Note: Keyword matches will not proceed past '/'.
 */
pine.core.match_subpath = (function pine$core$match_subpath(test,subpath){
if(((!((test == null))) && (!((test.pine$core$TestPath$match_subpath$arity$2 == null))))){
return test.pine$core$TestPath$match_subpath$arity$2(test,subpath);
} else {
var x__4211__auto__ = (((test == null))?null:test);
var m__4212__auto__ = (pine.core.match_subpath[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,test,subpath);
} else {
var m__4212__auto____$1 = (pine.core.match_subpath["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,test,subpath);
} else {
throw cljs.core.missing_protocol.call(null,"TestPath.match-subpath",test);
}
}
}
});

pine.core.build_subpath = (function pine$core$build_subpath(test,params){
if(((!((test == null))) && (!((test.pine$core$TestPath$build_subpath$arity$2 == null))))){
return test.pine$core$TestPath$build_subpath$arity$2(test,params);
} else {
var x__4211__auto__ = (((test == null))?null:test);
var m__4212__auto__ = (pine.core.build_subpath[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,test,params);
} else {
var m__4212__auto____$1 = (pine.core.build_subpath["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,test,params);
} else {
throw cljs.core.missing_protocol.call(null,"TestPath.build-subpath",test);
}
}
}
});

String.prototype.pine$core$TestPath$ = cljs.core.PROTOCOL_SENTINEL;

String.prototype.pine$core$TestPath$match_subpath$arity$2 = (function (test,subpath){
var test__$1 = this;
if(clojure.string.starts_with_QMARK_.call(null,subpath,test__$1)){
return (new pine.core.SubpathMatch((function (){var remainder = clojure.string.replace_first.call(null,subpath,test__$1,"");
if(!(cljs.core.empty_QMARK_.call(null,remainder))){
return remainder;
} else {
return null;
}
})(),null,null,null,null));
} else {
return null;
}
});

String.prototype.pine$core$TestPath$build_subpath$arity$2 = (function (test,params){
var test__$1 = this;
return test__$1;
});

cljs.core.PersistentVector.prototype.pine$core$TestPath$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.pine$core$TestPath$match_subpath$arity$2 = (function (test,subpath){
var test__$1 = this;
var match = cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,"(\\/?[^\\/\\n]+)(\\/.*)?"),subpath);
var focus = cljs.core.second.call(null,match);
var remainder = match.call(null,(2));
var temp__5457__auto__ = pine.core.traverse_vector_path.call(null,test__$1,focus,cljs.core.PersistentArrayMap.EMPTY);
if(cljs.core.truth_(temp__5457__auto__)){
var params = temp__5457__auto__;
return (new pine.core.SubpathMatch(remainder,params,null,null,null));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.pine$core$TestPath$build_subpath$arity$2 = (function (test,params){
var test__$1 = this;
return clojure.string.join.call(null,cljs.core.map.call(null,((function (test__$1){
return (function (p1__36536_SHARP_){
var pred__36537 = cljs.core._EQ_;
var expr__36538 = cljs.core.type.call(null,p1__36536_SHARP_);
if(cljs.core.truth_(pred__36537.call(null,String,expr__36538))){
return p1__36536_SHARP_;
} else {
if(cljs.core.truth_(pred__36537.call(null,cljs.core.Keyword,expr__36538))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__36536_SHARP_.call(null,params))].join('');
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__36538)].join('')));
}
}
});})(test__$1))
,test__$1));
});
pine.core.traverse_vector_path = (function pine$core$traverse_vector_path(test,path,params){
while(true){
if(cljs.core.empty_QMARK_.call(null,test)){
return params;
} else {
var current = cljs.core.first.call(null,test);
if(cljs.core._EQ_.call(null,cljs.core.type.call(null,current),String)){
var next_string = clojure.string.replace_first.call(null,path,current,"");
if(((clojure.string.starts_with_QMARK_.call(null,path,current)) && (!(cljs.core.empty_QMARK_.call(null,next_string))))){
var G__36540 = cljs.core.rest.call(null,test);
var G__36541 = next_string;
var G__36542 = params;
test = G__36540;
path = G__36541;
params = G__36542;
continue;
} else {
return null;
}
} else {
if(cljs.core._EQ_.call(null,cljs.core.type.call(null,current),cljs.core.Keyword)){
var lookahead = (function (){var or__3922__auto__ = cljs.core.second.call(null,test);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return "";
}
})();
if(clojure.string.includes_QMARK_.call(null,path,lookahead)){
var regex_result = cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,["(.*)(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lookahead),".*)"].join('')),path);
var match = cljs.core.second.call(null,regex_result);
var remainder = regex_result.call(null,(2));
var G__36543 = cljs.core.rest.call(null,test);
var G__36544 = remainder;
var G__36545 = cljs.core.assoc.call(null,params,current,match);
test = G__36543;
path = G__36544;
params = G__36545;
continue;
} else {
return null;
}
} else {
return null;
}
}
}
break;
}
});
pine.core.path_for = (function pine$core$path_for(route_id,params,routes){
var compiled = pine.core.routes_by_key.call(null,routes);
return clojure.string.join.call(null,cljs.core.map.call(null,((function (compiled){
return (function (p1__36546_SHARP_){
return pine.core.build_subpath.call(null,new cljs.core.Keyword(null,"test-path","test-path",-678164055).cljs$core$IFn$_invoke$arity$1(p1__36546_SHARP_),new cljs.core.Keyword(null,"route-id","route-id",-1804166443).cljs$core$IFn$_invoke$arity$1(p1__36546_SHARP_).call(null,params));
});})(compiled))
,route_id.call(null,compiled)));
});
pine.core.routes_by_key_STAR_ = (function pine$core$routes_by_key_STAR_(routes_stack,result_stack,result){
while(true){
var temp__5457__auto__ = cljs.core.first.call(null,routes_stack);
if(cljs.core.truth_(temp__5457__auto__)){
var child_set = temp__5457__auto__;
if(cljs.core.empty_QMARK_.call(null,child_set)){
if(!(cljs.core.empty_QMARK_.call(null,cljs.core.rest.call(null,routes_stack)))){
var G__36548 = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.rest.call(null,routes_stack));
var G__36549 = cljs.core.pop.call(null,result_stack);
var G__36550 = result;
routes_stack = G__36548;
result_stack = G__36549;
result = G__36550;
continue;
} else {
return result;
}
} else {
var current_route = cljs.core.first.call(null,child_set);
var child_routes = new cljs.core.Keyword(null,"routes","routes",457900162).cljs$core$IFn$_invoke$arity$1(current_route);
var remaining_routes = cljs.core.update_in.call(null,routes_stack,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),((function (routes_stack,result_stack,result,current_route,child_routes,child_set,temp__5457__auto__){
return (function (p1__36547_SHARP_){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.rest.call(null,p1__36547_SHARP_));
});})(routes_stack,result_stack,result,current_route,child_routes,child_set,temp__5457__auto__))
);
var next_result_stack = cljs.core.conj.call(null,result_stack,cljs.core.dissoc.call(null,current_route,new cljs.core.Keyword(null,"routes","routes",457900162)));
var next_result = cljs.core.assoc.call(null,result,new cljs.core.Keyword(null,"route-id","route-id",-1804166443).cljs$core$IFn$_invoke$arity$1(current_route),next_result_stack);
if(cljs.core.truth_(child_routes)){
var G__36551 = pine.core.push_children.call(null,remaining_routes,child_routes);
var G__36552 = next_result_stack;
var G__36553 = next_result;
routes_stack = G__36551;
result_stack = G__36552;
result = G__36553;
continue;
} else {
var G__36554 = remaining_routes;
var G__36555 = cljs.core.pop.call(null,next_result_stack);
var G__36556 = next_result;
routes_stack = G__36554;
result_stack = G__36555;
result = G__36556;
continue;
}
}
} else {
return null;
}
break;
}
});
pine.core.routes_by_key = (function pine$core$routes_by_key(routes){
return pine.core.routes_by_key_STAR_.call(null,pine.core.push_children.call(null,cljs.core.PersistentVector.EMPTY,routes),cljs.core.PersistentVector.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
});

//# sourceMappingURL=core.js.map?rel=1524452102651
