// Compiled by ClojureScript 1.10.238 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.15";
figwheel.client.js_stringify = ((((typeof JSON !== 'undefined') && (!((JSON.stringify == null)))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}catch (e40390){if((e40390 instanceof Error)){
var e = e40390;
return "Error: Unable to stringify";
} else {
throw e40390;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__40393 = arguments.length;
switch (G__40393) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__40391_SHARP_){
if(typeof p1__40391_SHARP_ === 'string'){
return p1__40391_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__40391_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__4502__auto__ = [];
var len__4499__auto___40396 = arguments.length;
var i__4500__auto___40397 = (0);
while(true){
if((i__4500__auto___40397 < len__4499__auto___40396)){
args__4502__auto__.push((arguments[i__4500__auto___40397]));

var G__40398 = (i__4500__auto___40397 + (1));
i__4500__auto___40397 = G__40398;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((0) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4503__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq40395){
var self__4487__auto__ = this;
return self__4487__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq40395));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__4502__auto__ = [];
var len__4499__auto___40400 = arguments.length;
var i__4500__auto___40401 = (0);
while(true){
if((i__4500__auto___40401 < len__4499__auto___40400)){
args__4502__auto__.push((arguments[i__4500__auto___40401]));

var G__40402 = (i__4500__auto___40401 + (1));
i__4500__auto___40401 = G__40402;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((0) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4503__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq40399){
var self__4487__auto__ = this;
return self__4487__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq40399));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)"].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Figwheel autoloading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if(((b === true) || (b === false))){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if(((b === true) || (b === false))){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__40403){
var map__40404 = p__40403;
var map__40404__$1 = ((((!((map__40404 == null)))?(((((map__40404.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40404.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40404):map__40404);
var message = cljs.core.get.call(null,map__40404__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__40404__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__3922__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__3911__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__3911__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__3911__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return ((cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts))));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__36609__auto___40483 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto___40483,ch){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto___40483,ch){
return (function (state_40455){
var state_val_40456 = (state_40455[(1)]);
if((state_val_40456 === (7))){
var inst_40451 = (state_40455[(2)]);
var state_40455__$1 = state_40455;
var statearr_40457_40484 = state_40455__$1;
(statearr_40457_40484[(2)] = inst_40451);

(statearr_40457_40484[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40456 === (1))){
var state_40455__$1 = state_40455;
var statearr_40458_40485 = state_40455__$1;
(statearr_40458_40485[(2)] = null);

(statearr_40458_40485[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40456 === (4))){
var inst_40408 = (state_40455[(7)]);
var inst_40408__$1 = (state_40455[(2)]);
var state_40455__$1 = (function (){var statearr_40459 = state_40455;
(statearr_40459[(7)] = inst_40408__$1);

return statearr_40459;
})();
if(cljs.core.truth_(inst_40408__$1)){
var statearr_40460_40486 = state_40455__$1;
(statearr_40460_40486[(1)] = (5));

} else {
var statearr_40461_40487 = state_40455__$1;
(statearr_40461_40487[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40456 === (15))){
var inst_40415 = (state_40455[(8)]);
var inst_40430 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_40415);
var inst_40431 = cljs.core.first.call(null,inst_40430);
var inst_40432 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_40431);
var inst_40433 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40432)].join('');
var inst_40434 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_40433);
var state_40455__$1 = state_40455;
var statearr_40462_40488 = state_40455__$1;
(statearr_40462_40488[(2)] = inst_40434);

(statearr_40462_40488[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40456 === (13))){
var inst_40439 = (state_40455[(2)]);
var state_40455__$1 = state_40455;
var statearr_40463_40489 = state_40455__$1;
(statearr_40463_40489[(2)] = inst_40439);

(statearr_40463_40489[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40456 === (6))){
var state_40455__$1 = state_40455;
var statearr_40464_40490 = state_40455__$1;
(statearr_40464_40490[(2)] = null);

(statearr_40464_40490[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40456 === (17))){
var inst_40437 = (state_40455[(2)]);
var state_40455__$1 = state_40455;
var statearr_40465_40491 = state_40455__$1;
(statearr_40465_40491[(2)] = inst_40437);

(statearr_40465_40491[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40456 === (3))){
var inst_40453 = (state_40455[(2)]);
var state_40455__$1 = state_40455;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40455__$1,inst_40453);
} else {
if((state_val_40456 === (12))){
var inst_40414 = (state_40455[(9)]);
var inst_40428 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_40414,opts);
var state_40455__$1 = state_40455;
if(cljs.core.truth_(inst_40428)){
var statearr_40466_40492 = state_40455__$1;
(statearr_40466_40492[(1)] = (15));

} else {
var statearr_40467_40493 = state_40455__$1;
(statearr_40467_40493[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40456 === (2))){
var state_40455__$1 = state_40455;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40455__$1,(4),ch);
} else {
if((state_val_40456 === (11))){
var inst_40415 = (state_40455[(8)]);
var inst_40420 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40421 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_40415);
var inst_40422 = cljs.core.async.timeout.call(null,(1000));
var inst_40423 = [inst_40421,inst_40422];
var inst_40424 = (new cljs.core.PersistentVector(null,2,(5),inst_40420,inst_40423,null));
var state_40455__$1 = state_40455;
return cljs.core.async.ioc_alts_BANG_.call(null,state_40455__$1,(14),inst_40424);
} else {
if((state_val_40456 === (9))){
var inst_40415 = (state_40455[(8)]);
var inst_40441 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_40442 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_40415);
var inst_40443 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_40442);
var inst_40444 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40443)].join('');
var inst_40445 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_40444);
var state_40455__$1 = (function (){var statearr_40468 = state_40455;
(statearr_40468[(10)] = inst_40441);

return statearr_40468;
})();
var statearr_40469_40494 = state_40455__$1;
(statearr_40469_40494[(2)] = inst_40445);

(statearr_40469_40494[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40456 === (5))){
var inst_40408 = (state_40455[(7)]);
var inst_40410 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_40411 = (new cljs.core.PersistentArrayMap(null,2,inst_40410,null));
var inst_40412 = (new cljs.core.PersistentHashSet(null,inst_40411,null));
var inst_40413 = figwheel.client.focus_msgs.call(null,inst_40412,inst_40408);
var inst_40414 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_40413);
var inst_40415 = cljs.core.first.call(null,inst_40413);
var inst_40416 = figwheel.client.autoload_QMARK_.call(null);
var state_40455__$1 = (function (){var statearr_40470 = state_40455;
(statearr_40470[(9)] = inst_40414);

(statearr_40470[(8)] = inst_40415);

return statearr_40470;
})();
if(cljs.core.truth_(inst_40416)){
var statearr_40471_40495 = state_40455__$1;
(statearr_40471_40495[(1)] = (8));

} else {
var statearr_40472_40496 = state_40455__$1;
(statearr_40472_40496[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40456 === (14))){
var inst_40426 = (state_40455[(2)]);
var state_40455__$1 = state_40455;
var statearr_40473_40497 = state_40455__$1;
(statearr_40473_40497[(2)] = inst_40426);

(statearr_40473_40497[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40456 === (16))){
var state_40455__$1 = state_40455;
var statearr_40474_40498 = state_40455__$1;
(statearr_40474_40498[(2)] = null);

(statearr_40474_40498[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40456 === (10))){
var inst_40447 = (state_40455[(2)]);
var state_40455__$1 = (function (){var statearr_40475 = state_40455;
(statearr_40475[(11)] = inst_40447);

return statearr_40475;
})();
var statearr_40476_40499 = state_40455__$1;
(statearr_40476_40499[(2)] = null);

(statearr_40476_40499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40456 === (8))){
var inst_40414 = (state_40455[(9)]);
var inst_40418 = figwheel.client.reload_file_state_QMARK_.call(null,inst_40414,opts);
var state_40455__$1 = state_40455;
if(cljs.core.truth_(inst_40418)){
var statearr_40477_40500 = state_40455__$1;
(statearr_40477_40500[(1)] = (11));

} else {
var statearr_40478_40501 = state_40455__$1;
(statearr_40478_40501[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36609__auto___40483,ch))
;
return ((function (switch__36521__auto__,c__36609__auto___40483,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__36522__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__36522__auto____0 = (function (){
var statearr_40479 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40479[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__36522__auto__);

(statearr_40479[(1)] = (1));

return statearr_40479;
});
var figwheel$client$file_reloader_plugin_$_state_machine__36522__auto____1 = (function (state_40455){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_40455);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e40480){if((e40480 instanceof Object)){
var ex__36525__auto__ = e40480;
var statearr_40481_40502 = state_40455;
(statearr_40481_40502[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40455);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40480;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40503 = state_40455;
state_40455 = G__40503;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__36522__auto__ = function(state_40455){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__36522__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__36522__auto____1.call(this,state_40455);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloader_plugin_$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__36522__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__36522__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto___40483,ch))
})();
var state__36611__auto__ = (function (){var statearr_40482 = f__36610__auto__.call(null);
(statearr_40482[(6)] = c__36609__auto___40483);

return statearr_40482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto___40483,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__40504_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__40504_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_40508 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_40508){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{var sb = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_40506 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_40507 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_40506,_STAR_print_fn_STAR_40507,sb,base_path_40508){
return (function (x){
return sb.append(x);
});})(_STAR_print_newline_STAR_40506,_STAR_print_fn_STAR_40507,sb,base_path_40508))
;

try{var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"out","out",-910545517),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb)].join(''),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_40507;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_40506;
}}catch (e40505){if((e40505 instanceof Error)){
var e = e40505;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_40508], null));
} else {
var e = e40505;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}});})(base_path_40508))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__40509){
var map__40510 = p__40509;
var map__40510__$1 = ((((!((map__40510 == null)))?(((((map__40510.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40510.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40510):map__40510);
var opts = map__40510__$1;
var build_id = cljs.core.get.call(null,map__40510__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__40510,map__40510__$1,opts,build_id){
return (function (p__40512){
var vec__40513 = p__40512;
var seq__40514 = cljs.core.seq.call(null,vec__40513);
var first__40515 = cljs.core.first.call(null,seq__40514);
var seq__40514__$1 = cljs.core.next.call(null,seq__40514);
var map__40516 = first__40515;
var map__40516__$1 = ((((!((map__40516 == null)))?(((((map__40516.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40516.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40516):map__40516);
var msg = map__40516__$1;
var msg_name = cljs.core.get.call(null,map__40516__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__40514__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__40513,seq__40514,first__40515,seq__40514__$1,map__40516,map__40516__$1,msg,msg_name,_,map__40510,map__40510__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__40513,seq__40514,first__40515,seq__40514__$1,map__40516,map__40516__$1,msg,msg_name,_,map__40510,map__40510__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__40510,map__40510__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__40518){
var vec__40519 = p__40518;
var seq__40520 = cljs.core.seq.call(null,vec__40519);
var first__40521 = cljs.core.first.call(null,seq__40520);
var seq__40520__$1 = cljs.core.next.call(null,seq__40520);
var map__40522 = first__40521;
var map__40522__$1 = ((((!((map__40522 == null)))?(((((map__40522.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40522.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40522):map__40522);
var msg = map__40522__$1;
var msg_name = cljs.core.get.call(null,map__40522__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__40520__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__40524){
var map__40525 = p__40524;
var map__40525__$1 = ((((!((map__40525 == null)))?(((((map__40525.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40525.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40525):map__40525);
var on_compile_warning = cljs.core.get.call(null,map__40525__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__40525__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__40525,map__40525__$1,on_compile_warning,on_compile_fail){
return (function (p__40527){
var vec__40528 = p__40527;
var seq__40529 = cljs.core.seq.call(null,vec__40528);
var first__40530 = cljs.core.first.call(null,seq__40529);
var seq__40529__$1 = cljs.core.next.call(null,seq__40529);
var map__40531 = first__40530;
var map__40531__$1 = ((((!((map__40531 == null)))?(((((map__40531.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40531.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40531):map__40531);
var msg = map__40531__$1;
var msg_name = cljs.core.get.call(null,map__40531__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__40529__$1;
var pred__40533 = cljs.core._EQ_;
var expr__40534 = msg_name;
if(cljs.core.truth_(pred__40533.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__40534))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__40533.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__40534))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__40525,map__40525__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__36609__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto__,msg_hist,msg_names,msg){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto__,msg_hist,msg_names,msg){
return (function (state_40623){
var state_val_40624 = (state_40623[(1)]);
if((state_val_40624 === (7))){
var inst_40543 = (state_40623[(2)]);
var state_40623__$1 = state_40623;
if(cljs.core.truth_(inst_40543)){
var statearr_40625_40672 = state_40623__$1;
(statearr_40625_40672[(1)] = (8));

} else {
var statearr_40626_40673 = state_40623__$1;
(statearr_40626_40673[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (20))){
var inst_40617 = (state_40623[(2)]);
var state_40623__$1 = state_40623;
var statearr_40627_40674 = state_40623__$1;
(statearr_40627_40674[(2)] = inst_40617);

(statearr_40627_40674[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (27))){
var inst_40613 = (state_40623[(2)]);
var state_40623__$1 = state_40623;
var statearr_40628_40675 = state_40623__$1;
(statearr_40628_40675[(2)] = inst_40613);

(statearr_40628_40675[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (1))){
var inst_40536 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_40623__$1 = state_40623;
if(cljs.core.truth_(inst_40536)){
var statearr_40629_40676 = state_40623__$1;
(statearr_40629_40676[(1)] = (2));

} else {
var statearr_40630_40677 = state_40623__$1;
(statearr_40630_40677[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (24))){
var inst_40615 = (state_40623[(2)]);
var state_40623__$1 = state_40623;
var statearr_40631_40678 = state_40623__$1;
(statearr_40631_40678[(2)] = inst_40615);

(statearr_40631_40678[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (4))){
var inst_40621 = (state_40623[(2)]);
var state_40623__$1 = state_40623;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40623__$1,inst_40621);
} else {
if((state_val_40624 === (15))){
var inst_40619 = (state_40623[(2)]);
var state_40623__$1 = state_40623;
var statearr_40632_40679 = state_40623__$1;
(statearr_40632_40679[(2)] = inst_40619);

(statearr_40632_40679[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (21))){
var inst_40572 = (state_40623[(2)]);
var inst_40573 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_40574 = figwheel.client.auto_jump_to_error.call(null,opts,inst_40573);
var state_40623__$1 = (function (){var statearr_40633 = state_40623;
(statearr_40633[(7)] = inst_40572);

return statearr_40633;
})();
var statearr_40634_40680 = state_40623__$1;
(statearr_40634_40680[(2)] = inst_40574);

(statearr_40634_40680[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (31))){
var inst_40602 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_40623__$1 = state_40623;
if(cljs.core.truth_(inst_40602)){
var statearr_40635_40681 = state_40623__$1;
(statearr_40635_40681[(1)] = (34));

} else {
var statearr_40636_40682 = state_40623__$1;
(statearr_40636_40682[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (32))){
var inst_40611 = (state_40623[(2)]);
var state_40623__$1 = state_40623;
var statearr_40637_40683 = state_40623__$1;
(statearr_40637_40683[(2)] = inst_40611);

(statearr_40637_40683[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (33))){
var inst_40598 = (state_40623[(2)]);
var inst_40599 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_40600 = figwheel.client.auto_jump_to_error.call(null,opts,inst_40599);
var state_40623__$1 = (function (){var statearr_40638 = state_40623;
(statearr_40638[(8)] = inst_40598);

return statearr_40638;
})();
var statearr_40639_40684 = state_40623__$1;
(statearr_40639_40684[(2)] = inst_40600);

(statearr_40639_40684[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (13))){
var inst_40557 = figwheel.client.heads_up.clear.call(null);
var state_40623__$1 = state_40623;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40623__$1,(16),inst_40557);
} else {
if((state_val_40624 === (22))){
var inst_40578 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_40579 = figwheel.client.heads_up.append_warning_message.call(null,inst_40578);
var state_40623__$1 = state_40623;
var statearr_40640_40685 = state_40623__$1;
(statearr_40640_40685[(2)] = inst_40579);

(statearr_40640_40685[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (36))){
var inst_40609 = (state_40623[(2)]);
var state_40623__$1 = state_40623;
var statearr_40641_40686 = state_40623__$1;
(statearr_40641_40686[(2)] = inst_40609);

(statearr_40641_40686[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (29))){
var inst_40589 = (state_40623[(2)]);
var inst_40590 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_40591 = figwheel.client.auto_jump_to_error.call(null,opts,inst_40590);
var state_40623__$1 = (function (){var statearr_40642 = state_40623;
(statearr_40642[(9)] = inst_40589);

return statearr_40642;
})();
var statearr_40643_40687 = state_40623__$1;
(statearr_40643_40687[(2)] = inst_40591);

(statearr_40643_40687[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (6))){
var inst_40538 = (state_40623[(10)]);
var state_40623__$1 = state_40623;
var statearr_40644_40688 = state_40623__$1;
(statearr_40644_40688[(2)] = inst_40538);

(statearr_40644_40688[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (28))){
var inst_40585 = (state_40623[(2)]);
var inst_40586 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_40587 = figwheel.client.heads_up.display_warning.call(null,inst_40586);
var state_40623__$1 = (function (){var statearr_40645 = state_40623;
(statearr_40645[(11)] = inst_40585);

return statearr_40645;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40623__$1,(29),inst_40587);
} else {
if((state_val_40624 === (25))){
var inst_40583 = figwheel.client.heads_up.clear.call(null);
var state_40623__$1 = state_40623;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40623__$1,(28),inst_40583);
} else {
if((state_val_40624 === (34))){
var inst_40604 = figwheel.client.heads_up.flash_loaded.call(null);
var state_40623__$1 = state_40623;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40623__$1,(37),inst_40604);
} else {
if((state_val_40624 === (17))){
var inst_40563 = (state_40623[(2)]);
var inst_40564 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_40565 = figwheel.client.auto_jump_to_error.call(null,opts,inst_40564);
var state_40623__$1 = (function (){var statearr_40646 = state_40623;
(statearr_40646[(12)] = inst_40563);

return statearr_40646;
})();
var statearr_40647_40689 = state_40623__$1;
(statearr_40647_40689[(2)] = inst_40565);

(statearr_40647_40689[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (3))){
var inst_40555 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_40623__$1 = state_40623;
if(cljs.core.truth_(inst_40555)){
var statearr_40648_40690 = state_40623__$1;
(statearr_40648_40690[(1)] = (13));

} else {
var statearr_40649_40691 = state_40623__$1;
(statearr_40649_40691[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (12))){
var inst_40551 = (state_40623[(2)]);
var state_40623__$1 = state_40623;
var statearr_40650_40692 = state_40623__$1;
(statearr_40650_40692[(2)] = inst_40551);

(statearr_40650_40692[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (2))){
var inst_40538 = (state_40623[(10)]);
var inst_40538__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_40623__$1 = (function (){var statearr_40651 = state_40623;
(statearr_40651[(10)] = inst_40538__$1);

return statearr_40651;
})();
if(cljs.core.truth_(inst_40538__$1)){
var statearr_40652_40693 = state_40623__$1;
(statearr_40652_40693[(1)] = (5));

} else {
var statearr_40653_40694 = state_40623__$1;
(statearr_40653_40694[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (23))){
var inst_40581 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_40623__$1 = state_40623;
if(cljs.core.truth_(inst_40581)){
var statearr_40654_40695 = state_40623__$1;
(statearr_40654_40695[(1)] = (25));

} else {
var statearr_40655_40696 = state_40623__$1;
(statearr_40655_40696[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (35))){
var state_40623__$1 = state_40623;
var statearr_40656_40697 = state_40623__$1;
(statearr_40656_40697[(2)] = null);

(statearr_40656_40697[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (19))){
var inst_40576 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_40623__$1 = state_40623;
if(cljs.core.truth_(inst_40576)){
var statearr_40657_40698 = state_40623__$1;
(statearr_40657_40698[(1)] = (22));

} else {
var statearr_40658_40699 = state_40623__$1;
(statearr_40658_40699[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (11))){
var inst_40547 = (state_40623[(2)]);
var state_40623__$1 = state_40623;
var statearr_40659_40700 = state_40623__$1;
(statearr_40659_40700[(2)] = inst_40547);

(statearr_40659_40700[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (9))){
var inst_40549 = figwheel.client.heads_up.clear.call(null);
var state_40623__$1 = state_40623;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40623__$1,(12),inst_40549);
} else {
if((state_val_40624 === (5))){
var inst_40540 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_40623__$1 = state_40623;
var statearr_40660_40701 = state_40623__$1;
(statearr_40660_40701[(2)] = inst_40540);

(statearr_40660_40701[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (14))){
var inst_40567 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_40623__$1 = state_40623;
if(cljs.core.truth_(inst_40567)){
var statearr_40661_40702 = state_40623__$1;
(statearr_40661_40702[(1)] = (18));

} else {
var statearr_40662_40703 = state_40623__$1;
(statearr_40662_40703[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (26))){
var inst_40593 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_40623__$1 = state_40623;
if(cljs.core.truth_(inst_40593)){
var statearr_40663_40704 = state_40623__$1;
(statearr_40663_40704[(1)] = (30));

} else {
var statearr_40664_40705 = state_40623__$1;
(statearr_40664_40705[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (16))){
var inst_40559 = (state_40623[(2)]);
var inst_40560 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_40561 = figwheel.client.heads_up.display_exception.call(null,inst_40560);
var state_40623__$1 = (function (){var statearr_40665 = state_40623;
(statearr_40665[(13)] = inst_40559);

return statearr_40665;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40623__$1,(17),inst_40561);
} else {
if((state_val_40624 === (30))){
var inst_40595 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_40596 = figwheel.client.heads_up.display_warning.call(null,inst_40595);
var state_40623__$1 = state_40623;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40623__$1,(33),inst_40596);
} else {
if((state_val_40624 === (10))){
var inst_40553 = (state_40623[(2)]);
var state_40623__$1 = state_40623;
var statearr_40666_40706 = state_40623__$1;
(statearr_40666_40706[(2)] = inst_40553);

(statearr_40666_40706[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (18))){
var inst_40569 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_40570 = figwheel.client.heads_up.display_exception.call(null,inst_40569);
var state_40623__$1 = state_40623;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40623__$1,(21),inst_40570);
} else {
if((state_val_40624 === (37))){
var inst_40606 = (state_40623[(2)]);
var state_40623__$1 = state_40623;
var statearr_40667_40707 = state_40623__$1;
(statearr_40667_40707[(2)] = inst_40606);

(statearr_40667_40707[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40624 === (8))){
var inst_40545 = figwheel.client.heads_up.flash_loaded.call(null);
var state_40623__$1 = state_40623;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40623__$1,(11),inst_40545);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36609__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__36521__auto__,c__36609__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__36522__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__36522__auto____0 = (function (){
var statearr_40668 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40668[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__36522__auto__);

(statearr_40668[(1)] = (1));

return statearr_40668;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__36522__auto____1 = (function (state_40623){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_40623);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e40669){if((e40669 instanceof Object)){
var ex__36525__auto__ = e40669;
var statearr_40670_40708 = state_40623;
(statearr_40670_40708[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40623);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40669;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40709 = state_40623;
state_40623 = G__40709;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__36522__auto__ = function(state_40623){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__36522__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__36522__auto____1.call(this,state_40623);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__36522__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__36522__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto__,msg_hist,msg_names,msg))
})();
var state__36611__auto__ = (function (){var statearr_40671 = f__36610__auto__.call(null);
(statearr_40671[(6)] = c__36609__auto__);

return statearr_40671;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto__,msg_hist,msg_names,msg))
);

return c__36609__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__36609__auto___40738 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto___40738,ch){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto___40738,ch){
return (function (state_40724){
var state_val_40725 = (state_40724[(1)]);
if((state_val_40725 === (1))){
var state_40724__$1 = state_40724;
var statearr_40726_40739 = state_40724__$1;
(statearr_40726_40739[(2)] = null);

(statearr_40726_40739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40725 === (2))){
var state_40724__$1 = state_40724;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40724__$1,(4),ch);
} else {
if((state_val_40725 === (3))){
var inst_40722 = (state_40724[(2)]);
var state_40724__$1 = state_40724;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40724__$1,inst_40722);
} else {
if((state_val_40725 === (4))){
var inst_40712 = (state_40724[(7)]);
var inst_40712__$1 = (state_40724[(2)]);
var state_40724__$1 = (function (){var statearr_40727 = state_40724;
(statearr_40727[(7)] = inst_40712__$1);

return statearr_40727;
})();
if(cljs.core.truth_(inst_40712__$1)){
var statearr_40728_40740 = state_40724__$1;
(statearr_40728_40740[(1)] = (5));

} else {
var statearr_40729_40741 = state_40724__$1;
(statearr_40729_40741[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40725 === (5))){
var inst_40712 = (state_40724[(7)]);
var inst_40714 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_40712);
var state_40724__$1 = state_40724;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40724__$1,(8),inst_40714);
} else {
if((state_val_40725 === (6))){
var state_40724__$1 = state_40724;
var statearr_40730_40742 = state_40724__$1;
(statearr_40730_40742[(2)] = null);

(statearr_40730_40742[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40725 === (7))){
var inst_40720 = (state_40724[(2)]);
var state_40724__$1 = state_40724;
var statearr_40731_40743 = state_40724__$1;
(statearr_40731_40743[(2)] = inst_40720);

(statearr_40731_40743[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40725 === (8))){
var inst_40716 = (state_40724[(2)]);
var state_40724__$1 = (function (){var statearr_40732 = state_40724;
(statearr_40732[(8)] = inst_40716);

return statearr_40732;
})();
var statearr_40733_40744 = state_40724__$1;
(statearr_40733_40744[(2)] = null);

(statearr_40733_40744[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__36609__auto___40738,ch))
;
return ((function (switch__36521__auto__,c__36609__auto___40738,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__36522__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__36522__auto____0 = (function (){
var statearr_40734 = [null,null,null,null,null,null,null,null,null];
(statearr_40734[(0)] = figwheel$client$heads_up_plugin_$_state_machine__36522__auto__);

(statearr_40734[(1)] = (1));

return statearr_40734;
});
var figwheel$client$heads_up_plugin_$_state_machine__36522__auto____1 = (function (state_40724){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_40724);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e40735){if((e40735 instanceof Object)){
var ex__36525__auto__ = e40735;
var statearr_40736_40745 = state_40724;
(statearr_40736_40745[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40724);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40735;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40746 = state_40724;
state_40724 = G__40746;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__36522__auto__ = function(state_40724){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__36522__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__36522__auto____1.call(this,state_40724);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__36522__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__36522__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto___40738,ch))
})();
var state__36611__auto__ = (function (){var statearr_40737 = f__36610__auto__.call(null);
(statearr_40737[(6)] = c__36609__auto___40738);

return statearr_40737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto___40738,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__36609__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto__){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto__){
return (function (state_40752){
var state_val_40753 = (state_40752[(1)]);
if((state_val_40753 === (1))){
var inst_40747 = cljs.core.async.timeout.call(null,(3000));
var state_40752__$1 = state_40752;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40752__$1,(2),inst_40747);
} else {
if((state_val_40753 === (2))){
var inst_40749 = (state_40752[(2)]);
var inst_40750 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_40752__$1 = (function (){var statearr_40754 = state_40752;
(statearr_40754[(7)] = inst_40749);

return statearr_40754;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40752__$1,inst_40750);
} else {
return null;
}
}
});})(c__36609__auto__))
;
return ((function (switch__36521__auto__,c__36609__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__36522__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__36522__auto____0 = (function (){
var statearr_40755 = [null,null,null,null,null,null,null,null];
(statearr_40755[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__36522__auto__);

(statearr_40755[(1)] = (1));

return statearr_40755;
});
var figwheel$client$enforce_project_plugin_$_state_machine__36522__auto____1 = (function (state_40752){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_40752);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e40756){if((e40756 instanceof Object)){
var ex__36525__auto__ = e40756;
var statearr_40757_40759 = state_40752;
(statearr_40757_40759[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40752);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40756;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40760 = state_40752;
state_40752 = G__40760;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__36522__auto__ = function(state_40752){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__36522__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__36522__auto____1.call(this,state_40752);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_project_plugin_$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__36522__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__36522__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto__))
})();
var state__36611__auto__ = (function (){var statearr_40758 = f__36610__auto__.call(null);
(statearr_40758[(6)] = c__36609__auto__);

return statearr_40758;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto__))
);

return c__36609__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__4657__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__4657__auto__)){
var figwheel_version = temp__4657__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__36609__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto__,figwheel_version,temp__4657__auto__){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto__,figwheel_version,temp__4657__auto__){
return (function (state_40767){
var state_val_40768 = (state_40767[(1)]);
if((state_val_40768 === (1))){
var inst_40761 = cljs.core.async.timeout.call(null,(2000));
var state_40767__$1 = state_40767;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40767__$1,(2),inst_40761);
} else {
if((state_val_40768 === (2))){
var inst_40763 = (state_40767[(2)]);
var inst_40764 = ["Figwheel Client Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_40765 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_40764);
var state_40767__$1 = (function (){var statearr_40769 = state_40767;
(statearr_40769[(7)] = inst_40763);

return statearr_40769;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40767__$1,inst_40765);
} else {
return null;
}
}
});})(c__36609__auto__,figwheel_version,temp__4657__auto__))
;
return ((function (switch__36521__auto__,c__36609__auto__,figwheel_version,temp__4657__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__36522__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__36522__auto____0 = (function (){
var statearr_40770 = [null,null,null,null,null,null,null,null];
(statearr_40770[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__36522__auto__);

(statearr_40770[(1)] = (1));

return statearr_40770;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__36522__auto____1 = (function (state_40767){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_40767);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e40771){if((e40771 instanceof Object)){
var ex__36525__auto__ = e40771;
var statearr_40772_40774 = state_40767;
(statearr_40772_40774[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40767);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40771;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40775 = state_40767;
state_40767 = G__40775;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__36522__auto__ = function(state_40767){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__36522__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__36522__auto____1.call(this,state_40767);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__36522__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__36522__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto__,figwheel_version,temp__4657__auto__))
})();
var state__36611__auto__ = (function (){var statearr_40773 = f__36610__auto__.call(null);
(statearr_40773[(6)] = c__36609__auto__);

return statearr_40773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto__,figwheel_version,temp__4657__auto__))
);

return c__36609__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__40776){
var map__40777 = p__40776;
var map__40777__$1 = ((((!((map__40777 == null)))?(((((map__40777.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40777.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40777):map__40777);
var file = cljs.core.get.call(null,map__40777__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__40777__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__40777__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__40779 = "";
var G__40779__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__40779),"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__40779);
var G__40779__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__40779__$1)," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__40779__$1);
if(cljs.core.truth_((function (){var and__3911__auto__ = line;
if(cljs.core.truth_(and__3911__auto__)){
return column;
} else {
return and__3911__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__40779__$2),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__40779__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__40780){
var map__40781 = p__40780;
var map__40781__$1 = ((((!((map__40781 == null)))?(((((map__40781.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40781.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40781):map__40781);
var ed = map__40781__$1;
var formatted_exception = cljs.core.get.call(null,map__40781__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__40781__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__40781__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__40783_40787 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__40784_40788 = null;
var count__40785_40789 = (0);
var i__40786_40790 = (0);
while(true){
if((i__40786_40790 < count__40785_40789)){
var msg_40791 = cljs.core._nth.call(null,chunk__40784_40788,i__40786_40790);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_40791);


var G__40792 = seq__40783_40787;
var G__40793 = chunk__40784_40788;
var G__40794 = count__40785_40789;
var G__40795 = (i__40786_40790 + (1));
seq__40783_40787 = G__40792;
chunk__40784_40788 = G__40793;
count__40785_40789 = G__40794;
i__40786_40790 = G__40795;
continue;
} else {
var temp__4657__auto___40796 = cljs.core.seq.call(null,seq__40783_40787);
if(temp__4657__auto___40796){
var seq__40783_40797__$1 = temp__4657__auto___40796;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__40783_40797__$1)){
var c__4319__auto___40798 = cljs.core.chunk_first.call(null,seq__40783_40797__$1);
var G__40799 = cljs.core.chunk_rest.call(null,seq__40783_40797__$1);
var G__40800 = c__4319__auto___40798;
var G__40801 = cljs.core.count.call(null,c__4319__auto___40798);
var G__40802 = (0);
seq__40783_40787 = G__40799;
chunk__40784_40788 = G__40800;
count__40785_40789 = G__40801;
i__40786_40790 = G__40802;
continue;
} else {
var msg_40803 = cljs.core.first.call(null,seq__40783_40797__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_40803);


var G__40804 = cljs.core.next.call(null,seq__40783_40797__$1);
var G__40805 = null;
var G__40806 = (0);
var G__40807 = (0);
seq__40783_40787 = G__40804;
chunk__40784_40788 = G__40805;
count__40785_40789 = G__40806;
i__40786_40790 = G__40807;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Error on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__40808){
var map__40809 = p__40808;
var map__40809__$1 = ((((!((map__40809 == null)))?(((((map__40809.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40809.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40809):map__40809);
var w = map__40809__$1;
var message = cljs.core.get.call(null,map__40809__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message))," in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/out/figwheel/client.cljs",33,1,361,361,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/out/figwheel/client.cljs",30,1,353,353,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__3911__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__3911__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__3911__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_json_message_watch = (function figwheel$client$add_json_message_watch(key,callback){
return figwheel.client.add_message_watch.call(null,key,cljs.core.comp.call(null,callback,cljs.core.clj__GT_js));
});
goog.exportSymbol('figwheel.client.add_json_message_watch', figwheel.client.add_json_message_watch);
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__40811 = cljs.core.seq.call(null,plugins);
var chunk__40812 = null;
var count__40813 = (0);
var i__40814 = (0);
while(true){
if((i__40814 < count__40813)){
var vec__40815 = cljs.core._nth.call(null,chunk__40812,i__40814);
var k = cljs.core.nth.call(null,vec__40815,(0),null);
var plugin = cljs.core.nth.call(null,vec__40815,(1),null);
if(cljs.core.truth_(plugin)){
var pl_40821 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__40811,chunk__40812,count__40813,i__40814,pl_40821,vec__40815,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_40821.call(null,msg_hist);
});})(seq__40811,chunk__40812,count__40813,i__40814,pl_40821,vec__40815,k,plugin))
);
} else {
}


var G__40822 = seq__40811;
var G__40823 = chunk__40812;
var G__40824 = count__40813;
var G__40825 = (i__40814 + (1));
seq__40811 = G__40822;
chunk__40812 = G__40823;
count__40813 = G__40824;
i__40814 = G__40825;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__40811);
if(temp__4657__auto__){
var seq__40811__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__40811__$1)){
var c__4319__auto__ = cljs.core.chunk_first.call(null,seq__40811__$1);
var G__40826 = cljs.core.chunk_rest.call(null,seq__40811__$1);
var G__40827 = c__4319__auto__;
var G__40828 = cljs.core.count.call(null,c__4319__auto__);
var G__40829 = (0);
seq__40811 = G__40826;
chunk__40812 = G__40827;
count__40813 = G__40828;
i__40814 = G__40829;
continue;
} else {
var vec__40818 = cljs.core.first.call(null,seq__40811__$1);
var k = cljs.core.nth.call(null,vec__40818,(0),null);
var plugin = cljs.core.nth.call(null,vec__40818,(1),null);
if(cljs.core.truth_(plugin)){
var pl_40830 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__40811,chunk__40812,count__40813,i__40814,pl_40830,vec__40818,k,plugin,seq__40811__$1,temp__4657__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_40830.call(null,msg_hist);
});})(seq__40811,chunk__40812,count__40813,i__40814,pl_40830,vec__40818,k,plugin,seq__40811__$1,temp__4657__auto__))
);
} else {
}


var G__40831 = cljs.core.next.call(null,seq__40811__$1);
var G__40832 = null;
var G__40833 = (0);
var G__40834 = (0);
seq__40811 = G__40831;
chunk__40812 = G__40832;
count__40813 = G__40833;
i__40814 = G__40834;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__40836 = arguments.length;
switch (G__40836) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__40837_40842 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__40838_40843 = null;
var count__40839_40844 = (0);
var i__40840_40845 = (0);
while(true){
if((i__40840_40845 < count__40839_40844)){
var msg_40846 = cljs.core._nth.call(null,chunk__40838_40843,i__40840_40845);
figwheel.client.socket.handle_incoming_message.call(null,msg_40846);


var G__40847 = seq__40837_40842;
var G__40848 = chunk__40838_40843;
var G__40849 = count__40839_40844;
var G__40850 = (i__40840_40845 + (1));
seq__40837_40842 = G__40847;
chunk__40838_40843 = G__40848;
count__40839_40844 = G__40849;
i__40840_40845 = G__40850;
continue;
} else {
var temp__4657__auto___40851 = cljs.core.seq.call(null,seq__40837_40842);
if(temp__4657__auto___40851){
var seq__40837_40852__$1 = temp__4657__auto___40851;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__40837_40852__$1)){
var c__4319__auto___40853 = cljs.core.chunk_first.call(null,seq__40837_40852__$1);
var G__40854 = cljs.core.chunk_rest.call(null,seq__40837_40852__$1);
var G__40855 = c__4319__auto___40853;
var G__40856 = cljs.core.count.call(null,c__4319__auto___40853);
var G__40857 = (0);
seq__40837_40842 = G__40854;
chunk__40838_40843 = G__40855;
count__40839_40844 = G__40856;
i__40840_40845 = G__40857;
continue;
} else {
var msg_40858 = cljs.core.first.call(null,seq__40837_40852__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_40858);


var G__40859 = cljs.core.next.call(null,seq__40837_40852__$1);
var G__40860 = null;
var G__40861 = (0);
var G__40862 = (0);
seq__40837_40842 = G__40859;
chunk__40838_40843 = G__40860;
count__40839_40844 = G__40861;
i__40840_40845 = G__40862;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__4502__auto__ = [];
var len__4499__auto___40867 = arguments.length;
var i__4500__auto___40868 = (0);
while(true){
if((i__4500__auto___40868 < len__4499__auto___40867)){
args__4502__auto__.push((arguments[i__4500__auto___40868]));

var G__40869 = (i__4500__auto___40868 + (1));
i__4500__auto___40868 = G__40869;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((0) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__4503__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__40864){
var map__40865 = p__40864;
var map__40865__$1 = ((((!((map__40865 == null)))?(((((map__40865.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40865.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40865):map__40865);
var opts = map__40865__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq40863){
var self__4487__auto__ = this;
return self__4487__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq40863));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e40870){if((e40870 instanceof Error)){
var e = e40870;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e40870;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__40871){
var map__40872 = p__40871;
var map__40872__$1 = ((((!((map__40872 == null)))?(((((map__40872.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40872.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40872):map__40872);
var msg_name = cljs.core.get.call(null,map__40872__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1522272000477
