// Compiled by ClojureScript 1.10.238 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__3922__auto__ = ((cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && ((((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string'))) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372))));
if(or__3922__auto__){
return or__3922__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__3922__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
var or__3922__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__3922__auto____$1)){
return or__3922__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__38629_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__38629_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__38630 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__38631 = null;
var count__38632 = (0);
var i__38633 = (0);
while(true){
if((i__38633 < count__38632)){
var n = cljs.core._nth.call(null,chunk__38631,i__38633);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);


var G__38634 = seq__38630;
var G__38635 = chunk__38631;
var G__38636 = count__38632;
var G__38637 = (i__38633 + (1));
seq__38630 = G__38634;
chunk__38631 = G__38635;
count__38632 = G__38636;
i__38633 = G__38637;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__38630);
if(temp__4657__auto__){
var seq__38630__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38630__$1)){
var c__4319__auto__ = cljs.core.chunk_first.call(null,seq__38630__$1);
var G__38638 = cljs.core.chunk_rest.call(null,seq__38630__$1);
var G__38639 = c__4319__auto__;
var G__38640 = cljs.core.count.call(null,c__4319__auto__);
var G__38641 = (0);
seq__38630 = G__38638;
chunk__38631 = G__38639;
count__38632 = G__38640;
i__38633 = G__38641;
continue;
} else {
var n = cljs.core.first.call(null,seq__38630__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);


var G__38642 = cljs.core.next.call(null,seq__38630__$1);
var G__38643 = null;
var G__38644 = (0);
var G__38645 = (0);
seq__38630 = G__38642;
chunk__38631 = G__38643;
count__38632 = G__38644;
i__38633 = G__38645;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.in_upper_level_QMARK_ = (function figwheel$client$file_reloading$in_upper_level_QMARK_(topo_state,current_depth,dep){
return cljs.core.some.call(null,(function (p__38646){
var vec__38647 = p__38646;
var _ = cljs.core.nth.call(null,vec__38647,(0),null);
var v = cljs.core.nth.call(null,vec__38647,(1),null);
var and__3911__auto__ = v;
if(cljs.core.truth_(and__3911__auto__)){
return v.call(null,dep);
} else {
return and__3911__auto__;
}
}),cljs.core.filter.call(null,(function (p__38650){
var vec__38651 = p__38650;
var k = cljs.core.nth.call(null,vec__38651,(0),null);
var v = cljs.core.nth.call(null,vec__38651,(1),null);
return (k > current_depth);
}),topo_state));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__38663_38671 = cljs.core.seq.call(null,deps);
var chunk__38664_38672 = null;
var count__38665_38673 = (0);
var i__38666_38674 = (0);
while(true){
if((i__38666_38674 < count__38665_38673)){
var dep_38675 = cljs.core._nth.call(null,chunk__38664_38672,i__38666_38674);
if(cljs.core.truth_((function (){var and__3911__auto__ = dep_38675;
if(cljs.core.truth_(and__3911__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_38675));
} else {
return and__3911__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_38675,(depth + (1)),state);
} else {
}


var G__38676 = seq__38663_38671;
var G__38677 = chunk__38664_38672;
var G__38678 = count__38665_38673;
var G__38679 = (i__38666_38674 + (1));
seq__38663_38671 = G__38676;
chunk__38664_38672 = G__38677;
count__38665_38673 = G__38678;
i__38666_38674 = G__38679;
continue;
} else {
var temp__4657__auto___38680 = cljs.core.seq.call(null,seq__38663_38671);
if(temp__4657__auto___38680){
var seq__38663_38681__$1 = temp__4657__auto___38680;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38663_38681__$1)){
var c__4319__auto___38682 = cljs.core.chunk_first.call(null,seq__38663_38681__$1);
var G__38683 = cljs.core.chunk_rest.call(null,seq__38663_38681__$1);
var G__38684 = c__4319__auto___38682;
var G__38685 = cljs.core.count.call(null,c__4319__auto___38682);
var G__38686 = (0);
seq__38663_38671 = G__38683;
chunk__38664_38672 = G__38684;
count__38665_38673 = G__38685;
i__38666_38674 = G__38686;
continue;
} else {
var dep_38687 = cljs.core.first.call(null,seq__38663_38681__$1);
if(cljs.core.truth_((function (){var and__3911__auto__ = dep_38687;
if(cljs.core.truth_(and__3911__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_38687));
} else {
return and__3911__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_38687,(depth + (1)),state);
} else {
}


var G__38688 = cljs.core.next.call(null,seq__38663_38681__$1);
var G__38689 = null;
var G__38690 = (0);
var G__38691 = (0);
seq__38663_38671 = G__38688;
chunk__38664_38672 = G__38689;
count__38665_38673 = G__38690;
i__38666_38674 = G__38691;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__38667){
var vec__38668 = p__38667;
var seq__38669 = cljs.core.seq.call(null,vec__38668);
var first__38670 = cljs.core.first.call(null,seq__38669);
var seq__38669__$1 = cljs.core.next.call(null,seq__38669);
var x = first__38670;
var xs = seq__38669__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__38668,seq__38669,first__38670,seq__38669__$1,x,xs,get_deps__$1){
return (function (p1__38654_SHARP_){
return clojure.set.difference.call(null,p1__38654_SHARP_,x);
});})(vec__38668,seq__38669,first__38670,seq__38669__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__38692 = cljs.core.seq.call(null,provides);
var chunk__38693 = null;
var count__38694 = (0);
var i__38695 = (0);
while(true){
if((i__38695 < count__38694)){
var prov = cljs.core._nth.call(null,chunk__38693,i__38695);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__38696_38704 = cljs.core.seq.call(null,requires);
var chunk__38697_38705 = null;
var count__38698_38706 = (0);
var i__38699_38707 = (0);
while(true){
if((i__38699_38707 < count__38698_38706)){
var req_38708 = cljs.core._nth.call(null,chunk__38697_38705,i__38699_38707);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_38708,prov);


var G__38709 = seq__38696_38704;
var G__38710 = chunk__38697_38705;
var G__38711 = count__38698_38706;
var G__38712 = (i__38699_38707 + (1));
seq__38696_38704 = G__38709;
chunk__38697_38705 = G__38710;
count__38698_38706 = G__38711;
i__38699_38707 = G__38712;
continue;
} else {
var temp__4657__auto___38713 = cljs.core.seq.call(null,seq__38696_38704);
if(temp__4657__auto___38713){
var seq__38696_38714__$1 = temp__4657__auto___38713;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38696_38714__$1)){
var c__4319__auto___38715 = cljs.core.chunk_first.call(null,seq__38696_38714__$1);
var G__38716 = cljs.core.chunk_rest.call(null,seq__38696_38714__$1);
var G__38717 = c__4319__auto___38715;
var G__38718 = cljs.core.count.call(null,c__4319__auto___38715);
var G__38719 = (0);
seq__38696_38704 = G__38716;
chunk__38697_38705 = G__38717;
count__38698_38706 = G__38718;
i__38699_38707 = G__38719;
continue;
} else {
var req_38720 = cljs.core.first.call(null,seq__38696_38714__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_38720,prov);


var G__38721 = cljs.core.next.call(null,seq__38696_38714__$1);
var G__38722 = null;
var G__38723 = (0);
var G__38724 = (0);
seq__38696_38704 = G__38721;
chunk__38697_38705 = G__38722;
count__38698_38706 = G__38723;
i__38699_38707 = G__38724;
continue;
}
} else {
}
}
break;
}


var G__38725 = seq__38692;
var G__38726 = chunk__38693;
var G__38727 = count__38694;
var G__38728 = (i__38695 + (1));
seq__38692 = G__38725;
chunk__38693 = G__38726;
count__38694 = G__38727;
i__38695 = G__38728;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__38692);
if(temp__4657__auto__){
var seq__38692__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38692__$1)){
var c__4319__auto__ = cljs.core.chunk_first.call(null,seq__38692__$1);
var G__38729 = cljs.core.chunk_rest.call(null,seq__38692__$1);
var G__38730 = c__4319__auto__;
var G__38731 = cljs.core.count.call(null,c__4319__auto__);
var G__38732 = (0);
seq__38692 = G__38729;
chunk__38693 = G__38730;
count__38694 = G__38731;
i__38695 = G__38732;
continue;
} else {
var prov = cljs.core.first.call(null,seq__38692__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__38700_38733 = cljs.core.seq.call(null,requires);
var chunk__38701_38734 = null;
var count__38702_38735 = (0);
var i__38703_38736 = (0);
while(true){
if((i__38703_38736 < count__38702_38735)){
var req_38737 = cljs.core._nth.call(null,chunk__38701_38734,i__38703_38736);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_38737,prov);


var G__38738 = seq__38700_38733;
var G__38739 = chunk__38701_38734;
var G__38740 = count__38702_38735;
var G__38741 = (i__38703_38736 + (1));
seq__38700_38733 = G__38738;
chunk__38701_38734 = G__38739;
count__38702_38735 = G__38740;
i__38703_38736 = G__38741;
continue;
} else {
var temp__4657__auto___38742__$1 = cljs.core.seq.call(null,seq__38700_38733);
if(temp__4657__auto___38742__$1){
var seq__38700_38743__$1 = temp__4657__auto___38742__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38700_38743__$1)){
var c__4319__auto___38744 = cljs.core.chunk_first.call(null,seq__38700_38743__$1);
var G__38745 = cljs.core.chunk_rest.call(null,seq__38700_38743__$1);
var G__38746 = c__4319__auto___38744;
var G__38747 = cljs.core.count.call(null,c__4319__auto___38744);
var G__38748 = (0);
seq__38700_38733 = G__38745;
chunk__38701_38734 = G__38746;
count__38702_38735 = G__38747;
i__38703_38736 = G__38748;
continue;
} else {
var req_38749 = cljs.core.first.call(null,seq__38700_38743__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_38749,prov);


var G__38750 = cljs.core.next.call(null,seq__38700_38743__$1);
var G__38751 = null;
var G__38752 = (0);
var G__38753 = (0);
seq__38700_38733 = G__38750;
chunk__38701_38734 = G__38751;
count__38702_38735 = G__38752;
i__38703_38736 = G__38753;
continue;
}
} else {
}
}
break;
}


var G__38754 = cljs.core.next.call(null,seq__38692__$1);
var G__38755 = null;
var G__38756 = (0);
var G__38757 = (0);
seq__38692 = G__38754;
chunk__38693 = G__38755;
count__38694 = G__38756;
i__38695 = G__38757;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__38758_38762 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__38759_38763 = null;
var count__38760_38764 = (0);
var i__38761_38765 = (0);
while(true){
if((i__38761_38765 < count__38760_38764)){
var ns_38766 = cljs.core._nth.call(null,chunk__38759_38763,i__38761_38765);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_38766);


var G__38767 = seq__38758_38762;
var G__38768 = chunk__38759_38763;
var G__38769 = count__38760_38764;
var G__38770 = (i__38761_38765 + (1));
seq__38758_38762 = G__38767;
chunk__38759_38763 = G__38768;
count__38760_38764 = G__38769;
i__38761_38765 = G__38770;
continue;
} else {
var temp__4657__auto___38771 = cljs.core.seq.call(null,seq__38758_38762);
if(temp__4657__auto___38771){
var seq__38758_38772__$1 = temp__4657__auto___38771;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38758_38772__$1)){
var c__4319__auto___38773 = cljs.core.chunk_first.call(null,seq__38758_38772__$1);
var G__38774 = cljs.core.chunk_rest.call(null,seq__38758_38772__$1);
var G__38775 = c__4319__auto___38773;
var G__38776 = cljs.core.count.call(null,c__4319__auto___38773);
var G__38777 = (0);
seq__38758_38762 = G__38774;
chunk__38759_38763 = G__38775;
count__38760_38764 = G__38776;
i__38761_38765 = G__38777;
continue;
} else {
var ns_38778 = cljs.core.first.call(null,seq__38758_38772__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_38778);


var G__38779 = cljs.core.next.call(null,seq__38758_38772__$1);
var G__38780 = null;
var G__38781 = (0);
var G__38782 = (0);
seq__38758_38762 = G__38779;
chunk__38759_38763 = G__38780;
count__38760_38764 = G__38781;
i__38761_38765 = G__38782;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__3922__auto__ = goog.require__;
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__38783__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__38783 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__38784__i = 0, G__38784__a = new Array(arguments.length -  0);
while (G__38784__i < G__38784__a.length) {G__38784__a[G__38784__i] = arguments[G__38784__i + 0]; ++G__38784__i;}
  args = new cljs.core.IndexedSeq(G__38784__a,0,null);
} 
return G__38783__delegate.call(this,args);};
G__38783.cljs$lang$maxFixedArity = 0;
G__38783.cljs$lang$applyTo = (function (arglist__38785){
var args = cljs.core.seq(arglist__38785);
return G__38783__delegate(args);
});
G__38783.cljs$core$IFn$_invoke$arity$variadic = G__38783__delegate;
return G__38783;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = ((typeof goog.net.jsloader.safeLoad !== 'undefined')?(function (p1__38786_SHARP_,p2__38787_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__38786_SHARP_)].join('')),p2__38787_SHARP_);
}):((typeof goog.net.jsloader.load !== 'undefined')?(function (p1__38788_SHARP_,p2__38789_SHARP_){
return goog.net.jsloader.load([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__38788_SHARP_)].join(''),p2__38789_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__38790 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__38790.addCallback(((function (G__38790){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(G__38790))
);

G__38790.addErrback(((function (G__38790){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(G__38790))
);

return G__38790;
});
figwheel.client.file_reloading.write_script_tag_import = figwheel.client.file_reloading.reload_file_in_html_env;
goog.exportSymbol('figwheel.client.file_reloading.write_script_tag_import', figwheel.client.file_reloading.write_script_tag_import);
figwheel.client.file_reloading.worker_import_script = (function figwheel$client$file_reloading$worker_import_script(request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e38791){if((e38791 instanceof Error)){
var e = e38791;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e38791;

}
}})());
});
goog.exportSymbol('figwheel.client.file_reloading.worker_import_script', figwheel.client.file_reloading.worker_import_script);
figwheel.client.file_reloading.create_node_script_import_fn = (function figwheel$client$file_reloading$create_node_script_import_fn(){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e38792){if((e38792 instanceof Error)){
var e = e38792;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e38792;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path))
});
goog.exportSymbol('figwheel.client.file_reloading.create_node_script_import_fn', figwheel.client.file_reloading.create_node_script_import_fn);
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__38793 = cljs.core._EQ_;
var expr__38794 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__38793.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__38794))){
return figwheel.client.file_reloading.create_node_script_import_fn.call(null);
} else {
if(cljs.core.truth_(pred__38793.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__38794))){
return figwheel.client.file_reloading.write_script_tag_import;
} else {
if(cljs.core.truth_(pred__38793.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__38794))){
return figwheel.client.file_reloading.worker_import_script;
} else {
return ((function (pred__38793,expr__38794){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__38793,expr__38794))
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__38796,callback){
var map__38797 = p__38796;
var map__38797__$1 = ((((!((map__38797 == null)))?(((((map__38797.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38797.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38797):map__38797);
var file_msg = map__38797__$1;
var request_url = cljs.core.get.call(null,map__38797__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return (function (){var or__3922__auto__ = goog.object.get(goog.global,"FIGWHEEL_IMPORT_SCRIPT");
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return figwheel.client.file_reloading.reload_file_STAR_;
}
})().call(null,request_url,((function (map__38797,map__38797__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__38797,map__38797__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__36609__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto__){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto__){
return (function (state_38835){
var state_val_38836 = (state_38835[(1)]);
if((state_val_38836 === (7))){
var inst_38831 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38837_38863 = state_38835__$1;
(statearr_38837_38863[(2)] = inst_38831);

(statearr_38837_38863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (1))){
var state_38835__$1 = state_38835;
var statearr_38838_38864 = state_38835__$1;
(statearr_38838_38864[(2)] = null);

(statearr_38838_38864[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (4))){
var inst_38801 = (state_38835[(7)]);
var inst_38801__$1 = (state_38835[(2)]);
var state_38835__$1 = (function (){var statearr_38839 = state_38835;
(statearr_38839[(7)] = inst_38801__$1);

return statearr_38839;
})();
if(cljs.core.truth_(inst_38801__$1)){
var statearr_38840_38865 = state_38835__$1;
(statearr_38840_38865[(1)] = (5));

} else {
var statearr_38841_38866 = state_38835__$1;
(statearr_38841_38866[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (15))){
var inst_38816 = (state_38835[(8)]);
var inst_38814 = (state_38835[(9)]);
var inst_38818 = inst_38816.call(null,inst_38814);
var state_38835__$1 = state_38835;
var statearr_38842_38867 = state_38835__$1;
(statearr_38842_38867[(2)] = inst_38818);

(statearr_38842_38867[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (13))){
var inst_38825 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38843_38868 = state_38835__$1;
(statearr_38843_38868[(2)] = inst_38825);

(statearr_38843_38868[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (6))){
var state_38835__$1 = state_38835;
var statearr_38844_38869 = state_38835__$1;
(statearr_38844_38869[(2)] = null);

(statearr_38844_38869[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (17))){
var inst_38822 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38845_38870 = state_38835__$1;
(statearr_38845_38870[(2)] = inst_38822);

(statearr_38845_38870[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (3))){
var inst_38833 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38835__$1,inst_38833);
} else {
if((state_val_38836 === (12))){
var state_38835__$1 = state_38835;
var statearr_38846_38871 = state_38835__$1;
(statearr_38846_38871[(2)] = null);

(statearr_38846_38871[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (2))){
var state_38835__$1 = state_38835;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38835__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_38836 === (11))){
var inst_38806 = (state_38835[(10)]);
var inst_38812 = figwheel.client.file_reloading.blocking_load.call(null,inst_38806);
var state_38835__$1 = state_38835;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38835__$1,(14),inst_38812);
} else {
if((state_val_38836 === (9))){
var inst_38806 = (state_38835[(10)]);
var state_38835__$1 = state_38835;
if(cljs.core.truth_(inst_38806)){
var statearr_38847_38872 = state_38835__$1;
(statearr_38847_38872[(1)] = (11));

} else {
var statearr_38848_38873 = state_38835__$1;
(statearr_38848_38873[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (5))){
var inst_38801 = (state_38835[(7)]);
var inst_38807 = (state_38835[(11)]);
var inst_38806 = cljs.core.nth.call(null,inst_38801,(0),null);
var inst_38807__$1 = cljs.core.nth.call(null,inst_38801,(1),null);
var state_38835__$1 = (function (){var statearr_38849 = state_38835;
(statearr_38849[(10)] = inst_38806);

(statearr_38849[(11)] = inst_38807__$1);

return statearr_38849;
})();
if(cljs.core.truth_(inst_38807__$1)){
var statearr_38850_38874 = state_38835__$1;
(statearr_38850_38874[(1)] = (8));

} else {
var statearr_38851_38875 = state_38835__$1;
(statearr_38851_38875[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (14))){
var inst_38816 = (state_38835[(8)]);
var inst_38806 = (state_38835[(10)]);
var inst_38814 = (state_38835[(2)]);
var inst_38815 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_38816__$1 = cljs.core.get.call(null,inst_38815,inst_38806);
var state_38835__$1 = (function (){var statearr_38852 = state_38835;
(statearr_38852[(8)] = inst_38816__$1);

(statearr_38852[(9)] = inst_38814);

return statearr_38852;
})();
if(cljs.core.truth_(inst_38816__$1)){
var statearr_38853_38876 = state_38835__$1;
(statearr_38853_38876[(1)] = (15));

} else {
var statearr_38854_38877 = state_38835__$1;
(statearr_38854_38877[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (16))){
var inst_38814 = (state_38835[(9)]);
var inst_38820 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_38814);
var state_38835__$1 = state_38835;
var statearr_38855_38878 = state_38835__$1;
(statearr_38855_38878[(2)] = inst_38820);

(statearr_38855_38878[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (10))){
var inst_38827 = (state_38835[(2)]);
var state_38835__$1 = (function (){var statearr_38856 = state_38835;
(statearr_38856[(12)] = inst_38827);

return statearr_38856;
})();
var statearr_38857_38879 = state_38835__$1;
(statearr_38857_38879[(2)] = null);

(statearr_38857_38879[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (8))){
var inst_38807 = (state_38835[(11)]);
var inst_38809 = eval(inst_38807);
var state_38835__$1 = state_38835;
var statearr_38858_38880 = state_38835__$1;
(statearr_38858_38880[(2)] = inst_38809);

(statearr_38858_38880[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36609__auto__))
;
return ((function (switch__36521__auto__,c__36609__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__36522__auto__ = null;
var figwheel$client$file_reloading$state_machine__36522__auto____0 = (function (){
var statearr_38859 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38859[(0)] = figwheel$client$file_reloading$state_machine__36522__auto__);

(statearr_38859[(1)] = (1));

return statearr_38859;
});
var figwheel$client$file_reloading$state_machine__36522__auto____1 = (function (state_38835){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_38835);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e38860){if((e38860 instanceof Object)){
var ex__36525__auto__ = e38860;
var statearr_38861_38881 = state_38835;
(statearr_38861_38881[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38835);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38860;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38882 = state_38835;
state_38835 = G__38882;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__36522__auto__ = function(state_38835){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__36522__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__36522__auto____1.call(this,state_38835);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__36522__auto____0;
figwheel$client$file_reloading$state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__36522__auto____1;
return figwheel$client$file_reloading$state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto__))
})();
var state__36611__auto__ = (function (){var statearr_38862 = f__36610__auto__.call(null);
(statearr_38862[(6)] = c__36609__auto__);

return statearr_38862;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto__))
);

return c__36609__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(var_args){
var G__38884 = arguments.length;
switch (G__38884) {
case 1:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1 = (function (url){
return figwheel.client.file_reloading.queued_file_reload.call(null,url,null);
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2 = (function (url,opt_source_text){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,opt_source_text], null));
});

figwheel.client.file_reloading.queued_file_reload.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__38886,callback){
var map__38887 = p__38886;
var map__38887__$1 = ((((!((map__38887 == null)))?(((((map__38887.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38887.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38887):map__38887);
var file_msg = map__38887__$1;
var namespace = cljs.core.get.call(null,map__38887__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__38887,map__38887__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__38887,map__38887__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__38889){
var map__38890 = p__38889;
var map__38890__$1 = ((((!((map__38890 == null)))?(((((map__38890.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38890.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38890):map__38890);
var file_msg = map__38890__$1;
var namespace = cljs.core.get.call(null,map__38890__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.ns_exists_QMARK_ = (function figwheel$client$file_reloading$ns_exists_QMARK_(namespace){
return !((cljs.core.reduce.call(null,cljs.core.fnil.call(null,goog.object.get,({})),goog.global,clojure.string.split.call(null,cljs.core.name.call(null,namespace),".")) == null));
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__38892){
var map__38893 = p__38892;
var map__38893__$1 = ((((!((map__38893 == null)))?(((((map__38893.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38893.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38893):map__38893);
var file_msg = map__38893__$1;
var namespace = cljs.core.get.call(null,map__38893__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__3911__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__3911__auto__){
var or__3922__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
var or__3922__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__3922__auto____$1)){
return or__3922__auto____$1;
} else {
var or__3922__auto____$2 = figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
if(cljs.core.truth_(or__3922__auto____$2)){
return or__3922__auto____$2;
} else {
return figwheel.client.file_reloading.ns_exists_QMARK_.call(null,namespace);
}
}
}
} else {
return and__3911__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__38895,callback){
var map__38896 = p__38895;
var map__38896__$1 = ((((!((map__38896 == null)))?(((((map__38896.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38896.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38896):map__38896);
var file_msg = map__38896__$1;
var request_url = cljs.core.get.call(null,map__38896__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__38896__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__36609__auto___38946 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto___38946,out){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto___38946,out){
return (function (state_38931){
var state_val_38932 = (state_38931[(1)]);
if((state_val_38932 === (1))){
var inst_38905 = cljs.core.seq.call(null,files);
var inst_38906 = cljs.core.first.call(null,inst_38905);
var inst_38907 = cljs.core.next.call(null,inst_38905);
var inst_38908 = files;
var state_38931__$1 = (function (){var statearr_38933 = state_38931;
(statearr_38933[(7)] = inst_38908);

(statearr_38933[(8)] = inst_38906);

(statearr_38933[(9)] = inst_38907);

return statearr_38933;
})();
var statearr_38934_38947 = state_38931__$1;
(statearr_38934_38947[(2)] = null);

(statearr_38934_38947[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38932 === (2))){
var inst_38908 = (state_38931[(7)]);
var inst_38914 = (state_38931[(10)]);
var inst_38913 = cljs.core.seq.call(null,inst_38908);
var inst_38914__$1 = cljs.core.first.call(null,inst_38913);
var inst_38915 = cljs.core.next.call(null,inst_38913);
var inst_38916 = (inst_38914__$1 == null);
var inst_38917 = cljs.core.not.call(null,inst_38916);
var state_38931__$1 = (function (){var statearr_38935 = state_38931;
(statearr_38935[(11)] = inst_38915);

(statearr_38935[(10)] = inst_38914__$1);

return statearr_38935;
})();
if(inst_38917){
var statearr_38936_38948 = state_38931__$1;
(statearr_38936_38948[(1)] = (4));

} else {
var statearr_38937_38949 = state_38931__$1;
(statearr_38937_38949[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38932 === (3))){
var inst_38929 = (state_38931[(2)]);
var state_38931__$1 = state_38931;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38931__$1,inst_38929);
} else {
if((state_val_38932 === (4))){
var inst_38914 = (state_38931[(10)]);
var inst_38919 = figwheel.client.file_reloading.reload_js_file.call(null,inst_38914);
var state_38931__$1 = state_38931;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38931__$1,(7),inst_38919);
} else {
if((state_val_38932 === (5))){
var inst_38925 = cljs.core.async.close_BANG_.call(null,out);
var state_38931__$1 = state_38931;
var statearr_38938_38950 = state_38931__$1;
(statearr_38938_38950[(2)] = inst_38925);

(statearr_38938_38950[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38932 === (6))){
var inst_38927 = (state_38931[(2)]);
var state_38931__$1 = state_38931;
var statearr_38939_38951 = state_38931__$1;
(statearr_38939_38951[(2)] = inst_38927);

(statearr_38939_38951[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38932 === (7))){
var inst_38915 = (state_38931[(11)]);
var inst_38921 = (state_38931[(2)]);
var inst_38922 = cljs.core.async.put_BANG_.call(null,out,inst_38921);
var inst_38908 = inst_38915;
var state_38931__$1 = (function (){var statearr_38940 = state_38931;
(statearr_38940[(7)] = inst_38908);

(statearr_38940[(12)] = inst_38922);

return statearr_38940;
})();
var statearr_38941_38952 = state_38931__$1;
(statearr_38941_38952[(2)] = null);

(statearr_38941_38952[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__36609__auto___38946,out))
;
return ((function (switch__36521__auto__,c__36609__auto___38946,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__36522__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__36522__auto____0 = (function (){
var statearr_38942 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38942[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__36522__auto__);

(statearr_38942[(1)] = (1));

return statearr_38942;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__36522__auto____1 = (function (state_38931){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_38931);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e38943){if((e38943 instanceof Object)){
var ex__36525__auto__ = e38943;
var statearr_38944_38953 = state_38931;
(statearr_38944_38953[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38931);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38943;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38954 = state_38931;
state_38931 = G__38954;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__36522__auto__ = function(state_38931){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__36522__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__36522__auto____1.call(this,state_38931);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__36522__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__36522__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto___38946,out))
})();
var state__36611__auto__ = (function (){var statearr_38945 = f__36610__auto__.call(null);
(statearr_38945[(6)] = c__36609__auto___38946);

return statearr_38945;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto___38946,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__38955,opts){
var map__38956 = p__38955;
var map__38956__$1 = ((((!((map__38956 == null)))?(((((map__38956.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38956.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38956):map__38956);
var eval_body = cljs.core.get.call(null,map__38956__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__38956__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__3911__auto__ = eval_body;
if(cljs.core.truth_(and__3911__auto__)){
return typeof eval_body === 'string';
} else {
return and__3911__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e38958){var e = e38958;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__38959_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__38959_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__38960){
var vec__38961 = p__38960;
var k = cljs.core.nth.call(null,vec__38961,(0),null);
var v = cljs.core.nth.call(null,vec__38961,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__38964){
var vec__38965 = p__38964;
var k = cljs.core.nth.call(null,vec__38965,(0),null);
var v = cljs.core.nth.call(null,vec__38965,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__38971,p__38972){
var map__38973 = p__38971;
var map__38973__$1 = ((((!((map__38973 == null)))?(((((map__38973.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38973.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38973):map__38973);
var opts = map__38973__$1;
var before_jsload = cljs.core.get.call(null,map__38973__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__38973__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__38973__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__38974 = p__38972;
var map__38974__$1 = ((((!((map__38974 == null)))?(((((map__38974.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38974.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38974):map__38974);
var msg = map__38974__$1;
var files = cljs.core.get.call(null,map__38974__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__38974__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__38974__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__36609__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__36609__auto__,map__38973,map__38973__$1,opts,before_jsload,on_jsload,reload_dependents,map__38974,map__38974__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__36610__auto__ = (function (){var switch__36521__auto__ = ((function (c__36609__auto__,map__38973,map__38973__$1,opts,before_jsload,on_jsload,reload_dependents,map__38974,map__38974__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_39128){
var state_val_39129 = (state_39128[(1)]);
if((state_val_39129 === (7))){
var inst_38988 = (state_39128[(7)]);
var inst_38991 = (state_39128[(8)]);
var inst_38990 = (state_39128[(9)]);
var inst_38989 = (state_39128[(10)]);
var inst_38996 = cljs.core._nth.call(null,inst_38989,inst_38991);
var inst_38997 = figwheel.client.file_reloading.eval_body.call(null,inst_38996,opts);
var inst_38998 = (inst_38991 + (1));
var tmp39130 = inst_38988;
var tmp39131 = inst_38990;
var tmp39132 = inst_38989;
var inst_38988__$1 = tmp39130;
var inst_38989__$1 = tmp39132;
var inst_38990__$1 = tmp39131;
var inst_38991__$1 = inst_38998;
var state_39128__$1 = (function (){var statearr_39133 = state_39128;
(statearr_39133[(7)] = inst_38988__$1);

(statearr_39133[(8)] = inst_38991__$1);

(statearr_39133[(9)] = inst_38990__$1);

(statearr_39133[(10)] = inst_38989__$1);

(statearr_39133[(11)] = inst_38997);

return statearr_39133;
})();
var statearr_39134_39217 = state_39128__$1;
(statearr_39134_39217[(2)] = null);

(statearr_39134_39217[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (20))){
var inst_39031 = (state_39128[(12)]);
var inst_39039 = figwheel.client.file_reloading.sort_files.call(null,inst_39031);
var state_39128__$1 = state_39128;
var statearr_39135_39218 = state_39128__$1;
(statearr_39135_39218[(2)] = inst_39039);

(statearr_39135_39218[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (27))){
var state_39128__$1 = state_39128;
var statearr_39136_39219 = state_39128__$1;
(statearr_39136_39219[(2)] = null);

(statearr_39136_39219[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (1))){
var inst_38980 = (state_39128[(13)]);
var inst_38977 = before_jsload.call(null,files);
var inst_38978 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_38979 = (function (){return ((function (inst_38980,inst_38977,inst_38978,state_val_39129,c__36609__auto__,map__38973,map__38973__$1,opts,before_jsload,on_jsload,reload_dependents,map__38974,map__38974__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__38968_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__38968_SHARP_);
});
;})(inst_38980,inst_38977,inst_38978,state_val_39129,c__36609__auto__,map__38973,map__38973__$1,opts,before_jsload,on_jsload,reload_dependents,map__38974,map__38974__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_38980__$1 = cljs.core.filter.call(null,inst_38979,files);
var inst_38981 = cljs.core.not_empty.call(null,inst_38980__$1);
var state_39128__$1 = (function (){var statearr_39137 = state_39128;
(statearr_39137[(13)] = inst_38980__$1);

(statearr_39137[(14)] = inst_38978);

(statearr_39137[(15)] = inst_38977);

return statearr_39137;
})();
if(cljs.core.truth_(inst_38981)){
var statearr_39138_39220 = state_39128__$1;
(statearr_39138_39220[(1)] = (2));

} else {
var statearr_39139_39221 = state_39128__$1;
(statearr_39139_39221[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (24))){
var state_39128__$1 = state_39128;
var statearr_39140_39222 = state_39128__$1;
(statearr_39140_39222[(2)] = null);

(statearr_39140_39222[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (39))){
var inst_39081 = (state_39128[(16)]);
var state_39128__$1 = state_39128;
var statearr_39141_39223 = state_39128__$1;
(statearr_39141_39223[(2)] = inst_39081);

(statearr_39141_39223[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (46))){
var inst_39123 = (state_39128[(2)]);
var state_39128__$1 = state_39128;
var statearr_39142_39224 = state_39128__$1;
(statearr_39142_39224[(2)] = inst_39123);

(statearr_39142_39224[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (4))){
var inst_39025 = (state_39128[(2)]);
var inst_39026 = cljs.core.List.EMPTY;
var inst_39027 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_39026);
var inst_39028 = (function (){return ((function (inst_39025,inst_39026,inst_39027,state_val_39129,c__36609__auto__,map__38973,map__38973__$1,opts,before_jsload,on_jsload,reload_dependents,map__38974,map__38974__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__38969_SHARP_){
var and__3911__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__38969_SHARP_);
if(cljs.core.truth_(and__3911__auto__)){
return ((cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__38969_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__38969_SHARP_))));
} else {
return and__3911__auto__;
}
});
;})(inst_39025,inst_39026,inst_39027,state_val_39129,c__36609__auto__,map__38973,map__38973__$1,opts,before_jsload,on_jsload,reload_dependents,map__38974,map__38974__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_39029 = cljs.core.filter.call(null,inst_39028,files);
var inst_39030 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_39031 = cljs.core.concat.call(null,inst_39029,inst_39030);
var state_39128__$1 = (function (){var statearr_39143 = state_39128;
(statearr_39143[(17)] = inst_39025);

(statearr_39143[(18)] = inst_39027);

(statearr_39143[(12)] = inst_39031);

return statearr_39143;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_39144_39225 = state_39128__$1;
(statearr_39144_39225[(1)] = (16));

} else {
var statearr_39145_39226 = state_39128__$1;
(statearr_39145_39226[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (15))){
var inst_39015 = (state_39128[(2)]);
var state_39128__$1 = state_39128;
var statearr_39146_39227 = state_39128__$1;
(statearr_39146_39227[(2)] = inst_39015);

(statearr_39146_39227[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (21))){
var inst_39041 = (state_39128[(19)]);
var inst_39041__$1 = (state_39128[(2)]);
var inst_39042 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_39041__$1);
var state_39128__$1 = (function (){var statearr_39147 = state_39128;
(statearr_39147[(19)] = inst_39041__$1);

return statearr_39147;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39128__$1,(22),inst_39042);
} else {
if((state_val_39129 === (31))){
var inst_39126 = (state_39128[(2)]);
var state_39128__$1 = state_39128;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39128__$1,inst_39126);
} else {
if((state_val_39129 === (32))){
var inst_39081 = (state_39128[(16)]);
var inst_39086 = inst_39081.cljs$lang$protocol_mask$partition0$;
var inst_39087 = (inst_39086 & (64));
var inst_39088 = inst_39081.cljs$core$ISeq$;
var inst_39089 = (cljs.core.PROTOCOL_SENTINEL === inst_39088);
var inst_39090 = ((inst_39087) || (inst_39089));
var state_39128__$1 = state_39128;
if(cljs.core.truth_(inst_39090)){
var statearr_39148_39228 = state_39128__$1;
(statearr_39148_39228[(1)] = (35));

} else {
var statearr_39149_39229 = state_39128__$1;
(statearr_39149_39229[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (40))){
var inst_39103 = (state_39128[(20)]);
var inst_39102 = (state_39128[(2)]);
var inst_39103__$1 = cljs.core.get.call(null,inst_39102,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_39104 = cljs.core.get.call(null,inst_39102,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_39105 = cljs.core.not_empty.call(null,inst_39103__$1);
var state_39128__$1 = (function (){var statearr_39150 = state_39128;
(statearr_39150[(21)] = inst_39104);

(statearr_39150[(20)] = inst_39103__$1);

return statearr_39150;
})();
if(cljs.core.truth_(inst_39105)){
var statearr_39151_39230 = state_39128__$1;
(statearr_39151_39230[(1)] = (41));

} else {
var statearr_39152_39231 = state_39128__$1;
(statearr_39152_39231[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (33))){
var state_39128__$1 = state_39128;
var statearr_39153_39232 = state_39128__$1;
(statearr_39153_39232[(2)] = false);

(statearr_39153_39232[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (13))){
var inst_39001 = (state_39128[(22)]);
var inst_39005 = cljs.core.chunk_first.call(null,inst_39001);
var inst_39006 = cljs.core.chunk_rest.call(null,inst_39001);
var inst_39007 = cljs.core.count.call(null,inst_39005);
var inst_38988 = inst_39006;
var inst_38989 = inst_39005;
var inst_38990 = inst_39007;
var inst_38991 = (0);
var state_39128__$1 = (function (){var statearr_39154 = state_39128;
(statearr_39154[(7)] = inst_38988);

(statearr_39154[(8)] = inst_38991);

(statearr_39154[(9)] = inst_38990);

(statearr_39154[(10)] = inst_38989);

return statearr_39154;
})();
var statearr_39155_39233 = state_39128__$1;
(statearr_39155_39233[(2)] = null);

(statearr_39155_39233[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (22))){
var inst_39049 = (state_39128[(23)]);
var inst_39041 = (state_39128[(19)]);
var inst_39045 = (state_39128[(24)]);
var inst_39044 = (state_39128[(25)]);
var inst_39044__$1 = (state_39128[(2)]);
var inst_39045__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_39044__$1);
var inst_39046 = (function (){var all_files = inst_39041;
var res_SINGLEQUOTE_ = inst_39044__$1;
var res = inst_39045__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_39049,inst_39041,inst_39045,inst_39044,inst_39044__$1,inst_39045__$1,state_val_39129,c__36609__auto__,map__38973,map__38973__$1,opts,before_jsload,on_jsload,reload_dependents,map__38974,map__38974__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__38970_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__38970_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_39049,inst_39041,inst_39045,inst_39044,inst_39044__$1,inst_39045__$1,state_val_39129,c__36609__auto__,map__38973,map__38973__$1,opts,before_jsload,on_jsload,reload_dependents,map__38974,map__38974__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_39047 = cljs.core.filter.call(null,inst_39046,inst_39044__$1);
var inst_39048 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_39049__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_39048);
var inst_39050 = cljs.core.not_empty.call(null,inst_39049__$1);
var state_39128__$1 = (function (){var statearr_39156 = state_39128;
(statearr_39156[(23)] = inst_39049__$1);

(statearr_39156[(24)] = inst_39045__$1);

(statearr_39156[(25)] = inst_39044__$1);

(statearr_39156[(26)] = inst_39047);

return statearr_39156;
})();
if(cljs.core.truth_(inst_39050)){
var statearr_39157_39234 = state_39128__$1;
(statearr_39157_39234[(1)] = (23));

} else {
var statearr_39158_39235 = state_39128__$1;
(statearr_39158_39235[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (36))){
var state_39128__$1 = state_39128;
var statearr_39159_39236 = state_39128__$1;
(statearr_39159_39236[(2)] = false);

(statearr_39159_39236[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (41))){
var inst_39103 = (state_39128[(20)]);
var inst_39107 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_39108 = cljs.core.map.call(null,inst_39107,inst_39103);
var inst_39109 = cljs.core.pr_str.call(null,inst_39108);
var inst_39110 = ["figwheel-no-load meta-data: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39109)].join('');
var inst_39111 = figwheel.client.utils.log.call(null,inst_39110);
var state_39128__$1 = state_39128;
var statearr_39160_39237 = state_39128__$1;
(statearr_39160_39237[(2)] = inst_39111);

(statearr_39160_39237[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (43))){
var inst_39104 = (state_39128[(21)]);
var inst_39114 = (state_39128[(2)]);
var inst_39115 = cljs.core.not_empty.call(null,inst_39104);
var state_39128__$1 = (function (){var statearr_39161 = state_39128;
(statearr_39161[(27)] = inst_39114);

return statearr_39161;
})();
if(cljs.core.truth_(inst_39115)){
var statearr_39162_39238 = state_39128__$1;
(statearr_39162_39238[(1)] = (44));

} else {
var statearr_39163_39239 = state_39128__$1;
(statearr_39163_39239[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (29))){
var inst_39049 = (state_39128[(23)]);
var inst_39041 = (state_39128[(19)]);
var inst_39081 = (state_39128[(16)]);
var inst_39045 = (state_39128[(24)]);
var inst_39044 = (state_39128[(25)]);
var inst_39047 = (state_39128[(26)]);
var inst_39077 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_39080 = (function (){var all_files = inst_39041;
var res_SINGLEQUOTE_ = inst_39044;
var res = inst_39045;
var files_not_loaded = inst_39047;
var dependencies_that_loaded = inst_39049;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_39049,inst_39041,inst_39081,inst_39045,inst_39044,inst_39047,inst_39077,state_val_39129,c__36609__auto__,map__38973,map__38973__$1,opts,before_jsload,on_jsload,reload_dependents,map__38974,map__38974__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__39079){
var map__39164 = p__39079;
var map__39164__$1 = ((((!((map__39164 == null)))?(((((map__39164.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39164.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__39164):map__39164);
var namespace = cljs.core.get.call(null,map__39164__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_39049,inst_39041,inst_39081,inst_39045,inst_39044,inst_39047,inst_39077,state_val_39129,c__36609__auto__,map__38973,map__38973__$1,opts,before_jsload,on_jsload,reload_dependents,map__38974,map__38974__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_39081__$1 = cljs.core.group_by.call(null,inst_39080,inst_39047);
var inst_39083 = (inst_39081__$1 == null);
var inst_39084 = cljs.core.not.call(null,inst_39083);
var state_39128__$1 = (function (){var statearr_39166 = state_39128;
(statearr_39166[(16)] = inst_39081__$1);

(statearr_39166[(28)] = inst_39077);

return statearr_39166;
})();
if(inst_39084){
var statearr_39167_39240 = state_39128__$1;
(statearr_39167_39240[(1)] = (32));

} else {
var statearr_39168_39241 = state_39128__$1;
(statearr_39168_39241[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (44))){
var inst_39104 = (state_39128[(21)]);
var inst_39117 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_39104);
var inst_39118 = cljs.core.pr_str.call(null,inst_39117);
var inst_39119 = ["not required: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39118)].join('');
var inst_39120 = figwheel.client.utils.log.call(null,inst_39119);
var state_39128__$1 = state_39128;
var statearr_39169_39242 = state_39128__$1;
(statearr_39169_39242[(2)] = inst_39120);

(statearr_39169_39242[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (6))){
var inst_39022 = (state_39128[(2)]);
var state_39128__$1 = state_39128;
var statearr_39170_39243 = state_39128__$1;
(statearr_39170_39243[(2)] = inst_39022);

(statearr_39170_39243[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (28))){
var inst_39047 = (state_39128[(26)]);
var inst_39074 = (state_39128[(2)]);
var inst_39075 = cljs.core.not_empty.call(null,inst_39047);
var state_39128__$1 = (function (){var statearr_39171 = state_39128;
(statearr_39171[(29)] = inst_39074);

return statearr_39171;
})();
if(cljs.core.truth_(inst_39075)){
var statearr_39172_39244 = state_39128__$1;
(statearr_39172_39244[(1)] = (29));

} else {
var statearr_39173_39245 = state_39128__$1;
(statearr_39173_39245[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (25))){
var inst_39045 = (state_39128[(24)]);
var inst_39061 = (state_39128[(2)]);
var inst_39062 = cljs.core.not_empty.call(null,inst_39045);
var state_39128__$1 = (function (){var statearr_39174 = state_39128;
(statearr_39174[(30)] = inst_39061);

return statearr_39174;
})();
if(cljs.core.truth_(inst_39062)){
var statearr_39175_39246 = state_39128__$1;
(statearr_39175_39246[(1)] = (26));

} else {
var statearr_39176_39247 = state_39128__$1;
(statearr_39176_39247[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (34))){
var inst_39097 = (state_39128[(2)]);
var state_39128__$1 = state_39128;
if(cljs.core.truth_(inst_39097)){
var statearr_39177_39248 = state_39128__$1;
(statearr_39177_39248[(1)] = (38));

} else {
var statearr_39178_39249 = state_39128__$1;
(statearr_39178_39249[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (17))){
var state_39128__$1 = state_39128;
var statearr_39179_39250 = state_39128__$1;
(statearr_39179_39250[(2)] = recompile_dependents);

(statearr_39179_39250[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (3))){
var state_39128__$1 = state_39128;
var statearr_39180_39251 = state_39128__$1;
(statearr_39180_39251[(2)] = null);

(statearr_39180_39251[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (12))){
var inst_39018 = (state_39128[(2)]);
var state_39128__$1 = state_39128;
var statearr_39181_39252 = state_39128__$1;
(statearr_39181_39252[(2)] = inst_39018);

(statearr_39181_39252[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (2))){
var inst_38980 = (state_39128[(13)]);
var inst_38987 = cljs.core.seq.call(null,inst_38980);
var inst_38988 = inst_38987;
var inst_38989 = null;
var inst_38990 = (0);
var inst_38991 = (0);
var state_39128__$1 = (function (){var statearr_39182 = state_39128;
(statearr_39182[(7)] = inst_38988);

(statearr_39182[(8)] = inst_38991);

(statearr_39182[(9)] = inst_38990);

(statearr_39182[(10)] = inst_38989);

return statearr_39182;
})();
var statearr_39183_39253 = state_39128__$1;
(statearr_39183_39253[(2)] = null);

(statearr_39183_39253[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (23))){
var inst_39049 = (state_39128[(23)]);
var inst_39041 = (state_39128[(19)]);
var inst_39045 = (state_39128[(24)]);
var inst_39044 = (state_39128[(25)]);
var inst_39047 = (state_39128[(26)]);
var inst_39052 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_39054 = (function (){var all_files = inst_39041;
var res_SINGLEQUOTE_ = inst_39044;
var res = inst_39045;
var files_not_loaded = inst_39047;
var dependencies_that_loaded = inst_39049;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_39049,inst_39041,inst_39045,inst_39044,inst_39047,inst_39052,state_val_39129,c__36609__auto__,map__38973,map__38973__$1,opts,before_jsload,on_jsload,reload_dependents,map__38974,map__38974__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__39053){
var map__39184 = p__39053;
var map__39184__$1 = ((((!((map__39184 == null)))?(((((map__39184.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39184.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__39184):map__39184);
var request_url = cljs.core.get.call(null,map__39184__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_39049,inst_39041,inst_39045,inst_39044,inst_39047,inst_39052,state_val_39129,c__36609__auto__,map__38973,map__38973__$1,opts,before_jsload,on_jsload,reload_dependents,map__38974,map__38974__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_39055 = cljs.core.reverse.call(null,inst_39049);
var inst_39056 = cljs.core.map.call(null,inst_39054,inst_39055);
var inst_39057 = cljs.core.pr_str.call(null,inst_39056);
var inst_39058 = figwheel.client.utils.log.call(null,inst_39057);
var state_39128__$1 = (function (){var statearr_39186 = state_39128;
(statearr_39186[(31)] = inst_39052);

return statearr_39186;
})();
var statearr_39187_39254 = state_39128__$1;
(statearr_39187_39254[(2)] = inst_39058);

(statearr_39187_39254[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (35))){
var state_39128__$1 = state_39128;
var statearr_39188_39255 = state_39128__$1;
(statearr_39188_39255[(2)] = true);

(statearr_39188_39255[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (19))){
var inst_39031 = (state_39128[(12)]);
var inst_39037 = figwheel.client.file_reloading.expand_files.call(null,inst_39031);
var state_39128__$1 = state_39128;
var statearr_39189_39256 = state_39128__$1;
(statearr_39189_39256[(2)] = inst_39037);

(statearr_39189_39256[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (11))){
var state_39128__$1 = state_39128;
var statearr_39190_39257 = state_39128__$1;
(statearr_39190_39257[(2)] = null);

(statearr_39190_39257[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (9))){
var inst_39020 = (state_39128[(2)]);
var state_39128__$1 = state_39128;
var statearr_39191_39258 = state_39128__$1;
(statearr_39191_39258[(2)] = inst_39020);

(statearr_39191_39258[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (5))){
var inst_38991 = (state_39128[(8)]);
var inst_38990 = (state_39128[(9)]);
var inst_38993 = (inst_38991 < inst_38990);
var inst_38994 = inst_38993;
var state_39128__$1 = state_39128;
if(cljs.core.truth_(inst_38994)){
var statearr_39192_39259 = state_39128__$1;
(statearr_39192_39259[(1)] = (7));

} else {
var statearr_39193_39260 = state_39128__$1;
(statearr_39193_39260[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (14))){
var inst_39001 = (state_39128[(22)]);
var inst_39010 = cljs.core.first.call(null,inst_39001);
var inst_39011 = figwheel.client.file_reloading.eval_body.call(null,inst_39010,opts);
var inst_39012 = cljs.core.next.call(null,inst_39001);
var inst_38988 = inst_39012;
var inst_38989 = null;
var inst_38990 = (0);
var inst_38991 = (0);
var state_39128__$1 = (function (){var statearr_39194 = state_39128;
(statearr_39194[(7)] = inst_38988);

(statearr_39194[(8)] = inst_38991);

(statearr_39194[(9)] = inst_38990);

(statearr_39194[(10)] = inst_38989);

(statearr_39194[(32)] = inst_39011);

return statearr_39194;
})();
var statearr_39195_39261 = state_39128__$1;
(statearr_39195_39261[(2)] = null);

(statearr_39195_39261[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (45))){
var state_39128__$1 = state_39128;
var statearr_39196_39262 = state_39128__$1;
(statearr_39196_39262[(2)] = null);

(statearr_39196_39262[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (26))){
var inst_39049 = (state_39128[(23)]);
var inst_39041 = (state_39128[(19)]);
var inst_39045 = (state_39128[(24)]);
var inst_39044 = (state_39128[(25)]);
var inst_39047 = (state_39128[(26)]);
var inst_39064 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_39066 = (function (){var all_files = inst_39041;
var res_SINGLEQUOTE_ = inst_39044;
var res = inst_39045;
var files_not_loaded = inst_39047;
var dependencies_that_loaded = inst_39049;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_39049,inst_39041,inst_39045,inst_39044,inst_39047,inst_39064,state_val_39129,c__36609__auto__,map__38973,map__38973__$1,opts,before_jsload,on_jsload,reload_dependents,map__38974,map__38974__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__39065){
var map__39197 = p__39065;
var map__39197__$1 = ((((!((map__39197 == null)))?(((((map__39197.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39197.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__39197):map__39197);
var namespace = cljs.core.get.call(null,map__39197__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__39197__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_39049,inst_39041,inst_39045,inst_39044,inst_39047,inst_39064,state_val_39129,c__36609__auto__,map__38973,map__38973__$1,opts,before_jsload,on_jsload,reload_dependents,map__38974,map__38974__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_39067 = cljs.core.map.call(null,inst_39066,inst_39045);
var inst_39068 = cljs.core.pr_str.call(null,inst_39067);
var inst_39069 = figwheel.client.utils.log.call(null,inst_39068);
var inst_39070 = (function (){var all_files = inst_39041;
var res_SINGLEQUOTE_ = inst_39044;
var res = inst_39045;
var files_not_loaded = inst_39047;
var dependencies_that_loaded = inst_39049;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_39049,inst_39041,inst_39045,inst_39044,inst_39047,inst_39064,inst_39066,inst_39067,inst_39068,inst_39069,state_val_39129,c__36609__auto__,map__38973,map__38973__$1,opts,before_jsload,on_jsload,reload_dependents,map__38974,map__38974__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_39049,inst_39041,inst_39045,inst_39044,inst_39047,inst_39064,inst_39066,inst_39067,inst_39068,inst_39069,state_val_39129,c__36609__auto__,map__38973,map__38973__$1,opts,before_jsload,on_jsload,reload_dependents,map__38974,map__38974__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_39071 = setTimeout(inst_39070,(10));
var state_39128__$1 = (function (){var statearr_39199 = state_39128;
(statearr_39199[(33)] = inst_39069);

(statearr_39199[(34)] = inst_39064);

return statearr_39199;
})();
var statearr_39200_39263 = state_39128__$1;
(statearr_39200_39263[(2)] = inst_39071);

(statearr_39200_39263[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (16))){
var state_39128__$1 = state_39128;
var statearr_39201_39264 = state_39128__$1;
(statearr_39201_39264[(2)] = reload_dependents);

(statearr_39201_39264[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (38))){
var inst_39081 = (state_39128[(16)]);
var inst_39099 = cljs.core.apply.call(null,cljs.core.hash_map,inst_39081);
var state_39128__$1 = state_39128;
var statearr_39202_39265 = state_39128__$1;
(statearr_39202_39265[(2)] = inst_39099);

(statearr_39202_39265[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (30))){
var state_39128__$1 = state_39128;
var statearr_39203_39266 = state_39128__$1;
(statearr_39203_39266[(2)] = null);

(statearr_39203_39266[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (10))){
var inst_39001 = (state_39128[(22)]);
var inst_39003 = cljs.core.chunked_seq_QMARK_.call(null,inst_39001);
var state_39128__$1 = state_39128;
if(inst_39003){
var statearr_39204_39267 = state_39128__$1;
(statearr_39204_39267[(1)] = (13));

} else {
var statearr_39205_39268 = state_39128__$1;
(statearr_39205_39268[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (18))){
var inst_39035 = (state_39128[(2)]);
var state_39128__$1 = state_39128;
if(cljs.core.truth_(inst_39035)){
var statearr_39206_39269 = state_39128__$1;
(statearr_39206_39269[(1)] = (19));

} else {
var statearr_39207_39270 = state_39128__$1;
(statearr_39207_39270[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (42))){
var state_39128__$1 = state_39128;
var statearr_39208_39271 = state_39128__$1;
(statearr_39208_39271[(2)] = null);

(statearr_39208_39271[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (37))){
var inst_39094 = (state_39128[(2)]);
var state_39128__$1 = state_39128;
var statearr_39209_39272 = state_39128__$1;
(statearr_39209_39272[(2)] = inst_39094);

(statearr_39209_39272[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (8))){
var inst_38988 = (state_39128[(7)]);
var inst_39001 = (state_39128[(22)]);
var inst_39001__$1 = cljs.core.seq.call(null,inst_38988);
var state_39128__$1 = (function (){var statearr_39210 = state_39128;
(statearr_39210[(22)] = inst_39001__$1);

return statearr_39210;
})();
if(inst_39001__$1){
var statearr_39211_39273 = state_39128__$1;
(statearr_39211_39273[(1)] = (10));

} else {
var statearr_39212_39274 = state_39128__$1;
(statearr_39212_39274[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36609__auto__,map__38973,map__38973__$1,opts,before_jsload,on_jsload,reload_dependents,map__38974,map__38974__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__36521__auto__,c__36609__auto__,map__38973,map__38973__$1,opts,before_jsload,on_jsload,reload_dependents,map__38974,map__38974__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__36522__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__36522__auto____0 = (function (){
var statearr_39213 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39213[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__36522__auto__);

(statearr_39213[(1)] = (1));

return statearr_39213;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__36522__auto____1 = (function (state_39128){
while(true){
var ret_value__36523__auto__ = (function (){try{while(true){
var result__36524__auto__ = switch__36521__auto__.call(null,state_39128);
if(cljs.core.keyword_identical_QMARK_.call(null,result__36524__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36524__auto__;
}
break;
}
}catch (e39214){if((e39214 instanceof Object)){
var ex__36525__auto__ = e39214;
var statearr_39215_39275 = state_39128;
(statearr_39215_39275[(5)] = ex__36525__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39128);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39214;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__36523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39276 = state_39128;
state_39128 = G__39276;
continue;
} else {
return ret_value__36523__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__36522__auto__ = function(state_39128){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__36522__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__36522__auto____1.call(this,state_39128);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__36522__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__36522__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__36522__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__36522__auto__;
})()
;})(switch__36521__auto__,c__36609__auto__,map__38973,map__38973__$1,opts,before_jsload,on_jsload,reload_dependents,map__38974,map__38974__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__36611__auto__ = (function (){var statearr_39216 = f__36610__auto__.call(null);
(statearr_39216[(6)] = c__36609__auto__);

return statearr_39216;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__36611__auto__);
});})(c__36609__auto__,map__38973,map__38973__$1,opts,before_jsload,on_jsload,reload_dependents,map__38974,map__38974__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__36609__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__39279,link){
var map__39280 = p__39279;
var map__39280__$1 = ((((!((map__39280 == null)))?(((((map__39280.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39280.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__39280):map__39280);
var file = cljs.core.get.call(null,map__39280__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__39280,map__39280__$1,file){
return (function (p1__39277_SHARP_,p2__39278_SHARP_){
if(cljs.core._EQ_.call(null,p1__39277_SHARP_,p2__39278_SHARP_)){
return p1__39277_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__39280,map__39280__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__39283){
var map__39284 = p__39283;
var map__39284__$1 = ((((!((map__39284 == null)))?(((((map__39284.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39284.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__39284):map__39284);
var match_length = cljs.core.get.call(null,map__39284__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__39284__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__39282_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__39282_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__39286_SHARP_,p2__39287_SHARP_){
return cljs.core.assoc.call(null,p1__39286_SHARP_,cljs.core.get.call(null,p2__39287_SHARP_,key),p2__39287_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__4655__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4655__auto__)){
var link = temp__4655__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__4655__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__4655__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_39288 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_39288);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_39288);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__39289,p__39290){
var map__39291 = p__39289;
var map__39291__$1 = ((((!((map__39291 == null)))?(((((map__39291.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39291.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__39291):map__39291);
var on_cssload = cljs.core.get.call(null,map__39291__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__39292 = p__39290;
var map__39292__$1 = ((((!((map__39292 == null)))?(((((map__39292.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39292.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__39292):map__39292);
var files_msg = map__39292__$1;
var files = cljs.core.get.call(null,map__39292__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__4657__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__4657__auto__)){
var f_datas = temp__4657__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1522271998599
