(in-ns 'ds)
(clojure.core/refer-clojure)

(defn print-table [[f :as data]]
  (->> (cond
         (map? f) [data]
         (sequential? f) [(range (count (first data)))
                          (map #(into {} (map-indexed vector %)) data)])
       (apply clojure.pprint/print-table)))

(defn print-and-return
  [form evaluated]
  (println)
  (location-line-and-form form evaluated)
  (puget.printer/cprint evaluated)
  (println)
  evaluated)

(defn pprint-wrapper
  "A wrapper that helps the pretty-printer identify whether or not there's a
  nested ds macro expansion in pretty-printed output."
  ([form]
   (print-and-return form (eval form)))
  ([form thread-type]
   (fn [threaded-arg]
     (let [form-as-list (if (not (list? form))
                          (list form)
                          form)
           [f & args]   (when (list? form-as-list) form-as-list)
           quoted-arg   `(quote ~threaded-arg)
           evaluated (case thread-type
                       :first (->> quoted-arg
                                   (conj (seq args))
                                   (cons f)
                                   eval)
                       :last  (-> form-as-list
                                  vec
                                  (conj quoted-arg)
                                  seq
                                  eval))]
       (print-and-return form evaluated)))))

(defn scope-pprint [form]
  `(pprint-wrapper '~form))

(defn scope-pprint-thread-last [form]
  `((pprint-wrapper '~form :last)))

(defn scope-pprint-thread-first [form]
  `((pprint-wrapper '~form :first)))

(defn scope-print-table [form]
  `(let [form# ~form]
     (~print-table form#)
     form#))

(defn scope-print-table-thread-last [form]
  `((fn [x#]
      (let [form# (->> x# ~form)]
        (~print-table form#)
        form#))))

(defn scope-print-table-thread-first [form]
  `((fn [x#]
      (let [form# (-> x# ~form)]
        (~print-table form#)
        form#))))
