(in-ns 'ds)
(clojure.core/refer-clojure)

(defn print-table [[f :as data]]
  (->> (cond
         (map? f) [data]
         (sequential? f) [(range (count (first data)))
                          (map #(into {} (map-indexed vector %)) data)])
       (apply clojure.pprint/print-table)))

(defn print-and-return
  [form evaluated]
  (println)
  (location-line-and-form form evaluated)
  (puget.printer/cprint evaluated)
  (println)
  evaluated)

(defn scope-pprint [form]
  `(do
     ;; tag helps identify this as a pretty-print form for when we're
     ;; outputting nested pretty-print forms to the console
     {:tervorz.data-scope/tag "ds-pprint"}
     (print-and-return '~form ~form)))

(defn scope-pprint-thread-last [form]
  `((do
      ;; tag helps identify this as a pretty-print form for when we're
      ;; outputting nested pretty-print forms to the console
      {:tervorz.data-scope/tag "ds-pprint-threaded"}
      (fn [x#]
        (let [form# (->> x# ~form)]
          (print-and-return '~form form#))))))

(defn scope-pprint-thread-first [form]
  `((do
      ;; tag helps identify this as a pretty-print form for when we're
      ;; outputting nested pretty-print forms to the console
      {:tervorz.data-scope/tag "ds-pprint-threaded"}
      (fn [x#]
        (let [form# (-> x# ~form)]
          (print-and-return '~form form#))))))

(defn scope-print-table [form]
  `(let [form# ~form]
     (~print-table form#)
     form#))

(defn scope-print-table-thread-last [form]
  `((fn [x#]
      (let [form# (->> x# ~form)]
        (~print-table form#)
        form#))))

(defn scope-print-table-thread-first [form]
  `((fn [x#]
      (let [form# (-> x# ~form)]
        (~print-table form#)
        form#))))
