(ns secant-test.sample
  (:require [secant-test.core :refer [deftest verify] :as s]
            [loom.graph :as graph]
            [loom.attr :as attr]
            loom.io
            [loom.alg :as graph-alg]))
(def all-dd-tests
  {:t1 (s/map->Test {:name "t1", :steps '(println "t1"), :description "test foo"})
   :t2 (s/map->Test {:name "t2", :steps '(println "t2"), :description "test foo"})
   :t3 (s/map->Test {:name "t3", :steps '(println "t3"), :description "test foo"})})


(deftest login {:name "login", :steps `(do (println "login") (verify (= 1 1) "1 is 1!")), :description "test foo"})
(deftest create-org {:name "create-org", :steps '(println "create-org"), :description "test foo"})
(deftest create-prod {:name "create-prod", :steps (fn [] (println "foo")), :description "test foo"})
(deftest create-env {:name "create-env", :steps '(println "create-env"), :description "test foo"})
(deftest promo-empty-prod {:name "promo-empty-prod", :steps '(println "promo-empty-prod"), :description "test foo"})
(deftest promo-content {:name "promo-content", :steps '(println "promo-content"), :description "test foo"})
(deftest create-repo {:name "create-repo", :steps '(throw (Exception. "Create repo fizzailed!")), :description "test foo"})
(deftest sync-repo {:name "sync-repo", :steps '(println "sync-repo"), :description "test foo"})

(def test-structure  ;; x is a dependency of y
  (vector
   [:bz-login login]
   {login [create-org create-prod]}
   {create-org (conj (vals all-dd-tests) create-env)}
   {create-env [promo-empty-prod promo-content]}
   [create-prod create-repo]
   {create-repo [promo-empty-prod sync-repo]}
   [:bz-sync sync-repo]
   [sync-repo promo-content]))

(def test-structure2 (update-in test-structure []))
(def mytests2
  (-> (apply graph/digraph test-structure)
      (attr/add-attr :bz-login :shape :rectangle)
      (attr/add-attr :bz-sync :shape :rectangle)))

(comment (loom.io/view mytests2 :node-label :name))
(comment (map :name (graph-alg/bf-traverse mytests2)) )
