/*
 * Decompiled with CFR 0.152.
 */
package com.textteaser.summarizer;

import com.google.common.base.Splitter;
import com.google.inject.Inject;
import com.textteaser.summarizer.ArticleKeyword;
import com.textteaser.summarizer.Config;
import com.textteaser.summarizer.KeywordList;
import java.util.regex.Pattern;
import opennlp.tools.sentdetect.SentenceDetectorME;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y4A!\u0001\u0002\u0001\u0013\t1\u0001+\u0019:tKJT!a\u0001\u0003\u0002\u0015M,X.\\1sSj,'O\u0003\u0002\u0006\r\u0005QA/\u001a=ui\u0016\f7/\u001a:\u000b\u0003\u001d\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\u0006\u0011\u0005-qQ\"\u0001\u0007\u000b\u00035\tQa]2bY\u0006L!a\u0004\u0007\u0003\r\u0005s\u0017PU3g\u0011!\t\u0002A!A!\u0002\u0013\u0011\u0012\u0001E:f]R,gnY3EKR,7\r^8s!\t\u0019\"$D\u0001\u0015\u0015\t)b#\u0001\u0006tK:$H-\u001a;fGRT!a\u0006\r\u0002\u000bQ|w\u000e\\:\u000b\u0003e\tqa\u001c9f]:d\u0007/\u0003\u0002\u001c)\t\u00112+\u001a8uK:\u001cW\rR3uK\u000e$xN]'F\u0011!i\u0002A!A!\u0002\u0013q\u0012AB2p]\u001aLw\r\u0005\u0002 A5\t!!\u0003\u0002\"\u0005\t11i\u001c8gS\u001eDQa\t\u0001\u0005\u0002\u0011\na\u0001P5oSRtDcA\u0013'OA\u0011q\u0004\u0001\u0005\u0006#\t\u0002\rA\u0005\u0005\u0006;\t\u0002\rA\b\u0015\u0003E%\u0002\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\r%t'.Z2u\u0015\tqc!\u0001\u0004h_><G.Z\u0005\u0003a-\u0012a!\u00138kK\u000e$\b\u0002\u0003\u001a\u0001\u0011\u000b\u0007I\u0011A\u001a\u0002\u0013M$x\u000e],pe\u0012\u001cX#\u0001\u001b\u0011\u0007URD(D\u00017\u0015\t9\u0004(A\u0005j[6,H/\u00192mK*\u0011\u0011\bD\u0001\u000bG>dG.Z2uS>t\u0017BA\u001e7\u0005\r\u0019V\r\u001e\t\u0003{\tk\u0011A\u0010\u0006\u0003\u007f\u0001\u000bA\u0001\\1oO*\t\u0011)\u0001\u0003kCZ\f\u0017BA\"?\u0005\u0019\u0019FO]5oO\"AQ\t\u0001E\u0001B\u0003&A'\u0001\u0006ti>\u0004xk\u001c:eg\u0002Bqa\u0012\u0001C\u0002\u0013\u0005\u0001*A\u0003jI\u0016\fG.F\u0001J!\tY!*\u0003\u0002L\u0019\t\u0019\u0011J\u001c;\t\r5\u0003\u0001\u0015!\u0003J\u0003\u0019IG-Z1mA!)q\n\u0001C\u0001!\u0006q1/\u001a8uK:\u001cW\rT3oORDGCA)U!\tY!+\u0003\u0002T\u0019\t1Ai\\;cY\u0016DQ!\u0016(A\u0002Y\u000b\u0001b]3oi\u0016t7-\u001a\t\u0004\u0017]K\u0016B\u0001-\r\u0005\u0015\t%O]1z!\tQVL\u0004\u0002\f7&\u0011A\fD\u0001\u0007!J,G-\u001a4\n\u0005\rs&B\u0001/\r\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0003)\u0019\b\u000f\\5u/>\u0014Hm\u001d\u000b\u0003E\u000e\u00042aC,=\u0011\u0015!w\f1\u0001Z\u0003\u0019\u0019x.\u001e:dK\")a\r\u0001C\u0001O\u0006QA/\u001b;mKN\u001bwN]3\u0015\u0007EC'\u000eC\u0003jK\u0002\u0007a+\u0001\u0006uSRdWmV8sINDQ!V3A\u0002YCQ\u0001\u001c\u0001\u0005\u00025\f1bZ3u\u0017\u0016Lxo\u001c:egR\u0011a.\u001d\t\u0003?=L!\u0001\u001d\u0002\u0003\u0017-+\u0017p^8sI2K7\u000f\u001e\u0005\u0006e.\u0004\r!W\u0001\u0005i\u0016DH\u000fC\u0003u\u0001\u0011\u0005Q/\u0001\bta2LGoU3oi\u0016t7-Z:\u0015\u0005\t4\b\"\u00023t\u0001\u0004I\u0006\"\u0002=\u0001\t\u0003I\u0018\u0001E:f]R,gnY3Q_NLG/[8o)\r\t&\u0010 \u0005\u0006w^\u0004\r!S\u0001\u0004GR\u0014\b\"B?x\u0001\u0004\t\u0016!D:f]R,gnY3D_VtG\u000f")
public class Parser {
    private final SentenceDetectorME sentenceDetector;
    private Set<String> stopWords;
    private final int ideal;
    private volatile boolean bitmap$0;

    private Set stopWords$lzycompute() {
        Parser parser = this;
        synchronized (parser) {
            if (!this.bitmap$0) {
                this.stopWords = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-", " ", ",", ".", "a", "e", "i", "o", "u", "t", "about", "above", "above", "across", "after", "afterwards", "again", "against", "all", "almost", "alone", "along", "already", "also", "although", "always", "am", "among", "amongst", "amoungst", "amount", "an", "and", "another", "any", "anyhow", "anyone", "anything", "anyway", "anywhere", "are", "around", "as", "at", "back", "be", "became", "because", "become", "becomes", "becoming", "been", "before", "beforehand", "behind", "being", "below", "beside", "besides", "between", "beyond", "both", "bottom", "but", "by", "call", "can", "cannot", "can't", "co", "con", "could", "couldn't", "de", "describe", "detail", "did", "do", "done", "down", "due", "during", "each", "eg", "eight", "either", "eleven", "else", "elsewhere", "empty", "enough", "etc", "even", "ever", "every", "everyone", "everything", "everywhere", "except", "few", "fifteen", "fifty", "fill", "find", "fire", "first", "five", "for", "former", "formerly", "forty", "found", "four", "from", "front", "full", "further", "get", "give", "go", "got", "had", "has", "hasnt", "have", "he", "hence", "her", "here", "hereafter", "hereby", "herein", "hereupon", "hers", "herself", "him", "himself", "his", "how", "however", "hundred", "i", "ie", "if", "in", "inc", "indeed", "into", "is", "it", "its", "it's", "itself", "just", "keep", "last", "latter", "latterly", "least", "less", "like", "ltd", "made", "make", "many", "may", "me", "meanwhile", "might", "mill", "mine", "more", "moreover", "most", "mostly", "move", "much", "must", "my", "myself", "name", "namely", "neither", "never", "nevertheless", "new", "next", "nine", "no", "nobody", "none", "noone", "nor", "not", "nothing", "now", "nowhere", "of", "off", "often", "on", "once", "one", "only", "onto", "or", "other", "others", "otherwise", "our", "ours", "ourselves", "out", "over", "own", "part", "people", "per", "perhaps", "please", "put", "rather", "re", "said", "same", "see", "seem", "seemed", "seeming", "seems", "several", "she", "should", "show", "side", "since", "sincere", "six", "sixty", "so", "some", "somehow", "someone", "something", "sometime", "sometimes", "somewhere", "still", "such", "take", "ten", "than", "that", "the", "their", "them", "themselves", "then", "thence", "there", "thereafter", "thereby", "therefore", "therein", "thereupon", "these", "they", "thickv", "thin", "third", "this", "those", "though", "three", "through", "throughout", "thru", "thus", "to", "together", "too", "top", "toward", "towards", "twelve", "twenty", "two", "un", "under", "until", "up", "upon", "us", "use", "very", "via", "want", "was", "we", "well", "were", "what", "whatever", "when", "whence", "whenever", "where", "whereafter", "whereas", "whereby", "wherein", "whereupon", "wherever", "whether", "which", "while", "whither", "who", "whoever", "whole", "whom", "whose", "why", "will", "with", "within", "without", "would", "yet", "you", "your", "yours", "yourself", "yourselves", "the", "reuters", "news", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "mon", "tue", "wed", "thu", "fri", "sat", "sun", "rappler", "rapplercom", "inquirer", "yahoo", "home", "sports", "1", "10", "2012", "sa", "says", "tweet", "pm", "home", "homepage", "sports", "section", "newsinfo", "stories", "story", "photo", "2013", "na", "ng", "ang", "year", "years", "percent", "ko", "ako", "yung", "yun", "2", "3", "4", "5", "6", "7", "8", "9", "0", "time", "january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", "philippine", "government", "police", "manila"}));
                this.bitmap$0 = true;
            }
            return this.stopWords;
        }
    }

    public Set<String> stopWords() {
        return this.bitmap$0 ? this.stopWords : this.stopWords$lzycompute();
    }

    public int ideal() {
        return this.ideal;
    }

    public double sentenceLength(String[] sentence) {
        return 1.0 - (double)Math.abs(this.ideal() - Predef$.MODULE$.refArrayOps((Object[])sentence).size()) / (double)this.ideal();
    }

    public String[] splitWords(String source) {
        return (String[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(Splitter.on((Pattern)new StringOps(Predef$.MODULE$.augmentString("[^\\w]")).r().pattern()).trimResults().omitEmptyStrings().split((CharSequence)source)).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public double titleScore(String[] titleWords, String[] sentence) {
        return (double)Predef$.MODULE$.refArrayOps((Object[])sentence).count((Function1)new Serializable(this, titleWords){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Parser $outer;
            private final String[] titleWords$1;

            public final boolean apply(String w) {
                return !this.$outer.stopWords().contains((Object)w) && Predef$.MODULE$.refArrayOps((Object[])this.titleWords$1).contains((Object)w);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.titleWords$1 = titleWords$1;
            }
        }) / (double)Predef$.MODULE$.refArrayOps((Object[])titleWords).size();
    }

    public KeywordList getKeywords(String text) {
        String[] keyWords = this.splitWords(text);
        int sizeWithRepeatingWords = keyWords.length;
        return new KeywordList((List<ArticleKeyword>)((List)((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])keyWords).filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Parser $outer;

            public final boolean apply(String w) {
                return this.$outer.stopWords().contains((Object)w);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        })).groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String w) {
                return w;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArticleKeyword apply(Tuple2<String, String[]> w) {
                return new ArticleKeyword((String)w._1(), ((String[])w._2()).length);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(ArticleKeyword x$1) {
                return -x$1.count();
            }
        }, (Ordering)Ordering.Int$.MODULE$)), sizeWithRepeatingWords);
    }

    public String[] splitSentences(String source) {
        return this.sentenceDetector.sentDetect(source);
    }

    public double sentencePosition(int ctr, double sentenceCount) {
        double normalized = (double)ctr / sentenceCount;
        Double d = normalized > 1.0 ? BoxesRunTime.boxToDouble((double)0.0) : (normalized > 0.9 ? BoxesRunTime.boxToDouble((double)0.15) : (normalized > 0.8 ? BoxesRunTime.boxToDouble((double)0.04) : (normalized > 0.7 ? BoxesRunTime.boxToDouble((double)0.04) : (normalized > 0.6 ? BoxesRunTime.boxToDouble((double)0.06) : (normalized > 0.5 ? BoxesRunTime.boxToDouble((double)0.04) : (normalized > 0.4 ? BoxesRunTime.boxToDouble((double)0.05) : (normalized > 0.3 ? BoxesRunTime.boxToDouble((double)0.08) : (normalized > 0.2 ? BoxesRunTime.boxToDouble((double)0.14) : (normalized > 0.1 ? BoxesRunTime.boxToDouble((double)0.23) : (normalized > 0.0 ? BoxesRunTime.boxToDouble((double)0.17) : BoxedUnit.UNIT))))))))));
        return 0.0;
    }

    @Inject
    public Parser(SentenceDetectorME sentenceDetector, Config config) {
        this.sentenceDetector = sentenceDetector;
        this.ideal = config.words().ideal();
    }
}

