/*
 * Decompiled with CFR 0.152.
 */
package com.textteaser.summarizer;

import com.google.inject.Inject;
import com.textteaser.summarizer.ArticleKeyword;
import com.textteaser.summarizer.KeywordList;
import com.textteaser.summarizer.KeywordService;
import com.textteaser.summarizer.Parser;
import com.textteaser.summarizer.Sentence;
import com.textteaser.summarizer.Summarizer$$anonfun$1$;
import com.textteaser.summarizer.Summarizer$$anonfun$3$;
import com.textteaser.summarizer.Summarizer$$anonfun$8$;
import com.textteaser.summarizer.Summary;
import com.textteaser.summarizer.TopKeyword;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.native.JsonMethods$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.Traversable;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001B\u0001\u0003\u0001%\u0011!bU;n[\u0006\u0014\u0018N_3s\u0015\t\u0019A!\u0001\u0006tk6l\u0017M]5{KJT!!\u0002\u0004\u0002\u0015Q,\u0007\u0010\u001e;fCN,'OC\u0001\b\u0003\r\u0019w.\\\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\t#\u0001\u0011\t\u0011)A\u0005%\u00051\u0001/\u0019:tKJ\u0004\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003\rA\u000b'o]3s\u0011!9\u0002A!A!\u0002\u0013A\u0012AD6fs^|'\u000fZ*feZL7-\u001a\t\u0003'eI!A\u0007\u0002\u0003\u001d-+\u0017p^8sIN+'O^5dK\")A\u0004\u0001C\u0001;\u00051A(\u001b8jiz\"2AH\u0010!!\t\u0019\u0002\u0001C\u0003\u00127\u0001\u0007!\u0003C\u0003\u00187\u0001\u0007\u0001\u0004\u000b\u0002\u001cEA\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0007S:TWm\u0019;\u000b\u0005\u001d2\u0011AB4p_\u001edW-\u0003\u0002*I\t1\u0011J\u001c6fGRDqa\u000b\u0001A\u0002\u0013%A&\u0001\u0007`gVlW.\u0019:z'&TX-F\u0001.!\tYa&\u0003\u00020\u0019\t\u0019\u0011J\u001c;\t\u000fE\u0002\u0001\u0019!C\u0005e\u0005\u0001rl];n[\u0006\u0014\u0018pU5{K~#S-\u001d\u000b\u0003gY\u0002\"a\u0003\u001b\n\u0005Ub!\u0001B+oSRDqa\u000e\u0019\u0002\u0002\u0003\u0007Q&A\u0002yIEBa!\u000f\u0001!B\u0013i\u0013!D0tk6l\u0017M]=TSj,\u0007\u0005C\u0004<\u0001\u0001\u0007I\u0011\u0002\u0017\u0002\u001b}[W-_<pe\u0012\u001c8+\u001b>f\u0011\u001di\u0004\u00011A\u0005\ny\n\u0011cX6fs^|'\u000fZ:TSj,w\fJ3r)\t\u0019t\bC\u00048y\u0005\u0005\t\u0019A\u0017\t\r\u0005\u0003\u0001\u0015)\u0003.\u00039y6.Z=x_J$7oU5{K\u0002BQa\u0011\u0001\u0005\u00021\n1b];n[\u0006\u0014\u0018pU5{K\")Q\t\u0001C\u0001\r\u0006y1/^7nCJL8+\u001b>f?\u0012*\u0017\u000f\u0006\u00024\u000f\")\u0001\n\u0012a\u0001[\u00059a.Z<TSj,\u0007\"\u0002&\u0001\t\u0003a\u0013\u0001D6fs^|'\u000fZ:TSj,\u0007\"\u0002'\u0001\t\u0003i\u0015\u0001E6fs^|'\u000fZ:TSj,w\fJ3r)\t\u0019d\nC\u0003I\u0017\u0002\u0007Q\u0006C\u0003Q\u0001\u0011%\u0011+\u0001\u000ff]N,(/Z*ju\u0016$u.Z:O_R,\u0005pY3fI2KW.\u001b;\u0015\u00075\u0012F\u000bC\u0003T\u001f\u0002\u0007Q&\u0001\u0003tSj,\u0007\"B+P\u0001\u0004i\u0013!\u00027j[&$\b\"B,\u0001\t\u0003A\u0016!C:v[6\f'/\u001b>f)\u0019IF,Z4jWB\u00111CW\u0005\u00037\n\u0011qaU;n[\u0006\u0014\u0018\u0010C\u0003^-\u0002\u0007a,\u0001\u0003uKb$\bCA0c\u001d\tY\u0001-\u0003\u0002b\u0019\u00051\u0001K]3eK\u001aL!a\u00193\u0003\rM#(/\u001b8h\u0015\t\tG\u0002C\u0003g-\u0002\u0007a,A\u0003uSRdW\rC\u0003i-\u0002\u0007a,\u0001\u0003mS:\\\u0007\"\u00026W\u0001\u0004q\u0016\u0001\u00022m_\u001eDQ\u0001\u001c,A\u0002y\u000b\u0001bY1uK\u001e|'/\u001f\u0005\u0006]\u0002!\ta\\\u0001\u0007i>T5k\u0014(\u0015\u0005y\u0003\b\"B9n\u0001\u0004I\u0016aB:v[6\f'/\u001f\u0005\u0006g\u0002!\t\u0001^\u0001\u000fO\u0016$Hk\u001c9LKf<xN\u001d3t)-)\u0018\u0011BA\u000b\u00033\tY\"!\b\u0011\tYt\u00181\u0001\b\u0003ort!\u0001_>\u000e\u0003eT!A\u001f\u0005\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA?\r\u0003\u001d\u0001\u0018mY6bO\u0016L1a`A\u0001\u0005\u0011a\u0015n\u001d;\u000b\u0005ud\u0001cA\n\u0002\u0006%\u0019\u0011q\u0001\u0002\u0003\u0015Q{\u0007oS3zo>\u0014H\rC\u0004\u0002\fI\u0004\r!!\u0004\u0002\u0011-,\u0017p^8sIN\u0004BA\u001e@\u0002\u0010A\u00191#!\u0005\n\u0007\u0005M!A\u0001\bBeRL7\r\\3LKf<xN\u001d3\t\r\u0005]!\u000f1\u0001.\u00031\t'\u000f^5dY\u0016\u001cu.\u001e8u\u0011\u0015A'\u000f1\u0001_\u0011\u0015Q'\u000f1\u0001_\u0011\u0015a'\u000f1\u0001_\u0011\u001d\t\t\u0003\u0001C\u0001\u0003G\tAbY8naV$XmU2pe\u0016$\u0002\"!\n\u00022\u0005]\u00121\b\t\u0006\u0017\u0005\u001d\u00121F\u0005\u0004\u0003Sa!!B!se\u0006L\bcA\n\u0002.%\u0019\u0011q\u0006\u0002\u0003\u0011M+g\u000e^3oG\u0016D\u0001\"a\r\u0002 \u0001\u0007\u0011QG\u0001\ng\u0016tG/\u001a8dKN\u0004BaCA\u0014=\"A\u0011\u0011HA\u0010\u0001\u0004\t)$\u0001\u0006uSRdWmV8sINDq!!\u0010\u0002 \u0001\u0007Q/A\u0006u_B\\U-_<pe\u0012\u001c\bbBA!\u0001\u0011\u0005\u00111I\u0001\u0004g\n\u001cHCBA#\u0003\u0017\ny\u0005E\u0002\f\u0003\u000fJ1!!\u0013\r\u0005\u0019!u.\u001e2mK\"A\u0011QJA \u0001\u0004\t)$A\u0003x_J$7\u000fC\u0004\u0002>\u0005}\u0002\u0019A;\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V\u0005\u0019AMY:\u0015\r\u0005\u0015\u0013qKA-\u0011!\ti%!\u0015A\u0002\u0005U\u0002bBA\u001f\u0003#\u0002\r!\u001e\u0005\b\u0003;\u0002A\u0011AA0\u00035\u0019\u0017M\\8oS\u000e\fGn\u00183cgR1\u0011QIA1\u0003GB\u0001\"!\u0014\u0002\\\u0001\u0007\u0011Q\u0007\u0005\b\u0003{\tY\u00061\u0001v\u0001")
public class Summarizer {
    public final Parser com$textteaser$summarizer$Summarizer$$parser;
    public final KeywordService com$textteaser$summarizer$Summarizer$$keywordService;
    private int _summarySize;
    private int _keywordsSize;

    private int _summarySize() {
        return this._summarySize;
    }

    private void _summarySize_$eq(int x$1) {
        this._summarySize = x$1;
    }

    private int _keywordsSize() {
        return this._keywordsSize;
    }

    private void _keywordsSize_$eq(int x$1) {
        this._keywordsSize = x$1;
    }

    public int summarySize() {
        return this._summarySize();
    }

    public void summarySize_$eq(int newSize) {
        this._summarySize_$eq(newSize);
    }

    public int keywordsSize() {
        return this._keywordsSize();
    }

    public void keywordsSize_$eq(int newSize) {
        this._keywordsSize_$eq(newSize);
    }

    private int ensureSizeDoesNotExceedLimit(int size, int limit) {
        return RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(size), limit);
    }

    public Summary summarize(String text, String title, String link, String blog, String category) {
        String[] sentences = this.com$textteaser$summarizer$Summarizer$$parser.splitSentences(text);
        KeywordList resKeywords = this.com$textteaser$summarizer$Summarizer$$parser.getKeywords(text);
        List<ArticleKeyword> keywords = resKeywords.keywords();
        this.keywordsSize_$eq(this.ensureSizeDoesNotExceedLimit(this.keywordsSize(), keywords.size()));
        List<TopKeyword> topKeywords = this.getTopKeywords((List<ArticleKeyword>)keywords.take(this.keywordsSize()), resKeywords.wordCount(), link, blog, category);
        Sentence[] result = this.computeScore(sentences, this.titleWords$1(title), topKeywords);
        this.summarySize_$eq(this.ensureSizeDoesNotExceedLimit(this.summarySize(), Predef$.MODULE$.refArrayOps((Object[])result).size()));
        return new Summary((IndexedSeq<Sentence>)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])result).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Sentence x$1) {
                return -x$1.score();
            }
        }, (Ordering)Ordering.Double$.MODULE$)).take(this.summarySize())).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Sentence x$2) {
                return x$2.order();
            }
        }, (Ordering)Ordering.Int$.MODULE$)).toIndexedSeq());
    }

    public String toJSON(Summary summary) {
        return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"sentences"), (Object)summary.toList()), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JArray apply(Traversable<String> s) {
                return JsonDSL$.MODULE$.seq2jvalue(s, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonAST.JString apply(String x) {
                        return JsonDSL$.MODULE$.string2jvalue(x);
                    }
                });
            }
        })));
    }

    public List<TopKeyword> getTopKeywords(List<ArticleKeyword> keywords, int articleCount, String link, String blog, String category) {
        return (List)keywords.map((Function1)new Serializable(this, articleCount, link, blog, category){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Summarizer $outer;
            private final int articleCount$1;
            private final String link$1;
            private final String blog$1;
            private final String category$1;

            public final TopKeyword apply(ArticleKeyword k) {
                double blogCount = (double)this.$outer.com$textteaser$summarizer$Summarizer$$keywordService.getBlogCount(this.blog$1) + 1.0;
                double categoryCount = (double)this.$outer.com$textteaser$summarizer$Summarizer$$keywordService.getCategoryCount(this.category$1) + 1.0;
                this.$outer.com$textteaser$summarizer$Summarizer$$keywordService.add(k.word(), k.count(), this.link$1, this.blog$1, this.category$1);
                int articleScore = k.count() / this.articleCount$1;
                double blogScore = (double)this.$outer.com$textteaser$summarizer$Summarizer$$keywordService.getBlogScore(k.word(), this.blog$1) / blogCount;
                double categoryScore = (double)this.$outer.com$textteaser$summarizer$Summarizer$$keywordService.getCategoryScore(k.word(), this.category$1) / categoryCount;
                double totalScore = (double)articleScore * 1.5 + blogScore + categoryScore;
                return new TopKeyword(k.word(), totalScore);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.articleCount$1 = articleCount$1;
                this.link$1 = link$1;
                this.blog$1 = blog$1;
                this.category$1 = category$1;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public Sentence[] computeScore(String[] sentences, String[] titleWords, List<TopKeyword> topKeywords) {
        return (Sentence[])Array$.MODULE$.tabulate(Predef$.MODULE$.refArrayOps((Object[])sentences).size(), (Function1)new Serializable(this, sentences, titleWords, topKeywords){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Summarizer $outer;
            private final String[] sentences$1;
            private final String[] titleWords$2;
            private final List topKeywords$1;

            public final Sentence apply(int i) {
                String[] sentence = this.$outer.com$textteaser$summarizer$Summarizer$$parser.splitWords(this.sentences$1[i]);
                double titleFeature = this.$outer.com$textteaser$summarizer$Summarizer$$parser.titleScore(this.titleWords$2, sentence);
                double sentenceLength = this.$outer.com$textteaser$summarizer$Summarizer$$parser.sentenceLength(sentence);
                double sentencePosition = this.$outer.com$textteaser$summarizer$Summarizer$$parser.sentencePosition(i, Predef$.MODULE$.refArrayOps((Object[])this.sentences$1).size());
                double sbsFeature = this.$outer.sbs(sentence, (List<TopKeyword>)this.topKeywords$1);
                double dbsFeature = this.$outer.dbs(sentence, (List<TopKeyword>)this.topKeywords$1);
                double keywordFrequency = (sbsFeature + dbsFeature) / 2.0 * 10.0;
                double totalScore = (titleFeature * 1.5 + keywordFrequency * 2.0 + sentenceLength * 0.5 + sentencePosition * 1.0) / 4.0;
                return new Sentence(this.sentences$1[i], totalScore, i);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.sentences$1 = sentences$1;
                this.titleWords$2 = titleWords$2;
                this.topKeywords$1 = topKeywords$1;
            }
        }, ClassTag$.MODULE$.apply(Sentence.class));
    }

    public double sbs(String[] words, List<TopKeyword> topKeywords) {
        double d;
        if (Predef$.MODULE$.refArrayOps((Object[])words).size() == 0) {
            d = 0.0;
        } else {
            double summ = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])words).map((Function1)new Serializable(this, topKeywords){
                public static final long serialVersionUID = 0L;
                private final List topKeywords$2;

                public final double apply(String word) {
                    Option option;
                    block4: {
                        double d;
                        block3: {
                            block2: {
                                option = this.topKeywords$2.find((Function1)new $anonfun$1$$anonfun$2(this, word));
                                None$ none$ = None$.MODULE$;
                                Option option2 = option;
                                if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                                d = 0.0;
                                break block3;
                            }
                            if (!(option instanceof Some)) break block4;
                            Some some = (Some)option;
                            TopKeyword x = (TopKeyword)some.x();
                            d = x.score();
                        }
                        return d;
                    }
                    throw new MatchError((Object)option);
                }
                {
                    this.topKeywords$2 = topKeywords$2;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            d = 1.0 / (double)Math.abs(Predef$.MODULE$.refArrayOps((Object[])words).size()) * summ;
        }
        return d;
    }

    public double dbs(String[] words, List<TopKeyword> topKeywords) {
        double d;
        if (Predef$.MODULE$.refArrayOps((Object[])words).size() == 0) {
            d = 0.0;
        } else {
            Tuple2[] res = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])words).map((Function1)new Serializable(this, topKeywords){
                public static final long serialVersionUID = 0L;
                private final List topKeywords$3;

                public final double apply(String word) {
                    Option option;
                    block4: {
                        double d;
                        block3: {
                            block2: {
                                option = this.topKeywords$3.find((Function1)new $anonfun$3$$anonfun$4(this, word));
                                None$ none$ = None$.MODULE$;
                                Option option2 = option;
                                if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                                d = 0.0;
                                break block3;
                            }
                            if (!(option instanceof Some)) break block4;
                            Some some = (Some)option;
                            TopKeyword x = (TopKeyword)some.x();
                            d = x.score();
                        }
                        return d;
                    }
                    throw new MatchError((Object)option);
                }
                {
                    this.topKeywords$3 = topKeywords$3;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Object> x$5) {
                    return x$5._1$mcD$sp() > 0.0;
                }
            });
            double summ = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])res).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])res).slice(1, Predef$.MODULE$.refArrayOps((Object[])res).size())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> r) {
                    return ((Tuple2)r._1())._1$mcD$sp() * ((Tuple2)r._2())._1$mcD$sp() / Math.pow(((Tuple2)r._1())._2$mcI$sp() - ((Tuple2)r._2())._2$mcI$sp(), 2.0);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            int k = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])words).intersect((GenSeq)topKeywords.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(TopKeyword x$6) {
                    return x$6.word();
                }
            }, List$.MODULE$.canBuildFrom()))).size() + 1;
            d = 1.0 / ((double)k * ((double)k + 1.0)) * summ;
        }
        return d;
    }

    public double canonical_dbs(String[] words, List<TopKeyword> topKeywords) {
        double d;
        if (Predef$.MODULE$.refArrayOps((Object[])words).size() == 0) {
            d = 0.0;
        } else {
            Tuple2[] res = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])words).map((Function1)new Serializable(this, topKeywords){
                public static final long serialVersionUID = 0L;
                private final List topKeywords$4;

                public final double apply(String word) {
                    Option option;
                    block4: {
                        double d;
                        block3: {
                            block2: {
                                option = this.topKeywords$4.find((Function1)new $anonfun$8$$anonfun$9(this, word));
                                None$ none$ = None$.MODULE$;
                                Option option2 = option;
                                if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                                d = 0.0;
                                break block3;
                            }
                            if (!(option instanceof Some)) break block4;
                            Some some = (Some)option;
                            TopKeyword x = (TopKeyword)some.x();
                            d = x.score();
                        }
                        return d;
                    }
                    throw new MatchError((Object)option);
                }
                {
                    this.topKeywords$4 = topKeywords$4;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Object> x$8) {
                    return x$8._1$mcD$sp() > 0.0;
                }
            });
            double summ = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])res).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])res).slice(1, Predef$.MODULE$.refArrayOps((Object[])res).size())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> r) {
                    return ((Tuple2)r._1())._1$mcD$sp() * ((Tuple2)r._2())._1$mcD$sp() / Math.pow(((Tuple2)r._1())._2$mcI$sp() - ((Tuple2)r._2())._2$mcI$sp(), 2.0);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            int k = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])words).intersect((GenSeq)topKeywords.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(TopKeyword x$9) {
                    return x$9.word();
                }
            }, List$.MODULE$.canBuildFrom()))).size() + 1;
            d = 1.0 / ((double)k * ((double)k + 1.0)) * summ;
        }
        return d;
    }

    private final String[] titleWords$1(String title$1) {
        return this.com$textteaser$summarizer$Summarizer$$parser.splitWords(title$1);
    }

    @Inject
    public Summarizer(Parser parser, KeywordService keywordService) {
        this.com$textteaser$summarizer$Summarizer$$parser = parser;
        this.com$textteaser$summarizer$Summarizer$$keywordService = keywordService;
        this._summarySize = 5;
        this._keywordsSize = 10;
    }
}

