(ns ^:no-doc mranderson048.rewrite-clj.v0v6v0.rewrite-clj.node.coerce
  (:require [mranderson048.rewrite-clj.v0v6v0.rewrite-clj.potemkin :refer [defprotocol+]]
            [mranderson048.rewrite-clj.v0v6v0.rewrite-clj.node
             comment forms integer keyword
             quote string uneval
             [meta :refer [meta-node]]
             [protocols :as node
              :refer [NodeCoerceable
                      coerce]]
             [reader-macro
              :refer [reader-macro-node var-node]]
             [seq :refer [vector-node
                          list-node
                          set-node
                          map-node]]
             [token :refer [token-node]]
             [whitespace :as ws]])
  (:import [mranderson048.rewrite_clj.v0v6v0.rewrite_clj.node.comment CommentNode]
           [mranderson048.rewrite_clj.v0v6v0.rewrite_clj.node.forms FormsNode]
           [mranderson048.rewrite_clj.v0v6v0.rewrite_clj.node.integer IntNode]
           [mranderson048.rewrite_clj.v0v6v0.rewrite_clj.node.keyword KeywordNode]
           [mranderson048.rewrite_clj.v0v6v0.rewrite_clj.node.meta MetaNode]
           [mranderson048.rewrite_clj.v0v6v0.rewrite_clj.node.quote QuoteNode]
           [mranderson048.rewrite_clj.v0v6v0.rewrite_clj.node.reader_macro             ReaderNode ReaderMacroNode DerefNode]
           [mranderson048.rewrite_clj.v0v6v0.rewrite_clj.node.seq SeqNode]
           [mranderson048.rewrite_clj.v0v6v0.rewrite_clj.node.string StringNode]
           [mranderson048.rewrite_clj.v0v6v0.rewrite_clj.node.token TokenNode]
           [mranderson048.rewrite_clj.v0v6v0.rewrite_clj.node.uneval UnevalNode]
           [mranderson048.rewrite_clj.v0v6v0.rewrite_clj.node.whitespace WhitespaceNode NewlineNode]))

;; ## Helpers

(defn- node-with-meta
  [node value]
  (if (instance? clojure.lang.IMeta value)
    (let [mta (meta value)]
      (if (empty? mta)
        node
        (meta-node (coerce mta) node)))
    node))

;; ## Tokens

(extend-protocol NodeCoerceable
  Object
  (coerce [v]
    (node-with-meta
      (token-node v)
      v)))

(extend-protocol NodeCoerceable
  nil
  (coerce [v]
    (token-node nil)))

;; ## Seqs

(defn- seq-node
  [f sq]
  (node-with-meta
    (->> (map coerce sq)
         (ws/space-separated)
         (vec)
         (f))
    sq))

(extend-protocol NodeCoerceable
  clojure.lang.IPersistentVector
  (coerce [sq]
    (seq-node vector-node sq))
  clojure.lang.IPersistentList
  (coerce [sq]
    (seq-node list-node sq))
  clojure.lang.IPersistentSet
  (coerce [sq]
    (seq-node set-node sq)))

;; ## Maps

(let [comma (ws/whitespace-nodes ", ")
      space (ws/whitespace-node " ")]
  (defn- map->children
    [m]
    (->> (mapcat
          (fn [[k v]]
            (list* (coerce k) space (coerce v) comma))
          m)
         (drop-last (count comma))
         (vec))))

(defn- record-node
  [m]
  (reader-macro-node
    [(token-node (symbol (.getName ^Class (class m))))
     (map-node (map->children m))]))

(defn- is-record?
  [v]
  (instance? clojure.lang.IRecord v))

(extend-protocol NodeCoerceable
  clojure.lang.IPersistentMap
  (coerce [m]
    (node-with-meta
      (if (is-record? m)
        (record-node m)
        (map-node (map->children m)))
      m)))

;; ## Vars

(extend-protocol NodeCoerceable
  clojure.lang.Var
  (coerce [v]
    (-> (str v)
        (subs 2)
        (symbol)
        (token-node)
        (vector)
        (var-node))))

;; ## Existing Nodes

(extend-protocol NodeCoerceable
  CommentNode     (coerce [v] v)
  FormsNode       (coerce [v] v)
  IntNode         (coerce [v] v)
  KeywordNode     (coerce [v] v)
  MetaNode        (coerce [v] v)
  QuoteNode       (coerce [v] v)
  ReaderNode      (coerce [v] v)
  ReaderMacroNode (coerce [v] v)
  DerefNode       (coerce [v] v)
  StringNode      (coerce [v] v)
  UnevalNode      (coerce [v] v)
  NewlineNode     (coerce [v] v)
  SeqNode         (coerce [v] v)
  TokenNode       (coerce [v] v)
  WhitespaceNode  (coerce [v] v))
