(ns ^{:mranderson/inlined true} refactor-nrepl.inlined-deps.orchard.v0v4v0.orchard.classpath
  "A simple wrapper around `clojure.java.classpath` that is Boot-aware."
  (:require
   [refactor-nrepl.inlined-deps.javaclasspath.v0v3v0.clojure.java.classpath :as cp]
   [clojure.string :as str]
   [refactor-nrepl.inlined-deps.orchard.v0v4v0.orchard.classloader :as cl]
   [refactor-nrepl.inlined-deps.orchard.v0v4v0.orchard.misc :as u])
  (:import
   java.io.File
   java.util.jar.JarFile))

(defn- ensure-absolute-paths
  "Returns a `File` guaranteeing an absolute path for `file`."
  [^File file]
  (if (.isAbsolute file)
    file
    (File. (.getAbsolutePath file))))

(defn classpath
  "Return a sequence of File objects of elements on the classpath.

  It takes into account the classpath trickery performed by Boot."
  ([]
   (classpath (cl/class-loader)))
  ([classloader]
   (let [sep (re-pattern File/pathSeparator)
         ;; TODO: Check if that's really needed - after all we have a Boot-aware classloader
         boot-classpath (u/boot-fake-classpath)
         path (if boot-classpath
                (map #(File. ^String %) (str/split boot-classpath sep))
                ;; See https://dev.clojure.org/jira/browse/CLASSPATH-8
                (or (seq (cp/classpath classloader))
                    ;; Java 9+
                    (map ensure-absolute-paths (cp/system-classpath))))]
     path)))

(defn classpath-directories
  "Returns a sequence of File objects for the directories on classpath.

  Uses `classpath` instead of `refactor-nrepl.inlined-deps.javaclasspath.v0v3v0.clojure.java.classpath/classpath`."
  ([]
   (classpath-directories (classpath)))
  ([path]
   (filter #(.isDirectory ^File %) path)))

(defn classpath-jarfiles
  "Returns a sequence of JarFile objects for the JAR files on classpath.

  Uses `classpath` instead of `refactor-nrepl.inlined-deps.javaclasspath.v0v3v0.clojure.java.classpath/classpath`."
  ([]
   (classpath-jarfiles (classpath)))
  ([path]
   (map #(JarFile. ^File %) (filter cp/jar-file? path))))
