/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.direct;

import com.android.dex.util.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPathOpener {
    private final String pathname;
    private final Consumer consumer;
    private final boolean sort;
    private FileNameFilter filter;
    public static final FileNameFilter acceptAll = new FileNameFilter(){

        @Override
        public boolean accept(String path2) {
            return true;
        }
    };

    public ClassPathOpener(String pathname, boolean sort2, Consumer consumer) {
        this(pathname, sort2, acceptAll, consumer);
    }

    public ClassPathOpener(String pathname, boolean sort2, FileNameFilter filter2, Consumer consumer) {
        this.pathname = pathname;
        this.sort = sort2;
        this.consumer = consumer;
        this.filter = filter2;
    }

    public boolean process() {
        File file2 = new File(this.pathname);
        return this.processOne(file2, true);
    }

    private boolean processOne(File file2, boolean topLevel) {
        try {
            if (file2.isDirectory()) {
                return this.processDirectory(file2, topLevel);
            }
            String path2 = file2.getPath();
            if (path2.endsWith(".zip") || path2.endsWith(".jar") || path2.endsWith(".apk")) {
                return this.processArchive(file2);
            }
            if (this.filter.accept(path2)) {
                byte[] bytes2 = FileUtils.readFile(file2);
                return this.consumer.processFileBytes(path2, file2.lastModified(), bytes2);
            }
            return false;
        }
        catch (Exception ex) {
            this.consumer.onException(ex);
            return false;
        }
    }

    private static int compareClassNames(String a, String b) {
        a = a.replace('$', '0');
        b = b.replace('$', '0');
        a = a.replace("package-info", "");
        b = b.replace("package-info", "");
        return a.compareTo(b);
    }

    private boolean processDirectory(File dir2, boolean topLevel) {
        if (topLevel) {
            dir2 = new File(dir2, ".");
        }
        File[] files = dir2.listFiles();
        int len = files.length;
        boolean any = false;
        if (this.sort) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File a, File b) {
                    return ClassPathOpener.compareClassNames(a.getName(), b.getName());
                }
            });
        }
        for (int i = 0; i < len; ++i) {
            any |= this.processOne(files[i], false);
        }
        return any;
    }

    private boolean processArchive(File file2) throws IOException {
        ZipFile zip2 = new ZipFile(file2);
        ArrayList<? extends ZipEntry> entriesList = Collections.list(zip2.entries());
        if (this.sort) {
            Collections.sort(entriesList, new Comparator<ZipEntry>(){

                @Override
                public int compare(ZipEntry a, ZipEntry b) {
                    return ClassPathOpener.compareClassNames(a.getName(), b.getName());
                }
            });
        }
        this.consumer.onProcessArchiveStart(file2);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(40000);
        byte[] buf = new byte[20000];
        boolean any = false;
        for (ZipEntry zipEntry : entriesList) {
            byte[] bytes2;
            boolean isDirectory = zipEntry.isDirectory();
            String path2 = zipEntry.getName();
            if (!this.filter.accept(path2)) continue;
            if (!isDirectory) {
                int read2;
                InputStream in = zip2.getInputStream(zipEntry);
                baos.reset();
                while ((read2 = in.read(buf)) != -1) {
                    baos.write(buf, 0, read2);
                }
                in.close();
                byte[] bytes3 = baos.toByteArray();
            } else {
                bytes2 = new byte[]{};
            }
            any |= this.consumer.processFileBytes(path2, zipEntry.getTime(), bytes2);
        }
        zip2.close();
        return any;
    }

    public static interface FileNameFilter {
        public boolean accept(String var1);
    }

    public static interface Consumer {
        public boolean processFileBytes(String var1, long var2, byte[] var4);

        public void onException(Exception var1);

        public void onProcessArchiveStart(File var1);
    }
}

