/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dex.DexIndexOverflowException;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.Item;
import com.android.dx.dex.file.MemberIdItem;
import com.android.dx.dex.file.MethodIdsSection;
import com.android.dx.dex.file.UniformItemSection;
import java.util.Formatter;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class MemberIdsSection
extends UniformItemSection {
    public MemberIdsSection(String name2, DexFile file2) {
        super(name2, file2, 4);
    }

    @Override
    protected void orderItems() {
        int idx = 0;
        if (this.items().size() > 65536) {
            throw new DexIndexOverflowException(this.getTooManyMembersMessage());
        }
        for (Item item : this.items()) {
            ((MemberIdItem)item).setIndex(idx);
            ++idx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTooManyMembersMessage() {
        TreeMap<String, AtomicInteger> membersByPackage = new TreeMap<String, AtomicInteger>();
        for (Item item : this.items()) {
            String packageName = ((MemberIdItem)item).getDefiningClass().getPackageName();
            AtomicInteger count2 = (AtomicInteger)membersByPackage.get(packageName);
            if (count2 == null) {
                count2 = new AtomicInteger();
                membersByPackage.put(packageName, count2);
            }
            count2.incrementAndGet();
        }
        try (Formatter formatter2 = new Formatter();){
            String string2 = this instanceof MethodIdsSection ? "method" : "field";
            formatter2.format("Too many %1$s references to fit in one dex file: %2$d; max is %3$d.%nYou may try using multi-dex. If multi-dex is enabled then the list of classes for the main dex list is too large.%nReferences by package:", string2, this.items().size(), 65536);
            for (Map.Entry entry : membersByPackage.entrySet()) {
                formatter2.format("%n%6d %s", ((AtomicInteger)entry.getValue()).get(), entry.getKey());
            }
            String string3 = formatter2.toString();
            return string3;
        }
    }
}

