/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.io;

import com.android.dx.io.DexBuffer;
import com.android.dx.util.Unsigned;

public final class MethodId
implements Comparable<MethodId> {
    private final DexBuffer buffer;
    private final int declaringClassIndex;
    private final int protoIndex;
    private final int nameIndex;

    public MethodId(DexBuffer buffer, int declaringClassIndex, int protoIndex, int nameIndex) {
        this.buffer = buffer;
        this.declaringClassIndex = declaringClassIndex;
        this.protoIndex = protoIndex;
        this.nameIndex = nameIndex;
    }

    public int getDeclaringClassIndex() {
        return this.declaringClassIndex;
    }

    public int getProtoIndex() {
        return this.protoIndex;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    @Override
    public int compareTo(MethodId other) {
        if (this.declaringClassIndex != other.declaringClassIndex) {
            return Unsigned.compare(this.declaringClassIndex, other.declaringClassIndex);
        }
        if (this.nameIndex != other.nameIndex) {
            return Unsigned.compare(this.nameIndex, other.nameIndex);
        }
        return Unsigned.compare(this.protoIndex, other.protoIndex);
    }

    public void writeTo(DexBuffer.Section out) {
        out.writeUnsignedShort(this.declaringClassIndex);
        out.writeUnsignedShort(this.protoIndex);
        out.writeInt(this.nameIndex);
    }

    public String toString() {
        if (this.buffer == null) {
            return this.declaringClassIndex + " " + this.protoIndex + " " + this.nameIndex;
        }
        return this.buffer.typeNames().get(this.declaringClassIndex) + "." + this.buffer.strings().get(this.nameIndex) + this.buffer.readTypeList(this.buffer.protoIds().get(this.protoIndex).getParametersOffset());
    }
}

