/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util._tests;

import com.android.dx.util.BitIntSet;
import com.android.dx.util.IntIterator;
import com.android.dx.util.ListIntSet;
import java.util.NoSuchElementException;
import junit.framework.TestCase;

public class _BitIntSet
extends TestCase {
    public void test_basic() {
        BitIntSet set2 = new BitIntSet(32);
        _BitIntSet.assertEquals(0, set2.elements());
        set2.add(0);
        set2.add(1);
        set2.add(31);
        _BitIntSet.assertTrue(set2.has(0));
        _BitIntSet.assertTrue(set2.has(1));
        _BitIntSet.assertTrue(set2.has(31));
        _BitIntSet.assertEquals(3, set2.elements());
        _BitIntSet.assertFalse(set2.has(2));
        _BitIntSet.assertFalse(set2.has(7));
        _BitIntSet.assertFalse(set2.has(30));
    }

    public void test_iterator() {
        BitIntSet set2 = new BitIntSet(32);
        set2.add(0);
        set2.add(0);
        set2.add(1);
        set2.add(1);
        set2.add(31);
        set2.add(31);
        IntIterator iter = set2.iterator();
        _BitIntSet.assertTrue(iter.hasNext());
        _BitIntSet.assertEquals(iter.next(), 0);
        _BitIntSet.assertTrue(iter.hasNext());
        _BitIntSet.assertEquals(iter.next(), 1);
        _BitIntSet.assertTrue(iter.hasNext());
        _BitIntSet.assertEquals(iter.next(), 31);
        _BitIntSet.assertFalse(iter.hasNext());
        try {
            iter.next();
            _BitIntSet.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void test_remove() {
        BitIntSet set2 = new BitIntSet(32);
        set2.add(0);
        set2.add(1);
        set2.add(31);
        _BitIntSet.assertTrue(set2.has(0));
        _BitIntSet.assertTrue(set2.has(1));
        _BitIntSet.assertTrue(set2.has(31));
        _BitIntSet.assertFalse(set2.has(2));
        _BitIntSet.assertFalse(set2.has(7));
        _BitIntSet.assertFalse(set2.has(30));
        set2.remove(0);
        _BitIntSet.assertFalse(set2.has(0));
        _BitIntSet.assertTrue(set2.has(1));
        _BitIntSet.assertTrue(set2.has(31));
    }

    public void test_expand() {
        BitIntSet set2 = new BitIntSet(32);
        int[] values = new int[]{0, 1, 31, 32, 128};
        for (int i = 0; i < values.length; ++i) {
            set2.add(values[i]);
        }
        IntIterator iter = set2.iterator();
        for (int i = 0; i < values.length; ++i) {
            _BitIntSet.assertTrue(iter.hasNext());
            _BitIntSet.assertEquals(values[i], iter.next());
        }
        _BitIntSet.assertFalse(iter.hasNext());
    }

    public void test_merge() {
        int i;
        BitIntSet setA = new BitIntSet(32);
        int[] valuesA = new int[]{0, 1, 31};
        for (int i2 = 0; i2 < valuesA.length; ++i2) {
            setA.add(valuesA[i2]);
        }
        BitIntSet setB = new BitIntSet(32);
        int[] valuesB = new int[]{0, 5, 6, 8, 31};
        for (i = 0; i < valuesB.length; ++i) {
            setB.add(valuesB[i]);
        }
        setA.merge(setB);
        for (i = 0; i < valuesA.length; ++i) {
            _BitIntSet.assertTrue(setA.has(valuesA[i]));
        }
        for (i = 0; i < valuesB.length; ++i) {
            _BitIntSet.assertTrue(setA.has(valuesB[i]));
        }
    }

    public void test_mergeWithListIntSet() {
        int i;
        BitIntSet setA = new BitIntSet(32);
        int[] valuesA = new int[]{0, 1, 31};
        for (int i2 = 0; i2 < valuesA.length; ++i2) {
            setA.add(valuesA[i2]);
        }
        ListIntSet setB = new ListIntSet();
        int[] valuesB = new int[]{0, 5, 6, 8, 31};
        for (i = 0; i < valuesB.length; ++i) {
            setB.add(valuesB[i]);
        }
        setA.merge(setB);
        for (i = 0; i < valuesA.length; ++i) {
            _BitIntSet.assertTrue(setA.has(valuesA[i]));
        }
        for (i = 0; i < valuesB.length; ++i) {
            _BitIntSet.assertTrue(setA.has(valuesB[i]));
        }
    }

    public void test_mergeAndExpand() {
        int i;
        BitIntSet setA = new BitIntSet(32);
        int[] valuesA = new int[]{0, 1, 31};
        for (int i2 = 0; i2 < valuesA.length; ++i2) {
            setA.add(valuesA[i2]);
        }
        BitIntSet setB = new BitIntSet(32);
        int[] valuesB = new int[]{0, 5, 6, 32, 127};
        for (i = 0; i < valuesB.length; ++i) {
            setB.add(valuesB[i]);
        }
        setA.merge(setB);
        for (i = 0; i < valuesA.length; ++i) {
            _BitIntSet.assertTrue(setA.has(valuesA[i]));
        }
        for (i = 0; i < valuesB.length; ++i) {
            _BitIntSet.assertTrue(setA.has(valuesB[i]));
        }
    }

    public void test_toString() {
        BitIntSet set2 = new BitIntSet(32);
        _BitIntSet.assertEquals(set2.toString(), "{}");
        set2.add(1);
        _BitIntSet.assertEquals(set2.toString(), "{1}");
        set2.add(2);
        _BitIntSet.assertEquals(set2.toString(), "{1, 2}");
    }
}

