/*
 * Decompiled with CFR 0.152.
 */
package junit.runner;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class TestCaseClassLoader
extends ClassLoader {
    private Vector<String> fPathItems;
    private String[] defaultExclusions = new String[]{"junit.framework.", "junit.extensions.", "junit.runner."};
    static final String EXCLUDED_FILE = "excluded.properties";
    private Vector<String> fExcluded;

    public TestCaseClassLoader() {
        this(System.getProperty("java.class.path"));
    }

    public TestCaseClassLoader(String classPath) {
        this.scanPath(classPath);
        this.readExcludedPackages();
    }

    private void scanPath(String classPath) {
        String separator = System.getProperty("path.separator");
        this.fPathItems = new Vector(10);
        StringTokenizer st = new StringTokenizer(classPath, separator);
        while (st.hasMoreTokens()) {
            this.fPathItems.addElement(st.nextToken());
        }
    }

    @Override
    public URL getResource(String name2) {
        return ClassLoader.getSystemResource(name2);
    }

    @Override
    public InputStream getResourceAsStream(String name2) {
        return ClassLoader.getSystemResourceAsStream(name2);
    }

    public boolean isExcluded(String name2) {
        for (int i = 0; i < this.fExcluded.size(); ++i) {
            if (!name2.startsWith(this.fExcluded.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public synchronized Class loadClass(String name2, boolean resolve2) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name2);
        if (c != null) {
            return c;
        }
        if (this.isExcluded(name2)) {
            try {
                c = this.findSystemClass(name2);
                return c;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (c == null) {
            byte[] data2 = this.lookupClassData(name2);
            if (data2 == null) {
                throw new ClassNotFoundException();
            }
            c = this.defineClass(name2, data2, 0, data2.length);
        }
        if (resolve2) {
            this.resolveClass(c);
        }
        return c;
    }

    private byte[] lookupClassData(String className) throws ClassNotFoundException {
        byte[] data2 = null;
        for (int i = 0; i < this.fPathItems.size(); ++i) {
            String path2 = this.fPathItems.elementAt(i);
            String fileName = className.replace('.', '/') + ".class";
            data2 = this.isJar(path2) ? this.loadJarData(path2, fileName) : this.loadFileData(path2, fileName);
            if (data2 == null) continue;
            return data2;
        }
        throw new ClassNotFoundException(className);
    }

    boolean isJar(String pathEntry) {
        return pathEntry.endsWith(".jar") || pathEntry.endsWith(".zip") || pathEntry.endsWith(".apk");
    }

    private byte[] loadFileData(String path2, String fileName) {
        File file2 = new File(path2, fileName);
        if (file2.exists()) {
            return this.getClassData(file2);
        }
        return null;
    }

    private byte[] getClassData(File f) {
        try {
            int n;
            FileInputStream stream = new FileInputStream(f);
            ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = stream.read(b)) != -1) {
                out.write(b, 0, n);
            }
            stream.close();
            out.close();
            return out.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadJarData(String path2, String fileName) {
        ZipFile zipFile = null;
        InputStream stream = null;
        File archive = new File(path2);
        if (!archive.exists()) {
            return null;
        }
        try {
            zipFile = new ZipFile(archive);
        }
        catch (IOException io2) {
            return null;
        }
        ZipEntry entry = zipFile.getEntry(fileName);
        if (entry == null) {
            return null;
        }
        int size = (int)entry.getSize();
        try {
            int n;
            stream = zipFile.getInputStream(entry);
            byte[] data2 = new byte[size];
            for (int pos = 0; pos < size; pos += n) {
                n = stream.read(data2, pos, data2.length - pos);
            }
            zipFile.close();
            byte[] byArray = data2;
            return byArray;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readExcludedPackages() {
        this.fExcluded = new Vector(10);
        for (int i = 0; i < this.defaultExclusions.length; ++i) {
            this.fExcluded.addElement(this.defaultExclusions[i]);
        }
        InputStream is2 = this.getClass().getResourceAsStream(EXCLUDED_FILE);
        if (is2 == null) {
            return;
        }
        Properties p = new Properties();
        try {
            p.load(is2);
        }
        catch (IOException e2) {
            try {
                is2.close();
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            try {
                is2.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            is2.close();
        }
        catch (IOException iOException) {}
        Enumeration<?> e3 = p.propertyNames();
        while (e3.hasMoreElements()) {
            String key2 = (String)e3.nextElement();
            if (!key2.startsWith("excluded.")) continue;
            String path2 = p.getProperty(key2);
            if ((path2 = path2.trim()).endsWith("*")) {
                path2 = path2.substring(0, path2.length() - 1);
            }
            if (path2.length() <= 0) continue;
            this.fExcluded.addElement(path2);
        }
    }
}

