/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.gen;

import com.android.dx.gen.FieldId;
import com.android.dx.gen.MethodId;
import com.android.dx.gen.TypeList;
import com.android.dx.rop.cst.CstType;
import java.util.HashMap;
import java.util.Map;

public final class Type<T> {
    public static final Type<Boolean> BOOLEAN = new Type(com.android.dx.rop.type.Type.BOOLEAN);
    public static final Type<Byte> BYTE = new Type(com.android.dx.rop.type.Type.BYTE);
    public static final Type<Character> CHAR = new Type(com.android.dx.rop.type.Type.CHAR);
    public static final Type<Double> DOUBLE = new Type(com.android.dx.rop.type.Type.DOUBLE);
    public static final Type<Float> FLOAT = new Type(com.android.dx.rop.type.Type.FLOAT);
    public static final Type<Integer> INT = new Type(com.android.dx.rop.type.Type.INT);
    public static final Type<Long> LONG = new Type(com.android.dx.rop.type.Type.LONG);
    public static final Type<Short> SHORT = new Type(com.android.dx.rop.type.Type.SHORT);
    public static final Type<Void> VOID = new Type(com.android.dx.rop.type.Type.VOID);
    public static final Type<Object> OBJECT = new Type(com.android.dx.rop.type.Type.OBJECT);
    public static final Type<String> STRING = new Type(com.android.dx.rop.type.Type.STRING);
    private static final Map<Class<?>, Type<?>> PRIMITIVE_TO_TYPE = new HashMap();
    final String name;
    final com.android.dx.rop.type.Type ropType;
    final CstType constant;

    Type(com.android.dx.rop.type.Type ropType) {
        this(ropType.getDescriptor(), ropType);
    }

    Type(String name2, com.android.dx.rop.type.Type ropType) {
        if (name2 == null || ropType == null) {
            throw new NullPointerException();
        }
        this.name = name2;
        this.ropType = ropType;
        this.constant = CstType.intern(ropType);
    }

    public static <T> Type<T> get(String name2) {
        return new Type<T>(name2, com.android.dx.rop.type.Type.internReturnType(name2));
    }

    public static <T> Type<T> get(Class<T> type2) {
        if (type2.isPrimitive()) {
            Type<?> result = PRIMITIVE_TO_TYPE.get(type2);
            return result;
        }
        String name2 = type2.getName().replace('.', '/');
        return Type.get(type2.isArray() ? name2 : 'L' + name2 + ';');
    }

    public <V> FieldId<T, V> getField(Type<V> type2, String name2) {
        return new FieldId(this, type2, name2);
    }

    public MethodId<T, Void> getConstructor(Type<?> ... parameters) {
        return new MethodId(this, VOID, "<init>", new TypeList(parameters));
    }

    public <R> MethodId<T, R> getMethod(Type<R> returnType, String name2, Type<?> ... parameters) {
        return new MethodId(this, returnType, name2, new TypeList(parameters));
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        return o instanceof Type && ((Type)o).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    static {
        PRIMITIVE_TO_TYPE.put(Boolean.TYPE, BOOLEAN);
        PRIMITIVE_TO_TYPE.put(Byte.TYPE, BYTE);
        PRIMITIVE_TO_TYPE.put(Character.TYPE, CHAR);
        PRIMITIVE_TO_TYPE.put(Double.TYPE, DOUBLE);
        PRIMITIVE_TO_TYPE.put(Float.TYPE, FLOAT);
        PRIMITIVE_TO_TYPE.put(Integer.TYPE, INT);
        PRIMITIVE_TO_TYPE.put(Long.TYPE, LONG);
        PRIMITIVE_TO_TYPE.put(Short.TYPE, SHORT);
        PRIMITIVE_TO_TYPE.put(Void.TYPE, VOID);
    }
}

