/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

public class TestSuite
implements Test {
    private Vector<Test> fTests = new Vector(10);
    private String fName;

    public TestSuite() {
    }

    public TestSuite(Class theClass, String name2) {
        this(theClass);
        this.setName(name2);
    }

    public TestSuite(Class theClass) {
        this.fName = theClass.getName();
        try {
            TestSuite.getTestConstructor(theClass);
        }
        catch (NoSuchMethodException e2) {
            this.addTest(TestSuite.warning("Class " + theClass.getName() + " has no public constructor TestCase(String name) or TestCase()"));
            return;
        }
        if (!Modifier.isPublic(theClass.getModifiers())) {
            this.addTest(TestSuite.warning("Class " + theClass.getName() + " is not public"));
            return;
        }
        Class superClass = theClass;
        Vector<String> names = new Vector<String>();
        while (Test.class.isAssignableFrom(superClass)) {
            Method[] methods2 = superClass.getDeclaredMethods();
            for (int i = 0; i < methods2.length; ++i) {
                this.addTestMethod(methods2[i], names, theClass);
            }
            superClass = superClass.getSuperclass();
        }
        if (this.fTests.size() == 0) {
            this.addTest(TestSuite.warning("No tests found in " + theClass.getName()));
        }
    }

    public TestSuite(String name2) {
        this.setName(name2);
    }

    public void addTest(Test test2) {
        this.fTests.addElement(test2);
    }

    public void addTestSuite(Class testClass) {
        this.addTest(new TestSuite(testClass));
    }

    private void addTestMethod(Method m, Vector<String> names, Class theClass) {
        String name2 = m.getName();
        if (names.contains(name2)) {
            return;
        }
        if (!this.isPublicTestMethod(m)) {
            if (this.isTestMethod(m)) {
                this.addTest(TestSuite.warning("Test method isn't public: " + m.getName()));
            }
            return;
        }
        names.addElement(name2);
        this.addTest(TestSuite.createTest(theClass, name2));
    }

    public static Test createTest(Class theClass, String name2) {
        Object test2;
        Constructor constructor;
        try {
            constructor = TestSuite.getTestConstructor(theClass);
        }
        catch (NoSuchMethodException e2) {
            return TestSuite.warning("Class " + theClass.getName() + " has no public constructor TestCase(String name) or TestCase()");
        }
        try {
            if (constructor.getParameterTypes().length == 0) {
                test2 = constructor.newInstance(new Object[0]);
                if (test2 instanceof TestCase) {
                    ((TestCase)test2).setName(name2);
                }
            } else {
                test2 = constructor.newInstance(name2);
            }
        }
        catch (InstantiationException e3) {
            return TestSuite.warning("Cannot instantiate test case: " + name2 + " (" + TestSuite.exceptionToString(e3) + ")");
        }
        catch (InvocationTargetException e4) {
            return TestSuite.warning("Exception in constructor: " + name2 + " (" + TestSuite.exceptionToString(e4.getTargetException()) + ")");
        }
        catch (IllegalAccessException e5) {
            return TestSuite.warning("Cannot access test case: " + name2 + " (" + TestSuite.exceptionToString(e5) + ")");
        }
        return (Test)test2;
    }

    private static String exceptionToString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer2 = new PrintWriter(stringWriter);
        t.printStackTrace(writer2);
        return stringWriter.toString();
    }

    @Override
    public int countTestCases() {
        int count2 = 0;
        Enumeration e2 = this.tests();
        while (e2.hasMoreElements()) {
            Test test2 = (Test)e2.nextElement();
            count2 += test2.countTestCases();
        }
        return count2;
    }

    public static Constructor getTestConstructor(Class theClass) throws NoSuchMethodException {
        Class[] args = new Class[]{String.class};
        try {
            return theClass.getConstructor(args);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return theClass.getConstructor(new Class[0]);
        }
    }

    private boolean isPublicTestMethod(Method m) {
        return this.isTestMethod(m) && Modifier.isPublic(m.getModifiers());
    }

    private boolean isTestMethod(Method m) {
        String name2 = m.getName();
        Class<?>[] parameters = m.getParameterTypes();
        Class<?> returnType = m.getReturnType();
        return parameters.length == 0 && name2.startsWith("test") && returnType.equals(Void.TYPE);
    }

    @Override
    public void run(TestResult result) {
        Enumeration e2 = this.tests();
        while (e2.hasMoreElements() && !result.shouldStop()) {
            Test test2 = (Test)e2.nextElement();
            this.runTest(test2, result);
        }
    }

    public void runTest(Test test2, TestResult result) {
        test2.run(result);
    }

    public Test testAt(int index2) {
        return this.fTests.elementAt(index2);
    }

    public int testCount() {
        return this.fTests.size();
    }

    public Enumeration tests() {
        return this.fTests.elements();
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return super.toString();
    }

    public void setName(String name2) {
        this.fName = name2;
    }

    public String getName() {
        return this.fName;
    }

    private static Test warning(final String message) {
        return new TestCase("warning"){

            @Override
            protected void runTest() {
                1.fail(message);
            }
        };
    }
}

