# utils WIP

A set of useful functions for Clojure programming language
Spreadsheet, Scaling, Pagination, Markdown and others


## Installation 
Put 
`[TODO 0.1.0]` to your `project.clj`

Below is the documentation on what is available within each namespace
Most of it is autogenerated with the help of
[akronim](https://github.com/MichaelLeachim/akronim) library. 



This readme file is **AUTOGENERATED. Do not edit!!**
Check [readme_template.md](https://github.com/michaelleachim/utils/blob/master/resources/README_template.md)  for source
Check [gen_doc.clj](https://github.com/michaelleachim/utils/blob/master/src/thereisnodot/utils/gen_doc.clj) 
for generation mechanics




## Table of contents
* [Spreadsheets](#spreadsheets)
    * [excel-slurp](#excel-slurp)
    * [excel-spit](#excel-spit)
    * [excel-round-up](#excel-round-up)
    * [excel-round-down](#excel-round-down)
* [Collections](#collections)
    * [hashmaps->sparse-table](#hashmaps-sparse-table)
    * [meta-iterate](#meta-iterate)
    * [map-longest](#map-longest)
    * [filter-map-key](#filter-map-key)
    * [filter-map-val](#filter-map-val)
    * [jaccard-words](#jaccard-words)
    * [map-val](#map-val)
    * [pad-numbers](#pad-numbers)
    * [jaccard](#jaccard)
    * [nested-group-by](#nested-group-by)
    * [pad-coll](#pad-coll)
    * [order-by-collection](#order-by-collection)
    * [invert-map](#invert-map)
* [Scales](#scales)
    * [x-y->tile-lat-lon](#x-y-tile-lat-lon)
    * [paginate](#paginate)
    * [lat-lon->tile-x-y](#lat-lon-tile-x-y)
    * [log-scale](#log-scale)
    * [scale](#scale)
    * [log-scale-round](#log-scale-round)
    * [golden-ratio](#golden-ratio)
    * [euclidean-distance](#euclidean-distance)
    * [font-size-in-a-tag-cloud](#font-size-in-a-tag-cloud)
    * [tag-font-log-normalized](#tag-font-log-normalized)
    * [haversine](#haversine)
* [Strings](#strings)
    * [truncate-words-by-chars](#truncate-words-by-chars)
    * [number->roman](#number-roman)
    * [human-date](#human-date)
    * [pluralize->as-ies](#pluralize-as-ies)
    * [number-ordinal->english](#number-ordinal-english)
    * [slugify](#slugify)
    * [lorem-ipsum](#lorem-ipsum)
    * [remove-new-lines](#remove-new-lines)
    * [pluralize->as-s](#pluralize-as-s)
    * [number->english](#number-english)
* [Reading time](#reading-time)
    * [dress-minute](#dress-minute)
    * [dress-minute-small](#dress-minute-small)
    * [calculate](#calculate)
    * [calculate-multiformat](#calculate-multiformat)
* [Framerate](#framerate)
    * [number->duration](#number-duration)
    * [duration->string](#duration-string)
* [HTML](#html)
    * [styles-map->string](#styles-map-string)
    * [gen-layout-class](#gen-layout-class)
    * [backlet](#backlet)
    * [grid-amount](#grid-amount)
    * [style](#style)
    * [parse-sorting-field](#parse-sorting-field)
    * [inlet](#inlet)
* [Transliterate](#transliterate)
    * [cyrillic-str->latin](#cyrillic-str-latin)
    * [latin-str->cyrillic](#latin-str-cyrillic)
* [FS](#fs)
    * [temp-file](#temp-file)
    * [zip-dir](#zip-dir)
* [Markdown](#markdown)
    * [text->html](#text-html)
* [CSS](#css)
    * [inline-css-of-a-html](#inline-css-of-a-html)



### Spreadsheets
#### excel-slurp 
[top](#table-of-contents)
`(excel-slurp fname-str)`

Load spreadsheet as a hashmap where the key is a sheet name. and value is 
   a list of hashmaps with `:key` being the header of a sheet and `:val` being 
   the value on a given row. 
   Will raise an error if there is no such file
   For dumping data to an excel file see [excel-spit](#excel-spit)
   See tests for more examples

**Usage:**
```clojure
(require '[thereisnodot.utils.spreadsheets :refer [excel-slurp]])

(excel-slurp (str (clojure.java.io/file (clojure.java.io/resource
                                          "demo2.xlsx"))))
;; => {"sheet1"
;;       (list
;;         {:secon_column "no one", :third_column "works on this", :first_column "a1"}
;;         {:secon_column "no one", :third_column "n/a", :first_column "n/a"}),
;;     "sheet2"
;;       (list {:secon_column "everything", :third_column "n/a", :first_column "n/a"}
;;             {:secon_column "no one",
;;              :third_column "works on this",
;;              :first_column "b1"})}
```
<hr>

#### excel-spit 
[top](#table-of-contents)
`(excel-spit fpath sheet-maps)`<br>`(excel-spit fpath sheet-maps if-empty)`<br>`(excel-spit fpath sheet-maps if-empty header-order)`

Will turn maps into a spreadsheet of many sheets
   will overwrite any file that is on the given `fpath`

   `if-empty` should be a string value that will replace 
   empty cell. 

   `Header order` will put order on the fields. 
   Those which specified, will go first in the specified order.

   See tests for more examples

**Usage:**
```clojure
(require '[thereisnodot.utils.spreadsheets :refer [excel-spit]])

(excel-spit "/tmp/thereisnodot.utils7945546543919997425.xlsx"
              {"sheet1" (list {:first_column "a1",
                               :secon_column "no one",
                               :third_column "works on this"}
                              {:secon_column "no one"}),
               "sheet2" (list {:secon_column "everything"}
                              {:first_column "b1",
                               :secon_column "no one",
                               :third_column "works on this"})}
            "n/a" [])
;; => nil

(excel-spit "/tmp/thereisnodot.utils7945546543919997426.xlsx"
              {"sheet1" (list {:first_column "a1",
                               :secon_column "no one",
                               :third_column "works on this"}
                              {:secon_column "no one"}),
               "sheet2" (list {:secon_column "everything"}
                              {:first_column "b1",
                               :secon_column "no one",
                               :third_column "works on this"})}
            "n/a" [:secon_column :third_column])
;; => nil
```
<hr>

#### excel-round-up 
[top](#table-of-contents)
`(excel-round-up number digits)`

Excel compatible ROUND formula

**Usage:**
```clojure
(require '[thereisnodot.utils.spreadsheets :refer [excel-round-up]])

(excel-round-up 3.2 0)
;; => 4.0

(excel-round-up 76.9 0)
;; => 77.0

(excel-round-up 3.14159 3)
;; => 3.142

(excel-round-up -3.14159 1)
;; => -3.2

(excel-round-up 31415.92654 -2)
;; => 31500.0

(excel-round-up 100.999 -2)
;; => 200.0
```
<hr>

#### excel-round-down 
[top](#table-of-contents)
`(excel-round-down number digits)`

Excel compatible ROUND formula

**Usage:**
```clojure
(require '[thereisnodot.utils.spreadsheets :refer [excel-round-down]])

(excel-round-down 3.2 0)
;; => 3.0

(excel-round-down 76.9 0)
;; => 76.0

(excel-round-down 3.14159 3)
;; => 3.141

(excel-round-down -3.14159 1)
;; => -3.1

(excel-round-down 31415.92654 -2)
;; => 31400.0
```
<hr>



### Collections

#### hashmaps->sparse-table 
[top](#table-of-contents)
`(hashmaps->sparse-table datum)`<br>`(hashmaps->sparse-table datum null-type)`<br>`(hashmaps->sparse-table datum null-type order-by)`

Will turn a list of hashmaps into a sparse table. 
   Useful when exporting data into a spreadsheet. 
   First row is a headers row

**Usage:**
```clojure
(require '[thereisnodot.utils.collections :refer [hashmaps->sparse-table]])

(hashmaps->sparse-table [{:hello "world", :blab "blip", :blop "12"}
                         {:1 "asd", :2 "zc", :hello "nothing"}])
;; => (list (list "hello" "blab" "blop" "1" "2")
;;          (list "world" "blip" "12" nil nil)
;;          (list "nothing" nil nil "asd" "zc"))

(hashmaps->sparse-table [{:name "hello", :surname "world"}
                         {:name "blab", :surname "blip", :whatever "blop"}]
                        "n/a"
                        [:whatever :name :surname])
;; => (list (list "whatever" "name" "surname")
;;          (list "n/a" "hello" "world")
;;          (list "blop" "blab" "blip"))
```
<hr>

#### meta-iterate 
[top](#table-of-contents)
`(meta-iterate data-set)`

Provide metadata in the form {:index :last? :first?} on a collection

**Usage:**
```clojure
(require '[thereisnodot.utils.collections :refer [meta-iterate]])

(for [[item meta-item] (meta-iterate (range 10 14))] [item meta-item])
;; => (list [10 {:index 0, :last? false, :first? true}]
;;          [11 {:index 1, :last? false, :first? false}]
;;          [12 {:index 2, :last? false, :first? false}]
;;          [13 {:index 3, :last? true, :first? false}])
```
<hr>

#### map-longest 
[top](#table-of-contents)
`(map-longest fn & colls)`

Opposite of map. On multiple collections will iterate until 
   the longest sequence has no more members.
   Will hang when used with lazy collections

**Usage:**
```clojure
(require '[thereisnodot.utils.collections :refer [map-longest]])

(map-longest list (range 1 6) (range 1 3) (range 10 15))
;; => (list (list 1 1 10)
;;          (list 2 2 11)
;;          (list 3 nil 12)
;;          (list 4 nil 13)
;;          (list 5 nil 14))
```
<hr>

#### filter-map-key 
[top](#table-of-contents)
`(filter-map-key filter-fn some-map)`

Will filter on key of a hashmap

**Usage:**
```clojure
(require '[thereisnodot.utils.collections :refer [filter-map-key]])

(filter-map-key (fn [item] (= item :1)) {:1 1, :2 2, :3 3})
;; => {:1 1}
```
<hr>

#### filter-map-val 
[top](#table-of-contents)
`(filter-map-val filter-fn some-map)`

WIll filter on value of a hashmap

**Usage:**
```clojure
(require '[thereisnodot.utils.collections :refer [filter-map-val]])

(filter-map-val (fn [item] (= item 1)) {:1 1, :2 2, :3 3})
;; => {:1 1}
```
<hr>

#### jaccard-words 
[top](#table-of-contents)
`(jaccard-words some-str some-another-str)`

Calculate Jaccard distance between two strings split by space

**Usage:**
```clojure
(require '[thereisnodot.utils.collections :refer [jaccard-words]])

(jaccard-words "Hello my friend" "goodbye my friend")
;; => 1/2

(jaccard-words "hello nobody" "buy one")
;; => 0

(jaccard-words "a b c d e n" "a b c d e")
;; => 5/6

(jaccard-words "a n" "a n")
;; => 1
```
<hr>

#### map-val 
[top](#table-of-contents)
`(map-val f m)`

Will execute function over value of the map

**Usage:**
```clojure
(require '[thereisnodot.utils.collections :refer [map-val]])

(map-val inc {:1 1, :2 2})
;; => {:1 2, :2 3}
```
<hr>

#### pad-numbers 
[top](#table-of-contents)
`(pad-numbers n c pad-symbol)`

Pad numbers - takes a number and the length to pad to as arguments

**Usage:**
```clojure
(require '[thereisnodot.utils.collections :refer [pad-numbers]])

(pad-numbers 10 1234567 0)
;; => "1234567000"
```
<hr>

#### jaccard 
[top](#table-of-contents)
`(jaccard a b)`

Will calculate Jaccard distance over two sets

**Usage:**
```clojure
(require '[thereisnodot.utils.collections :refer [jaccard]])

(jaccard #{:b :a} #{:c :d})
;; => 0

(jaccard #{:c :b :a} #{:c :d})
;; => 1/4

(jaccard #{:c :b :a} #{:b :a})
;; => 2/3

(jaccard #{:b :a} #{:b :a})
;; => 1
```
<hr>

#### nested-group-by 
[top](#table-of-contents)
`(nested-group-by fs coll & [final-fn])`

From: https://stackoverflow.com/a/38842018/3362518
   Like group-by but instead of a single function, this is given a list or vec
   of functions to apply recursively via group-by. An optional `final` argument
   (defaults to identity) may be given to run on the vector result of the final
   group-by. !!careful, deep nesting is not supported

**Usage:**
```clojure
(require '[thereisnodot.utils.collections :refer [nested-group-by]])

(nested-group-by [first second]
                 [["A" 2011 "Dan"] ["A" 2011 "Jon"] ["A" 2010 "Tim"]
                  ["B" 2009 "Tom"]])
;; => {"A" {2010 [["A" 2010 "Tim"]], 2011 [["A" 2011 "Dan"] ["A" 2011 "Jon"]]},
;;     "B" {2009 [["B" 2009 "Tom"]]}}
```
<hr>

#### pad-coll 
[top](#table-of-contents)
`(pad-coll n coll pad-with)`

Pad collection <coll> with <pad-with> until <n> is reached

**Usage:**
```clojure
(require '[thereisnodot.utils.collections :refer [pad-coll]])

(pad-coll 10 [3 4] nil)
;; => [3 4 nil nil nil nil nil nil nil nil]

(pad-coll 10 [3 4] "n/a")
;; => [3 4 "n/a" "n/a" "n/a" "n/a" "n/a" "n/a" "n/a" "n/a"]
```
<hr>

#### order-by-collection 
[top](#table-of-contents)
`(order-by-collection input order-coll)`

Will order input hashmap by order collection. Will append 
   non appearing at the end

**Usage:**
```clojure
(require '[thereisnodot.utils.collections :refer [order-by-collection]])

(order-by-collection {:a 1, :b 34, :c 87, :h 47, :d 12} [:h :d])
;; => (list 47 12 1 34 87)
```
<hr>

#### invert-map 
[top](#table-of-contents)
`(invert-map dataset)`

Turn values into keys and reverse. 
   Basically, an inverted index. See tests for example

**Usage:**
```clojure
(require '[thereisnodot.utils.collections :refer [invert-map]])

(invert-map {:F [:a :b :n], :Q [:c :d :n]})
;; => {:a [:F], :b [:F], :c [:Q], :d [:Q], :n [:F :Q]}

(invert-map
  {1 ["hello" "world"], 2 ["not" "important"], 3 ["very" "important" "thing"]})
;; => {"hello" [1],
;;     "important" [2 3],
;;     "not" [2],
;;     "thing" [3],
;;     "very" [3],
;;     "world" [1]}
```
<hr>



### Scales

#### x-y->tile-lat-lon 
[top](#table-of-contents)
`(x-y->tile-lat-lon xtile ytile zoom)`

Will calculate latitude and longitude coordinates of a map tile, 
   when given tile X Y and  a zoom level. 
   You can check example on OpenStreetMap: 
   https://www.openstreetmap.org/#map=18/42.1440/41.6780

**Usage:**
```clojure
(require '[thereisnodot.utils.scale :refer [x-y->tile-lat-lon]])

(x-y->tile-lat-lon 161421 97171 18)
;; => [42.14405981155153 41.678009033203125]
```
<hr>

#### paginate 
[top](#table-of-contents)
`(paginate current last-item)`

Will create pagination based on 
   current page and the amount of pages as input

**Usage:**
```clojure
(require '[thereisnodot.utils.scale :refer [paginate]])

(paginate 1 3)
;; => (list {:page-num 1, :name "1", :cur? true, :first? true, :last? false}
;;          {:page-num 2, :name "2", :cur? false, :first? false, :last? false}
;;          {:page-num 3, :name "3", :cur? false, :first? false, :last? true})

(map :name (paginate 37 40))
;; => (list "1" "..." "35" "36" "37" "38" "39" "40")

(map :name (paginate 12 30))
;; => (list "1" "..." "10" "11" "12" "13" "14" "..." "30")
```
<hr>

#### lat-lon->tile-x-y 
[top](#table-of-contents)
`(lat-lon->tile-x-y lat-deg lon-deg zoom)`

Will calculate X and Y coordinates of a map tile, 
   when given latitude longitude and a zoom level. 
   Which you can check on OpenStreetMap: 
   https://c.tile.openstreetmap.org/18/161421/97171.png

**Usage:**
```clojure
(require '[thereisnodot.utils.scale :refer [lat-lon->tile-x-y]])

(lat-lon->tile-x-y 42.1438 41.6781 18)
;; => [161421 97171]
```
<hr>

#### log-scale 
[top](#table-of-contents)
`(log-scale x1 x2 y1 y2 x)`

Will calculate log scaling (mapping)
   from one metric into another

**Usage:**
```clojure
(require '[thereisnodot.utils.scale :refer [log-scale]])

(map int (map (partial log-scale 1 5 10 50) (range 1 6)))
;; => (list 10 14 22 33 49)
```
<hr>

#### scale 
[top](#table-of-contents)
`(scale A B C D X)`

Will calculate linear scaling (mapping) from one metric into 

**Usage:**
```clojure
(require '[thereisnodot.utils.scale :refer [scale]])

(map (partial scale 1 5 10 50) (range 1 6))
;; => (list 10 20N 30N 40N 50)
```
<hr>

#### log-scale-round 
[top](#table-of-contents)
`(log-scale-round x1 x2 y1 y2 x)`

Will calculate rounded log scale

**Usage:**
```clojure
(require '[thereisnodot.utils.scale :refer [log-scale-round]])

(map (partial log-scale-round 1 5 10 50) (range 1 6))
;; => (list 10.0 14.0 22.0 33.0 49.0)
```
<hr>

#### golden-ratio 
[top](#table-of-contents)
`(golden-ratio size step)`

Will calculate golden ratio

**Usage:**
```clojure
(require '[thereisnodot.utils.scale :refer [golden-ratio]])

(map (partial golden-ratio 1) (range 1 10))
;; => (list 1 2 4 6 11 17 29 46 75)

(map (partial golden-ratio 5) (range 1 10))
;; => (list 8 13 21 34 55 89 145 234 379)
```
<hr>

#### euclidean-distance 
[top](#table-of-contents)
`(euclidean-distance vec-a vec-b)`

Will calculate Euclidean distance between two vectors
   of the same size. 

**Usage:**
```clojure
(require '[thereisnodot.utils.scale :refer [euclidean-distance]])

(euclidean-distance [1 2 3 4] [5 6 7 8])
;; => 8.0
```
<hr>

#### font-size-in-a-tag-cloud 
[top](#table-of-contents)
`(font-size-in-a-tag-cloud min-font-size max-font-size items-in-the-biggest-tag items)`

Will linearly calculate font size of a tag in a tag cloud. 
   Courtesy of: https://stackoverflow.com/a/3717340/3362518

**Usage:**
```clojure
(require '[thereisnodot.utils.scale :refer [font-size-in-a-tag-cloud]])

(map (partial font-size-in-a-tag-cloud 10 30 6) (range 1 5))
;; => (list 5N 10N 15N 20N)
```
<hr>

#### tag-font-log-normalized 
[top](#table-of-contents)
`(tag-font-log-normalized items-in-the-biggest-tag items)`

Will non linearly calculate font size of a tag in a tag cloud

**Usage:**
```clojure
(require '[thereisnodot.utils.scale :refer [tag-font-log-normalized]])

(map (partial tag-font-log-normalized 10) (range 1 10))
;; => (list 0.33 0.53 0.65 0.73 0.79 0.85 0.89 0.93 0.96)
```
<hr>

#### haversine 
[top](#table-of-contents)
`(haversine lat-1 lng-1 lat-2 lng-2)`<br>`(haversine lat-1 lng-1 lat-2 lng-2 radius)`

Will calculate Haversine distance between two points on a shphere
   Correctness checked at: https://www.vcalc.com/wiki/vCalc/Haversine+-+Distance

**Usage:**
```clojure
(require '[thereisnodot.utils.scale :refer [haversine]])

(haversine 42.1438 41.6781 42.144 41.678)
;; => 0.0237180780670015
```
<hr>



### Strings

#### truncate-words-by-chars 
[top](#table-of-contents)
`(truncate-words-by-chars amount input)`<br>`(truncate-words-by-chars amount input ending)`

will intelligently truncate (without splitting words, with appending ... in the end, if exists)

**Usage:**
```clojure
(require '[thereisnodot.utils.strings :refer [truncate-words-by-chars]])

(truncate-words-by-chars 40 "This is a beautiful sunny day")
;; => "This is a beautiful sunny day"

(truncate-words-by-chars 30 "This is a beautiful sunny day")
;; => "This is a beautiful sunny ..."

(truncate-words-by-chars 20 "This is a beautiful sunny day")
;; => "This is a ..."

(truncate-words-by-chars 10 "This is a beautiful sunny day")
;; => "This ..."
```
<hr>

#### number->roman 
[top](#table-of-contents)
`(number->roman number-int)`

Number to Roman

**Usage:**
```clojure
(require '[thereisnodot.utils.strings :refer [number->roman]])

(number->roman 3)
;; => "III"
```
<hr>

#### human-date 
[top](#table-of-contents)
`(human-date year month day)`

Will make a human readable date

**Usage:**
```clojure
(require '[thereisnodot.utils.strings :refer [human-date]])

(human-date 2017 12 12)
;; => "Twelfth of December, 2017"

(human-date 2000 10 10)
;; => "Tenth of October, 2000"

(human-date 2000 1 1)
;; => "First of January, 2000"
```
<hr>

#### pluralize->as-ies 
[top](#table-of-contents)
`(pluralize->as-ies root-str number-int)`

Pluralize English with -ies suffix

**Usage:**
```clojure
(require '[thereisnodot.utils.strings :refer [pluralize->as-ies]])

(pluralize->as-ies "strawberr" 1)
;; => "strawberry"

(pluralize->as-ies "strawberr" 2)
;; => "strawberries"
```
<hr>

#### number-ordinal->english 
[top](#table-of-contents)
`(number-ordinal->english number-int)`

Number ordinal to English

**Usage:**
```clojure
(require '[thereisnodot.utils.strings :refer [number-ordinal->english]])

(number-ordinal->english 3)
;; => "third"
```
<hr>

#### slugify 
[top](#table-of-contents)
`(slugify some-text)`<br>`(slugify some-text split-kind)`

Will slugify given string. Will remove non ASCII characters

**Usage:**
```clojure
(require '[thereisnodot.utils.strings :refer [slugify]])

(slugify "Will slugify given string.")
;; => "will-slugify-given-string"

(slugify "Это не работает")
;; => ""

(slugify "whatever whoever" "_")
;; => "whatever_whoever"
```
<hr>

#### lorem-ipsum 
[top](#table-of-contents)
`(lorem-ipsum amount-of-words)`<br>`(lorem-ipsum amount-of-words rand-fn)`

Generate lorem ipsum of words of a given size
   Accepts second parameter as a source of randomness. 
   Default rand-int

**Usage:**
```clojure
(require '[thereisnodot.utils.strings :refer [lorem-ipsum]])

(lorem-ipsum 5 (fn [_] 0))
;; => (list "sed" "sed" "sed" "sed" "sed")
```
<hr>

#### remove-new-lines 
[top](#table-of-contents)
`(remove-new-lines datum)`

Will remove new lines from text

**Usage:**
```clojure
(require '[thereisnodot.utils.strings :refer [remove-new-lines]])

(remove-new-lines "Hello\n                      world")
;; => "Hello                       world"
```
<hr>

#### pluralize->as-s 
[top](#table-of-contents)
`(pluralize->as-s root-str number-int)`

Pluralize English with -s suffix

**Usage:**
```clojure
(require '[thereisnodot.utils.strings :refer [pluralize->as-s]])

(pluralize->as-s "friend" 1)
;; => "friend"

(pluralize->as-s "friend" 2)
;; => "friends"
```
<hr>

#### number->english 
[top](#table-of-contents)
`(number->english number-int)`

Number to English

**Usage:**
```clojure
(require '[thereisnodot.utils.strings :refer [number->english]])

(number->english 3)
;; => "three"
```
<hr>



### Reading time

#### dress-minute 
[top](#table-of-contents)
`(dress-minute minute-int)`

Turns digit into human readable minute

**Usage:**
```clojure
(require '[thereisnodot.utils.reading-time :refer [dress-minute]])

(dress-minute 12)
;; => "less than twelve minutes"

(dress-minute 1)
;; => "less than one minute"
```
<hr>

#### dress-minute-small 
[top](#table-of-contents)
`(dress-minute-small minute-int)`

Same as dress-minute, but shorter version

**Usage:**
```clojure
(require '[thereisnodot.utils.reading-time :refer [dress-minute-small]])

(dress-minute-small 1)
;; => "1 minute"

(dress-minute-small 12)
;; => "12 minutes"
```
<hr>

#### calculate 
[top](#table-of-contents)
`(calculate text)`<br>`(calculate text average-words-per-minute)`

(1/(words per minute)) * (amount of words) = (amount of minutes)

**Usage:**
```clojure
(require '[thereisnodot.utils.reading-time :refer [calculate]])

(calculate "Hello world")
;; => 1

(calculate (apply str (repeat 1000 " huge text ")))
;; => 10

(calculate (apply str (repeat 256 " middle text ")))
;; => 3

(calculate (apply str (repeat 256 " middle text ")) 1)
;; => 512
```
<hr>

#### calculate-multiformat 
[top](#table-of-contents)
`(calculate-multiformat text wpm)`<br>`(calculate-multiformat text)`

Will return result in three different formats: numeric/short/long

**Usage:**
```clojure
(require '[thereisnodot.utils.reading-time :refer [calculate-multiformat]])

(calculate-multiformat (apply str (repeat 256 " middle text ")))
;; => [3 "3 minutes" "less than three minutes"]
```
<hr>



### Framerate

#### number->duration 
[top](#table-of-contents)
`(number->duration frames)`<br>`(number->duration frames frame-rate)`

Will take the amount of frames and frame rate.
   Will output the resulting duration in the format 
   of:
   `:hours`, `:minutes`,  `:seconds`, and `:frames`

**Usage:**
```clojure
(require '[thereisnodot.utils.framerate :refer [number->duration]])

(number->duration 1234 25)
;; => {:frames 9.0, :hours 0.0, :minutes 0.0, :seconds 49.0}

(number->duration 0 25)
;; => {:frames 0.0, :hours 0.0, :minutes 0.0, :seconds 0.0}

(number->duration 25 25)
;; => {:frames 0.0, :hours 0.0, :minutes 0.0, :seconds 1.0}

(number->duration (* 60 25) 25)
;; => {:frames 0.0, :hours 0.0, :minutes 1.0, :seconds 0.0}

(number->duration (* 60 60 25) 25)
;; => {:frames 0.0, :hours 1.0, :minutes 0.0, :seconds 0.0}
```
<hr>

#### duration->string 
[top](#table-of-contents)
`(duration->string item)`

Will format framerate into a string

**Usage:**
```clojure
(require '[thereisnodot.utils.framerate :refer [duration->string]])

(duration->string {:hours 1, :minutes 12, :seconds 13, :frames 11})
;; => "01h 12m 13s 11fr"

(duration->string {:hours 0, :minutes 0, :seconds 0, :frames 0})
;; => "00:00"

(duration->string {:hours 0, :minutes 0, :seconds 250, :frames 0})
;; => "250s"
```
<hr>



### HTML

#### styles-map->string 
[top](#table-of-contents)
`(styles-map->string data)`

Will turn a map style of CSS into an inline style of CSS

**Usage:**
```clojure
(require '[thereisnodot.utils.html :refer [styles-map->string]])

(styles-map->string {:background "green", :color "white", :font-weight "900"})
;; => "background:green; color:white; font-weight:900;"
```
<hr>

#### gen-layout-class 
[top](#table-of-contents)
`(gen-layout-class pivot a b c)`

Will generate position specific class. 
   For example: For the pivot 3 
   classes are: 
   text-align:left; text-align:center; text-align:right; 
   Useful when implementing something on CSS grid

**Usage:**
```clojure
(require '[thereisnodot.utils.html :refer [gen-layout-class]])

(take 9 (gen-layout-class 3 "left" "justify" "right"))
;; => (list "left"
;;          "justify" "right"
;;          "left" "justify"
;;          "right" "left"
;;          "justify" "right")
```
<hr>

#### backlet 
[top](#table-of-contents)
`(backlet text class-item)`

Will change last letter in hiccup form

**Usage:**
```clojure
(require '[thereisnodot.utils.html :refer [backlet]])

(backlet "Hello" "blab")
;; => [:span "Hell" [:span {:class "blab"} "o"]]
```
<hr>

#### grid-amount 
[top](#table-of-contents)
`(grid-amount size amount)`

Percentage on classical grid. Size is the amount of blocks in a grid

**Usage:**
```clojure
(require '[thereisnodot.utils.html :refer [grid-amount]])

(map (partial grid-amount 16) (range 16))
;; => (list "0.0%" "6.25%"
;;          "12.5%" "18.75%"
;;          "25.0%" "31.25%"
;;          "37.5%" "43.75%"
;;          "50.0%" "56.25%"
;;          "62.5%" "68.75%"
;;          "75.0%" "81.25%"
;;          "87.5%" "93.75%")
```
<hr>

#### style 
[top](#table-of-contents)
`(style link)`

Will make style in a Hiccup syntax

**Usage:**
```clojure
(require '[thereisnodot.utils.html :refer [style]])

(style "some-link.css")
;; => [:link {:href "some-link.css", :rel "stylesheet", :type "text/css"}]
```
<hr>

#### parse-sorting-field 
[top](#table-of-contents)
`(parse-sorting-field input)`

Will parse sorting field like this: (year | -year) (price | -price) (age | -age) e.t.c.
   (parse-sorting-field "-age") => {:inverse? true, :field :age}

**Usage:**
```clojure
(require '[thereisnodot.utils.html :refer [parse-sorting-field]])

(parse-sorting-field "-age")
;; => {:field :age, :inverse? true}

(parse-sorting-field "age")
;; => {:field :age, :inverse? false}

(parse-sorting-field "blab")
;; => {:field :blab, :inverse? false}
```
<hr>

#### inlet 
[top](#table-of-contents)
`(inlet text text-class)`

Will change first letter in hiccup form

**Usage:**
```clojure
(require '[thereisnodot.utils.html :refer [inlet]])

(inlet "Hello" "blab")
;; => [:span [:span {:class "blab"} "H"] "ello"]
```
<hr>



### Transliterate

#### cyrillic-str->latin 
[top](#table-of-contents)
`(cyrillic-str->latin phrase-str)`

Primitive transliteration of cyrillic to latin.

**Usage:**
```clojure
(require '[thereisnodot.utils.transliterate :refer [cyrillic-str->latin]])

(cyrillic-str->latin "Хелло ворлд")
;; => "Hello world"

(cyrillic-str->latin "Нотхинг воркс")
;; => "Nothing worx"

(cyrillic-str->latin "Фоо бар")
;; => "Foo bar"
```
<hr>

#### latin-str->cyrillic 
[top](#table-of-contents)
`(latin-str->cyrillic phrase-str)`

Primitive transliteration of latin to cyrillic

**Usage:**
```clojure
(require '[thereisnodot.utils.transliterate :refer [latin-str->cyrillic]])

(latin-str->cyrillic "Hello world")
;; => "Хелло ворлд"

(latin-str->cyrillic "Nothing works")
;; => "Нотхинг воркс"

(latin-str->cyrillic "Foo bar")
;; => "Фоо бар"
```
<hr>



### FS

#### temp-file 
[top](#table-of-contents)
`(temp-file)`<br>`(temp-file prefix extension)`

Will return temp file handler without actually making it

**Usage:**
```clojure
(require '[thereisnodot.utils.fs :refer [temp-file]])

(str (temp-file))
;; => "/tmp/cljtmpfile1555885885588503551"
```
<hr>

#### zip-dir 
[top](#table-of-contents)
`(zip-dir archive-name directory)`

will zip directory into a folder

**Usage:**
```clojure
(require '[thereisnodot.utils.fs :refer [zip-dir]])

(zip-dir "/home/mik/Downloads/alacritty.zip" "/home/mik/Downloads/alacritty")
;; => nil
```
<hr>



### Markdown
#### text->html 
[top](#table-of-contents)
`(text->html text)`<br>`(text->html text params)`

Will translate markdown text into HTML.
   This is a thin wrapper over: https://github.com/atlassian/commonmark-java
   The following extensions are enabled by default:

   * Yaml metadata extraction `YamlFrontMatterExtension`
   * `InsExtension`. Underlining of text by enclosing it in ++.
   * Heading anchors via `HeadingAnchorExtension`
   * Tables using pipes, as in: [Github Flavored Markdown](https://help.github.com/articles/organizing-information-with-tables/)
   * Strikethrough of text by enclosing it in ~~ via `StrikethroughExtension`
   * Autolink: turns plain links such as URLS into links via `AutolinkExtension`

   The main reason behind using wrapper because 
   commonmark implementation doesn't have problems with embedded HTML parsing. 

   The parameters currently only encode `:keywordize-keys?` field

**Usage:**
```clojure
(require '[thereisnodot.utils.markdown :refer [text->html]])

(text->html
  "\n---\nhello: world\nblab:  blip\nblop:  blop\n---\n# This is a library\n## And here is its link\n\nhttps://github.com/MichaelLeachim/utils\n")
;; => {:html
;;       "<h1 id=\"this-is-a-library\">This is a library</h1>\n<h2 id=\"and-here-is-its-link\">And here is its link</h2>\n<p><a href=\"https://github.com/MichaelLeachim/utils\">https://github.com/MichaelLeachim/utils</a></p>\n",
;;     :meta {:blab ["blip"], :blop ["blop"], :hello ["world"]}}
```
<hr>


### CSS
#### inline-css-of-a-html 
[top](#table-of-contents)
`(inline-css-of-a-html html-string)`<br>`(inline-css-of-a-html html-string params)`


The implementation is based upon:  https://stackoverflow.com/a/4521740/3362518

Will inline css of a given HTML string
Does not take into account linked CSS (CSS that is passed through `link` HTML tag) 
Available params are: `:silent?`, `:strip-class?`, `:delete-style?`

* `:silent?` (`true` by default) will suppress potential errors e.g. (@media selectors), 
   and continue inlining. When set to `false` will throw `SelectorParseException`
* `:strip-class?` (`true` by default)  will remove classes from the html
* `:delete-style?` (`true` by default) will remove `style` tags from the source

In case of `:silent?` will return a vector of two. First with inlined HTML, second
with errors that occured during inlining

**Usage:**
```clojure
(require '[thereisnodot.utils.css :refer [inline-css-of-a-html]])

(first
  (inline-css-of-a-html
    "<style>.demo-class {background:green;}</style>\n<div class='demo-class'>Hello</div>"))
;; => "<html>\n <head> \n </head>\n <body>\n  <div style=\"background:green\">\n   Hello\n  </div>\n </body>\n</html>"
```
<hr>




## Development

This will clone the repo and start running REPL
and a test watcher/runner

```clojure

git clone github.com/MichaelLeachim/utils;
cd utils;
tmuxinator .

```


## License

Copyright © 2018 Michael Leahcim

Distributed under the Eclipse Public License 
