goog.provide('shadow.api');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('shadow.dom');
goog.require('clojure.string');
goog.require('shadow.util');
shadow.api.ready_ref = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
shadow.api.load_order_ref = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
shadow.api.script__GT_dom_el = (function shadow$api$script__GT_dom_el(script){
var temp__5457__auto__ = shadow.dom.data(script,new cljs.core.Keyword(null,"ref","ref",1289896967));
if(cljs.core.truth_(temp__5457__auto__)){
var dom_ref = temp__5457__auto__;
var pred__60261 = cljs.core._EQ_;
var expr__60262 = dom_ref;
if(cljs.core.truth_((pred__60261.cljs$core$IFn$_invoke$arity$2 ? pred__60261.cljs$core$IFn$_invoke$arity$2("none",expr__60262) : pred__60261.call(null,"none",expr__60262)))){
return null;
} else {
if(cljs.core.truth_((pred__60261.cljs$core$IFn$_invoke$arity$2 ? pred__60261.cljs$core$IFn$_invoke$arity$2("self",expr__60262) : pred__60261.call(null,"self",expr__60262)))){
return script;
} else {
if(cljs.core.truth_((pred__60261.cljs$core$IFn$_invoke$arity$2 ? pred__60261.cljs$core$IFn$_invoke$arity$2("parent",expr__60262) : pred__60261.call(null,"parent",expr__60262)))){
return shadow.dom.get_parent(script);
} else {
if(cljs.core.truth_((pred__60261.cljs$core$IFn$_invoke$arity$2 ? pred__60261.cljs$core$IFn$_invoke$arity$2("previous-sibling",expr__60262) : pred__60261.call(null,"previous-sibling",expr__60262)))){
return shadow.dom.get_previous_sibling(script);
} else {
if(cljs.core.truth_((pred__60261.cljs$core$IFn$_invoke$arity$2 ? pred__60261.cljs$core$IFn$_invoke$arity$2("next-sibling",expr__60262) : pred__60261.call(null,"next-sibling",expr__60262)))){
return shadow.dom.get_next_sibling(script);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("script tag with invalid dom ref",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"dom-ref","dom-ref",-1127826326),dom_ref,new cljs.core.Keyword(null,"script","script",-1304443801),script], null));
}
}
}
}
}
} else {
return null;
}
});
/**
 * a <script type="shadow/run" data-fn="js-fn">edn-args</script> tag is meant to embed calls to javascript in html
 * instead of writing the javascript inline, we only define the call and its args + the location in the dom
 * we want to reference. this allows the javascript to be loaded as late as possible, avoids unknown reference errors,
 * does not litter the html with $(function() {}); and since a dom reference point is provided it makes it more
 * logical to reference dom elements via the server, no need to mess with id/class selectors.
 * 
 * script tags will be executed as soon as the js module is loaded (assuming it called module-ready), not on dom ready
 * which means it triggers earlier
 */
shadow.api.run_script_tag = (function shadow$api$run_script_tag(script){
var init_fn = shadow.dom.data(script,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = shadow.dom.get_html(script);
var args__$1 = (cljs.core.truth_((function (){var and__3938__auto__ = args;
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("",args);
} else {
return and__3938__auto__;
}
})())?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(args):null);
var dom_el = shadow.api.script__GT_dom_el(script);
var args__$2 = (cljs.core.truth_(dom_el)?cljs.core.cons(dom_el,args__$1):args__$1);
var queued_fn = goog.getObjectByName(init_fn);
if(cljs.core.truth_(queued_fn)){
var console__36899__auto___60265 = (window["console"]);
if(cljs.core.truth_(console__36899__auto___60265)){
console__36899__auto___60265.log(shadow.util.console_friendly("init"),shadow.util.console_friendly(init_fn));
} else {
}

return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(queued_fn,args__$2);
} else {
var console__36899__auto__ = (window["console"]);
if(cljs.core.truth_(console__36899__auto__)){
return console__36899__auto__.log(shadow.util.console_friendly("unknown init function"),shadow.util.console_friendly(init_fn),shadow.util.console_friendly(args__$2));
} else {
return null;
}
}
});
shadow.api.script_tags_for_ns = (function shadow$api$script_tags_for_ns(ns_name){
var ns_name__$1 = clojure.string.replace(ns_name,/-/,"_");
var iter__4324__auto__ = ((function (ns_name__$1){
return (function shadow$api$script_tags_for_ns_$_iter__60266(s__60267){
return (new cljs.core.LazySeq(null,((function (ns_name__$1){
return (function (){
var s__60267__$1 = s__60267;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__60267__$1);
if(temp__5457__auto__){
var s__60267__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__60267__$2)){
var c__4322__auto__ = cljs.core.chunk_first(s__60267__$2);
var size__4323__auto__ = cljs.core.count(c__4322__auto__);
var b__60269 = cljs.core.chunk_buffer(size__4323__auto__);
if((function (){var i__60268 = (0);
while(true){
if((i__60268 < size__4323__auto__)){
var script = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4322__auto__,i__60268);
var fn = shadow.dom.data(script,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var fn_ns = fn.substring((0),fn.lastIndexOf("."));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns_name__$1,fn_ns)){
cljs.core.chunk_append(b__60269,script);

var G__60272 = (i__60268 + (1));
i__60268 = G__60272;
continue;
} else {
var G__60273 = (i__60268 + (1));
i__60268 = G__60273;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__60269),shadow$api$script_tags_for_ns_$_iter__60266(cljs.core.chunk_rest(s__60267__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__60269),null);
}
} else {
var script = cljs.core.first(s__60267__$2);
var fn = shadow.dom.data(script,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var fn_ns = fn.substring((0),fn.lastIndexOf("."));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns_name__$1,fn_ns)){
return cljs.core.cons(script,shadow$api$script_tags_for_ns_$_iter__60266(cljs.core.rest(s__60267__$2)));
} else {
var G__60274 = cljs.core.rest(s__60267__$2);
s__60267__$1 = G__60274;
continue;
}
}
} else {
return null;
}
break;
}
});})(ns_name__$1))
,null,null));
});})(ns_name__$1))
;
return iter__4324__auto__(shadow.dom.query.cljs$core$IFn$_invoke$arity$1("script[type=\"shadow/run\"]"));
});
/**
 * use after calling (dom/set-html node html) and that html may contain embedded script tags
 * 
 *   only runs tags when the namespace of the function is already loaded, if the ns is not yet loaded to ns-ready function
 *   will pick remaining tags
 */
shadow.api.run_embedded_tags = (function shadow$api$run_embedded_tags(node){
var seq__60275 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2("script[type=\"shadow/run\"]",node));
var chunk__60278 = null;
var count__60279 = (0);
var i__60280 = (0);
while(true){
if((i__60280 < count__60279)){
var script = chunk__60278.cljs$core$IIndexed$_nth$arity$2(null,i__60280);
var fn = shadow.dom.data(script,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var fn_ns = fn.substring((0),fn.lastIndexOf("."));
if(cljs.core.contains_QMARK_(cljs.core.deref(shadow.api.ready_ref),fn_ns)){
shadow.api.run_script_tag(script);


var G__60283 = seq__60275;
var G__60284 = chunk__60278;
var G__60285 = count__60279;
var G__60286 = (i__60280 + (1));
seq__60275 = G__60283;
chunk__60278 = G__60284;
count__60279 = G__60285;
i__60280 = G__60286;
continue;
} else {
var G__60287 = seq__60275;
var G__60288 = chunk__60278;
var G__60289 = count__60279;
var G__60290 = (i__60280 + (1));
seq__60275 = G__60287;
chunk__60278 = G__60288;
count__60279 = G__60289;
i__60280 = G__60290;
continue;
}
} else {
var temp__5457__auto__ = cljs.core.seq(seq__60275);
if(temp__5457__auto__){
var seq__60275__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__60275__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__60275__$1);
var G__60292 = cljs.core.chunk_rest(seq__60275__$1);
var G__60293 = c__4351__auto__;
var G__60294 = cljs.core.count(c__4351__auto__);
var G__60295 = (0);
seq__60275 = G__60292;
chunk__60278 = G__60293;
count__60279 = G__60294;
i__60280 = G__60295;
continue;
} else {
var script = cljs.core.first(seq__60275__$1);
var fn = shadow.dom.data(script,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var fn_ns = fn.substring((0),fn.lastIndexOf("."));
if(cljs.core.contains_QMARK_(cljs.core.deref(shadow.api.ready_ref),fn_ns)){
shadow.api.run_script_tag(script);


var G__60296 = cljs.core.next(seq__60275__$1);
var G__60297 = null;
var G__60298 = (0);
var G__60299 = (0);
seq__60275 = G__60296;
chunk__60278 = G__60297;
count__60279 = G__60298;
i__60280 = G__60299;
continue;
} else {
var G__60300 = cljs.core.next(seq__60275__$1);
var G__60301 = null;
var G__60302 = (0);
var G__60303 = (0);
seq__60275 = G__60300;
chunk__60278 = G__60301;
count__60279 = G__60302;
i__60280 = G__60303;
continue;
}
}
} else {
return null;
}
}
break;
}
});
shadow.api.run_tags_for_ns = (function shadow$api$run_tags_for_ns(ns_name){
var console__36899__auto___60311 = (window["console"]);
if(cljs.core.truth_(console__36899__auto___60311)){
console__36899__auto___60311.log(shadow.util.console_friendly("ns-ready"),shadow.util.console_friendly(ns_name));
} else {
}

var seq__60304 = cljs.core.seq(shadow.api.script_tags_for_ns(ns_name));
var chunk__60305 = null;
var count__60306 = (0);
var i__60307 = (0);
while(true){
if((i__60307 < count__60306)){
var script = chunk__60305.cljs$core$IIndexed$_nth$arity$2(null,i__60307);
shadow.api.run_script_tag(script);


var G__60313 = seq__60304;
var G__60314 = chunk__60305;
var G__60315 = count__60306;
var G__60316 = (i__60307 + (1));
seq__60304 = G__60313;
chunk__60305 = G__60314;
count__60306 = G__60315;
i__60307 = G__60316;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__60304);
if(temp__5457__auto__){
var seq__60304__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__60304__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__60304__$1);
var G__60317 = cljs.core.chunk_rest(seq__60304__$1);
var G__60318 = c__4351__auto__;
var G__60319 = cljs.core.count(c__4351__auto__);
var G__60320 = (0);
seq__60304 = G__60317;
chunk__60305 = G__60318;
count__60306 = G__60319;
i__60307 = G__60320;
continue;
} else {
var script = cljs.core.first(seq__60304__$1);
shadow.api.run_script_tag(script);


var G__60321 = cljs.core.next(seq__60304__$1);
var G__60322 = null;
var G__60323 = (0);
var G__60324 = (0);
seq__60304 = G__60321;
chunk__60305 = G__60322;
count__60306 = G__60323;
i__60307 = G__60324;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.api.restart = (function shadow$api$restart(){
var seq__60325 = cljs.core.seq(cljs.core.deref(shadow.api.load_order_ref));
var chunk__60328 = null;
var count__60329 = (0);
var i__60330 = (0);
while(true){
if((i__60330 < count__60329)){
var ns_name = chunk__60328.cljs$core$IIndexed$_nth$arity$2(null,i__60330);
var map__60333 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.api.ready_ref),ns_name);
var map__60333__$1 = ((((!((map__60333 == null)))?(((((map__60333.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__60333.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__60333):map__60333);
var opts = map__60333__$1;
var reloadable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60333__$1,new cljs.core.Keyword(null,"reloadable","reloadable",-1517539404));
if(cljs.core.truth_(reloadable)){
shadow.api.run_tags_for_ns(ns_name);


var G__60337 = seq__60325;
var G__60338 = chunk__60328;
var G__60339 = count__60329;
var G__60340 = (i__60330 + (1));
seq__60325 = G__60337;
chunk__60328 = G__60338;
count__60329 = G__60339;
i__60330 = G__60340;
continue;
} else {
var G__60341 = seq__60325;
var G__60342 = chunk__60328;
var G__60343 = count__60329;
var G__60344 = (i__60330 + (1));
seq__60325 = G__60341;
chunk__60328 = G__60342;
count__60329 = G__60343;
i__60330 = G__60344;
continue;
}
} else {
var temp__5457__auto__ = cljs.core.seq(seq__60325);
if(temp__5457__auto__){
var seq__60325__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__60325__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__60325__$1);
var G__60345 = cljs.core.chunk_rest(seq__60325__$1);
var G__60346 = c__4351__auto__;
var G__60347 = cljs.core.count(c__4351__auto__);
var G__60348 = (0);
seq__60325 = G__60345;
chunk__60328 = G__60346;
count__60329 = G__60347;
i__60330 = G__60348;
continue;
} else {
var ns_name = cljs.core.first(seq__60325__$1);
var map__60335 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.api.ready_ref),ns_name);
var map__60335__$1 = ((((!((map__60335 == null)))?(((((map__60335.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__60335.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__60335):map__60335);
var opts = map__60335__$1;
var reloadable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60335__$1,new cljs.core.Keyword(null,"reloadable","reloadable",-1517539404));
if(cljs.core.truth_(reloadable)){
shadow.api.run_tags_for_ns(ns_name);


var G__60349 = cljs.core.next(seq__60325__$1);
var G__60350 = null;
var G__60351 = (0);
var G__60352 = (0);
seq__60325 = G__60349;
chunk__60328 = G__60350;
count__60329 = G__60351;
i__60330 = G__60352;
continue;
} else {
var G__60353 = cljs.core.next(seq__60325__$1);
var G__60354 = null;
var G__60355 = (0);
var G__60356 = (0);
seq__60325 = G__60353;
chunk__60328 = G__60354;
count__60329 = G__60355;
i__60330 = G__60356;
continue;
}
}
} else {
return null;
}
}
break;
}
});
/**
 * use (ns-ready) macro, do not use this directly
 */
shadow.api.ns_ready_STAR_ = (function shadow$api$ns_ready_STAR_(ns_name,opts){
if(cljs.core.contains_QMARK_(cljs.core.deref(shadow.api.ready_ref),ns_name)){
return null;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(shadow.api.ready_ref,cljs.core.assoc,ns_name,opts);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(shadow.api.load_order_ref,cljs.core.conj,ns_name);

return setTimeout((function (){
return shadow.api.run_tags_for_ns(ns_name);
}),(0));
}
});
goog.exportSymbol('shadow.api.ns_ready_STAR_', shadow.api.ns_ready_STAR_);

//# sourceMappingURL=shadow.api.js.map
