goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__137140 = arguments.length;
switch (G__137140) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async137141 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async137141 = (function (f,blockable,meta137142){
this.f = f;
this.blockable = blockable;
this.meta137142 = meta137142;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async137141.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_137143,meta137142__$1){
var self__ = this;
var _137143__$1 = this;
return (new cljs.core.async.t_cljs$core$async137141(self__.f,self__.blockable,meta137142__$1));
});

cljs.core.async.t_cljs$core$async137141.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_137143){
var self__ = this;
var _137143__$1 = this;
return self__.meta137142;
});

cljs.core.async.t_cljs$core$async137141.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async137141.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async137141.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async137141.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async137141.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta137142","meta137142",1477606447,null)], null);
});

cljs.core.async.t_cljs$core$async137141.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async137141.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async137141";

cljs.core.async.t_cljs$core$async137141.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async137141");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async137141.
 */
cljs.core.async.__GT_t_cljs$core$async137141 = (function cljs$core$async$__GT_t_cljs$core$async137141(f__$1,blockable__$1,meta137142){
return (new cljs.core.async.t_cljs$core$async137141(f__$1,blockable__$1,meta137142));
});

}

return (new cljs.core.async.t_cljs$core$async137141(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__137156 = arguments.length;
switch (G__137156) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__137159 = arguments.length;
switch (G__137159) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__137162 = arguments.length;
switch (G__137162) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_137164 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_137164) : fn1.call(null,val_137164));
} else {
cljs.core.async.impl.dispatch.run(((function (val_137164,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_137164) : fn1.call(null,val_137164));
});})(val_137164,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__137170 = arguments.length;
switch (G__137170) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__5455__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4408__auto___137190 = n;
var x_137192 = (0);
while(true){
if((x_137192 < n__4408__auto___137190)){
(a[x_137192] = (0));

var G__137193 = (x_137192 + (1));
x_137192 = G__137193;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__137194 = (i + (1));
i = G__137194;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async137195 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async137195 = (function (flag,meta137196){
this.flag = flag;
this.meta137196 = meta137196;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async137195.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_137197,meta137196__$1){
var self__ = this;
var _137197__$1 = this;
return (new cljs.core.async.t_cljs$core$async137195(self__.flag,meta137196__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async137195.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_137197){
var self__ = this;
var _137197__$1 = this;
return self__.meta137196;
});})(flag))
;

cljs.core.async.t_cljs$core$async137195.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async137195.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async137195.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async137195.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async137195.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta137196","meta137196",1408294981,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async137195.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async137195.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async137195";

cljs.core.async.t_cljs$core$async137195.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async137195");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async137195.
 */
cljs.core.async.__GT_t_cljs$core$async137195 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async137195(flag__$1,meta137196){
return (new cljs.core.async.t_cljs$core$async137195(flag__$1,meta137196));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async137195(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async137198 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async137198 = (function (flag,cb,meta137199){
this.flag = flag;
this.cb = cb;
this.meta137199 = meta137199;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async137198.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_137200,meta137199__$1){
var self__ = this;
var _137200__$1 = this;
return (new cljs.core.async.t_cljs$core$async137198(self__.flag,self__.cb,meta137199__$1));
});

cljs.core.async.t_cljs$core$async137198.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_137200){
var self__ = this;
var _137200__$1 = this;
return self__.meta137199;
});

cljs.core.async.t_cljs$core$async137198.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async137198.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async137198.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async137198.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async137198.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta137199","meta137199",481761795,null)], null);
});

cljs.core.async.t_cljs$core$async137198.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async137198.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async137198";

cljs.core.async.t_cljs$core$async137198.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async137198");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async137198.
 */
cljs.core.async.__GT_t_cljs$core$async137198 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async137198(flag__$1,cb__$1,meta137199){
return (new cljs.core.async.t_cljs$core$async137198(flag__$1,cb__$1,meta137199));
});

}

return (new cljs.core.async.t_cljs$core$async137198(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__137201_SHARP_){
var G__137203 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__137201_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__137203) : fret.call(null,G__137203));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__137202_SHARP_){
var G__137204 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__137202_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__137204) : fret.call(null,G__137204));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__3949__auto__ = wport;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return port;
}
})()], null));
} else {
var G__137206 = (i + (1));
i = G__137206;
continue;
}
} else {
return null;
}
break;
}
})();
var or__3949__auto__ = ret;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5457__auto__ = (function (){var and__3938__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__3938__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4534__auto__ = [];
var len__4531__auto___137212 = arguments.length;
var i__4532__auto___137213 = (0);
while(true){
if((i__4532__auto___137213 < len__4531__auto___137212)){
args__4534__auto__.push((arguments[i__4532__auto___137213]));

var G__137214 = (i__4532__auto___137213 + (1));
i__4532__auto___137213 = G__137214;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__137209){
var map__137210 = p__137209;
var map__137210__$1 = ((((!((map__137210 == null)))?(((((map__137210.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__137210.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__137210):map__137210);
var opts = map__137210__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq137207){
var G__137208 = cljs.core.first(seq137207);
var seq137207__$1 = cljs.core.next(seq137207);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__137208,seq137207__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__137219 = arguments.length;
switch (G__137219) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__33263__auto___137271 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__33263__auto___137271){
return (function (){
var f__33264__auto__ = (function (){var switch__33031__auto__ = ((function (c__33263__auto___137271){
return (function (state_137243){
var state_val_137244 = (state_137243[(1)]);
if((state_val_137244 === (7))){
var inst_137239 = (state_137243[(2)]);
var state_137243__$1 = state_137243;
var statearr_137245_137274 = state_137243__$1;
(statearr_137245_137274[(2)] = inst_137239);

(statearr_137245_137274[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137244 === (1))){
var state_137243__$1 = state_137243;
var statearr_137246_137275 = state_137243__$1;
(statearr_137246_137275[(2)] = null);

(statearr_137246_137275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137244 === (4))){
var inst_137222 = (state_137243[(7)]);
var inst_137222__$1 = (state_137243[(2)]);
var inst_137223 = (inst_137222__$1 == null);
var state_137243__$1 = (function (){var statearr_137247 = state_137243;
(statearr_137247[(7)] = inst_137222__$1);

return statearr_137247;
})();
if(cljs.core.truth_(inst_137223)){
var statearr_137248_137276 = state_137243__$1;
(statearr_137248_137276[(1)] = (5));

} else {
var statearr_137249_137277 = state_137243__$1;
(statearr_137249_137277[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137244 === (13))){
var state_137243__$1 = state_137243;
var statearr_137250_137278 = state_137243__$1;
(statearr_137250_137278[(2)] = null);

(statearr_137250_137278[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137244 === (6))){
var inst_137222 = (state_137243[(7)]);
var state_137243__$1 = state_137243;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_137243__$1,(11),to,inst_137222);
} else {
if((state_val_137244 === (3))){
var inst_137241 = (state_137243[(2)]);
var state_137243__$1 = state_137243;
return cljs.core.async.impl.ioc_helpers.return_chan(state_137243__$1,inst_137241);
} else {
if((state_val_137244 === (12))){
var state_137243__$1 = state_137243;
var statearr_137251_137279 = state_137243__$1;
(statearr_137251_137279[(2)] = null);

(statearr_137251_137279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137244 === (2))){
var state_137243__$1 = state_137243;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_137243__$1,(4),from);
} else {
if((state_val_137244 === (11))){
var inst_137232 = (state_137243[(2)]);
var state_137243__$1 = state_137243;
if(cljs.core.truth_(inst_137232)){
var statearr_137252_137280 = state_137243__$1;
(statearr_137252_137280[(1)] = (12));

} else {
var statearr_137254_137281 = state_137243__$1;
(statearr_137254_137281[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137244 === (9))){
var state_137243__$1 = state_137243;
var statearr_137256_137282 = state_137243__$1;
(statearr_137256_137282[(2)] = null);

(statearr_137256_137282[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137244 === (5))){
var state_137243__$1 = state_137243;
if(cljs.core.truth_(close_QMARK_)){
var statearr_137257_137283 = state_137243__$1;
(statearr_137257_137283[(1)] = (8));

} else {
var statearr_137258_137284 = state_137243__$1;
(statearr_137258_137284[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137244 === (14))){
var inst_137237 = (state_137243[(2)]);
var state_137243__$1 = state_137243;
var statearr_137259_137285 = state_137243__$1;
(statearr_137259_137285[(2)] = inst_137237);

(statearr_137259_137285[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137244 === (10))){
var inst_137229 = (state_137243[(2)]);
var state_137243__$1 = state_137243;
var statearr_137260_137286 = state_137243__$1;
(statearr_137260_137286[(2)] = inst_137229);

(statearr_137260_137286[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137244 === (8))){
var inst_137226 = cljs.core.async.close_BANG_(to);
var state_137243__$1 = state_137243;
var statearr_137261_137287 = state_137243__$1;
(statearr_137261_137287[(2)] = inst_137226);

(statearr_137261_137287[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33263__auto___137271))
;
return ((function (switch__33031__auto__,c__33263__auto___137271){
return (function() {
var cljs$core$async$state_machine__33032__auto__ = null;
var cljs$core$async$state_machine__33032__auto____0 = (function (){
var statearr_137263 = [null,null,null,null,null,null,null,null];
(statearr_137263[(0)] = cljs$core$async$state_machine__33032__auto__);

(statearr_137263[(1)] = (1));

return statearr_137263;
});
var cljs$core$async$state_machine__33032__auto____1 = (function (state_137243){
while(true){
var ret_value__33033__auto__ = (function (){try{while(true){
var result__33034__auto__ = switch__33031__auto__(state_137243);
if(cljs.core.keyword_identical_QMARK_(result__33034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33034__auto__;
}
break;
}
}catch (e137266){if((e137266 instanceof Object)){
var ex__33035__auto__ = e137266;
var statearr_137267_137288 = state_137243;
(statearr_137267_137288[(5)] = ex__33035__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_137243);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e137266;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__33033__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__137289 = state_137243;
state_137243 = G__137289;
continue;
} else {
return ret_value__33033__auto__;
}
break;
}
});
cljs$core$async$state_machine__33032__auto__ = function(state_137243){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33032__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33032__auto____1.call(this,state_137243);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33032__auto____0;
cljs$core$async$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33032__auto____1;
return cljs$core$async$state_machine__33032__auto__;
})()
;})(switch__33031__auto__,c__33263__auto___137271))
})();
var state__33265__auto__ = (function (){var statearr_137268 = (f__33264__auto__.cljs$core$IFn$_invoke$arity$0 ? f__33264__auto__.cljs$core$IFn$_invoke$arity$0() : f__33264__auto__.call(null));
(statearr_137268[(6)] = c__33263__auto___137271);

return statearr_137268;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__33265__auto__);
});})(c__33263__auto___137271))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__137290){
var vec__137291 = p__137290;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__137291,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__137291,(1),null);
var job = vec__137291;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__33263__auto___137479 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__33263__auto___137479,res,vec__137291,v,p,job,jobs,results){
return (function (){
var f__33264__auto__ = (function (){var switch__33031__auto__ = ((function (c__33263__auto___137479,res,vec__137291,v,p,job,jobs,results){
return (function (state_137298){
var state_val_137299 = (state_137298[(1)]);
if((state_val_137299 === (1))){
var state_137298__$1 = state_137298;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_137298__$1,(2),res,v);
} else {
if((state_val_137299 === (2))){
var inst_137295 = (state_137298[(2)]);
var inst_137296 = cljs.core.async.close_BANG_(res);
var state_137298__$1 = (function (){var statearr_137300 = state_137298;
(statearr_137300[(7)] = inst_137295);

return statearr_137300;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_137298__$1,inst_137296);
} else {
return null;
}
}
});})(c__33263__auto___137479,res,vec__137291,v,p,job,jobs,results))
;
return ((function (switch__33031__auto__,c__33263__auto___137479,res,vec__137291,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____0 = (function (){
var statearr_137301 = [null,null,null,null,null,null,null,null];
(statearr_137301[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__);

(statearr_137301[(1)] = (1));

return statearr_137301;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____1 = (function (state_137298){
while(true){
var ret_value__33033__auto__ = (function (){try{while(true){
var result__33034__auto__ = switch__33031__auto__(state_137298);
if(cljs.core.keyword_identical_QMARK_(result__33034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33034__auto__;
}
break;
}
}catch (e137302){if((e137302 instanceof Object)){
var ex__33035__auto__ = e137302;
var statearr_137303_137480 = state_137298;
(statearr_137303_137480[(5)] = ex__33035__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_137298);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e137302;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__33033__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__137481 = state_137298;
state_137298 = G__137481;
continue;
} else {
return ret_value__33033__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__ = function(state_137298){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____1.call(this,state_137298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__;
})()
;})(switch__33031__auto__,c__33263__auto___137479,res,vec__137291,v,p,job,jobs,results))
})();
var state__33265__auto__ = (function (){var statearr_137304 = (f__33264__auto__.cljs$core$IFn$_invoke$arity$0 ? f__33264__auto__.cljs$core$IFn$_invoke$arity$0() : f__33264__auto__.call(null));
(statearr_137304[(6)] = c__33263__auto___137479);

return statearr_137304;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__33265__auto__);
});})(c__33263__auto___137479,res,vec__137291,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__137305){
var vec__137306 = p__137305;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__137306,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__137306,(1),null);
var job = vec__137306;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__4408__auto___137482 = n;
var __137483 = (0);
while(true){
if((__137483 < n__4408__auto___137482)){
var G__137309_137484 = type;
var G__137309_137485__$1 = (((G__137309_137484 instanceof cljs.core.Keyword))?G__137309_137484.fqn:null);
switch (G__137309_137485__$1) {
case "compute":
var c__33263__auto___137487 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__137483,c__33263__auto___137487,G__137309_137484,G__137309_137485__$1,n__4408__auto___137482,jobs,results,process,async){
return (function (){
var f__33264__auto__ = (function (){var switch__33031__auto__ = ((function (__137483,c__33263__auto___137487,G__137309_137484,G__137309_137485__$1,n__4408__auto___137482,jobs,results,process,async){
return (function (state_137322){
var state_val_137323 = (state_137322[(1)]);
if((state_val_137323 === (1))){
var state_137322__$1 = state_137322;
var statearr_137324_137488 = state_137322__$1;
(statearr_137324_137488[(2)] = null);

(statearr_137324_137488[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137323 === (2))){
var state_137322__$1 = state_137322;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_137322__$1,(4),jobs);
} else {
if((state_val_137323 === (3))){
var inst_137320 = (state_137322[(2)]);
var state_137322__$1 = state_137322;
return cljs.core.async.impl.ioc_helpers.return_chan(state_137322__$1,inst_137320);
} else {
if((state_val_137323 === (4))){
var inst_137312 = (state_137322[(2)]);
var inst_137313 = process(inst_137312);
var state_137322__$1 = state_137322;
if(cljs.core.truth_(inst_137313)){
var statearr_137325_137492 = state_137322__$1;
(statearr_137325_137492[(1)] = (5));

} else {
var statearr_137326_137493 = state_137322__$1;
(statearr_137326_137493[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137323 === (5))){
var state_137322__$1 = state_137322;
var statearr_137327_137494 = state_137322__$1;
(statearr_137327_137494[(2)] = null);

(statearr_137327_137494[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137323 === (6))){
var state_137322__$1 = state_137322;
var statearr_137328_137495 = state_137322__$1;
(statearr_137328_137495[(2)] = null);

(statearr_137328_137495[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137323 === (7))){
var inst_137318 = (state_137322[(2)]);
var state_137322__$1 = state_137322;
var statearr_137329_137496 = state_137322__$1;
(statearr_137329_137496[(2)] = inst_137318);

(statearr_137329_137496[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__137483,c__33263__auto___137487,G__137309_137484,G__137309_137485__$1,n__4408__auto___137482,jobs,results,process,async))
;
return ((function (__137483,switch__33031__auto__,c__33263__auto___137487,G__137309_137484,G__137309_137485__$1,n__4408__auto___137482,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____0 = (function (){
var statearr_137330 = [null,null,null,null,null,null,null];
(statearr_137330[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__);

(statearr_137330[(1)] = (1));

return statearr_137330;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____1 = (function (state_137322){
while(true){
var ret_value__33033__auto__ = (function (){try{while(true){
var result__33034__auto__ = switch__33031__auto__(state_137322);
if(cljs.core.keyword_identical_QMARK_(result__33034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33034__auto__;
}
break;
}
}catch (e137331){if((e137331 instanceof Object)){
var ex__33035__auto__ = e137331;
var statearr_137332_137498 = state_137322;
(statearr_137332_137498[(5)] = ex__33035__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_137322);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e137331;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__33033__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__137499 = state_137322;
state_137322 = G__137499;
continue;
} else {
return ret_value__33033__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__ = function(state_137322){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____1.call(this,state_137322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__;
})()
;})(__137483,switch__33031__auto__,c__33263__auto___137487,G__137309_137484,G__137309_137485__$1,n__4408__auto___137482,jobs,results,process,async))
})();
var state__33265__auto__ = (function (){var statearr_137333 = (f__33264__auto__.cljs$core$IFn$_invoke$arity$0 ? f__33264__auto__.cljs$core$IFn$_invoke$arity$0() : f__33264__auto__.call(null));
(statearr_137333[(6)] = c__33263__auto___137487);

return statearr_137333;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__33265__auto__);
});})(__137483,c__33263__auto___137487,G__137309_137484,G__137309_137485__$1,n__4408__auto___137482,jobs,results,process,async))
);


break;
case "async":
var c__33263__auto___137501 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__137483,c__33263__auto___137501,G__137309_137484,G__137309_137485__$1,n__4408__auto___137482,jobs,results,process,async){
return (function (){
var f__33264__auto__ = (function (){var switch__33031__auto__ = ((function (__137483,c__33263__auto___137501,G__137309_137484,G__137309_137485__$1,n__4408__auto___137482,jobs,results,process,async){
return (function (state_137346){
var state_val_137347 = (state_137346[(1)]);
if((state_val_137347 === (1))){
var state_137346__$1 = state_137346;
var statearr_137350_137502 = state_137346__$1;
(statearr_137350_137502[(2)] = null);

(statearr_137350_137502[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137347 === (2))){
var state_137346__$1 = state_137346;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_137346__$1,(4),jobs);
} else {
if((state_val_137347 === (3))){
var inst_137344 = (state_137346[(2)]);
var state_137346__$1 = state_137346;
return cljs.core.async.impl.ioc_helpers.return_chan(state_137346__$1,inst_137344);
} else {
if((state_val_137347 === (4))){
var inst_137336 = (state_137346[(2)]);
var inst_137337 = async(inst_137336);
var state_137346__$1 = state_137346;
if(cljs.core.truth_(inst_137337)){
var statearr_137351_137509 = state_137346__$1;
(statearr_137351_137509[(1)] = (5));

} else {
var statearr_137352_137510 = state_137346__$1;
(statearr_137352_137510[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137347 === (5))){
var state_137346__$1 = state_137346;
var statearr_137353_137511 = state_137346__$1;
(statearr_137353_137511[(2)] = null);

(statearr_137353_137511[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137347 === (6))){
var state_137346__$1 = state_137346;
var statearr_137354_137512 = state_137346__$1;
(statearr_137354_137512[(2)] = null);

(statearr_137354_137512[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137347 === (7))){
var inst_137342 = (state_137346[(2)]);
var state_137346__$1 = state_137346;
var statearr_137355_137513 = state_137346__$1;
(statearr_137355_137513[(2)] = inst_137342);

(statearr_137355_137513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__137483,c__33263__auto___137501,G__137309_137484,G__137309_137485__$1,n__4408__auto___137482,jobs,results,process,async))
;
return ((function (__137483,switch__33031__auto__,c__33263__auto___137501,G__137309_137484,G__137309_137485__$1,n__4408__auto___137482,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____0 = (function (){
var statearr_137356 = [null,null,null,null,null,null,null];
(statearr_137356[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__);

(statearr_137356[(1)] = (1));

return statearr_137356;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____1 = (function (state_137346){
while(true){
var ret_value__33033__auto__ = (function (){try{while(true){
var result__33034__auto__ = switch__33031__auto__(state_137346);
if(cljs.core.keyword_identical_QMARK_(result__33034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33034__auto__;
}
break;
}
}catch (e137357){if((e137357 instanceof Object)){
var ex__33035__auto__ = e137357;
var statearr_137358_137514 = state_137346;
(statearr_137358_137514[(5)] = ex__33035__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_137346);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e137357;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__33033__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__137515 = state_137346;
state_137346 = G__137515;
continue;
} else {
return ret_value__33033__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__ = function(state_137346){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____1.call(this,state_137346);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__;
})()
;})(__137483,switch__33031__auto__,c__33263__auto___137501,G__137309_137484,G__137309_137485__$1,n__4408__auto___137482,jobs,results,process,async))
})();
var state__33265__auto__ = (function (){var statearr_137360 = (f__33264__auto__.cljs$core$IFn$_invoke$arity$0 ? f__33264__auto__.cljs$core$IFn$_invoke$arity$0() : f__33264__auto__.call(null));
(statearr_137360[(6)] = c__33263__auto___137501);

return statearr_137360;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__33265__auto__);
});})(__137483,c__33263__auto___137501,G__137309_137484,G__137309_137485__$1,n__4408__auto___137482,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__137309_137485__$1)].join('')));

}

var G__137516 = (__137483 + (1));
__137483 = G__137516;
continue;
} else {
}
break;
}

var c__33263__auto___137517 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__33263__auto___137517,jobs,results,process,async){
return (function (){
var f__33264__auto__ = (function (){var switch__33031__auto__ = ((function (c__33263__auto___137517,jobs,results,process,async){
return (function (state_137385){
var state_val_137387 = (state_137385[(1)]);
if((state_val_137387 === (1))){
var state_137385__$1 = state_137385;
var statearr_137389_137524 = state_137385__$1;
(statearr_137389_137524[(2)] = null);

(statearr_137389_137524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137387 === (2))){
var state_137385__$1 = state_137385;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_137385__$1,(4),from);
} else {
if((state_val_137387 === (3))){
var inst_137380 = (state_137385[(2)]);
var state_137385__$1 = state_137385;
return cljs.core.async.impl.ioc_helpers.return_chan(state_137385__$1,inst_137380);
} else {
if((state_val_137387 === (4))){
var inst_137363 = (state_137385[(7)]);
var inst_137363__$1 = (state_137385[(2)]);
var inst_137364 = (inst_137363__$1 == null);
var state_137385__$1 = (function (){var statearr_137390 = state_137385;
(statearr_137390[(7)] = inst_137363__$1);

return statearr_137390;
})();
if(cljs.core.truth_(inst_137364)){
var statearr_137391_137525 = state_137385__$1;
(statearr_137391_137525[(1)] = (5));

} else {
var statearr_137392_137526 = state_137385__$1;
(statearr_137392_137526[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137387 === (5))){
var inst_137366 = cljs.core.async.close_BANG_(jobs);
var state_137385__$1 = state_137385;
var statearr_137393_137527 = state_137385__$1;
(statearr_137393_137527[(2)] = inst_137366);

(statearr_137393_137527[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137387 === (6))){
var inst_137368 = (state_137385[(8)]);
var inst_137363 = (state_137385[(7)]);
var inst_137368__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_137369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_137370 = [inst_137363,inst_137368__$1];
var inst_137371 = (new cljs.core.PersistentVector(null,2,(5),inst_137369,inst_137370,null));
var state_137385__$1 = (function (){var statearr_137394 = state_137385;
(statearr_137394[(8)] = inst_137368__$1);

return statearr_137394;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_137385__$1,(8),jobs,inst_137371);
} else {
if((state_val_137387 === (7))){
var inst_137378 = (state_137385[(2)]);
var state_137385__$1 = state_137385;
var statearr_137395_137528 = state_137385__$1;
(statearr_137395_137528[(2)] = inst_137378);

(statearr_137395_137528[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137387 === (8))){
var inst_137368 = (state_137385[(8)]);
var inst_137373 = (state_137385[(2)]);
var state_137385__$1 = (function (){var statearr_137396 = state_137385;
(statearr_137396[(9)] = inst_137373);

return statearr_137396;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_137385__$1,(9),results,inst_137368);
} else {
if((state_val_137387 === (9))){
var inst_137375 = (state_137385[(2)]);
var state_137385__$1 = (function (){var statearr_137397 = state_137385;
(statearr_137397[(10)] = inst_137375);

return statearr_137397;
})();
var statearr_137398_137529 = state_137385__$1;
(statearr_137398_137529[(2)] = null);

(statearr_137398_137529[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__33263__auto___137517,jobs,results,process,async))
;
return ((function (switch__33031__auto__,c__33263__auto___137517,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____0 = (function (){
var statearr_137399 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_137399[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__);

(statearr_137399[(1)] = (1));

return statearr_137399;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____1 = (function (state_137385){
while(true){
var ret_value__33033__auto__ = (function (){try{while(true){
var result__33034__auto__ = switch__33031__auto__(state_137385);
if(cljs.core.keyword_identical_QMARK_(result__33034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33034__auto__;
}
break;
}
}catch (e137400){if((e137400 instanceof Object)){
var ex__33035__auto__ = e137400;
var statearr_137401_137530 = state_137385;
(statearr_137401_137530[(5)] = ex__33035__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_137385);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e137400;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__33033__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__137531 = state_137385;
state_137385 = G__137531;
continue;
} else {
return ret_value__33033__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__ = function(state_137385){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____1.call(this,state_137385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__;
})()
;})(switch__33031__auto__,c__33263__auto___137517,jobs,results,process,async))
})();
var state__33265__auto__ = (function (){var statearr_137404 = (f__33264__auto__.cljs$core$IFn$_invoke$arity$0 ? f__33264__auto__.cljs$core$IFn$_invoke$arity$0() : f__33264__auto__.call(null));
(statearr_137404[(6)] = c__33263__auto___137517);

return statearr_137404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__33265__auto__);
});})(c__33263__auto___137517,jobs,results,process,async))
);


var c__33263__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__33263__auto__,jobs,results,process,async){
return (function (){
var f__33264__auto__ = (function (){var switch__33031__auto__ = ((function (c__33263__auto__,jobs,results,process,async){
return (function (state_137444){
var state_val_137445 = (state_137444[(1)]);
if((state_val_137445 === (7))){
var inst_137440 = (state_137444[(2)]);
var state_137444__$1 = state_137444;
var statearr_137446_137538 = state_137444__$1;
(statearr_137446_137538[(2)] = inst_137440);

(statearr_137446_137538[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137445 === (20))){
var state_137444__$1 = state_137444;
var statearr_137447_137539 = state_137444__$1;
(statearr_137447_137539[(2)] = null);

(statearr_137447_137539[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137445 === (1))){
var state_137444__$1 = state_137444;
var statearr_137448_137540 = state_137444__$1;
(statearr_137448_137540[(2)] = null);

(statearr_137448_137540[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137445 === (4))){
var inst_137407 = (state_137444[(7)]);
var inst_137407__$1 = (state_137444[(2)]);
var inst_137408 = (inst_137407__$1 == null);
var state_137444__$1 = (function (){var statearr_137449 = state_137444;
(statearr_137449[(7)] = inst_137407__$1);

return statearr_137449;
})();
if(cljs.core.truth_(inst_137408)){
var statearr_137450_137541 = state_137444__$1;
(statearr_137450_137541[(1)] = (5));

} else {
var statearr_137451_137542 = state_137444__$1;
(statearr_137451_137542[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137445 === (15))){
var inst_137421 = (state_137444[(8)]);
var state_137444__$1 = state_137444;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_137444__$1,(18),to,inst_137421);
} else {
if((state_val_137445 === (21))){
var inst_137435 = (state_137444[(2)]);
var state_137444__$1 = state_137444;
var statearr_137453_137543 = state_137444__$1;
(statearr_137453_137543[(2)] = inst_137435);

(statearr_137453_137543[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137445 === (13))){
var inst_137437 = (state_137444[(2)]);
var state_137444__$1 = (function (){var statearr_137454 = state_137444;
(statearr_137454[(9)] = inst_137437);

return statearr_137454;
})();
var statearr_137455_137544 = state_137444__$1;
(statearr_137455_137544[(2)] = null);

(statearr_137455_137544[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137445 === (6))){
var inst_137407 = (state_137444[(7)]);
var state_137444__$1 = state_137444;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_137444__$1,(11),inst_137407);
} else {
if((state_val_137445 === (17))){
var inst_137430 = (state_137444[(2)]);
var state_137444__$1 = state_137444;
if(cljs.core.truth_(inst_137430)){
var statearr_137456_137545 = state_137444__$1;
(statearr_137456_137545[(1)] = (19));

} else {
var statearr_137459_137546 = state_137444__$1;
(statearr_137459_137546[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137445 === (3))){
var inst_137442 = (state_137444[(2)]);
var state_137444__$1 = state_137444;
return cljs.core.async.impl.ioc_helpers.return_chan(state_137444__$1,inst_137442);
} else {
if((state_val_137445 === (12))){
var inst_137417 = (state_137444[(10)]);
var state_137444__$1 = state_137444;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_137444__$1,(14),inst_137417);
} else {
if((state_val_137445 === (2))){
var state_137444__$1 = state_137444;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_137444__$1,(4),results);
} else {
if((state_val_137445 === (19))){
var state_137444__$1 = state_137444;
var statearr_137460_137547 = state_137444__$1;
(statearr_137460_137547[(2)] = null);

(statearr_137460_137547[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137445 === (11))){
var inst_137417 = (state_137444[(2)]);
var state_137444__$1 = (function (){var statearr_137461 = state_137444;
(statearr_137461[(10)] = inst_137417);

return statearr_137461;
})();
var statearr_137462_137548 = state_137444__$1;
(statearr_137462_137548[(2)] = null);

(statearr_137462_137548[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137445 === (9))){
var state_137444__$1 = state_137444;
var statearr_137463_137550 = state_137444__$1;
(statearr_137463_137550[(2)] = null);

(statearr_137463_137550[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137445 === (5))){
var state_137444__$1 = state_137444;
if(cljs.core.truth_(close_QMARK_)){
var statearr_137466_137551 = state_137444__$1;
(statearr_137466_137551[(1)] = (8));

} else {
var statearr_137467_137552 = state_137444__$1;
(statearr_137467_137552[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137445 === (14))){
var inst_137424 = (state_137444[(11)]);
var inst_137421 = (state_137444[(8)]);
var inst_137421__$1 = (state_137444[(2)]);
var inst_137423 = (inst_137421__$1 == null);
var inst_137424__$1 = cljs.core.not(inst_137423);
var state_137444__$1 = (function (){var statearr_137468 = state_137444;
(statearr_137468[(11)] = inst_137424__$1);

(statearr_137468[(8)] = inst_137421__$1);

return statearr_137468;
})();
if(inst_137424__$1){
var statearr_137469_137554 = state_137444__$1;
(statearr_137469_137554[(1)] = (15));

} else {
var statearr_137470_137555 = state_137444__$1;
(statearr_137470_137555[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137445 === (16))){
var inst_137424 = (state_137444[(11)]);
var state_137444__$1 = state_137444;
var statearr_137471_137556 = state_137444__$1;
(statearr_137471_137556[(2)] = inst_137424);

(statearr_137471_137556[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137445 === (10))){
var inst_137414 = (state_137444[(2)]);
var state_137444__$1 = state_137444;
var statearr_137472_137557 = state_137444__$1;
(statearr_137472_137557[(2)] = inst_137414);

(statearr_137472_137557[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137445 === (18))){
var inst_137427 = (state_137444[(2)]);
var state_137444__$1 = state_137444;
var statearr_137473_137558 = state_137444__$1;
(statearr_137473_137558[(2)] = inst_137427);

(statearr_137473_137558[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137445 === (8))){
var inst_137411 = cljs.core.async.close_BANG_(to);
var state_137444__$1 = state_137444;
var statearr_137474_137561 = state_137444__$1;
(statearr_137474_137561[(2)] = inst_137411);

(statearr_137474_137561[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33263__auto__,jobs,results,process,async))
;
return ((function (switch__33031__auto__,c__33263__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____0 = (function (){
var statearr_137475 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_137475[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__);

(statearr_137475[(1)] = (1));

return statearr_137475;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____1 = (function (state_137444){
while(true){
var ret_value__33033__auto__ = (function (){try{while(true){
var result__33034__auto__ = switch__33031__auto__(state_137444);
if(cljs.core.keyword_identical_QMARK_(result__33034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33034__auto__;
}
break;
}
}catch (e137476){if((e137476 instanceof Object)){
var ex__33035__auto__ = e137476;
var statearr_137477_137563 = state_137444;
(statearr_137477_137563[(5)] = ex__33035__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_137444);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e137476;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__33033__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__137565 = state_137444;
state_137444 = G__137565;
continue;
} else {
return ret_value__33033__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__ = function(state_137444){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____1.call(this,state_137444);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33032__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33032__auto__;
})()
;})(switch__33031__auto__,c__33263__auto__,jobs,results,process,async))
})();
var state__33265__auto__ = (function (){var statearr_137478 = (f__33264__auto__.cljs$core$IFn$_invoke$arity$0 ? f__33264__auto__.cljs$core$IFn$_invoke$arity$0() : f__33264__auto__.call(null));
(statearr_137478[(6)] = c__33263__auto__);

return statearr_137478;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__33265__auto__);
});})(c__33263__auto__,jobs,results,process,async))
);

return c__33263__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__137567 = arguments.length;
switch (G__137567) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__137581 = arguments.length;
switch (G__137581) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__137588 = arguments.length;
switch (G__137588) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__33263__auto___137638 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__33263__auto___137638,tc,fc){
return (function (){
var f__33264__auto__ = (function (){var switch__33031__auto__ = ((function (c__33263__auto___137638,tc,fc){
return (function (state_137615){
var state_val_137616 = (state_137615[(1)]);
if((state_val_137616 === (7))){
var inst_137611 = (state_137615[(2)]);
var state_137615__$1 = state_137615;
var statearr_137617_137639 = state_137615__$1;
(statearr_137617_137639[(2)] = inst_137611);

(statearr_137617_137639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137616 === (1))){
var state_137615__$1 = state_137615;
var statearr_137618_137643 = state_137615__$1;
(statearr_137618_137643[(2)] = null);

(statearr_137618_137643[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137616 === (4))){
var inst_137592 = (state_137615[(7)]);
var inst_137592__$1 = (state_137615[(2)]);
var inst_137593 = (inst_137592__$1 == null);
var state_137615__$1 = (function (){var statearr_137619 = state_137615;
(statearr_137619[(7)] = inst_137592__$1);

return statearr_137619;
})();
if(cljs.core.truth_(inst_137593)){
var statearr_137620_137644 = state_137615__$1;
(statearr_137620_137644[(1)] = (5));

} else {
var statearr_137621_137646 = state_137615__$1;
(statearr_137621_137646[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137616 === (13))){
var state_137615__$1 = state_137615;
var statearr_137622_137647 = state_137615__$1;
(statearr_137622_137647[(2)] = null);

(statearr_137622_137647[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137616 === (6))){
var inst_137592 = (state_137615[(7)]);
var inst_137598 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_137592) : p.call(null,inst_137592));
var state_137615__$1 = state_137615;
if(cljs.core.truth_(inst_137598)){
var statearr_137623_137648 = state_137615__$1;
(statearr_137623_137648[(1)] = (9));

} else {
var statearr_137624_137650 = state_137615__$1;
(statearr_137624_137650[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137616 === (3))){
var inst_137613 = (state_137615[(2)]);
var state_137615__$1 = state_137615;
return cljs.core.async.impl.ioc_helpers.return_chan(state_137615__$1,inst_137613);
} else {
if((state_val_137616 === (12))){
var state_137615__$1 = state_137615;
var statearr_137625_137651 = state_137615__$1;
(statearr_137625_137651[(2)] = null);

(statearr_137625_137651[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137616 === (2))){
var state_137615__$1 = state_137615;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_137615__$1,(4),ch);
} else {
if((state_val_137616 === (11))){
var inst_137592 = (state_137615[(7)]);
var inst_137602 = (state_137615[(2)]);
var state_137615__$1 = state_137615;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_137615__$1,(8),inst_137602,inst_137592);
} else {
if((state_val_137616 === (9))){
var state_137615__$1 = state_137615;
var statearr_137626_137656 = state_137615__$1;
(statearr_137626_137656[(2)] = tc);

(statearr_137626_137656[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137616 === (5))){
var inst_137595 = cljs.core.async.close_BANG_(tc);
var inst_137596 = cljs.core.async.close_BANG_(fc);
var state_137615__$1 = (function (){var statearr_137627 = state_137615;
(statearr_137627[(8)] = inst_137595);

return statearr_137627;
})();
var statearr_137628_137658 = state_137615__$1;
(statearr_137628_137658[(2)] = inst_137596);

(statearr_137628_137658[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137616 === (14))){
var inst_137609 = (state_137615[(2)]);
var state_137615__$1 = state_137615;
var statearr_137629_137659 = state_137615__$1;
(statearr_137629_137659[(2)] = inst_137609);

(statearr_137629_137659[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137616 === (10))){
var state_137615__$1 = state_137615;
var statearr_137630_137660 = state_137615__$1;
(statearr_137630_137660[(2)] = fc);

(statearr_137630_137660[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137616 === (8))){
var inst_137604 = (state_137615[(2)]);
var state_137615__$1 = state_137615;
if(cljs.core.truth_(inst_137604)){
var statearr_137631_137661 = state_137615__$1;
(statearr_137631_137661[(1)] = (12));

} else {
var statearr_137632_137662 = state_137615__$1;
(statearr_137632_137662[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33263__auto___137638,tc,fc))
;
return ((function (switch__33031__auto__,c__33263__auto___137638,tc,fc){
return (function() {
var cljs$core$async$state_machine__33032__auto__ = null;
var cljs$core$async$state_machine__33032__auto____0 = (function (){
var statearr_137633 = [null,null,null,null,null,null,null,null,null];
(statearr_137633[(0)] = cljs$core$async$state_machine__33032__auto__);

(statearr_137633[(1)] = (1));

return statearr_137633;
});
var cljs$core$async$state_machine__33032__auto____1 = (function (state_137615){
while(true){
var ret_value__33033__auto__ = (function (){try{while(true){
var result__33034__auto__ = switch__33031__auto__(state_137615);
if(cljs.core.keyword_identical_QMARK_(result__33034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33034__auto__;
}
break;
}
}catch (e137634){if((e137634 instanceof Object)){
var ex__33035__auto__ = e137634;
var statearr_137635_137663 = state_137615;
(statearr_137635_137663[(5)] = ex__33035__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_137615);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e137634;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__33033__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__137664 = state_137615;
state_137615 = G__137664;
continue;
} else {
return ret_value__33033__auto__;
}
break;
}
});
cljs$core$async$state_machine__33032__auto__ = function(state_137615){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33032__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33032__auto____1.call(this,state_137615);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33032__auto____0;
cljs$core$async$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33032__auto____1;
return cljs$core$async$state_machine__33032__auto__;
})()
;})(switch__33031__auto__,c__33263__auto___137638,tc,fc))
})();
var state__33265__auto__ = (function (){var statearr_137636 = (f__33264__auto__.cljs$core$IFn$_invoke$arity$0 ? f__33264__auto__.cljs$core$IFn$_invoke$arity$0() : f__33264__auto__.call(null));
(statearr_137636[(6)] = c__33263__auto___137638);

return statearr_137636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__33265__auto__);
});})(c__33263__auto___137638,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__33263__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__33263__auto__){
return (function (){
var f__33264__auto__ = (function (){var switch__33031__auto__ = ((function (c__33263__auto__){
return (function (state_137685){
var state_val_137686 = (state_137685[(1)]);
if((state_val_137686 === (7))){
var inst_137681 = (state_137685[(2)]);
var state_137685__$1 = state_137685;
var statearr_137687_137711 = state_137685__$1;
(statearr_137687_137711[(2)] = inst_137681);

(statearr_137687_137711[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137686 === (1))){
var inst_137665 = init;
var state_137685__$1 = (function (){var statearr_137694 = state_137685;
(statearr_137694[(7)] = inst_137665);

return statearr_137694;
})();
var statearr_137695_137713 = state_137685__$1;
(statearr_137695_137713[(2)] = null);

(statearr_137695_137713[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137686 === (4))){
var inst_137668 = (state_137685[(8)]);
var inst_137668__$1 = (state_137685[(2)]);
var inst_137669 = (inst_137668__$1 == null);
var state_137685__$1 = (function (){var statearr_137696 = state_137685;
(statearr_137696[(8)] = inst_137668__$1);

return statearr_137696;
})();
if(cljs.core.truth_(inst_137669)){
var statearr_137697_137714 = state_137685__$1;
(statearr_137697_137714[(1)] = (5));

} else {
var statearr_137698_137715 = state_137685__$1;
(statearr_137698_137715[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137686 === (6))){
var inst_137665 = (state_137685[(7)]);
var inst_137668 = (state_137685[(8)]);
var inst_137672 = (state_137685[(9)]);
var inst_137672__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_137665,inst_137668) : f.call(null,inst_137665,inst_137668));
var inst_137673 = cljs.core.reduced_QMARK_(inst_137672__$1);
var state_137685__$1 = (function (){var statearr_137699 = state_137685;
(statearr_137699[(9)] = inst_137672__$1);

return statearr_137699;
})();
if(inst_137673){
var statearr_137700_137716 = state_137685__$1;
(statearr_137700_137716[(1)] = (8));

} else {
var statearr_137701_137717 = state_137685__$1;
(statearr_137701_137717[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137686 === (3))){
var inst_137683 = (state_137685[(2)]);
var state_137685__$1 = state_137685;
return cljs.core.async.impl.ioc_helpers.return_chan(state_137685__$1,inst_137683);
} else {
if((state_val_137686 === (2))){
var state_137685__$1 = state_137685;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_137685__$1,(4),ch);
} else {
if((state_val_137686 === (9))){
var inst_137672 = (state_137685[(9)]);
var inst_137665 = inst_137672;
var state_137685__$1 = (function (){var statearr_137702 = state_137685;
(statearr_137702[(7)] = inst_137665);

return statearr_137702;
})();
var statearr_137703_137719 = state_137685__$1;
(statearr_137703_137719[(2)] = null);

(statearr_137703_137719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137686 === (5))){
var inst_137665 = (state_137685[(7)]);
var state_137685__$1 = state_137685;
var statearr_137704_137720 = state_137685__$1;
(statearr_137704_137720[(2)] = inst_137665);

(statearr_137704_137720[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137686 === (10))){
var inst_137679 = (state_137685[(2)]);
var state_137685__$1 = state_137685;
var statearr_137705_137721 = state_137685__$1;
(statearr_137705_137721[(2)] = inst_137679);

(statearr_137705_137721[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137686 === (8))){
var inst_137672 = (state_137685[(9)]);
var inst_137675 = cljs.core.deref(inst_137672);
var state_137685__$1 = state_137685;
var statearr_137706_137722 = state_137685__$1;
(statearr_137706_137722[(2)] = inst_137675);

(statearr_137706_137722[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__33263__auto__))
;
return ((function (switch__33031__auto__,c__33263__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__33032__auto__ = null;
var cljs$core$async$reduce_$_state_machine__33032__auto____0 = (function (){
var statearr_137707 = [null,null,null,null,null,null,null,null,null,null];
(statearr_137707[(0)] = cljs$core$async$reduce_$_state_machine__33032__auto__);

(statearr_137707[(1)] = (1));

return statearr_137707;
});
var cljs$core$async$reduce_$_state_machine__33032__auto____1 = (function (state_137685){
while(true){
var ret_value__33033__auto__ = (function (){try{while(true){
var result__33034__auto__ = switch__33031__auto__(state_137685);
if(cljs.core.keyword_identical_QMARK_(result__33034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33034__auto__;
}
break;
}
}catch (e137708){if((e137708 instanceof Object)){
var ex__33035__auto__ = e137708;
var statearr_137709_137723 = state_137685;
(statearr_137709_137723[(5)] = ex__33035__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_137685);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e137708;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__33033__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__137724 = state_137685;
state_137685 = G__137724;
continue;
} else {
return ret_value__33033__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__33032__auto__ = function(state_137685){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__33032__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__33032__auto____1.call(this,state_137685);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__33032__auto____0;
cljs$core$async$reduce_$_state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__33032__auto____1;
return cljs$core$async$reduce_$_state_machine__33032__auto__;
})()
;})(switch__33031__auto__,c__33263__auto__))
})();
var state__33265__auto__ = (function (){var statearr_137710 = (f__33264__auto__.cljs$core$IFn$_invoke$arity$0 ? f__33264__auto__.cljs$core$IFn$_invoke$arity$0() : f__33264__auto__.call(null));
(statearr_137710[(6)] = c__33263__auto__);

return statearr_137710;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__33265__auto__);
});})(c__33263__auto__))
);

return c__33263__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__33263__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__33263__auto__,f__$1){
return (function (){
var f__33264__auto__ = (function (){var switch__33031__auto__ = ((function (c__33263__auto__,f__$1){
return (function (state_137730){
var state_val_137731 = (state_137730[(1)]);
if((state_val_137731 === (1))){
var inst_137725 = cljs.core.async.reduce(f__$1,init,ch);
var state_137730__$1 = state_137730;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_137730__$1,(2),inst_137725);
} else {
if((state_val_137731 === (2))){
var inst_137727 = (state_137730[(2)]);
var inst_137728 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_137727) : f__$1.call(null,inst_137727));
var state_137730__$1 = state_137730;
return cljs.core.async.impl.ioc_helpers.return_chan(state_137730__$1,inst_137728);
} else {
return null;
}
}
});})(c__33263__auto__,f__$1))
;
return ((function (switch__33031__auto__,c__33263__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__33032__auto__ = null;
var cljs$core$async$transduce_$_state_machine__33032__auto____0 = (function (){
var statearr_137732 = [null,null,null,null,null,null,null];
(statearr_137732[(0)] = cljs$core$async$transduce_$_state_machine__33032__auto__);

(statearr_137732[(1)] = (1));

return statearr_137732;
});
var cljs$core$async$transduce_$_state_machine__33032__auto____1 = (function (state_137730){
while(true){
var ret_value__33033__auto__ = (function (){try{while(true){
var result__33034__auto__ = switch__33031__auto__(state_137730);
if(cljs.core.keyword_identical_QMARK_(result__33034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33034__auto__;
}
break;
}
}catch (e137733){if((e137733 instanceof Object)){
var ex__33035__auto__ = e137733;
var statearr_137734_137736 = state_137730;
(statearr_137734_137736[(5)] = ex__33035__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_137730);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e137733;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__33033__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__137737 = state_137730;
state_137730 = G__137737;
continue;
} else {
return ret_value__33033__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__33032__auto__ = function(state_137730){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__33032__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__33032__auto____1.call(this,state_137730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__33032__auto____0;
cljs$core$async$transduce_$_state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__33032__auto____1;
return cljs$core$async$transduce_$_state_machine__33032__auto__;
})()
;})(switch__33031__auto__,c__33263__auto__,f__$1))
})();
var state__33265__auto__ = (function (){var statearr_137735 = (f__33264__auto__.cljs$core$IFn$_invoke$arity$0 ? f__33264__auto__.cljs$core$IFn$_invoke$arity$0() : f__33264__auto__.call(null));
(statearr_137735[(6)] = c__33263__auto__);

return statearr_137735;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__33265__auto__);
});})(c__33263__auto__,f__$1))
);

return c__33263__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__137746 = arguments.length;
switch (G__137746) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__33263__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__33263__auto__){
return (function (){
var f__33264__auto__ = (function (){var switch__33031__auto__ = ((function (c__33263__auto__){
return (function (state_137771){
var state_val_137772 = (state_137771[(1)]);
if((state_val_137772 === (7))){
var inst_137753 = (state_137771[(2)]);
var state_137771__$1 = state_137771;
var statearr_137773_137811 = state_137771__$1;
(statearr_137773_137811[(2)] = inst_137753);

(statearr_137773_137811[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137772 === (1))){
var inst_137747 = cljs.core.seq(coll);
var inst_137748 = inst_137747;
var state_137771__$1 = (function (){var statearr_137774 = state_137771;
(statearr_137774[(7)] = inst_137748);

return statearr_137774;
})();
var statearr_137775_137816 = state_137771__$1;
(statearr_137775_137816[(2)] = null);

(statearr_137775_137816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137772 === (4))){
var inst_137748 = (state_137771[(7)]);
var inst_137751 = cljs.core.first(inst_137748);
var state_137771__$1 = state_137771;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_137771__$1,(7),ch,inst_137751);
} else {
if((state_val_137772 === (13))){
var inst_137765 = (state_137771[(2)]);
var state_137771__$1 = state_137771;
var statearr_137783_137820 = state_137771__$1;
(statearr_137783_137820[(2)] = inst_137765);

(statearr_137783_137820[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137772 === (6))){
var inst_137756 = (state_137771[(2)]);
var state_137771__$1 = state_137771;
if(cljs.core.truth_(inst_137756)){
var statearr_137790_137821 = state_137771__$1;
(statearr_137790_137821[(1)] = (8));

} else {
var statearr_137791_137822 = state_137771__$1;
(statearr_137791_137822[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137772 === (3))){
var inst_137769 = (state_137771[(2)]);
var state_137771__$1 = state_137771;
return cljs.core.async.impl.ioc_helpers.return_chan(state_137771__$1,inst_137769);
} else {
if((state_val_137772 === (12))){
var state_137771__$1 = state_137771;
var statearr_137792_137823 = state_137771__$1;
(statearr_137792_137823[(2)] = null);

(statearr_137792_137823[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137772 === (2))){
var inst_137748 = (state_137771[(7)]);
var state_137771__$1 = state_137771;
if(cljs.core.truth_(inst_137748)){
var statearr_137793_137826 = state_137771__$1;
(statearr_137793_137826[(1)] = (4));

} else {
var statearr_137794_137827 = state_137771__$1;
(statearr_137794_137827[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137772 === (11))){
var inst_137762 = cljs.core.async.close_BANG_(ch);
var state_137771__$1 = state_137771;
var statearr_137795_137828 = state_137771__$1;
(statearr_137795_137828[(2)] = inst_137762);

(statearr_137795_137828[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137772 === (9))){
var state_137771__$1 = state_137771;
if(cljs.core.truth_(close_QMARK_)){
var statearr_137796_137830 = state_137771__$1;
(statearr_137796_137830[(1)] = (11));

} else {
var statearr_137797_137831 = state_137771__$1;
(statearr_137797_137831[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137772 === (5))){
var inst_137748 = (state_137771[(7)]);
var state_137771__$1 = state_137771;
var statearr_137798_137832 = state_137771__$1;
(statearr_137798_137832[(2)] = inst_137748);

(statearr_137798_137832[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137772 === (10))){
var inst_137767 = (state_137771[(2)]);
var state_137771__$1 = state_137771;
var statearr_137799_137833 = state_137771__$1;
(statearr_137799_137833[(2)] = inst_137767);

(statearr_137799_137833[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137772 === (8))){
var inst_137748 = (state_137771[(7)]);
var inst_137758 = cljs.core.next(inst_137748);
var inst_137748__$1 = inst_137758;
var state_137771__$1 = (function (){var statearr_137800 = state_137771;
(statearr_137800[(7)] = inst_137748__$1);

return statearr_137800;
})();
var statearr_137801_137834 = state_137771__$1;
(statearr_137801_137834[(2)] = null);

(statearr_137801_137834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33263__auto__))
;
return ((function (switch__33031__auto__,c__33263__auto__){
return (function() {
var cljs$core$async$state_machine__33032__auto__ = null;
var cljs$core$async$state_machine__33032__auto____0 = (function (){
var statearr_137802 = [null,null,null,null,null,null,null,null];
(statearr_137802[(0)] = cljs$core$async$state_machine__33032__auto__);

(statearr_137802[(1)] = (1));

return statearr_137802;
});
var cljs$core$async$state_machine__33032__auto____1 = (function (state_137771){
while(true){
var ret_value__33033__auto__ = (function (){try{while(true){
var result__33034__auto__ = switch__33031__auto__(state_137771);
if(cljs.core.keyword_identical_QMARK_(result__33034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33034__auto__;
}
break;
}
}catch (e137803){if((e137803 instanceof Object)){
var ex__33035__auto__ = e137803;
var statearr_137804_137835 = state_137771;
(statearr_137804_137835[(5)] = ex__33035__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_137771);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e137803;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__33033__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__137836 = state_137771;
state_137771 = G__137836;
continue;
} else {
return ret_value__33033__auto__;
}
break;
}
});
cljs$core$async$state_machine__33032__auto__ = function(state_137771){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33032__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33032__auto____1.call(this,state_137771);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33032__auto____0;
cljs$core$async$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33032__auto____1;
return cljs$core$async$state_machine__33032__auto__;
})()
;})(switch__33031__auto__,c__33263__auto__))
})();
var state__33265__auto__ = (function (){var statearr_137805 = (f__33264__auto__.cljs$core$IFn$_invoke$arity$0 ? f__33264__auto__.cljs$core$IFn$_invoke$arity$0() : f__33264__auto__.call(null));
(statearr_137805[(6)] = c__33263__auto__);

return statearr_137805;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__33265__auto__);
});})(c__33263__auto__))
);

return c__33263__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if(((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4244__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4244__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4244__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto__.call(null,m,ch));
} else {
var m__4244__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4244__auto__.call(null,m));
} else {
var m__4244__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__4244__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async137857 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async137857 = (function (ch,cs,meta137858){
this.ch = ch;
this.cs = cs;
this.meta137858 = meta137858;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async137857.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_137859,meta137858__$1){
var self__ = this;
var _137859__$1 = this;
return (new cljs.core.async.t_cljs$core$async137857(self__.ch,self__.cs,meta137858__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async137857.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_137859){
var self__ = this;
var _137859__$1 = this;
return self__.meta137858;
});})(cs))
;

cljs.core.async.t_cljs$core$async137857.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async137857.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async137857.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async137857.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async137857.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async137857.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async137857.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta137858","meta137858",766859028,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async137857.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async137857.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async137857";

cljs.core.async.t_cljs$core$async137857.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async137857");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async137857.
 */
cljs.core.async.__GT_t_cljs$core$async137857 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async137857(ch__$1,cs__$1,meta137858){
return (new cljs.core.async.t_cljs$core$async137857(ch__$1,cs__$1,meta137858));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async137857(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__33263__auto___138096 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__33263__auto___138096,cs,m,dchan,dctr,done){
return (function (){
var f__33264__auto__ = (function (){var switch__33031__auto__ = ((function (c__33263__auto___138096,cs,m,dchan,dctr,done){
return (function (state_137998){
var state_val_137999 = (state_137998[(1)]);
if((state_val_137999 === (7))){
var inst_137994 = (state_137998[(2)]);
var state_137998__$1 = state_137998;
var statearr_138000_138098 = state_137998__$1;
(statearr_138000_138098[(2)] = inst_137994);

(statearr_138000_138098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (20))){
var inst_137893 = (state_137998[(7)]);
var inst_137907 = cljs.core.first(inst_137893);
var inst_137908 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_137907,(0),null);
var inst_137909 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_137907,(1),null);
var state_137998__$1 = (function (){var statearr_138001 = state_137998;
(statearr_138001[(8)] = inst_137908);

return statearr_138001;
})();
if(cljs.core.truth_(inst_137909)){
var statearr_138002_138100 = state_137998__$1;
(statearr_138002_138100[(1)] = (22));

} else {
var statearr_138003_138101 = state_137998__$1;
(statearr_138003_138101[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (27))){
var inst_137939 = (state_137998[(9)]);
var inst_137937 = (state_137998[(10)]);
var inst_137944 = (state_137998[(11)]);
var inst_137862 = (state_137998[(12)]);
var inst_137944__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_137937,inst_137939);
var inst_137945 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_137944__$1,inst_137862,done);
var state_137998__$1 = (function (){var statearr_138005 = state_137998;
(statearr_138005[(11)] = inst_137944__$1);

return statearr_138005;
})();
if(cljs.core.truth_(inst_137945)){
var statearr_138006_138102 = state_137998__$1;
(statearr_138006_138102[(1)] = (30));

} else {
var statearr_138008_138103 = state_137998__$1;
(statearr_138008_138103[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (1))){
var state_137998__$1 = state_137998;
var statearr_138009_138104 = state_137998__$1;
(statearr_138009_138104[(2)] = null);

(statearr_138009_138104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (24))){
var inst_137893 = (state_137998[(7)]);
var inst_137914 = (state_137998[(2)]);
var inst_137915 = cljs.core.next(inst_137893);
var inst_137871 = inst_137915;
var inst_137872 = null;
var inst_137873 = (0);
var inst_137874 = (0);
var state_137998__$1 = (function (){var statearr_138011 = state_137998;
(statearr_138011[(13)] = inst_137871);

(statearr_138011[(14)] = inst_137914);

(statearr_138011[(15)] = inst_137873);

(statearr_138011[(16)] = inst_137874);

(statearr_138011[(17)] = inst_137872);

return statearr_138011;
})();
var statearr_138012_138108 = state_137998__$1;
(statearr_138012_138108[(2)] = null);

(statearr_138012_138108[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (39))){
var state_137998__$1 = state_137998;
var statearr_138016_138109 = state_137998__$1;
(statearr_138016_138109[(2)] = null);

(statearr_138016_138109[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (4))){
var inst_137862 = (state_137998[(12)]);
var inst_137862__$1 = (state_137998[(2)]);
var inst_137863 = (inst_137862__$1 == null);
var state_137998__$1 = (function (){var statearr_138017 = state_137998;
(statearr_138017[(12)] = inst_137862__$1);

return statearr_138017;
})();
if(cljs.core.truth_(inst_137863)){
var statearr_138018_138110 = state_137998__$1;
(statearr_138018_138110[(1)] = (5));

} else {
var statearr_138019_138111 = state_137998__$1;
(statearr_138019_138111[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (15))){
var inst_137871 = (state_137998[(13)]);
var inst_137873 = (state_137998[(15)]);
var inst_137874 = (state_137998[(16)]);
var inst_137872 = (state_137998[(17)]);
var inst_137889 = (state_137998[(2)]);
var inst_137890 = (inst_137874 + (1));
var tmp138013 = inst_137871;
var tmp138014 = inst_137873;
var tmp138015 = inst_137872;
var inst_137871__$1 = tmp138013;
var inst_137872__$1 = tmp138015;
var inst_137873__$1 = tmp138014;
var inst_137874__$1 = inst_137890;
var state_137998__$1 = (function (){var statearr_138020 = state_137998;
(statearr_138020[(18)] = inst_137889);

(statearr_138020[(13)] = inst_137871__$1);

(statearr_138020[(15)] = inst_137873__$1);

(statearr_138020[(16)] = inst_137874__$1);

(statearr_138020[(17)] = inst_137872__$1);

return statearr_138020;
})();
var statearr_138021_138112 = state_137998__$1;
(statearr_138021_138112[(2)] = null);

(statearr_138021_138112[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (21))){
var inst_137918 = (state_137998[(2)]);
var state_137998__$1 = state_137998;
var statearr_138025_138113 = state_137998__$1;
(statearr_138025_138113[(2)] = inst_137918);

(statearr_138025_138113[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (31))){
var inst_137944 = (state_137998[(11)]);
var inst_137948 = done(null);
var inst_137949 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_137944);
var state_137998__$1 = (function (){var statearr_138026 = state_137998;
(statearr_138026[(19)] = inst_137948);

return statearr_138026;
})();
var statearr_138027_138114 = state_137998__$1;
(statearr_138027_138114[(2)] = inst_137949);

(statearr_138027_138114[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (32))){
var inst_137939 = (state_137998[(9)]);
var inst_137938 = (state_137998[(20)]);
var inst_137937 = (state_137998[(10)]);
var inst_137936 = (state_137998[(21)]);
var inst_137951 = (state_137998[(2)]);
var inst_137952 = (inst_137939 + (1));
var tmp138022 = inst_137938;
var tmp138023 = inst_137937;
var tmp138024 = inst_137936;
var inst_137936__$1 = tmp138024;
var inst_137937__$1 = tmp138023;
var inst_137938__$1 = tmp138022;
var inst_137939__$1 = inst_137952;
var state_137998__$1 = (function (){var statearr_138028 = state_137998;
(statearr_138028[(22)] = inst_137951);

(statearr_138028[(9)] = inst_137939__$1);

(statearr_138028[(20)] = inst_137938__$1);

(statearr_138028[(10)] = inst_137937__$1);

(statearr_138028[(21)] = inst_137936__$1);

return statearr_138028;
})();
var statearr_138029_138115 = state_137998__$1;
(statearr_138029_138115[(2)] = null);

(statearr_138029_138115[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (40))){
var inst_137966 = (state_137998[(23)]);
var inst_137970 = done(null);
var inst_137971 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_137966);
var state_137998__$1 = (function (){var statearr_138030 = state_137998;
(statearr_138030[(24)] = inst_137970);

return statearr_138030;
})();
var statearr_138031_138116 = state_137998__$1;
(statearr_138031_138116[(2)] = inst_137971);

(statearr_138031_138116[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (33))){
var inst_137955 = (state_137998[(25)]);
var inst_137959 = cljs.core.chunked_seq_QMARK_(inst_137955);
var state_137998__$1 = state_137998;
if(inst_137959){
var statearr_138032_138117 = state_137998__$1;
(statearr_138032_138117[(1)] = (36));

} else {
var statearr_138033_138118 = state_137998__$1;
(statearr_138033_138118[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (13))){
var inst_137883 = (state_137998[(26)]);
var inst_137886 = cljs.core.async.close_BANG_(inst_137883);
var state_137998__$1 = state_137998;
var statearr_138034_138119 = state_137998__$1;
(statearr_138034_138119[(2)] = inst_137886);

(statearr_138034_138119[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (22))){
var inst_137908 = (state_137998[(8)]);
var inst_137911 = cljs.core.async.close_BANG_(inst_137908);
var state_137998__$1 = state_137998;
var statearr_138035_138120 = state_137998__$1;
(statearr_138035_138120[(2)] = inst_137911);

(statearr_138035_138120[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (36))){
var inst_137955 = (state_137998[(25)]);
var inst_137961 = cljs.core.chunk_first(inst_137955);
var inst_137962 = cljs.core.chunk_rest(inst_137955);
var inst_137963 = cljs.core.count(inst_137961);
var inst_137936 = inst_137962;
var inst_137937 = inst_137961;
var inst_137938 = inst_137963;
var inst_137939 = (0);
var state_137998__$1 = (function (){var statearr_138036 = state_137998;
(statearr_138036[(9)] = inst_137939);

(statearr_138036[(20)] = inst_137938);

(statearr_138036[(10)] = inst_137937);

(statearr_138036[(21)] = inst_137936);

return statearr_138036;
})();
var statearr_138037_138121 = state_137998__$1;
(statearr_138037_138121[(2)] = null);

(statearr_138037_138121[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (41))){
var inst_137955 = (state_137998[(25)]);
var inst_137973 = (state_137998[(2)]);
var inst_137974 = cljs.core.next(inst_137955);
var inst_137936 = inst_137974;
var inst_137937 = null;
var inst_137938 = (0);
var inst_137939 = (0);
var state_137998__$1 = (function (){var statearr_138038 = state_137998;
(statearr_138038[(9)] = inst_137939);

(statearr_138038[(20)] = inst_137938);

(statearr_138038[(10)] = inst_137937);

(statearr_138038[(27)] = inst_137973);

(statearr_138038[(21)] = inst_137936);

return statearr_138038;
})();
var statearr_138039_138122 = state_137998__$1;
(statearr_138039_138122[(2)] = null);

(statearr_138039_138122[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (43))){
var state_137998__$1 = state_137998;
var statearr_138042_138123 = state_137998__$1;
(statearr_138042_138123[(2)] = null);

(statearr_138042_138123[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (29))){
var inst_137982 = (state_137998[(2)]);
var state_137998__$1 = state_137998;
var statearr_138045_138124 = state_137998__$1;
(statearr_138045_138124[(2)] = inst_137982);

(statearr_138045_138124[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (44))){
var inst_137991 = (state_137998[(2)]);
var state_137998__$1 = (function (){var statearr_138046 = state_137998;
(statearr_138046[(28)] = inst_137991);

return statearr_138046;
})();
var statearr_138047_138125 = state_137998__$1;
(statearr_138047_138125[(2)] = null);

(statearr_138047_138125[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (6))){
var inst_137928 = (state_137998[(29)]);
var inst_137927 = cljs.core.deref(cs);
var inst_137928__$1 = cljs.core.keys(inst_137927);
var inst_137929 = cljs.core.count(inst_137928__$1);
var inst_137930 = cljs.core.reset_BANG_(dctr,inst_137929);
var inst_137935 = cljs.core.seq(inst_137928__$1);
var inst_137936 = inst_137935;
var inst_137937 = null;
var inst_137938 = (0);
var inst_137939 = (0);
var state_137998__$1 = (function (){var statearr_138049 = state_137998;
(statearr_138049[(9)] = inst_137939);

(statearr_138049[(20)] = inst_137938);

(statearr_138049[(10)] = inst_137937);

(statearr_138049[(30)] = inst_137930);

(statearr_138049[(21)] = inst_137936);

(statearr_138049[(29)] = inst_137928__$1);

return statearr_138049;
})();
var statearr_138050_138126 = state_137998__$1;
(statearr_138050_138126[(2)] = null);

(statearr_138050_138126[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (28))){
var inst_137955 = (state_137998[(25)]);
var inst_137936 = (state_137998[(21)]);
var inst_137955__$1 = cljs.core.seq(inst_137936);
var state_137998__$1 = (function (){var statearr_138051 = state_137998;
(statearr_138051[(25)] = inst_137955__$1);

return statearr_138051;
})();
if(inst_137955__$1){
var statearr_138052_138129 = state_137998__$1;
(statearr_138052_138129[(1)] = (33));

} else {
var statearr_138053_138130 = state_137998__$1;
(statearr_138053_138130[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (25))){
var inst_137939 = (state_137998[(9)]);
var inst_137938 = (state_137998[(20)]);
var inst_137941 = (inst_137939 < inst_137938);
var inst_137942 = inst_137941;
var state_137998__$1 = state_137998;
if(cljs.core.truth_(inst_137942)){
var statearr_138054_138132 = state_137998__$1;
(statearr_138054_138132[(1)] = (27));

} else {
var statearr_138055_138133 = state_137998__$1;
(statearr_138055_138133[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (34))){
var state_137998__$1 = state_137998;
var statearr_138056_138134 = state_137998__$1;
(statearr_138056_138134[(2)] = null);

(statearr_138056_138134[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (17))){
var state_137998__$1 = state_137998;
var statearr_138057_138135 = state_137998__$1;
(statearr_138057_138135[(2)] = null);

(statearr_138057_138135[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (3))){
var inst_137996 = (state_137998[(2)]);
var state_137998__$1 = state_137998;
return cljs.core.async.impl.ioc_helpers.return_chan(state_137998__$1,inst_137996);
} else {
if((state_val_137999 === (12))){
var inst_137923 = (state_137998[(2)]);
var state_137998__$1 = state_137998;
var statearr_138058_138137 = state_137998__$1;
(statearr_138058_138137[(2)] = inst_137923);

(statearr_138058_138137[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (2))){
var state_137998__$1 = state_137998;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_137998__$1,(4),ch);
} else {
if((state_val_137999 === (23))){
var state_137998__$1 = state_137998;
var statearr_138059_138138 = state_137998__$1;
(statearr_138059_138138[(2)] = null);

(statearr_138059_138138[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (35))){
var inst_137980 = (state_137998[(2)]);
var state_137998__$1 = state_137998;
var statearr_138060_138139 = state_137998__$1;
(statearr_138060_138139[(2)] = inst_137980);

(statearr_138060_138139[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (19))){
var inst_137893 = (state_137998[(7)]);
var inst_137899 = cljs.core.chunk_first(inst_137893);
var inst_137900 = cljs.core.chunk_rest(inst_137893);
var inst_137901 = cljs.core.count(inst_137899);
var inst_137871 = inst_137900;
var inst_137872 = inst_137899;
var inst_137873 = inst_137901;
var inst_137874 = (0);
var state_137998__$1 = (function (){var statearr_138061 = state_137998;
(statearr_138061[(13)] = inst_137871);

(statearr_138061[(15)] = inst_137873);

(statearr_138061[(16)] = inst_137874);

(statearr_138061[(17)] = inst_137872);

return statearr_138061;
})();
var statearr_138062_138140 = state_137998__$1;
(statearr_138062_138140[(2)] = null);

(statearr_138062_138140[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (11))){
var inst_137893 = (state_137998[(7)]);
var inst_137871 = (state_137998[(13)]);
var inst_137893__$1 = cljs.core.seq(inst_137871);
var state_137998__$1 = (function (){var statearr_138063 = state_137998;
(statearr_138063[(7)] = inst_137893__$1);

return statearr_138063;
})();
if(inst_137893__$1){
var statearr_138064_138142 = state_137998__$1;
(statearr_138064_138142[(1)] = (16));

} else {
var statearr_138065_138143 = state_137998__$1;
(statearr_138065_138143[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (9))){
var inst_137925 = (state_137998[(2)]);
var state_137998__$1 = state_137998;
var statearr_138066_138145 = state_137998__$1;
(statearr_138066_138145[(2)] = inst_137925);

(statearr_138066_138145[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (5))){
var inst_137869 = cljs.core.deref(cs);
var inst_137870 = cljs.core.seq(inst_137869);
var inst_137871 = inst_137870;
var inst_137872 = null;
var inst_137873 = (0);
var inst_137874 = (0);
var state_137998__$1 = (function (){var statearr_138067 = state_137998;
(statearr_138067[(13)] = inst_137871);

(statearr_138067[(15)] = inst_137873);

(statearr_138067[(16)] = inst_137874);

(statearr_138067[(17)] = inst_137872);

return statearr_138067;
})();
var statearr_138068_138146 = state_137998__$1;
(statearr_138068_138146[(2)] = null);

(statearr_138068_138146[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (14))){
var state_137998__$1 = state_137998;
var statearr_138070_138147 = state_137998__$1;
(statearr_138070_138147[(2)] = null);

(statearr_138070_138147[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (45))){
var inst_137988 = (state_137998[(2)]);
var state_137998__$1 = state_137998;
var statearr_138071_138150 = state_137998__$1;
(statearr_138071_138150[(2)] = inst_137988);

(statearr_138071_138150[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (26))){
var inst_137928 = (state_137998[(29)]);
var inst_137984 = (state_137998[(2)]);
var inst_137985 = cljs.core.seq(inst_137928);
var state_137998__$1 = (function (){var statearr_138072 = state_137998;
(statearr_138072[(31)] = inst_137984);

return statearr_138072;
})();
if(inst_137985){
var statearr_138073_138152 = state_137998__$1;
(statearr_138073_138152[(1)] = (42));

} else {
var statearr_138074_138153 = state_137998__$1;
(statearr_138074_138153[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (16))){
var inst_137893 = (state_137998[(7)]);
var inst_137897 = cljs.core.chunked_seq_QMARK_(inst_137893);
var state_137998__$1 = state_137998;
if(inst_137897){
var statearr_138075_138154 = state_137998__$1;
(statearr_138075_138154[(1)] = (19));

} else {
var statearr_138076_138155 = state_137998__$1;
(statearr_138076_138155[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (38))){
var inst_137977 = (state_137998[(2)]);
var state_137998__$1 = state_137998;
var statearr_138077_138156 = state_137998__$1;
(statearr_138077_138156[(2)] = inst_137977);

(statearr_138077_138156[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (30))){
var state_137998__$1 = state_137998;
var statearr_138078_138158 = state_137998__$1;
(statearr_138078_138158[(2)] = null);

(statearr_138078_138158[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (10))){
var inst_137874 = (state_137998[(16)]);
var inst_137872 = (state_137998[(17)]);
var inst_137882 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_137872,inst_137874);
var inst_137883 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_137882,(0),null);
var inst_137884 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_137882,(1),null);
var state_137998__$1 = (function (){var statearr_138080 = state_137998;
(statearr_138080[(26)] = inst_137883);

return statearr_138080;
})();
if(cljs.core.truth_(inst_137884)){
var statearr_138081_138159 = state_137998__$1;
(statearr_138081_138159[(1)] = (13));

} else {
var statearr_138083_138160 = state_137998__$1;
(statearr_138083_138160[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (18))){
var inst_137921 = (state_137998[(2)]);
var state_137998__$1 = state_137998;
var statearr_138084_138161 = state_137998__$1;
(statearr_138084_138161[(2)] = inst_137921);

(statearr_138084_138161[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (42))){
var state_137998__$1 = state_137998;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_137998__$1,(45),dchan);
} else {
if((state_val_137999 === (37))){
var inst_137955 = (state_137998[(25)]);
var inst_137966 = (state_137998[(23)]);
var inst_137862 = (state_137998[(12)]);
var inst_137966__$1 = cljs.core.first(inst_137955);
var inst_137967 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_137966__$1,inst_137862,done);
var state_137998__$1 = (function (){var statearr_138085 = state_137998;
(statearr_138085[(23)] = inst_137966__$1);

return statearr_138085;
})();
if(cljs.core.truth_(inst_137967)){
var statearr_138086_138162 = state_137998__$1;
(statearr_138086_138162[(1)] = (39));

} else {
var statearr_138087_138163 = state_137998__$1;
(statearr_138087_138163[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_137999 === (8))){
var inst_137873 = (state_137998[(15)]);
var inst_137874 = (state_137998[(16)]);
var inst_137876 = (inst_137874 < inst_137873);
var inst_137877 = inst_137876;
var state_137998__$1 = state_137998;
if(cljs.core.truth_(inst_137877)){
var statearr_138088_138164 = state_137998__$1;
(statearr_138088_138164[(1)] = (10));

} else {
var statearr_138089_138165 = state_137998__$1;
(statearr_138089_138165[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33263__auto___138096,cs,m,dchan,dctr,done))
;
return ((function (switch__33031__auto__,c__33263__auto___138096,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__33032__auto__ = null;
var cljs$core$async$mult_$_state_machine__33032__auto____0 = (function (){
var statearr_138090 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_138090[(0)] = cljs$core$async$mult_$_state_machine__33032__auto__);

(statearr_138090[(1)] = (1));

return statearr_138090;
});
var cljs$core$async$mult_$_state_machine__33032__auto____1 = (function (state_137998){
while(true){
var ret_value__33033__auto__ = (function (){try{while(true){
var result__33034__auto__ = switch__33031__auto__(state_137998);
if(cljs.core.keyword_identical_QMARK_(result__33034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33034__auto__;
}
break;
}
}catch (e138091){if((e138091 instanceof Object)){
var ex__33035__auto__ = e138091;
var statearr_138092_138168 = state_137998;
(statearr_138092_138168[(5)] = ex__33035__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_137998);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e138091;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__33033__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__138169 = state_137998;
state_137998 = G__138169;
continue;
} else {
return ret_value__33033__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__33032__auto__ = function(state_137998){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__33032__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__33032__auto____1.call(this,state_137998);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__33032__auto____0;
cljs$core$async$mult_$_state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__33032__auto____1;
return cljs$core$async$mult_$_state_machine__33032__auto__;
})()
;})(switch__33031__auto__,c__33263__auto___138096,cs,m,dchan,dctr,done))
})();
var state__33265__auto__ = (function (){var statearr_138093 = (f__33264__auto__.cljs$core$IFn$_invoke$arity$0 ? f__33264__auto__.cljs$core$IFn$_invoke$arity$0() : f__33264__auto__.call(null));
(statearr_138093[(6)] = c__33263__auto___138096);

return statearr_138093;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__33265__auto__);
});})(c__33263__auto___138096,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__138174 = arguments.length;
switch (G__138174) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto__.call(null,m,ch));
} else {
var m__4244__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto__.call(null,m,ch));
} else {
var m__4244__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4244__auto__.call(null,m));
} else {
var m__4244__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__4244__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4244__auto__.call(null,m,state_map));
} else {
var m__4244__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4244__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4244__auto__.call(null,m,mode));
} else {
var m__4244__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4244__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4534__auto__ = [];
var len__4531__auto___138189 = arguments.length;
var i__4532__auto___138190 = (0);
while(true){
if((i__4532__auto___138190 < len__4531__auto___138189)){
args__4534__auto__.push((arguments[i__4532__auto___138190]));

var G__138191 = (i__4532__auto___138190 + (1));
i__4532__auto___138190 = G__138191;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__138183){
var map__138184 = p__138183;
var map__138184__$1 = ((((!((map__138184 == null)))?(((((map__138184.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__138184.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__138184):map__138184);
var opts = map__138184__$1;
var statearr_138186_138194 = state;
(statearr_138186_138194[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts(((function (map__138184,map__138184__$1,opts){
return (function (val){
var statearr_138187_138195 = state;
(statearr_138187_138195[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__138184,map__138184__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_138188_138196 = state;
(statearr_138188_138196[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq138179){
var G__138180 = cljs.core.first(seq138179);
var seq138179__$1 = cljs.core.next(seq138179);
var G__138181 = cljs.core.first(seq138179__$1);
var seq138179__$2 = cljs.core.next(seq138179__$1);
var G__138182 = cljs.core.first(seq138179__$2);
var seq138179__$3 = cljs.core.next(seq138179__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__138180,G__138181,G__138182,seq138179__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_(solos)))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async138201 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async138201 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta138202){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta138202 = meta138202;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async138201.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_138203,meta138202__$1){
var self__ = this;
var _138203__$1 = this;
return (new cljs.core.async.t_cljs$core$async138201(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta138202__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async138201.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_138203){
var self__ = this;
var _138203__$1 = this;
return self__.meta138202;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async138201.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async138201.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async138201.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async138201.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async138201.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async138201.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async138201.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async138201.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async138201.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta138202","meta138202",1912296682,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async138201.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async138201.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async138201";

cljs.core.async.t_cljs$core$async138201.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async138201");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async138201.
 */
cljs.core.async.__GT_t_cljs$core$async138201 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async138201(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta138202){
return (new cljs.core.async.t_cljs$core$async138201(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta138202));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async138201(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__33263__auto___138394 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__33263__auto___138394,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__33264__auto__ = (function (){var switch__33031__auto__ = ((function (c__33263__auto___138394,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_138311){
var state_val_138312 = (state_138311[(1)]);
if((state_val_138312 === (7))){
var inst_138224 = (state_138311[(2)]);
var state_138311__$1 = state_138311;
var statearr_138314_138396 = state_138311__$1;
(statearr_138314_138396[(2)] = inst_138224);

(statearr_138314_138396[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (20))){
var inst_138236 = (state_138311[(7)]);
var state_138311__$1 = state_138311;
var statearr_138315_138397 = state_138311__$1;
(statearr_138315_138397[(2)] = inst_138236);

(statearr_138315_138397[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (27))){
var state_138311__$1 = state_138311;
var statearr_138316_138398 = state_138311__$1;
(statearr_138316_138398[(2)] = null);

(statearr_138316_138398[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (1))){
var inst_138211 = (state_138311[(8)]);
var inst_138211__$1 = calc_state();
var inst_138213 = (inst_138211__$1 == null);
var inst_138214 = cljs.core.not(inst_138213);
var state_138311__$1 = (function (){var statearr_138317 = state_138311;
(statearr_138317[(8)] = inst_138211__$1);

return statearr_138317;
})();
if(inst_138214){
var statearr_138318_138400 = state_138311__$1;
(statearr_138318_138400[(1)] = (2));

} else {
var statearr_138319_138401 = state_138311__$1;
(statearr_138319_138401[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (24))){
var inst_138271 = (state_138311[(9)]);
var inst_138262 = (state_138311[(10)]);
var inst_138285 = (state_138311[(11)]);
var inst_138285__$1 = (inst_138262.cljs$core$IFn$_invoke$arity$1 ? inst_138262.cljs$core$IFn$_invoke$arity$1(inst_138271) : inst_138262.call(null,inst_138271));
var state_138311__$1 = (function (){var statearr_138322 = state_138311;
(statearr_138322[(11)] = inst_138285__$1);

return statearr_138322;
})();
if(cljs.core.truth_(inst_138285__$1)){
var statearr_138323_138404 = state_138311__$1;
(statearr_138323_138404[(1)] = (29));

} else {
var statearr_138324_138405 = state_138311__$1;
(statearr_138324_138405[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (4))){
var inst_138227 = (state_138311[(2)]);
var state_138311__$1 = state_138311;
if(cljs.core.truth_(inst_138227)){
var statearr_138325_138406 = state_138311__$1;
(statearr_138325_138406[(1)] = (8));

} else {
var statearr_138326_138407 = state_138311__$1;
(statearr_138326_138407[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (15))){
var inst_138256 = (state_138311[(2)]);
var state_138311__$1 = state_138311;
if(cljs.core.truth_(inst_138256)){
var statearr_138327_138412 = state_138311__$1;
(statearr_138327_138412[(1)] = (19));

} else {
var statearr_138328_138413 = state_138311__$1;
(statearr_138328_138413[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (21))){
var inst_138261 = (state_138311[(12)]);
var inst_138261__$1 = (state_138311[(2)]);
var inst_138262 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_138261__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_138263 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_138261__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_138264 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_138261__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_138311__$1 = (function (){var statearr_138329 = state_138311;
(statearr_138329[(12)] = inst_138261__$1);

(statearr_138329[(10)] = inst_138262);

(statearr_138329[(13)] = inst_138263);

return statearr_138329;
})();
return cljs.core.async.ioc_alts_BANG_(state_138311__$1,(22),inst_138264);
} else {
if((state_val_138312 === (31))){
var inst_138293 = (state_138311[(2)]);
var state_138311__$1 = state_138311;
if(cljs.core.truth_(inst_138293)){
var statearr_138332_138415 = state_138311__$1;
(statearr_138332_138415[(1)] = (32));

} else {
var statearr_138333_138416 = state_138311__$1;
(statearr_138333_138416[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (32))){
var inst_138270 = (state_138311[(14)]);
var state_138311__$1 = state_138311;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_138311__$1,(35),out,inst_138270);
} else {
if((state_val_138312 === (33))){
var inst_138261 = (state_138311[(12)]);
var inst_138236 = inst_138261;
var state_138311__$1 = (function (){var statearr_138334 = state_138311;
(statearr_138334[(7)] = inst_138236);

return statearr_138334;
})();
var statearr_138335_138417 = state_138311__$1;
(statearr_138335_138417[(2)] = null);

(statearr_138335_138417[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (13))){
var inst_138236 = (state_138311[(7)]);
var inst_138245 = inst_138236.cljs$lang$protocol_mask$partition0$;
var inst_138246 = (inst_138245 & (64));
var inst_138247 = inst_138236.cljs$core$ISeq$;
var inst_138248 = (cljs.core.PROTOCOL_SENTINEL === inst_138247);
var inst_138249 = ((inst_138246) || (inst_138248));
var state_138311__$1 = state_138311;
if(cljs.core.truth_(inst_138249)){
var statearr_138336_138419 = state_138311__$1;
(statearr_138336_138419[(1)] = (16));

} else {
var statearr_138337_138420 = state_138311__$1;
(statearr_138337_138420[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (22))){
var inst_138271 = (state_138311[(9)]);
var inst_138270 = (state_138311[(14)]);
var inst_138269 = (state_138311[(2)]);
var inst_138270__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_138269,(0),null);
var inst_138271__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_138269,(1),null);
var inst_138272 = (inst_138270__$1 == null);
var inst_138273 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_138271__$1,change);
var inst_138274 = ((inst_138272) || (inst_138273));
var state_138311__$1 = (function (){var statearr_138338 = state_138311;
(statearr_138338[(9)] = inst_138271__$1);

(statearr_138338[(14)] = inst_138270__$1);

return statearr_138338;
})();
if(cljs.core.truth_(inst_138274)){
var statearr_138339_138421 = state_138311__$1;
(statearr_138339_138421[(1)] = (23));

} else {
var statearr_138340_138422 = state_138311__$1;
(statearr_138340_138422[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (36))){
var inst_138261 = (state_138311[(12)]);
var inst_138236 = inst_138261;
var state_138311__$1 = (function (){var statearr_138341 = state_138311;
(statearr_138341[(7)] = inst_138236);

return statearr_138341;
})();
var statearr_138342_138423 = state_138311__$1;
(statearr_138342_138423[(2)] = null);

(statearr_138342_138423[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (29))){
var inst_138285 = (state_138311[(11)]);
var state_138311__$1 = state_138311;
var statearr_138343_138424 = state_138311__$1;
(statearr_138343_138424[(2)] = inst_138285);

(statearr_138343_138424[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (6))){
var state_138311__$1 = state_138311;
var statearr_138344_138425 = state_138311__$1;
(statearr_138344_138425[(2)] = false);

(statearr_138344_138425[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (28))){
var inst_138281 = (state_138311[(2)]);
var inst_138282 = calc_state();
var inst_138236 = inst_138282;
var state_138311__$1 = (function (){var statearr_138345 = state_138311;
(statearr_138345[(7)] = inst_138236);

(statearr_138345[(15)] = inst_138281);

return statearr_138345;
})();
var statearr_138346_138426 = state_138311__$1;
(statearr_138346_138426[(2)] = null);

(statearr_138346_138426[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (25))){
var inst_138307 = (state_138311[(2)]);
var state_138311__$1 = state_138311;
var statearr_138347_138427 = state_138311__$1;
(statearr_138347_138427[(2)] = inst_138307);

(statearr_138347_138427[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (34))){
var inst_138305 = (state_138311[(2)]);
var state_138311__$1 = state_138311;
var statearr_138348_138428 = state_138311__$1;
(statearr_138348_138428[(2)] = inst_138305);

(statearr_138348_138428[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (17))){
var state_138311__$1 = state_138311;
var statearr_138349_138429 = state_138311__$1;
(statearr_138349_138429[(2)] = false);

(statearr_138349_138429[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (3))){
var state_138311__$1 = state_138311;
var statearr_138350_138430 = state_138311__$1;
(statearr_138350_138430[(2)] = false);

(statearr_138350_138430[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (12))){
var inst_138309 = (state_138311[(2)]);
var state_138311__$1 = state_138311;
return cljs.core.async.impl.ioc_helpers.return_chan(state_138311__$1,inst_138309);
} else {
if((state_val_138312 === (2))){
var inst_138211 = (state_138311[(8)]);
var inst_138216 = inst_138211.cljs$lang$protocol_mask$partition0$;
var inst_138217 = (inst_138216 & (64));
var inst_138218 = inst_138211.cljs$core$ISeq$;
var inst_138219 = (cljs.core.PROTOCOL_SENTINEL === inst_138218);
var inst_138220 = ((inst_138217) || (inst_138219));
var state_138311__$1 = state_138311;
if(cljs.core.truth_(inst_138220)){
var statearr_138351_138431 = state_138311__$1;
(statearr_138351_138431[(1)] = (5));

} else {
var statearr_138352_138432 = state_138311__$1;
(statearr_138352_138432[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (23))){
var inst_138270 = (state_138311[(14)]);
var inst_138276 = (inst_138270 == null);
var state_138311__$1 = state_138311;
if(cljs.core.truth_(inst_138276)){
var statearr_138353_138433 = state_138311__$1;
(statearr_138353_138433[(1)] = (26));

} else {
var statearr_138354_138434 = state_138311__$1;
(statearr_138354_138434[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (35))){
var inst_138296 = (state_138311[(2)]);
var state_138311__$1 = state_138311;
if(cljs.core.truth_(inst_138296)){
var statearr_138355_138436 = state_138311__$1;
(statearr_138355_138436[(1)] = (36));

} else {
var statearr_138356_138437 = state_138311__$1;
(statearr_138356_138437[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (19))){
var inst_138236 = (state_138311[(7)]);
var inst_138258 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_138236);
var state_138311__$1 = state_138311;
var statearr_138357_138438 = state_138311__$1;
(statearr_138357_138438[(2)] = inst_138258);

(statearr_138357_138438[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (11))){
var inst_138236 = (state_138311[(7)]);
var inst_138241 = (inst_138236 == null);
var inst_138242 = cljs.core.not(inst_138241);
var state_138311__$1 = state_138311;
if(inst_138242){
var statearr_138358_138439 = state_138311__$1;
(statearr_138358_138439[(1)] = (13));

} else {
var statearr_138359_138440 = state_138311__$1;
(statearr_138359_138440[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (9))){
var inst_138211 = (state_138311[(8)]);
var state_138311__$1 = state_138311;
var statearr_138360_138441 = state_138311__$1;
(statearr_138360_138441[(2)] = inst_138211);

(statearr_138360_138441[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (5))){
var state_138311__$1 = state_138311;
var statearr_138361_138442 = state_138311__$1;
(statearr_138361_138442[(2)] = true);

(statearr_138361_138442[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (14))){
var state_138311__$1 = state_138311;
var statearr_138362_138443 = state_138311__$1;
(statearr_138362_138443[(2)] = false);

(statearr_138362_138443[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (26))){
var inst_138271 = (state_138311[(9)]);
var inst_138278 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_138271);
var state_138311__$1 = state_138311;
var statearr_138363_138444 = state_138311__$1;
(statearr_138363_138444[(2)] = inst_138278);

(statearr_138363_138444[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (16))){
var state_138311__$1 = state_138311;
var statearr_138367_138445 = state_138311__$1;
(statearr_138367_138445[(2)] = true);

(statearr_138367_138445[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (38))){
var inst_138301 = (state_138311[(2)]);
var state_138311__$1 = state_138311;
var statearr_138368_138446 = state_138311__$1;
(statearr_138368_138446[(2)] = inst_138301);

(statearr_138368_138446[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (30))){
var inst_138271 = (state_138311[(9)]);
var inst_138262 = (state_138311[(10)]);
var inst_138263 = (state_138311[(13)]);
var inst_138288 = cljs.core.empty_QMARK_(inst_138262);
var inst_138289 = (inst_138263.cljs$core$IFn$_invoke$arity$1 ? inst_138263.cljs$core$IFn$_invoke$arity$1(inst_138271) : inst_138263.call(null,inst_138271));
var inst_138290 = cljs.core.not(inst_138289);
var inst_138291 = ((inst_138288) && (inst_138290));
var state_138311__$1 = state_138311;
var statearr_138369_138448 = state_138311__$1;
(statearr_138369_138448[(2)] = inst_138291);

(statearr_138369_138448[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (10))){
var inst_138211 = (state_138311[(8)]);
var inst_138232 = (state_138311[(2)]);
var inst_138233 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_138232,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_138234 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_138232,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_138235 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_138232,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_138236 = inst_138211;
var state_138311__$1 = (function (){var statearr_138375 = state_138311;
(statearr_138375[(16)] = inst_138234);

(statearr_138375[(7)] = inst_138236);

(statearr_138375[(17)] = inst_138235);

(statearr_138375[(18)] = inst_138233);

return statearr_138375;
})();
var statearr_138376_138450 = state_138311__$1;
(statearr_138376_138450[(2)] = null);

(statearr_138376_138450[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (18))){
var inst_138253 = (state_138311[(2)]);
var state_138311__$1 = state_138311;
var statearr_138377_138451 = state_138311__$1;
(statearr_138377_138451[(2)] = inst_138253);

(statearr_138377_138451[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (37))){
var state_138311__$1 = state_138311;
var statearr_138378_138452 = state_138311__$1;
(statearr_138378_138452[(2)] = null);

(statearr_138378_138452[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138312 === (8))){
var inst_138211 = (state_138311[(8)]);
var inst_138229 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_138211);
var state_138311__$1 = state_138311;
var statearr_138379_138453 = state_138311__$1;
(statearr_138379_138453[(2)] = inst_138229);

(statearr_138379_138453[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33263__auto___138394,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__33031__auto__,c__33263__auto___138394,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__33032__auto__ = null;
var cljs$core$async$mix_$_state_machine__33032__auto____0 = (function (){
var statearr_138381 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_138381[(0)] = cljs$core$async$mix_$_state_machine__33032__auto__);

(statearr_138381[(1)] = (1));

return statearr_138381;
});
var cljs$core$async$mix_$_state_machine__33032__auto____1 = (function (state_138311){
while(true){
var ret_value__33033__auto__ = (function (){try{while(true){
var result__33034__auto__ = switch__33031__auto__(state_138311);
if(cljs.core.keyword_identical_QMARK_(result__33034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33034__auto__;
}
break;
}
}catch (e138382){if((e138382 instanceof Object)){
var ex__33035__auto__ = e138382;
var statearr_138383_138454 = state_138311;
(statearr_138383_138454[(5)] = ex__33035__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_138311);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e138382;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__33033__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__138456 = state_138311;
state_138311 = G__138456;
continue;
} else {
return ret_value__33033__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__33032__auto__ = function(state_138311){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__33032__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__33032__auto____1.call(this,state_138311);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__33032__auto____0;
cljs$core$async$mix_$_state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__33032__auto____1;
return cljs$core$async$mix_$_state_machine__33032__auto__;
})()
;})(switch__33031__auto__,c__33263__auto___138394,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__33265__auto__ = (function (){var statearr_138385 = (f__33264__auto__.cljs$core$IFn$_invoke$arity$0 ? f__33264__auto__.cljs$core$IFn$_invoke$arity$0() : f__33264__auto__.call(null));
(statearr_138385[(6)] = c__33263__auto___138394);

return statearr_138385;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__33265__auto__);
});})(c__33263__auto___138394,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4244__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4244__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4244__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4244__auto__.call(null,p,v,ch));
} else {
var m__4244__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4244__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__138462 = arguments.length;
switch (G__138462) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4244__auto__.call(null,p));
} else {
var m__4244__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__4244__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4244__auto__.call(null,p,v));
} else {
var m__4244__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__4244__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__138475 = arguments.length;
switch (G__138475) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__3949__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__3949__auto__,mults){
return (function (p1__138471_SHARP_){
if(cljs.core.truth_((p1__138471_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__138471_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__138471_SHARP_.call(null,topic)))){
return p1__138471_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__138471_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__3949__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async138477 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async138477 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta138478){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta138478 = meta138478;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async138477.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_138479,meta138478__$1){
var self__ = this;
var _138479__$1 = this;
return (new cljs.core.async.t_cljs$core$async138477(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta138478__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async138477.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_138479){
var self__ = this;
var _138479__$1 = this;
return self__.meta138478;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async138477.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async138477.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async138477.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async138477.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async138477.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async138477.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async138477.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async138477.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta138478","meta138478",-1702121133,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async138477.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async138477.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async138477";

cljs.core.async.t_cljs$core$async138477.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async138477");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async138477.
 */
cljs.core.async.__GT_t_cljs$core$async138477 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async138477(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta138478){
return (new cljs.core.async.t_cljs$core$async138477(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta138478));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async138477(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__33263__auto___138603 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__33263__auto___138603,mults,ensure_mult,p){
return (function (){
var f__33264__auto__ = (function (){var switch__33031__auto__ = ((function (c__33263__auto___138603,mults,ensure_mult,p){
return (function (state_138551){
var state_val_138552 = (state_138551[(1)]);
if((state_val_138552 === (7))){
var inst_138547 = (state_138551[(2)]);
var state_138551__$1 = state_138551;
var statearr_138553_138604 = state_138551__$1;
(statearr_138553_138604[(2)] = inst_138547);

(statearr_138553_138604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138552 === (20))){
var state_138551__$1 = state_138551;
var statearr_138554_138605 = state_138551__$1;
(statearr_138554_138605[(2)] = null);

(statearr_138554_138605[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138552 === (1))){
var state_138551__$1 = state_138551;
var statearr_138555_138606 = state_138551__$1;
(statearr_138555_138606[(2)] = null);

(statearr_138555_138606[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138552 === (24))){
var inst_138530 = (state_138551[(7)]);
var inst_138539 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_138530);
var state_138551__$1 = state_138551;
var statearr_138556_138607 = state_138551__$1;
(statearr_138556_138607[(2)] = inst_138539);

(statearr_138556_138607[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138552 === (4))){
var inst_138482 = (state_138551[(8)]);
var inst_138482__$1 = (state_138551[(2)]);
var inst_138483 = (inst_138482__$1 == null);
var state_138551__$1 = (function (){var statearr_138557 = state_138551;
(statearr_138557[(8)] = inst_138482__$1);

return statearr_138557;
})();
if(cljs.core.truth_(inst_138483)){
var statearr_138558_138608 = state_138551__$1;
(statearr_138558_138608[(1)] = (5));

} else {
var statearr_138559_138609 = state_138551__$1;
(statearr_138559_138609[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138552 === (15))){
var inst_138524 = (state_138551[(2)]);
var state_138551__$1 = state_138551;
var statearr_138560_138610 = state_138551__$1;
(statearr_138560_138610[(2)] = inst_138524);

(statearr_138560_138610[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138552 === (21))){
var inst_138544 = (state_138551[(2)]);
var state_138551__$1 = (function (){var statearr_138561 = state_138551;
(statearr_138561[(9)] = inst_138544);

return statearr_138561;
})();
var statearr_138562_138611 = state_138551__$1;
(statearr_138562_138611[(2)] = null);

(statearr_138562_138611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138552 === (13))){
var inst_138506 = (state_138551[(10)]);
var inst_138508 = cljs.core.chunked_seq_QMARK_(inst_138506);
var state_138551__$1 = state_138551;
if(inst_138508){
var statearr_138563_138612 = state_138551__$1;
(statearr_138563_138612[(1)] = (16));

} else {
var statearr_138564_138613 = state_138551__$1;
(statearr_138564_138613[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138552 === (22))){
var inst_138536 = (state_138551[(2)]);
var state_138551__$1 = state_138551;
if(cljs.core.truth_(inst_138536)){
var statearr_138565_138617 = state_138551__$1;
(statearr_138565_138617[(1)] = (23));

} else {
var statearr_138566_138618 = state_138551__$1;
(statearr_138566_138618[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138552 === (6))){
var inst_138482 = (state_138551[(8)]);
var inst_138532 = (state_138551[(11)]);
var inst_138530 = (state_138551[(7)]);
var inst_138530__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_138482) : topic_fn.call(null,inst_138482));
var inst_138531 = cljs.core.deref(mults);
var inst_138532__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_138531,inst_138530__$1);
var state_138551__$1 = (function (){var statearr_138567 = state_138551;
(statearr_138567[(11)] = inst_138532__$1);

(statearr_138567[(7)] = inst_138530__$1);

return statearr_138567;
})();
if(cljs.core.truth_(inst_138532__$1)){
var statearr_138568_138619 = state_138551__$1;
(statearr_138568_138619[(1)] = (19));

} else {
var statearr_138569_138620 = state_138551__$1;
(statearr_138569_138620[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138552 === (25))){
var inst_138541 = (state_138551[(2)]);
var state_138551__$1 = state_138551;
var statearr_138570_138621 = state_138551__$1;
(statearr_138570_138621[(2)] = inst_138541);

(statearr_138570_138621[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138552 === (17))){
var inst_138506 = (state_138551[(10)]);
var inst_138515 = cljs.core.first(inst_138506);
var inst_138516 = cljs.core.async.muxch_STAR_(inst_138515);
var inst_138517 = cljs.core.async.close_BANG_(inst_138516);
var inst_138518 = cljs.core.next(inst_138506);
var inst_138492 = inst_138518;
var inst_138493 = null;
var inst_138494 = (0);
var inst_138495 = (0);
var state_138551__$1 = (function (){var statearr_138571 = state_138551;
(statearr_138571[(12)] = inst_138492);

(statearr_138571[(13)] = inst_138495);

(statearr_138571[(14)] = inst_138517);

(statearr_138571[(15)] = inst_138494);

(statearr_138571[(16)] = inst_138493);

return statearr_138571;
})();
var statearr_138572_138622 = state_138551__$1;
(statearr_138572_138622[(2)] = null);

(statearr_138572_138622[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138552 === (3))){
var inst_138549 = (state_138551[(2)]);
var state_138551__$1 = state_138551;
return cljs.core.async.impl.ioc_helpers.return_chan(state_138551__$1,inst_138549);
} else {
if((state_val_138552 === (12))){
var inst_138526 = (state_138551[(2)]);
var state_138551__$1 = state_138551;
var statearr_138573_138623 = state_138551__$1;
(statearr_138573_138623[(2)] = inst_138526);

(statearr_138573_138623[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138552 === (2))){
var state_138551__$1 = state_138551;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_138551__$1,(4),ch);
} else {
if((state_val_138552 === (23))){
var state_138551__$1 = state_138551;
var statearr_138574_138624 = state_138551__$1;
(statearr_138574_138624[(2)] = null);

(statearr_138574_138624[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138552 === (19))){
var inst_138482 = (state_138551[(8)]);
var inst_138532 = (state_138551[(11)]);
var inst_138534 = cljs.core.async.muxch_STAR_(inst_138532);
var state_138551__$1 = state_138551;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_138551__$1,(22),inst_138534,inst_138482);
} else {
if((state_val_138552 === (11))){
var inst_138506 = (state_138551[(10)]);
var inst_138492 = (state_138551[(12)]);
var inst_138506__$1 = cljs.core.seq(inst_138492);
var state_138551__$1 = (function (){var statearr_138575 = state_138551;
(statearr_138575[(10)] = inst_138506__$1);

return statearr_138575;
})();
if(inst_138506__$1){
var statearr_138576_138625 = state_138551__$1;
(statearr_138576_138625[(1)] = (13));

} else {
var statearr_138577_138626 = state_138551__$1;
(statearr_138577_138626[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138552 === (9))){
var inst_138528 = (state_138551[(2)]);
var state_138551__$1 = state_138551;
var statearr_138579_138627 = state_138551__$1;
(statearr_138579_138627[(2)] = inst_138528);

(statearr_138579_138627[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138552 === (5))){
var inst_138489 = cljs.core.deref(mults);
var inst_138490 = cljs.core.vals(inst_138489);
var inst_138491 = cljs.core.seq(inst_138490);
var inst_138492 = inst_138491;
var inst_138493 = null;
var inst_138494 = (0);
var inst_138495 = (0);
var state_138551__$1 = (function (){var statearr_138580 = state_138551;
(statearr_138580[(12)] = inst_138492);

(statearr_138580[(13)] = inst_138495);

(statearr_138580[(15)] = inst_138494);

(statearr_138580[(16)] = inst_138493);

return statearr_138580;
})();
var statearr_138581_138632 = state_138551__$1;
(statearr_138581_138632[(2)] = null);

(statearr_138581_138632[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138552 === (14))){
var state_138551__$1 = state_138551;
var statearr_138585_138633 = state_138551__$1;
(statearr_138585_138633[(2)] = null);

(statearr_138585_138633[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138552 === (16))){
var inst_138506 = (state_138551[(10)]);
var inst_138510 = cljs.core.chunk_first(inst_138506);
var inst_138511 = cljs.core.chunk_rest(inst_138506);
var inst_138512 = cljs.core.count(inst_138510);
var inst_138492 = inst_138511;
var inst_138493 = inst_138510;
var inst_138494 = inst_138512;
var inst_138495 = (0);
var state_138551__$1 = (function (){var statearr_138586 = state_138551;
(statearr_138586[(12)] = inst_138492);

(statearr_138586[(13)] = inst_138495);

(statearr_138586[(15)] = inst_138494);

(statearr_138586[(16)] = inst_138493);

return statearr_138586;
})();
var statearr_138587_138646 = state_138551__$1;
(statearr_138587_138646[(2)] = null);

(statearr_138587_138646[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138552 === (10))){
var inst_138492 = (state_138551[(12)]);
var inst_138495 = (state_138551[(13)]);
var inst_138494 = (state_138551[(15)]);
var inst_138493 = (state_138551[(16)]);
var inst_138500 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_138493,inst_138495);
var inst_138501 = cljs.core.async.muxch_STAR_(inst_138500);
var inst_138502 = cljs.core.async.close_BANG_(inst_138501);
var inst_138503 = (inst_138495 + (1));
var tmp138582 = inst_138492;
var tmp138583 = inst_138494;
var tmp138584 = inst_138493;
var inst_138492__$1 = tmp138582;
var inst_138493__$1 = tmp138584;
var inst_138494__$1 = tmp138583;
var inst_138495__$1 = inst_138503;
var state_138551__$1 = (function (){var statearr_138588 = state_138551;
(statearr_138588[(12)] = inst_138492__$1);

(statearr_138588[(13)] = inst_138495__$1);

(statearr_138588[(15)] = inst_138494__$1);

(statearr_138588[(17)] = inst_138502);

(statearr_138588[(16)] = inst_138493__$1);

return statearr_138588;
})();
var statearr_138589_138658 = state_138551__$1;
(statearr_138589_138658[(2)] = null);

(statearr_138589_138658[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138552 === (18))){
var inst_138521 = (state_138551[(2)]);
var state_138551__$1 = state_138551;
var statearr_138590_138663 = state_138551__$1;
(statearr_138590_138663[(2)] = inst_138521);

(statearr_138590_138663[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138552 === (8))){
var inst_138495 = (state_138551[(13)]);
var inst_138494 = (state_138551[(15)]);
var inst_138497 = (inst_138495 < inst_138494);
var inst_138498 = inst_138497;
var state_138551__$1 = state_138551;
if(cljs.core.truth_(inst_138498)){
var statearr_138591_138667 = state_138551__$1;
(statearr_138591_138667[(1)] = (10));

} else {
var statearr_138592_138672 = state_138551__$1;
(statearr_138592_138672[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33263__auto___138603,mults,ensure_mult,p))
;
return ((function (switch__33031__auto__,c__33263__auto___138603,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__33032__auto__ = null;
var cljs$core$async$state_machine__33032__auto____0 = (function (){
var statearr_138593 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_138593[(0)] = cljs$core$async$state_machine__33032__auto__);

(statearr_138593[(1)] = (1));

return statearr_138593;
});
var cljs$core$async$state_machine__33032__auto____1 = (function (state_138551){
while(true){
var ret_value__33033__auto__ = (function (){try{while(true){
var result__33034__auto__ = switch__33031__auto__(state_138551);
if(cljs.core.keyword_identical_QMARK_(result__33034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33034__auto__;
}
break;
}
}catch (e138594){if((e138594 instanceof Object)){
var ex__33035__auto__ = e138594;
var statearr_138595_138685 = state_138551;
(statearr_138595_138685[(5)] = ex__33035__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_138551);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e138594;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__33033__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__138693 = state_138551;
state_138551 = G__138693;
continue;
} else {
return ret_value__33033__auto__;
}
break;
}
});
cljs$core$async$state_machine__33032__auto__ = function(state_138551){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33032__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33032__auto____1.call(this,state_138551);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33032__auto____0;
cljs$core$async$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33032__auto____1;
return cljs$core$async$state_machine__33032__auto__;
})()
;})(switch__33031__auto__,c__33263__auto___138603,mults,ensure_mult,p))
})();
var state__33265__auto__ = (function (){var statearr_138596 = (f__33264__auto__.cljs$core$IFn$_invoke$arity$0 ? f__33264__auto__.cljs$core$IFn$_invoke$arity$0() : f__33264__auto__.call(null));
(statearr_138596[(6)] = c__33263__auto___138603);

return statearr_138596;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__33265__auto__);
});})(c__33263__auto___138603,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__138712 = arguments.length;
switch (G__138712) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__138718 = arguments.length;
switch (G__138718) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__138724 = arguments.length;
switch (G__138724) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__33263__auto___138794 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__33263__auto___138794,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__33264__auto__ = (function (){var switch__33031__auto__ = ((function (c__33263__auto___138794,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_138766){
var state_val_138767 = (state_138766[(1)]);
if((state_val_138767 === (7))){
var state_138766__$1 = state_138766;
var statearr_138768_138795 = state_138766__$1;
(statearr_138768_138795[(2)] = null);

(statearr_138768_138795[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138767 === (1))){
var state_138766__$1 = state_138766;
var statearr_138769_138796 = state_138766__$1;
(statearr_138769_138796[(2)] = null);

(statearr_138769_138796[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138767 === (4))){
var inst_138729 = (state_138766[(7)]);
var inst_138732 = (inst_138729 < cnt);
var state_138766__$1 = state_138766;
if(cljs.core.truth_(inst_138732)){
var statearr_138770_138797 = state_138766__$1;
(statearr_138770_138797[(1)] = (6));

} else {
var statearr_138771_138798 = state_138766__$1;
(statearr_138771_138798[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138767 === (15))){
var inst_138762 = (state_138766[(2)]);
var state_138766__$1 = state_138766;
var statearr_138772_138799 = state_138766__$1;
(statearr_138772_138799[(2)] = inst_138762);

(statearr_138772_138799[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138767 === (13))){
var inst_138755 = cljs.core.async.close_BANG_(out);
var state_138766__$1 = state_138766;
var statearr_138773_138800 = state_138766__$1;
(statearr_138773_138800[(2)] = inst_138755);

(statearr_138773_138800[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138767 === (6))){
var state_138766__$1 = state_138766;
var statearr_138774_138801 = state_138766__$1;
(statearr_138774_138801[(2)] = null);

(statearr_138774_138801[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138767 === (3))){
var inst_138764 = (state_138766[(2)]);
var state_138766__$1 = state_138766;
return cljs.core.async.impl.ioc_helpers.return_chan(state_138766__$1,inst_138764);
} else {
if((state_val_138767 === (12))){
var inst_138752 = (state_138766[(8)]);
var inst_138752__$1 = (state_138766[(2)]);
var inst_138753 = cljs.core.some(cljs.core.nil_QMARK_,inst_138752__$1);
var state_138766__$1 = (function (){var statearr_138775 = state_138766;
(statearr_138775[(8)] = inst_138752__$1);

return statearr_138775;
})();
if(cljs.core.truth_(inst_138753)){
var statearr_138776_138802 = state_138766__$1;
(statearr_138776_138802[(1)] = (13));

} else {
var statearr_138777_138803 = state_138766__$1;
(statearr_138777_138803[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138767 === (2))){
var inst_138728 = cljs.core.reset_BANG_(dctr,cnt);
var inst_138729 = (0);
var state_138766__$1 = (function (){var statearr_138778 = state_138766;
(statearr_138778[(9)] = inst_138728);

(statearr_138778[(7)] = inst_138729);

return statearr_138778;
})();
var statearr_138779_138804 = state_138766__$1;
(statearr_138779_138804[(2)] = null);

(statearr_138779_138804[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138767 === (11))){
var inst_138729 = (state_138766[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_138766,(10),Object,null,(9));
var inst_138739 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_138729) : chs__$1.call(null,inst_138729));
var inst_138740 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_138729) : done.call(null,inst_138729));
var inst_138741 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_138739,inst_138740);
var state_138766__$1 = state_138766;
var statearr_138780_138805 = state_138766__$1;
(statearr_138780_138805[(2)] = inst_138741);


cljs.core.async.impl.ioc_helpers.process_exception(state_138766__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138767 === (9))){
var inst_138729 = (state_138766[(7)]);
var inst_138743 = (state_138766[(2)]);
var inst_138744 = (inst_138729 + (1));
var inst_138729__$1 = inst_138744;
var state_138766__$1 = (function (){var statearr_138781 = state_138766;
(statearr_138781[(10)] = inst_138743);

(statearr_138781[(7)] = inst_138729__$1);

return statearr_138781;
})();
var statearr_138782_138806 = state_138766__$1;
(statearr_138782_138806[(2)] = null);

(statearr_138782_138806[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138767 === (5))){
var inst_138750 = (state_138766[(2)]);
var state_138766__$1 = (function (){var statearr_138783 = state_138766;
(statearr_138783[(11)] = inst_138750);

return statearr_138783;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_138766__$1,(12),dchan);
} else {
if((state_val_138767 === (14))){
var inst_138752 = (state_138766[(8)]);
var inst_138757 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_138752);
var state_138766__$1 = state_138766;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_138766__$1,(16),out,inst_138757);
} else {
if((state_val_138767 === (16))){
var inst_138759 = (state_138766[(2)]);
var state_138766__$1 = (function (){var statearr_138784 = state_138766;
(statearr_138784[(12)] = inst_138759);

return statearr_138784;
})();
var statearr_138785_138807 = state_138766__$1;
(statearr_138785_138807[(2)] = null);

(statearr_138785_138807[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138767 === (10))){
var inst_138734 = (state_138766[(2)]);
var inst_138735 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_138766__$1 = (function (){var statearr_138786 = state_138766;
(statearr_138786[(13)] = inst_138734);

return statearr_138786;
})();
var statearr_138787_138808 = state_138766__$1;
(statearr_138787_138808[(2)] = inst_138735);


cljs.core.async.impl.ioc_helpers.process_exception(state_138766__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138767 === (8))){
var inst_138748 = (state_138766[(2)]);
var state_138766__$1 = state_138766;
var statearr_138788_138809 = state_138766__$1;
(statearr_138788_138809[(2)] = inst_138748);

(statearr_138788_138809[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33263__auto___138794,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__33031__auto__,c__33263__auto___138794,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__33032__auto__ = null;
var cljs$core$async$state_machine__33032__auto____0 = (function (){
var statearr_138789 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_138789[(0)] = cljs$core$async$state_machine__33032__auto__);

(statearr_138789[(1)] = (1));

return statearr_138789;
});
var cljs$core$async$state_machine__33032__auto____1 = (function (state_138766){
while(true){
var ret_value__33033__auto__ = (function (){try{while(true){
var result__33034__auto__ = switch__33031__auto__(state_138766);
if(cljs.core.keyword_identical_QMARK_(result__33034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33034__auto__;
}
break;
}
}catch (e138790){if((e138790 instanceof Object)){
var ex__33035__auto__ = e138790;
var statearr_138791_138810 = state_138766;
(statearr_138791_138810[(5)] = ex__33035__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_138766);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e138790;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__33033__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__138811 = state_138766;
state_138766 = G__138811;
continue;
} else {
return ret_value__33033__auto__;
}
break;
}
});
cljs$core$async$state_machine__33032__auto__ = function(state_138766){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33032__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33032__auto____1.call(this,state_138766);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33032__auto____0;
cljs$core$async$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33032__auto____1;
return cljs$core$async$state_machine__33032__auto__;
})()
;})(switch__33031__auto__,c__33263__auto___138794,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__33265__auto__ = (function (){var statearr_138792 = (f__33264__auto__.cljs$core$IFn$_invoke$arity$0 ? f__33264__auto__.cljs$core$IFn$_invoke$arity$0() : f__33264__auto__.call(null));
(statearr_138792[(6)] = c__33263__auto___138794);

return statearr_138792;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__33265__auto__);
});})(c__33263__auto___138794,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__138814 = arguments.length;
switch (G__138814) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__33263__auto___138868 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__33263__auto___138868,out){
return (function (){
var f__33264__auto__ = (function (){var switch__33031__auto__ = ((function (c__33263__auto___138868,out){
return (function (state_138846){
var state_val_138847 = (state_138846[(1)]);
if((state_val_138847 === (7))){
var inst_138825 = (state_138846[(7)]);
var inst_138826 = (state_138846[(8)]);
var inst_138825__$1 = (state_138846[(2)]);
var inst_138826__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_138825__$1,(0),null);
var inst_138827 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_138825__$1,(1),null);
var inst_138828 = (inst_138826__$1 == null);
var state_138846__$1 = (function (){var statearr_138848 = state_138846;
(statearr_138848[(7)] = inst_138825__$1);

(statearr_138848[(8)] = inst_138826__$1);

(statearr_138848[(9)] = inst_138827);

return statearr_138848;
})();
if(cljs.core.truth_(inst_138828)){
var statearr_138849_138869 = state_138846__$1;
(statearr_138849_138869[(1)] = (8));

} else {
var statearr_138850_138870 = state_138846__$1;
(statearr_138850_138870[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138847 === (1))){
var inst_138815 = cljs.core.vec(chs);
var inst_138816 = inst_138815;
var state_138846__$1 = (function (){var statearr_138851 = state_138846;
(statearr_138851[(10)] = inst_138816);

return statearr_138851;
})();
var statearr_138852_138871 = state_138846__$1;
(statearr_138852_138871[(2)] = null);

(statearr_138852_138871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138847 === (4))){
var inst_138816 = (state_138846[(10)]);
var state_138846__$1 = state_138846;
return cljs.core.async.ioc_alts_BANG_(state_138846__$1,(7),inst_138816);
} else {
if((state_val_138847 === (6))){
var inst_138842 = (state_138846[(2)]);
var state_138846__$1 = state_138846;
var statearr_138853_138872 = state_138846__$1;
(statearr_138853_138872[(2)] = inst_138842);

(statearr_138853_138872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138847 === (3))){
var inst_138844 = (state_138846[(2)]);
var state_138846__$1 = state_138846;
return cljs.core.async.impl.ioc_helpers.return_chan(state_138846__$1,inst_138844);
} else {
if((state_val_138847 === (2))){
var inst_138816 = (state_138846[(10)]);
var inst_138818 = cljs.core.count(inst_138816);
var inst_138819 = (inst_138818 > (0));
var state_138846__$1 = state_138846;
if(cljs.core.truth_(inst_138819)){
var statearr_138855_138873 = state_138846__$1;
(statearr_138855_138873[(1)] = (4));

} else {
var statearr_138856_138874 = state_138846__$1;
(statearr_138856_138874[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138847 === (11))){
var inst_138816 = (state_138846[(10)]);
var inst_138835 = (state_138846[(2)]);
var tmp138854 = inst_138816;
var inst_138816__$1 = tmp138854;
var state_138846__$1 = (function (){var statearr_138857 = state_138846;
(statearr_138857[(11)] = inst_138835);

(statearr_138857[(10)] = inst_138816__$1);

return statearr_138857;
})();
var statearr_138858_138875 = state_138846__$1;
(statearr_138858_138875[(2)] = null);

(statearr_138858_138875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138847 === (9))){
var inst_138826 = (state_138846[(8)]);
var state_138846__$1 = state_138846;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_138846__$1,(11),out,inst_138826);
} else {
if((state_val_138847 === (5))){
var inst_138840 = cljs.core.async.close_BANG_(out);
var state_138846__$1 = state_138846;
var statearr_138859_138876 = state_138846__$1;
(statearr_138859_138876[(2)] = inst_138840);

(statearr_138859_138876[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138847 === (10))){
var inst_138838 = (state_138846[(2)]);
var state_138846__$1 = state_138846;
var statearr_138860_138877 = state_138846__$1;
(statearr_138860_138877[(2)] = inst_138838);

(statearr_138860_138877[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138847 === (8))){
var inst_138825 = (state_138846[(7)]);
var inst_138826 = (state_138846[(8)]);
var inst_138827 = (state_138846[(9)]);
var inst_138816 = (state_138846[(10)]);
var inst_138830 = (function (){var cs = inst_138816;
var vec__138821 = inst_138825;
var v = inst_138826;
var c = inst_138827;
return ((function (cs,vec__138821,v,c,inst_138825,inst_138826,inst_138827,inst_138816,state_val_138847,c__33263__auto___138868,out){
return (function (p1__138812_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__138812_SHARP_);
});
;})(cs,vec__138821,v,c,inst_138825,inst_138826,inst_138827,inst_138816,state_val_138847,c__33263__auto___138868,out))
})();
var inst_138831 = cljs.core.filterv(inst_138830,inst_138816);
var inst_138816__$1 = inst_138831;
var state_138846__$1 = (function (){var statearr_138861 = state_138846;
(statearr_138861[(10)] = inst_138816__$1);

return statearr_138861;
})();
var statearr_138862_138878 = state_138846__$1;
(statearr_138862_138878[(2)] = null);

(statearr_138862_138878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__33263__auto___138868,out))
;
return ((function (switch__33031__auto__,c__33263__auto___138868,out){
return (function() {
var cljs$core$async$state_machine__33032__auto__ = null;
var cljs$core$async$state_machine__33032__auto____0 = (function (){
var statearr_138863 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_138863[(0)] = cljs$core$async$state_machine__33032__auto__);

(statearr_138863[(1)] = (1));

return statearr_138863;
});
var cljs$core$async$state_machine__33032__auto____1 = (function (state_138846){
while(true){
var ret_value__33033__auto__ = (function (){try{while(true){
var result__33034__auto__ = switch__33031__auto__(state_138846);
if(cljs.core.keyword_identical_QMARK_(result__33034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33034__auto__;
}
break;
}
}catch (e138864){if((e138864 instanceof Object)){
var ex__33035__auto__ = e138864;
var statearr_138865_138879 = state_138846;
(statearr_138865_138879[(5)] = ex__33035__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_138846);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e138864;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__33033__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__138880 = state_138846;
state_138846 = G__138880;
continue;
} else {
return ret_value__33033__auto__;
}
break;
}
});
cljs$core$async$state_machine__33032__auto__ = function(state_138846){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33032__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33032__auto____1.call(this,state_138846);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33032__auto____0;
cljs$core$async$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33032__auto____1;
return cljs$core$async$state_machine__33032__auto__;
})()
;})(switch__33031__auto__,c__33263__auto___138868,out))
})();
var state__33265__auto__ = (function (){var statearr_138866 = (f__33264__auto__.cljs$core$IFn$_invoke$arity$0 ? f__33264__auto__.cljs$core$IFn$_invoke$arity$0() : f__33264__auto__.call(null));
(statearr_138866[(6)] = c__33263__auto___138868);

return statearr_138866;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__33265__auto__);
});})(c__33263__auto___138868,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__138882 = arguments.length;
switch (G__138882) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__33263__auto___138927 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__33263__auto___138927,out){
return (function (){
var f__33264__auto__ = (function (){var switch__33031__auto__ = ((function (c__33263__auto___138927,out){
return (function (state_138906){
var state_val_138907 = (state_138906[(1)]);
if((state_val_138907 === (7))){
var inst_138888 = (state_138906[(7)]);
var inst_138888__$1 = (state_138906[(2)]);
var inst_138889 = (inst_138888__$1 == null);
var inst_138890 = cljs.core.not(inst_138889);
var state_138906__$1 = (function (){var statearr_138908 = state_138906;
(statearr_138908[(7)] = inst_138888__$1);

return statearr_138908;
})();
if(inst_138890){
var statearr_138909_138928 = state_138906__$1;
(statearr_138909_138928[(1)] = (8));

} else {
var statearr_138910_138929 = state_138906__$1;
(statearr_138910_138929[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138907 === (1))){
var inst_138883 = (0);
var state_138906__$1 = (function (){var statearr_138911 = state_138906;
(statearr_138911[(8)] = inst_138883);

return statearr_138911;
})();
var statearr_138912_138930 = state_138906__$1;
(statearr_138912_138930[(2)] = null);

(statearr_138912_138930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138907 === (4))){
var state_138906__$1 = state_138906;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_138906__$1,(7),ch);
} else {
if((state_val_138907 === (6))){
var inst_138901 = (state_138906[(2)]);
var state_138906__$1 = state_138906;
var statearr_138913_138931 = state_138906__$1;
(statearr_138913_138931[(2)] = inst_138901);

(statearr_138913_138931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138907 === (3))){
var inst_138903 = (state_138906[(2)]);
var inst_138904 = cljs.core.async.close_BANG_(out);
var state_138906__$1 = (function (){var statearr_138914 = state_138906;
(statearr_138914[(9)] = inst_138903);

return statearr_138914;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_138906__$1,inst_138904);
} else {
if((state_val_138907 === (2))){
var inst_138883 = (state_138906[(8)]);
var inst_138885 = (inst_138883 < n);
var state_138906__$1 = state_138906;
if(cljs.core.truth_(inst_138885)){
var statearr_138915_138932 = state_138906__$1;
(statearr_138915_138932[(1)] = (4));

} else {
var statearr_138916_138933 = state_138906__$1;
(statearr_138916_138933[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138907 === (11))){
var inst_138883 = (state_138906[(8)]);
var inst_138893 = (state_138906[(2)]);
var inst_138894 = (inst_138883 + (1));
var inst_138883__$1 = inst_138894;
var state_138906__$1 = (function (){var statearr_138917 = state_138906;
(statearr_138917[(8)] = inst_138883__$1);

(statearr_138917[(10)] = inst_138893);

return statearr_138917;
})();
var statearr_138918_138934 = state_138906__$1;
(statearr_138918_138934[(2)] = null);

(statearr_138918_138934[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138907 === (9))){
var state_138906__$1 = state_138906;
var statearr_138919_138935 = state_138906__$1;
(statearr_138919_138935[(2)] = null);

(statearr_138919_138935[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138907 === (5))){
var state_138906__$1 = state_138906;
var statearr_138920_138936 = state_138906__$1;
(statearr_138920_138936[(2)] = null);

(statearr_138920_138936[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138907 === (10))){
var inst_138898 = (state_138906[(2)]);
var state_138906__$1 = state_138906;
var statearr_138921_138937 = state_138906__$1;
(statearr_138921_138937[(2)] = inst_138898);

(statearr_138921_138937[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138907 === (8))){
var inst_138888 = (state_138906[(7)]);
var state_138906__$1 = state_138906;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_138906__$1,(11),out,inst_138888);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__33263__auto___138927,out))
;
return ((function (switch__33031__auto__,c__33263__auto___138927,out){
return (function() {
var cljs$core$async$state_machine__33032__auto__ = null;
var cljs$core$async$state_machine__33032__auto____0 = (function (){
var statearr_138922 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_138922[(0)] = cljs$core$async$state_machine__33032__auto__);

(statearr_138922[(1)] = (1));

return statearr_138922;
});
var cljs$core$async$state_machine__33032__auto____1 = (function (state_138906){
while(true){
var ret_value__33033__auto__ = (function (){try{while(true){
var result__33034__auto__ = switch__33031__auto__(state_138906);
if(cljs.core.keyword_identical_QMARK_(result__33034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33034__auto__;
}
break;
}
}catch (e138923){if((e138923 instanceof Object)){
var ex__33035__auto__ = e138923;
var statearr_138924_138938 = state_138906;
(statearr_138924_138938[(5)] = ex__33035__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_138906);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e138923;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__33033__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__138939 = state_138906;
state_138906 = G__138939;
continue;
} else {
return ret_value__33033__auto__;
}
break;
}
});
cljs$core$async$state_machine__33032__auto__ = function(state_138906){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33032__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33032__auto____1.call(this,state_138906);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33032__auto____0;
cljs$core$async$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33032__auto____1;
return cljs$core$async$state_machine__33032__auto__;
})()
;})(switch__33031__auto__,c__33263__auto___138927,out))
})();
var state__33265__auto__ = (function (){var statearr_138925 = (f__33264__auto__.cljs$core$IFn$_invoke$arity$0 ? f__33264__auto__.cljs$core$IFn$_invoke$arity$0() : f__33264__auto__.call(null));
(statearr_138925[(6)] = c__33263__auto___138927);

return statearr_138925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__33265__auto__);
});})(c__33263__auto___138927,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async138941 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async138941 = (function (f,ch,meta138942){
this.f = f;
this.ch = ch;
this.meta138942 = meta138942;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async138941.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_138943,meta138942__$1){
var self__ = this;
var _138943__$1 = this;
return (new cljs.core.async.t_cljs$core$async138941(self__.f,self__.ch,meta138942__$1));
});

cljs.core.async.t_cljs$core$async138941.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_138943){
var self__ = this;
var _138943__$1 = this;
return self__.meta138942;
});

cljs.core.async.t_cljs$core$async138941.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async138941.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async138941.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async138941.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async138941.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async138944 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async138944 = (function (f,ch,meta138942,_,fn1,meta138945){
this.f = f;
this.ch = ch;
this.meta138942 = meta138942;
this._ = _;
this.fn1 = fn1;
this.meta138945 = meta138945;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async138944.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_138946,meta138945__$1){
var self__ = this;
var _138946__$1 = this;
return (new cljs.core.async.t_cljs$core$async138944(self__.f,self__.ch,self__.meta138942,self__._,self__.fn1,meta138945__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async138944.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_138946){
var self__ = this;
var _138946__$1 = this;
return self__.meta138945;
});})(___$1))
;

cljs.core.async.t_cljs$core$async138944.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async138944.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async138944.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async138944.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__138940_SHARP_){
var G__138947 = (((p1__138940_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__138940_SHARP_) : self__.f.call(null,p1__138940_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__138947) : f1.call(null,G__138947));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async138944.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta138942","meta138942",1332659859,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async138941","cljs.core.async/t_cljs$core$async138941",-787077631,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta138945","meta138945",150854716,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async138944.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async138944.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async138944";

cljs.core.async.t_cljs$core$async138944.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async138944");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async138944.
 */
cljs.core.async.__GT_t_cljs$core$async138944 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async138944(f__$1,ch__$1,meta138942__$1,___$2,fn1__$1,meta138945){
return (new cljs.core.async.t_cljs$core$async138944(f__$1,ch__$1,meta138942__$1,___$2,fn1__$1,meta138945));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async138944(self__.f,self__.ch,self__.meta138942,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__3938__auto__ = ret;
if(cljs.core.truth_(and__3938__auto__)){
return !((cljs.core.deref(ret) == null));
} else {
return and__3938__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__138948 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__138948) : self__.f.call(null,G__138948));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async138941.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async138941.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async138941.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta138942","meta138942",1332659859,null)], null);
});

cljs.core.async.t_cljs$core$async138941.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async138941.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async138941";

cljs.core.async.t_cljs$core$async138941.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async138941");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async138941.
 */
cljs.core.async.__GT_t_cljs$core$async138941 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async138941(f__$1,ch__$1,meta138942){
return (new cljs.core.async.t_cljs$core$async138941(f__$1,ch__$1,meta138942));
});

}

return (new cljs.core.async.t_cljs$core$async138941(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async138949 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async138949 = (function (f,ch,meta138950){
this.f = f;
this.ch = ch;
this.meta138950 = meta138950;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async138949.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_138951,meta138950__$1){
var self__ = this;
var _138951__$1 = this;
return (new cljs.core.async.t_cljs$core$async138949(self__.f,self__.ch,meta138950__$1));
});

cljs.core.async.t_cljs$core$async138949.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_138951){
var self__ = this;
var _138951__$1 = this;
return self__.meta138950;
});

cljs.core.async.t_cljs$core$async138949.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async138949.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async138949.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async138949.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async138949.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async138949.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async138949.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta138950","meta138950",-1502186945,null)], null);
});

cljs.core.async.t_cljs$core$async138949.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async138949.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async138949";

cljs.core.async.t_cljs$core$async138949.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async138949");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async138949.
 */
cljs.core.async.__GT_t_cljs$core$async138949 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async138949(f__$1,ch__$1,meta138950){
return (new cljs.core.async.t_cljs$core$async138949(f__$1,ch__$1,meta138950));
});

}

return (new cljs.core.async.t_cljs$core$async138949(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async138952 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async138952 = (function (p,ch,meta138953){
this.p = p;
this.ch = ch;
this.meta138953 = meta138953;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async138952.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_138954,meta138953__$1){
var self__ = this;
var _138954__$1 = this;
return (new cljs.core.async.t_cljs$core$async138952(self__.p,self__.ch,meta138953__$1));
});

cljs.core.async.t_cljs$core$async138952.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_138954){
var self__ = this;
var _138954__$1 = this;
return self__.meta138953;
});

cljs.core.async.t_cljs$core$async138952.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async138952.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async138952.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async138952.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async138952.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async138952.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async138952.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async138952.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta138953","meta138953",-1472855850,null)], null);
});

cljs.core.async.t_cljs$core$async138952.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async138952.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async138952";

cljs.core.async.t_cljs$core$async138952.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async138952");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async138952.
 */
cljs.core.async.__GT_t_cljs$core$async138952 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async138952(p__$1,ch__$1,meta138953){
return (new cljs.core.async.t_cljs$core$async138952(p__$1,ch__$1,meta138953));
});

}

return (new cljs.core.async.t_cljs$core$async138952(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__138956 = arguments.length;
switch (G__138956) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__33263__auto___138996 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__33263__auto___138996,out){
return (function (){
var f__33264__auto__ = (function (){var switch__33031__auto__ = ((function (c__33263__auto___138996,out){
return (function (state_138977){
var state_val_138978 = (state_138977[(1)]);
if((state_val_138978 === (7))){
var inst_138973 = (state_138977[(2)]);
var state_138977__$1 = state_138977;
var statearr_138979_138997 = state_138977__$1;
(statearr_138979_138997[(2)] = inst_138973);

(statearr_138979_138997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138978 === (1))){
var state_138977__$1 = state_138977;
var statearr_138980_138998 = state_138977__$1;
(statearr_138980_138998[(2)] = null);

(statearr_138980_138998[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138978 === (4))){
var inst_138959 = (state_138977[(7)]);
var inst_138959__$1 = (state_138977[(2)]);
var inst_138960 = (inst_138959__$1 == null);
var state_138977__$1 = (function (){var statearr_138981 = state_138977;
(statearr_138981[(7)] = inst_138959__$1);

return statearr_138981;
})();
if(cljs.core.truth_(inst_138960)){
var statearr_138982_138999 = state_138977__$1;
(statearr_138982_138999[(1)] = (5));

} else {
var statearr_138983_139000 = state_138977__$1;
(statearr_138983_139000[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138978 === (6))){
var inst_138959 = (state_138977[(7)]);
var inst_138964 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_138959) : p.call(null,inst_138959));
var state_138977__$1 = state_138977;
if(cljs.core.truth_(inst_138964)){
var statearr_138984_139001 = state_138977__$1;
(statearr_138984_139001[(1)] = (8));

} else {
var statearr_138985_139002 = state_138977__$1;
(statearr_138985_139002[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138978 === (3))){
var inst_138975 = (state_138977[(2)]);
var state_138977__$1 = state_138977;
return cljs.core.async.impl.ioc_helpers.return_chan(state_138977__$1,inst_138975);
} else {
if((state_val_138978 === (2))){
var state_138977__$1 = state_138977;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_138977__$1,(4),ch);
} else {
if((state_val_138978 === (11))){
var inst_138967 = (state_138977[(2)]);
var state_138977__$1 = state_138977;
var statearr_138986_139003 = state_138977__$1;
(statearr_138986_139003[(2)] = inst_138967);

(statearr_138986_139003[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138978 === (9))){
var state_138977__$1 = state_138977;
var statearr_138987_139004 = state_138977__$1;
(statearr_138987_139004[(2)] = null);

(statearr_138987_139004[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138978 === (5))){
var inst_138962 = cljs.core.async.close_BANG_(out);
var state_138977__$1 = state_138977;
var statearr_138988_139005 = state_138977__$1;
(statearr_138988_139005[(2)] = inst_138962);

(statearr_138988_139005[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138978 === (10))){
var inst_138970 = (state_138977[(2)]);
var state_138977__$1 = (function (){var statearr_138989 = state_138977;
(statearr_138989[(8)] = inst_138970);

return statearr_138989;
})();
var statearr_138990_139006 = state_138977__$1;
(statearr_138990_139006[(2)] = null);

(statearr_138990_139006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_138978 === (8))){
var inst_138959 = (state_138977[(7)]);
var state_138977__$1 = state_138977;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_138977__$1,(11),out,inst_138959);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__33263__auto___138996,out))
;
return ((function (switch__33031__auto__,c__33263__auto___138996,out){
return (function() {
var cljs$core$async$state_machine__33032__auto__ = null;
var cljs$core$async$state_machine__33032__auto____0 = (function (){
var statearr_138991 = [null,null,null,null,null,null,null,null,null];
(statearr_138991[(0)] = cljs$core$async$state_machine__33032__auto__);

(statearr_138991[(1)] = (1));

return statearr_138991;
});
var cljs$core$async$state_machine__33032__auto____1 = (function (state_138977){
while(true){
var ret_value__33033__auto__ = (function (){try{while(true){
var result__33034__auto__ = switch__33031__auto__(state_138977);
if(cljs.core.keyword_identical_QMARK_(result__33034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33034__auto__;
}
break;
}
}catch (e138992){if((e138992 instanceof Object)){
var ex__33035__auto__ = e138992;
var statearr_138993_139007 = state_138977;
(statearr_138993_139007[(5)] = ex__33035__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_138977);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e138992;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__33033__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__139008 = state_138977;
state_138977 = G__139008;
continue;
} else {
return ret_value__33033__auto__;
}
break;
}
});
cljs$core$async$state_machine__33032__auto__ = function(state_138977){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33032__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33032__auto____1.call(this,state_138977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33032__auto____0;
cljs$core$async$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33032__auto____1;
return cljs$core$async$state_machine__33032__auto__;
})()
;})(switch__33031__auto__,c__33263__auto___138996,out))
})();
var state__33265__auto__ = (function (){var statearr_138994 = (f__33264__auto__.cljs$core$IFn$_invoke$arity$0 ? f__33264__auto__.cljs$core$IFn$_invoke$arity$0() : f__33264__auto__.call(null));
(statearr_138994[(6)] = c__33263__auto___138996);

return statearr_138994;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__33265__auto__);
});})(c__33263__auto___138996,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__139010 = arguments.length;
switch (G__139010) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__33263__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__33263__auto__){
return (function (){
var f__33264__auto__ = (function (){var switch__33031__auto__ = ((function (c__33263__auto__){
return (function (state_139073){
var state_val_139074 = (state_139073[(1)]);
if((state_val_139074 === (7))){
var inst_139069 = (state_139073[(2)]);
var state_139073__$1 = state_139073;
var statearr_139075_139113 = state_139073__$1;
(statearr_139075_139113[(2)] = inst_139069);

(statearr_139075_139113[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139074 === (20))){
var inst_139039 = (state_139073[(7)]);
var inst_139050 = (state_139073[(2)]);
var inst_139051 = cljs.core.next(inst_139039);
var inst_139025 = inst_139051;
var inst_139026 = null;
var inst_139027 = (0);
var inst_139028 = (0);
var state_139073__$1 = (function (){var statearr_139076 = state_139073;
(statearr_139076[(8)] = inst_139026);

(statearr_139076[(9)] = inst_139050);

(statearr_139076[(10)] = inst_139025);

(statearr_139076[(11)] = inst_139028);

(statearr_139076[(12)] = inst_139027);

return statearr_139076;
})();
var statearr_139077_139114 = state_139073__$1;
(statearr_139077_139114[(2)] = null);

(statearr_139077_139114[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139074 === (1))){
var state_139073__$1 = state_139073;
var statearr_139078_139115 = state_139073__$1;
(statearr_139078_139115[(2)] = null);

(statearr_139078_139115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139074 === (4))){
var inst_139014 = (state_139073[(13)]);
var inst_139014__$1 = (state_139073[(2)]);
var inst_139015 = (inst_139014__$1 == null);
var state_139073__$1 = (function (){var statearr_139079 = state_139073;
(statearr_139079[(13)] = inst_139014__$1);

return statearr_139079;
})();
if(cljs.core.truth_(inst_139015)){
var statearr_139080_139116 = state_139073__$1;
(statearr_139080_139116[(1)] = (5));

} else {
var statearr_139081_139117 = state_139073__$1;
(statearr_139081_139117[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139074 === (15))){
var state_139073__$1 = state_139073;
var statearr_139085_139118 = state_139073__$1;
(statearr_139085_139118[(2)] = null);

(statearr_139085_139118[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139074 === (21))){
var state_139073__$1 = state_139073;
var statearr_139086_139119 = state_139073__$1;
(statearr_139086_139119[(2)] = null);

(statearr_139086_139119[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139074 === (13))){
var inst_139026 = (state_139073[(8)]);
var inst_139025 = (state_139073[(10)]);
var inst_139028 = (state_139073[(11)]);
var inst_139027 = (state_139073[(12)]);
var inst_139035 = (state_139073[(2)]);
var inst_139036 = (inst_139028 + (1));
var tmp139082 = inst_139026;
var tmp139083 = inst_139025;
var tmp139084 = inst_139027;
var inst_139025__$1 = tmp139083;
var inst_139026__$1 = tmp139082;
var inst_139027__$1 = tmp139084;
var inst_139028__$1 = inst_139036;
var state_139073__$1 = (function (){var statearr_139087 = state_139073;
(statearr_139087[(14)] = inst_139035);

(statearr_139087[(8)] = inst_139026__$1);

(statearr_139087[(10)] = inst_139025__$1);

(statearr_139087[(11)] = inst_139028__$1);

(statearr_139087[(12)] = inst_139027__$1);

return statearr_139087;
})();
var statearr_139088_139120 = state_139073__$1;
(statearr_139088_139120[(2)] = null);

(statearr_139088_139120[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139074 === (22))){
var state_139073__$1 = state_139073;
var statearr_139089_139121 = state_139073__$1;
(statearr_139089_139121[(2)] = null);

(statearr_139089_139121[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139074 === (6))){
var inst_139014 = (state_139073[(13)]);
var inst_139023 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_139014) : f.call(null,inst_139014));
var inst_139024 = cljs.core.seq(inst_139023);
var inst_139025 = inst_139024;
var inst_139026 = null;
var inst_139027 = (0);
var inst_139028 = (0);
var state_139073__$1 = (function (){var statearr_139090 = state_139073;
(statearr_139090[(8)] = inst_139026);

(statearr_139090[(10)] = inst_139025);

(statearr_139090[(11)] = inst_139028);

(statearr_139090[(12)] = inst_139027);

return statearr_139090;
})();
var statearr_139091_139122 = state_139073__$1;
(statearr_139091_139122[(2)] = null);

(statearr_139091_139122[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139074 === (17))){
var inst_139039 = (state_139073[(7)]);
var inst_139043 = cljs.core.chunk_first(inst_139039);
var inst_139044 = cljs.core.chunk_rest(inst_139039);
var inst_139045 = cljs.core.count(inst_139043);
var inst_139025 = inst_139044;
var inst_139026 = inst_139043;
var inst_139027 = inst_139045;
var inst_139028 = (0);
var state_139073__$1 = (function (){var statearr_139092 = state_139073;
(statearr_139092[(8)] = inst_139026);

(statearr_139092[(10)] = inst_139025);

(statearr_139092[(11)] = inst_139028);

(statearr_139092[(12)] = inst_139027);

return statearr_139092;
})();
var statearr_139093_139123 = state_139073__$1;
(statearr_139093_139123[(2)] = null);

(statearr_139093_139123[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139074 === (3))){
var inst_139071 = (state_139073[(2)]);
var state_139073__$1 = state_139073;
return cljs.core.async.impl.ioc_helpers.return_chan(state_139073__$1,inst_139071);
} else {
if((state_val_139074 === (12))){
var inst_139059 = (state_139073[(2)]);
var state_139073__$1 = state_139073;
var statearr_139094_139124 = state_139073__$1;
(statearr_139094_139124[(2)] = inst_139059);

(statearr_139094_139124[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139074 === (2))){
var state_139073__$1 = state_139073;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_139073__$1,(4),in$);
} else {
if((state_val_139074 === (23))){
var inst_139067 = (state_139073[(2)]);
var state_139073__$1 = state_139073;
var statearr_139095_139125 = state_139073__$1;
(statearr_139095_139125[(2)] = inst_139067);

(statearr_139095_139125[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139074 === (19))){
var inst_139054 = (state_139073[(2)]);
var state_139073__$1 = state_139073;
var statearr_139096_139126 = state_139073__$1;
(statearr_139096_139126[(2)] = inst_139054);

(statearr_139096_139126[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139074 === (11))){
var inst_139039 = (state_139073[(7)]);
var inst_139025 = (state_139073[(10)]);
var inst_139039__$1 = cljs.core.seq(inst_139025);
var state_139073__$1 = (function (){var statearr_139097 = state_139073;
(statearr_139097[(7)] = inst_139039__$1);

return statearr_139097;
})();
if(inst_139039__$1){
var statearr_139098_139127 = state_139073__$1;
(statearr_139098_139127[(1)] = (14));

} else {
var statearr_139099_139128 = state_139073__$1;
(statearr_139099_139128[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139074 === (9))){
var inst_139061 = (state_139073[(2)]);
var inst_139062 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_139073__$1 = (function (){var statearr_139100 = state_139073;
(statearr_139100[(15)] = inst_139061);

return statearr_139100;
})();
if(cljs.core.truth_(inst_139062)){
var statearr_139101_139129 = state_139073__$1;
(statearr_139101_139129[(1)] = (21));

} else {
var statearr_139102_139130 = state_139073__$1;
(statearr_139102_139130[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139074 === (5))){
var inst_139017 = cljs.core.async.close_BANG_(out);
var state_139073__$1 = state_139073;
var statearr_139103_139131 = state_139073__$1;
(statearr_139103_139131[(2)] = inst_139017);

(statearr_139103_139131[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139074 === (14))){
var inst_139039 = (state_139073[(7)]);
var inst_139041 = cljs.core.chunked_seq_QMARK_(inst_139039);
var state_139073__$1 = state_139073;
if(inst_139041){
var statearr_139104_139132 = state_139073__$1;
(statearr_139104_139132[(1)] = (17));

} else {
var statearr_139105_139133 = state_139073__$1;
(statearr_139105_139133[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139074 === (16))){
var inst_139057 = (state_139073[(2)]);
var state_139073__$1 = state_139073;
var statearr_139106_139134 = state_139073__$1;
(statearr_139106_139134[(2)] = inst_139057);

(statearr_139106_139134[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139074 === (10))){
var inst_139026 = (state_139073[(8)]);
var inst_139028 = (state_139073[(11)]);
var inst_139033 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_139026,inst_139028);
var state_139073__$1 = state_139073;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_139073__$1,(13),out,inst_139033);
} else {
if((state_val_139074 === (18))){
var inst_139039 = (state_139073[(7)]);
var inst_139048 = cljs.core.first(inst_139039);
var state_139073__$1 = state_139073;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_139073__$1,(20),out,inst_139048);
} else {
if((state_val_139074 === (8))){
var inst_139028 = (state_139073[(11)]);
var inst_139027 = (state_139073[(12)]);
var inst_139030 = (inst_139028 < inst_139027);
var inst_139031 = inst_139030;
var state_139073__$1 = state_139073;
if(cljs.core.truth_(inst_139031)){
var statearr_139107_139135 = state_139073__$1;
(statearr_139107_139135[(1)] = (10));

} else {
var statearr_139108_139136 = state_139073__$1;
(statearr_139108_139136[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33263__auto__))
;
return ((function (switch__33031__auto__,c__33263__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__33032__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__33032__auto____0 = (function (){
var statearr_139109 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_139109[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__33032__auto__);

(statearr_139109[(1)] = (1));

return statearr_139109;
});
var cljs$core$async$mapcat_STAR__$_state_machine__33032__auto____1 = (function (state_139073){
while(true){
var ret_value__33033__auto__ = (function (){try{while(true){
var result__33034__auto__ = switch__33031__auto__(state_139073);
if(cljs.core.keyword_identical_QMARK_(result__33034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33034__auto__;
}
break;
}
}catch (e139110){if((e139110 instanceof Object)){
var ex__33035__auto__ = e139110;
var statearr_139111_139137 = state_139073;
(statearr_139111_139137[(5)] = ex__33035__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_139073);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e139110;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__33033__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__139138 = state_139073;
state_139073 = G__139138;
continue;
} else {
return ret_value__33033__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__33032__auto__ = function(state_139073){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__33032__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__33032__auto____1.call(this,state_139073);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__33032__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__33032__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__33032__auto__;
})()
;})(switch__33031__auto__,c__33263__auto__))
})();
var state__33265__auto__ = (function (){var statearr_139112 = (f__33264__auto__.cljs$core$IFn$_invoke$arity$0 ? f__33264__auto__.cljs$core$IFn$_invoke$arity$0() : f__33264__auto__.call(null));
(statearr_139112[(6)] = c__33263__auto__);

return statearr_139112;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__33265__auto__);
});})(c__33263__auto__))
);

return c__33263__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__139140 = arguments.length;
switch (G__139140) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__139143 = arguments.length;
switch (G__139143) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__139146 = arguments.length;
switch (G__139146) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__33263__auto___139193 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__33263__auto___139193,out){
return (function (){
var f__33264__auto__ = (function (){var switch__33031__auto__ = ((function (c__33263__auto___139193,out){
return (function (state_139170){
var state_val_139171 = (state_139170[(1)]);
if((state_val_139171 === (7))){
var inst_139165 = (state_139170[(2)]);
var state_139170__$1 = state_139170;
var statearr_139172_139194 = state_139170__$1;
(statearr_139172_139194[(2)] = inst_139165);

(statearr_139172_139194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139171 === (1))){
var inst_139147 = null;
var state_139170__$1 = (function (){var statearr_139173 = state_139170;
(statearr_139173[(7)] = inst_139147);

return statearr_139173;
})();
var statearr_139174_139195 = state_139170__$1;
(statearr_139174_139195[(2)] = null);

(statearr_139174_139195[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139171 === (4))){
var inst_139150 = (state_139170[(8)]);
var inst_139150__$1 = (state_139170[(2)]);
var inst_139151 = (inst_139150__$1 == null);
var inst_139152 = cljs.core.not(inst_139151);
var state_139170__$1 = (function (){var statearr_139175 = state_139170;
(statearr_139175[(8)] = inst_139150__$1);

return statearr_139175;
})();
if(inst_139152){
var statearr_139176_139196 = state_139170__$1;
(statearr_139176_139196[(1)] = (5));

} else {
var statearr_139177_139197 = state_139170__$1;
(statearr_139177_139197[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139171 === (6))){
var state_139170__$1 = state_139170;
var statearr_139178_139198 = state_139170__$1;
(statearr_139178_139198[(2)] = null);

(statearr_139178_139198[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139171 === (3))){
var inst_139167 = (state_139170[(2)]);
var inst_139168 = cljs.core.async.close_BANG_(out);
var state_139170__$1 = (function (){var statearr_139179 = state_139170;
(statearr_139179[(9)] = inst_139167);

return statearr_139179;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_139170__$1,inst_139168);
} else {
if((state_val_139171 === (2))){
var state_139170__$1 = state_139170;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_139170__$1,(4),ch);
} else {
if((state_val_139171 === (11))){
var inst_139150 = (state_139170[(8)]);
var inst_139159 = (state_139170[(2)]);
var inst_139147 = inst_139150;
var state_139170__$1 = (function (){var statearr_139180 = state_139170;
(statearr_139180[(7)] = inst_139147);

(statearr_139180[(10)] = inst_139159);

return statearr_139180;
})();
var statearr_139181_139199 = state_139170__$1;
(statearr_139181_139199[(2)] = null);

(statearr_139181_139199[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139171 === (9))){
var inst_139150 = (state_139170[(8)]);
var state_139170__$1 = state_139170;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_139170__$1,(11),out,inst_139150);
} else {
if((state_val_139171 === (5))){
var inst_139150 = (state_139170[(8)]);
var inst_139147 = (state_139170[(7)]);
var inst_139154 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_139150,inst_139147);
var state_139170__$1 = state_139170;
if(inst_139154){
var statearr_139183_139200 = state_139170__$1;
(statearr_139183_139200[(1)] = (8));

} else {
var statearr_139184_139201 = state_139170__$1;
(statearr_139184_139201[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139171 === (10))){
var inst_139162 = (state_139170[(2)]);
var state_139170__$1 = state_139170;
var statearr_139185_139202 = state_139170__$1;
(statearr_139185_139202[(2)] = inst_139162);

(statearr_139185_139202[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139171 === (8))){
var inst_139147 = (state_139170[(7)]);
var tmp139182 = inst_139147;
var inst_139147__$1 = tmp139182;
var state_139170__$1 = (function (){var statearr_139186 = state_139170;
(statearr_139186[(7)] = inst_139147__$1);

return statearr_139186;
})();
var statearr_139187_139203 = state_139170__$1;
(statearr_139187_139203[(2)] = null);

(statearr_139187_139203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__33263__auto___139193,out))
;
return ((function (switch__33031__auto__,c__33263__auto___139193,out){
return (function() {
var cljs$core$async$state_machine__33032__auto__ = null;
var cljs$core$async$state_machine__33032__auto____0 = (function (){
var statearr_139188 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_139188[(0)] = cljs$core$async$state_machine__33032__auto__);

(statearr_139188[(1)] = (1));

return statearr_139188;
});
var cljs$core$async$state_machine__33032__auto____1 = (function (state_139170){
while(true){
var ret_value__33033__auto__ = (function (){try{while(true){
var result__33034__auto__ = switch__33031__auto__(state_139170);
if(cljs.core.keyword_identical_QMARK_(result__33034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33034__auto__;
}
break;
}
}catch (e139189){if((e139189 instanceof Object)){
var ex__33035__auto__ = e139189;
var statearr_139190_139204 = state_139170;
(statearr_139190_139204[(5)] = ex__33035__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_139170);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e139189;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__33033__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__139205 = state_139170;
state_139170 = G__139205;
continue;
} else {
return ret_value__33033__auto__;
}
break;
}
});
cljs$core$async$state_machine__33032__auto__ = function(state_139170){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33032__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33032__auto____1.call(this,state_139170);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33032__auto____0;
cljs$core$async$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33032__auto____1;
return cljs$core$async$state_machine__33032__auto__;
})()
;})(switch__33031__auto__,c__33263__auto___139193,out))
})();
var state__33265__auto__ = (function (){var statearr_139191 = (f__33264__auto__.cljs$core$IFn$_invoke$arity$0 ? f__33264__auto__.cljs$core$IFn$_invoke$arity$0() : f__33264__auto__.call(null));
(statearr_139191[(6)] = c__33263__auto___139193);

return statearr_139191;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__33265__auto__);
});})(c__33263__auto___139193,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__139207 = arguments.length;
switch (G__139207) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__33263__auto___139273 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__33263__auto___139273,out){
return (function (){
var f__33264__auto__ = (function (){var switch__33031__auto__ = ((function (c__33263__auto___139273,out){
return (function (state_139245){
var state_val_139246 = (state_139245[(1)]);
if((state_val_139246 === (7))){
var inst_139241 = (state_139245[(2)]);
var state_139245__$1 = state_139245;
var statearr_139247_139274 = state_139245__$1;
(statearr_139247_139274[(2)] = inst_139241);

(statearr_139247_139274[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139246 === (1))){
var inst_139208 = (new Array(n));
var inst_139209 = inst_139208;
var inst_139210 = (0);
var state_139245__$1 = (function (){var statearr_139248 = state_139245;
(statearr_139248[(7)] = inst_139209);

(statearr_139248[(8)] = inst_139210);

return statearr_139248;
})();
var statearr_139249_139275 = state_139245__$1;
(statearr_139249_139275[(2)] = null);

(statearr_139249_139275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139246 === (4))){
var inst_139213 = (state_139245[(9)]);
var inst_139213__$1 = (state_139245[(2)]);
var inst_139214 = (inst_139213__$1 == null);
var inst_139215 = cljs.core.not(inst_139214);
var state_139245__$1 = (function (){var statearr_139250 = state_139245;
(statearr_139250[(9)] = inst_139213__$1);

return statearr_139250;
})();
if(inst_139215){
var statearr_139251_139276 = state_139245__$1;
(statearr_139251_139276[(1)] = (5));

} else {
var statearr_139252_139277 = state_139245__$1;
(statearr_139252_139277[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139246 === (15))){
var inst_139235 = (state_139245[(2)]);
var state_139245__$1 = state_139245;
var statearr_139253_139278 = state_139245__$1;
(statearr_139253_139278[(2)] = inst_139235);

(statearr_139253_139278[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139246 === (13))){
var state_139245__$1 = state_139245;
var statearr_139254_139279 = state_139245__$1;
(statearr_139254_139279[(2)] = null);

(statearr_139254_139279[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139246 === (6))){
var inst_139210 = (state_139245[(8)]);
var inst_139231 = (inst_139210 > (0));
var state_139245__$1 = state_139245;
if(cljs.core.truth_(inst_139231)){
var statearr_139255_139280 = state_139245__$1;
(statearr_139255_139280[(1)] = (12));

} else {
var statearr_139256_139281 = state_139245__$1;
(statearr_139256_139281[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139246 === (3))){
var inst_139243 = (state_139245[(2)]);
var state_139245__$1 = state_139245;
return cljs.core.async.impl.ioc_helpers.return_chan(state_139245__$1,inst_139243);
} else {
if((state_val_139246 === (12))){
var inst_139209 = (state_139245[(7)]);
var inst_139233 = cljs.core.vec(inst_139209);
var state_139245__$1 = state_139245;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_139245__$1,(15),out,inst_139233);
} else {
if((state_val_139246 === (2))){
var state_139245__$1 = state_139245;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_139245__$1,(4),ch);
} else {
if((state_val_139246 === (11))){
var inst_139225 = (state_139245[(2)]);
var inst_139226 = (new Array(n));
var inst_139209 = inst_139226;
var inst_139210 = (0);
var state_139245__$1 = (function (){var statearr_139257 = state_139245;
(statearr_139257[(7)] = inst_139209);

(statearr_139257[(8)] = inst_139210);

(statearr_139257[(10)] = inst_139225);

return statearr_139257;
})();
var statearr_139258_139282 = state_139245__$1;
(statearr_139258_139282[(2)] = null);

(statearr_139258_139282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139246 === (9))){
var inst_139209 = (state_139245[(7)]);
var inst_139223 = cljs.core.vec(inst_139209);
var state_139245__$1 = state_139245;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_139245__$1,(11),out,inst_139223);
} else {
if((state_val_139246 === (5))){
var inst_139213 = (state_139245[(9)]);
var inst_139209 = (state_139245[(7)]);
var inst_139210 = (state_139245[(8)]);
var inst_139218 = (state_139245[(11)]);
var inst_139217 = (inst_139209[inst_139210] = inst_139213);
var inst_139218__$1 = (inst_139210 + (1));
var inst_139219 = (inst_139218__$1 < n);
var state_139245__$1 = (function (){var statearr_139259 = state_139245;
(statearr_139259[(12)] = inst_139217);

(statearr_139259[(11)] = inst_139218__$1);

return statearr_139259;
})();
if(cljs.core.truth_(inst_139219)){
var statearr_139260_139283 = state_139245__$1;
(statearr_139260_139283[(1)] = (8));

} else {
var statearr_139261_139284 = state_139245__$1;
(statearr_139261_139284[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139246 === (14))){
var inst_139238 = (state_139245[(2)]);
var inst_139239 = cljs.core.async.close_BANG_(out);
var state_139245__$1 = (function (){var statearr_139263 = state_139245;
(statearr_139263[(13)] = inst_139238);

return statearr_139263;
})();
var statearr_139264_139285 = state_139245__$1;
(statearr_139264_139285[(2)] = inst_139239);

(statearr_139264_139285[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139246 === (10))){
var inst_139229 = (state_139245[(2)]);
var state_139245__$1 = state_139245;
var statearr_139265_139286 = state_139245__$1;
(statearr_139265_139286[(2)] = inst_139229);

(statearr_139265_139286[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139246 === (8))){
var inst_139209 = (state_139245[(7)]);
var inst_139218 = (state_139245[(11)]);
var tmp139262 = inst_139209;
var inst_139209__$1 = tmp139262;
var inst_139210 = inst_139218;
var state_139245__$1 = (function (){var statearr_139266 = state_139245;
(statearr_139266[(7)] = inst_139209__$1);

(statearr_139266[(8)] = inst_139210);

return statearr_139266;
})();
var statearr_139267_139287 = state_139245__$1;
(statearr_139267_139287[(2)] = null);

(statearr_139267_139287[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33263__auto___139273,out))
;
return ((function (switch__33031__auto__,c__33263__auto___139273,out){
return (function() {
var cljs$core$async$state_machine__33032__auto__ = null;
var cljs$core$async$state_machine__33032__auto____0 = (function (){
var statearr_139268 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_139268[(0)] = cljs$core$async$state_machine__33032__auto__);

(statearr_139268[(1)] = (1));

return statearr_139268;
});
var cljs$core$async$state_machine__33032__auto____1 = (function (state_139245){
while(true){
var ret_value__33033__auto__ = (function (){try{while(true){
var result__33034__auto__ = switch__33031__auto__(state_139245);
if(cljs.core.keyword_identical_QMARK_(result__33034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33034__auto__;
}
break;
}
}catch (e139269){if((e139269 instanceof Object)){
var ex__33035__auto__ = e139269;
var statearr_139270_139288 = state_139245;
(statearr_139270_139288[(5)] = ex__33035__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_139245);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e139269;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__33033__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__139289 = state_139245;
state_139245 = G__139289;
continue;
} else {
return ret_value__33033__auto__;
}
break;
}
});
cljs$core$async$state_machine__33032__auto__ = function(state_139245){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33032__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33032__auto____1.call(this,state_139245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33032__auto____0;
cljs$core$async$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33032__auto____1;
return cljs$core$async$state_machine__33032__auto__;
})()
;})(switch__33031__auto__,c__33263__auto___139273,out))
})();
var state__33265__auto__ = (function (){var statearr_139271 = (f__33264__auto__.cljs$core$IFn$_invoke$arity$0 ? f__33264__auto__.cljs$core$IFn$_invoke$arity$0() : f__33264__auto__.call(null));
(statearr_139271[(6)] = c__33263__auto___139273);

return statearr_139271;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__33265__auto__);
});})(c__33263__auto___139273,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__139291 = arguments.length;
switch (G__139291) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__33263__auto___139361 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__33263__auto___139361,out){
return (function (){
var f__33264__auto__ = (function (){var switch__33031__auto__ = ((function (c__33263__auto___139361,out){
return (function (state_139333){
var state_val_139334 = (state_139333[(1)]);
if((state_val_139334 === (7))){
var inst_139329 = (state_139333[(2)]);
var state_139333__$1 = state_139333;
var statearr_139335_139362 = state_139333__$1;
(statearr_139335_139362[(2)] = inst_139329);

(statearr_139335_139362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139334 === (1))){
var inst_139292 = [];
var inst_139293 = inst_139292;
var inst_139294 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_139333__$1 = (function (){var statearr_139336 = state_139333;
(statearr_139336[(7)] = inst_139294);

(statearr_139336[(8)] = inst_139293);

return statearr_139336;
})();
var statearr_139337_139363 = state_139333__$1;
(statearr_139337_139363[(2)] = null);

(statearr_139337_139363[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139334 === (4))){
var inst_139297 = (state_139333[(9)]);
var inst_139297__$1 = (state_139333[(2)]);
var inst_139298 = (inst_139297__$1 == null);
var inst_139299 = cljs.core.not(inst_139298);
var state_139333__$1 = (function (){var statearr_139338 = state_139333;
(statearr_139338[(9)] = inst_139297__$1);

return statearr_139338;
})();
if(inst_139299){
var statearr_139339_139364 = state_139333__$1;
(statearr_139339_139364[(1)] = (5));

} else {
var statearr_139340_139365 = state_139333__$1;
(statearr_139340_139365[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139334 === (15))){
var inst_139323 = (state_139333[(2)]);
var state_139333__$1 = state_139333;
var statearr_139341_139366 = state_139333__$1;
(statearr_139341_139366[(2)] = inst_139323);

(statearr_139341_139366[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139334 === (13))){
var state_139333__$1 = state_139333;
var statearr_139342_139367 = state_139333__$1;
(statearr_139342_139367[(2)] = null);

(statearr_139342_139367[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139334 === (6))){
var inst_139293 = (state_139333[(8)]);
var inst_139318 = inst_139293.length;
var inst_139319 = (inst_139318 > (0));
var state_139333__$1 = state_139333;
if(cljs.core.truth_(inst_139319)){
var statearr_139343_139368 = state_139333__$1;
(statearr_139343_139368[(1)] = (12));

} else {
var statearr_139344_139369 = state_139333__$1;
(statearr_139344_139369[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139334 === (3))){
var inst_139331 = (state_139333[(2)]);
var state_139333__$1 = state_139333;
return cljs.core.async.impl.ioc_helpers.return_chan(state_139333__$1,inst_139331);
} else {
if((state_val_139334 === (12))){
var inst_139293 = (state_139333[(8)]);
var inst_139321 = cljs.core.vec(inst_139293);
var state_139333__$1 = state_139333;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_139333__$1,(15),out,inst_139321);
} else {
if((state_val_139334 === (2))){
var state_139333__$1 = state_139333;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_139333__$1,(4),ch);
} else {
if((state_val_139334 === (11))){
var inst_139297 = (state_139333[(9)]);
var inst_139301 = (state_139333[(10)]);
var inst_139311 = (state_139333[(2)]);
var inst_139312 = [];
var inst_139313 = inst_139312.push(inst_139297);
var inst_139293 = inst_139312;
var inst_139294 = inst_139301;
var state_139333__$1 = (function (){var statearr_139345 = state_139333;
(statearr_139345[(11)] = inst_139311);

(statearr_139345[(7)] = inst_139294);

(statearr_139345[(12)] = inst_139313);

(statearr_139345[(8)] = inst_139293);

return statearr_139345;
})();
var statearr_139346_139370 = state_139333__$1;
(statearr_139346_139370[(2)] = null);

(statearr_139346_139370[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139334 === (9))){
var inst_139293 = (state_139333[(8)]);
var inst_139309 = cljs.core.vec(inst_139293);
var state_139333__$1 = state_139333;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_139333__$1,(11),out,inst_139309);
} else {
if((state_val_139334 === (5))){
var inst_139297 = (state_139333[(9)]);
var inst_139301 = (state_139333[(10)]);
var inst_139294 = (state_139333[(7)]);
var inst_139301__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_139297) : f.call(null,inst_139297));
var inst_139302 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_139301__$1,inst_139294);
var inst_139303 = cljs.core.keyword_identical_QMARK_(inst_139294,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_139304 = ((inst_139302) || (inst_139303));
var state_139333__$1 = (function (){var statearr_139347 = state_139333;
(statearr_139347[(10)] = inst_139301__$1);

return statearr_139347;
})();
if(cljs.core.truth_(inst_139304)){
var statearr_139348_139371 = state_139333__$1;
(statearr_139348_139371[(1)] = (8));

} else {
var statearr_139349_139372 = state_139333__$1;
(statearr_139349_139372[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139334 === (14))){
var inst_139326 = (state_139333[(2)]);
var inst_139327 = cljs.core.async.close_BANG_(out);
var state_139333__$1 = (function (){var statearr_139351 = state_139333;
(statearr_139351[(13)] = inst_139326);

return statearr_139351;
})();
var statearr_139352_139373 = state_139333__$1;
(statearr_139352_139373[(2)] = inst_139327);

(statearr_139352_139373[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139334 === (10))){
var inst_139316 = (state_139333[(2)]);
var state_139333__$1 = state_139333;
var statearr_139353_139374 = state_139333__$1;
(statearr_139353_139374[(2)] = inst_139316);

(statearr_139353_139374[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139334 === (8))){
var inst_139297 = (state_139333[(9)]);
var inst_139301 = (state_139333[(10)]);
var inst_139293 = (state_139333[(8)]);
var inst_139306 = inst_139293.push(inst_139297);
var tmp139350 = inst_139293;
var inst_139293__$1 = tmp139350;
var inst_139294 = inst_139301;
var state_139333__$1 = (function (){var statearr_139354 = state_139333;
(statearr_139354[(14)] = inst_139306);

(statearr_139354[(7)] = inst_139294);

(statearr_139354[(8)] = inst_139293__$1);

return statearr_139354;
})();
var statearr_139355_139375 = state_139333__$1;
(statearr_139355_139375[(2)] = null);

(statearr_139355_139375[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33263__auto___139361,out))
;
return ((function (switch__33031__auto__,c__33263__auto___139361,out){
return (function() {
var cljs$core$async$state_machine__33032__auto__ = null;
var cljs$core$async$state_machine__33032__auto____0 = (function (){
var statearr_139356 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_139356[(0)] = cljs$core$async$state_machine__33032__auto__);

(statearr_139356[(1)] = (1));

return statearr_139356;
});
var cljs$core$async$state_machine__33032__auto____1 = (function (state_139333){
while(true){
var ret_value__33033__auto__ = (function (){try{while(true){
var result__33034__auto__ = switch__33031__auto__(state_139333);
if(cljs.core.keyword_identical_QMARK_(result__33034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33034__auto__;
}
break;
}
}catch (e139357){if((e139357 instanceof Object)){
var ex__33035__auto__ = e139357;
var statearr_139358_139376 = state_139333;
(statearr_139358_139376[(5)] = ex__33035__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_139333);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e139357;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__33033__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__139377 = state_139333;
state_139333 = G__139377;
continue;
} else {
return ret_value__33033__auto__;
}
break;
}
});
cljs$core$async$state_machine__33032__auto__ = function(state_139333){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33032__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33032__auto____1.call(this,state_139333);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33032__auto____0;
cljs$core$async$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33032__auto____1;
return cljs$core$async$state_machine__33032__auto__;
})()
;})(switch__33031__auto__,c__33263__auto___139361,out))
})();
var state__33265__auto__ = (function (){var statearr_139359 = (f__33264__auto__.cljs$core$IFn$_invoke$arity$0 ? f__33264__auto__.cljs$core$IFn$_invoke$arity$0() : f__33264__auto__.call(null));
(statearr_139359[(6)] = c__33263__auto___139361);

return statearr_139359;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__33265__auto__);
});})(c__33263__auto___139361,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=cljs.core.async.js.map
