(defproject thi.ng/color "0.1.0-SNAPSHOT"
  :description  "Cross-platform CLJ/CLJS library for color conversion & manipulation."
  :url          "http://thi.ng/color"
  :license      {:name "Apache Software License 2.0"
                 :url "http://www.apache.org/licenses/LICENSE-2.0"}
  :scm          {:name "git"
                 :url  "https://github.com/thi-ng/color"}
  :dependencies [[org.clojure/clojure "1.6.0"]
                 [thi.ng/common "0.3.0-SNAPSHOT"]
                 [thi.ng/macromath "0.2.3"]]

  :source-paths ["src/cljx"]
  :test-paths   ["target/test-classes"]

  :profiles {:dev {:dependencies [[org.clojure/clojurescript "0.0-2322"]
                                  [criterium "0.4.3"]]
                   :plugins      [[com.keminglabs/cljx "0.4.0"]
                                  [lein-cljsbuild "1.0.3"]
                                  [com.cemerick/clojurescript.test "0.3.1"]
                                  [com.cemerick/austin "0.1.4"]]
                   :hooks [cljx.hooks]
                   :aliases {"cleantest" ["do" "clean," "test," "cljsbuild" "test"]}}}

  :cljx {:builds [{:source-paths ["src/cljx"]
                   :output-path "target/classes"
                   :rules :clj}
                  {:source-paths ["src/cljx"]
                   :output-path "target/classes"
                   :rules :cljs}
                  {:source-paths ["test/cljx"]
                   :output-path "target/test-classes"
                   :rules :clj}
                  {:source-paths ["test/cljx"]
                   :output-path "target/test-classes"
                   :rules :cljs}]}

  :cljsbuild {:builds [{:source-paths ["target/classes" "target/test-classes"]
                        :id "simple"
                        :compiler {:output-to "target/color-0.1.0-SNAPSHOT.js"
                                   :optimizations :whitespace
                                   :pretty-print true}}]
              :test-commands {"unit-tests" ["phantomjs" :runner "target/color-0.1.0-SNAPSHOT.js"]}}

  :pom-addition [:developers [:developer
                              [:name "Karsten Schmidt"]
                              [:url "http://postspectacular.com"]
                              [:timezone "0"]]])
