(ns thi.ng.color.presets.brewer
  (:require
   [thi.ng.color.core :as col]
   [thi.ng.common.stringformat :as f]))

(def ^:private uniques
  [0x9e0142 0xd53e4f 0xf46d43 0xfdae61 0xfee08b 0xffffbf 0xe6f598 0xabdda4
   0x66c2a5 0x3288bd 0x5e4fa2 0xd7191c 0x2b83ba 0xfc8d59 0x99d594 0x7f3b08
   0xb35806 0xe08214 0xfdb863 0xfee0b6 0xf7f7f7 0xd8daeb 0xb2abd2 0x8073ac
   0x542788 0x2d004b 0xe66101 0x5e3c99 0xf1a340 0x998ec3 0xdeebf7 0x9ecae1
   0x3182bd 0xeff3ff 0xbdd7e7 0x6baed6 0x2171b5 0x08519c 0xc6dbef 0x4292c6
   0x084594 0xf7fbff 0x08306b 0xf7fcb9 0xaddd8e 0x31a354 0xffffcc 0xc2e699
   0x78c679 0x238443 0x006837 0xd9f0a3 0x41ab5d 0x005a32 0xffffe5 0x004529
   0xfee8c8 0xfdbb84 0xe34a33 0xfef0d9 0xfdcc8a 0xd7301f 0xb30000 0xfdd49e
   0xef6548 0x990000 0xfff7ec 0x7f0000 0xe7e1ef 0xc994c7 0xdd1c77 0xf1eef6
   0xd7b5d8 0xdf65b0 0xce1256 0x980043 0xd4b9da 0xe7298a 0x91003f 0xf7f4f9
   0x67001f 0xedf8b1 0x7fcdbb 0x2c7fb8 0xa1dab4 0x41b6c4 0x225ea8 0x253494
   0xc7e9b4 0x1d91c0 0xc2c84 0xffffd9 0x81d58 0xfee6ce 0xfdae6b 0xe6550d
   0xfeedde 0xfdbe85 0xfd8d3c 0xd94701 0xa63603 0xfdd0a2 0xf16913 0xd94801
   0x8c2d04 0xfff5eb 0x7f2704 0xe0f3db 0xa8ddb5 0x43a2ca 0xf0f9e8 0xbae4bc
   0x7bccc4 0x2b8cbe 0x868ac 0xccebc5 0x4eb3d3 0x8589e 0xf7fcf0 0x84081
   0xe5f5e0 0xa1d99b 0xedf8e9 0xbae4b3 0x74c476 0x238b45 0x6d2c 0xc7e9c0
   0xf7fcf5 0x441b 0xf0f0f0 0xbdbdbd 0x636363 0xcccccc 0x969696 0x525252
   0x252525 0xd9d9d9 0x737373 0xffffff 0x0 0xa50026 0xd73027 0xfee090
   0xe0f3f8 0xabd9e9 0x74add1 0x4575b4 0x313695 0x2c7bb6 0x91bfdb 0xe5f5f9
   0x99d8c9 0x2ca25f 0xedf8fb 0xb2e2e2 0x66c2a4 0xccece6 0x41ae76 0x5824
   0xf7fcfd 0xfc8d62 0x8da0cb 0xe78ac3 0xa6d854 0xffd92f 0xe5c494 0xb3b3b3
   0xd9ef8b 0xa6d96a 0x66bd63 0x1a9850 0x1a9641 0x91cf60 0xece2f0 0xa6bddb
   0x1c9099 0xf6eff7 0xbdc9e1 0x67a9cf 0x2818a 0x16c59 0xd0d1e6 0x3690c0
   0x16450 0xfff7fb 0x14636 0xfff7bc 0xfec44f 0xd95f0e 0xffffd4 0xfed98e
   0xfe9929 0xcc4c02 0x993404 0xfee391 0xec7014 0x662506 0x40004b 0x762a83
   0x9970ab 0xc2a5cf 0xe7d4e8 0xd9f0d3 0xa6dba0 0x5aae61 0x1b7837 0x7b3294
   0x8837 0xaf8dc3 0x7fbf7b 0xe41a1c 0x377eb8 0x4daf4a 0x984ea3 0xff7f00
   0xffff33 0xa65628 0xf781bf 0x999999 0xffeda0 0xfeb24c 0xf03b20 0xffffb2
   0xfecc5c 0xe31a1c 0xbd0026 0xfed976 0xfc4e2a 0xb10026 0x800026 0xece7f2
   0x74a9cf 0x570b0 0x45a8d 0x34e7b 0x23858 0xb2182b 0xd6604d 0xf4a582
   0xfddbc7 0xe0e0e0 0xbababa 0x878787 0x4d4d4d 0x1a1a1a 0xca0020 0x404040
   0xef8a62 0x543005 0x8c510a 0xbf812d 0xdfc27d 0xf6e8c3 0xf5f5f5 0xc7eae5
   0x80cdc1 0x35978f 0x1665e 0x3c30 0xa6611a 0x18571 0xd8b365 0x5ab4ac
   0xfee0d2 0xfc9272 0xde2d26 0xfee5d9 0xfcae91 0xfb6a4a 0xcb181d 0xa50f15
   0xfcbba1 0xef3b2c 0x99000d 0xfff5f0 0x67000d 0xd1e5f0 0x92c5de 0x4393c3
   0x2166ac 0x53061 0x571b0 0xa6cee3 0x1f78b4 0xb2df8a 0x33a02c 0xfb9a99
   0xfdbf6f 0xcab2d6 0x6a3d9a 0xffff99 0xb15928 0x1b9e77 0xd95f02 0x7570b3
   0x66a61e 0xe6ab02 0xa6761d 0x666666 0xe0ecf4 0x9ebcda 0x8856a7 0xb3cde3
   0x8c96c6 0x88419d 0x810f7c 0xbfd3e6 0x8c6bb1 0x6e016b 0x4d004b 0x8e0152
   0xc51b7d 0xde77ae 0xf1b6da 0xfde0ef 0xe6f5d0 0xb8e186 0x7fbc41 0x4d9221
   0x276419 0xd01c8b 0x4dac26 0xe9a3c9 0xa1d76a 0x7fc97f 0xbeaed4 0xfdc086
   0x386cb0 0xf0027f 0xbf5b17 0xfbb4ae 0xdecbe4 0xfed9a6 0xe5d8bd 0xfddaec
   0xf2f2f2 0xefedf5 0xbcbddc 0x756bb1 0xf2f0f7 0xcbc9e2 0x9e9ac8 0x6a51a3
   0x54278f 0xdadaeb 0x807dba 0x4a1486 0xfcfbfd 0x3f007d 0xfde0dd 0xfa9fb5
   0xc51b8a 0xfeebe2 0xfbb4b9 0xf768a1 0xae017e 0x7a0177 0xfcc5c0 0xdd3497
   0xfff7f3 0x49006a 0xb3e2cd 0xfdcdac 0xcbd5e8 0xf4cae4 0xe6f5c9 0xfff2ae
   0xf1e2cc 0x8dd3c7 0xffffb3 0xbebada 0xfb8072 0x80b1d3 0xfdb462 0xb3de69
   0xfccde5 0xbc80bd 0xffed6f])

(def ^:private schemes
  {:accent
   {:3 [325 326 327]
    :4 [325 326 327 291]
    :5 [325 326 327 291 328]
    :6 [325 326 327 291 328 329]
    :7 [325 326 327 291 328 329 330]
    :8 [325 326 327 291 328 329 330 299]}
   :blue-green
   {:3 [151 152 153]
    :4 [154 155 156 125]
    :5 [154 155 156 153 126]
    :6 [154 157 152 156 153 126]
    :7 [154 157 152 156 158 125 159]
    :8 [160 151 157 152 156 158 125 159]
    :9 [160 151 157 152 156 158 125 126 129]}
   :blue-purple
   {:3 [300 301 302]
    :4 [154 303 304 305]
    :5 [154 303 304 302 306]
    :6 [154 307 301 304 302 306]
    :7 [154 307 301 304 308 305 309]
    :8 [160 300 307 301 304 308 305 309]
    :9 [160 300 307 301 304 308 305 306 310]}
   :blues
   {:3 [30 31 32]
    :4 [33 34 35 36]
    :5 [33 34 35 32 37]
    :6 [33 38 31 35 32 37]
    :7 [33 38 31 35 39 36 40]
    :8 [41 30 38 31 35 39 36 40]
    :9 [41 30 38 31 35 39 36 37 42]}
   :brown-blue-green
   {:3 [262 254 263]
    :4 [260 252 256 261]
    :5 [260 252 254 256 261]
    :6 [250 262 253 255 263 258]
    :7 [250 262 253 254 255 263 258]
    :8 [250 251 252 253 255 256 257 258]
    :9 [250 251 252 253 254 255 256 257 258]
    :10 [249 250 251 252 253 255 256 257 258 259]
    :11 [249 250 251 252 253 254 255 256 257 258 259]}
   :dark2
   {:3 [293 294 295]
    :4 [293 294 295 77]
    :5 [293 294 295 77 296]
    :6 [293 294 295 77 296 297]
    :7 [293 294 295 77 296 297 298]
    :8 [293 294 295 77 296 297 298 299]}
   :green-blue
   {:3 [107 108 109]
    :4 [110 111 112 113]
    :5 [110 111 112 109 114]
    :6 [110 115 108 112 109 114]
    :7 [110 115 108 112 116 113 117]
    :8 [118 107 115 108 112 116 113 117]
    :9 [118 107 115 108 112 116 113 114 119]}
   :greens
   {:3 [120 121 45]
    :4 [122 123 124 125]
    :5 [122 123 124 45 126]
    :6 [122 127 121 124 45 126]
    :7 [122 127 121 124 52 125 53]
    :8 [128 120 127 121 124 52 125 53]
    :9 [128 120 127 121 124 52 125 126 129]}
   :greys
   {:3 [130 131 132]
    :4 [20 133 134 135]
    :5 [20 133 134 132 136]
    :6 [20 137 131 134 132 136]
    :7 [20 137 131 134 138 135 136]
    :8 [139 130 137 131 134 138 135 136]
    :9 [139 130 137 131 134 138 135 136 140]}
   :orange-red
   {:3 [56 57 58]
    :4 [59 60 13 61]
    :5 [59 60 13 58 62]
    :6 [59 63 57 13 58 62]
    :7 [59 63 57 13 64 61 65]
    :8 [66 56 63 57 13 64 61 65]
    :9 [66 56 63 57 13 64 61 62 67]}
   :oranges
   {:3 [93 94 95]
    :4 [96 97 98 99]
    :5 [96 97 98 95 100]
    :6 [96 101 94 98 95 100]
    :7 [96 101 94 98 102 103 104]
    :8 [105 93 101 94 98 102 103 104]
    :9 [105 93 101 94 98 102 103 100 106]}
   :paired
   {:10 [283 284 285 286 287 225 288 215 289 290]
    :11 [283 284 285 286 287 225 288 215 289 290 291]
    :12 [283 284 285 286 287 225 288 215 289 290 291 292]
    :3 [283 284 285]
    :4 [283 284 285 286]
    :5 [283 284 285 286 287]
    :6 [283 284 285 286 287 225]
    :7 [283 284 285 286 287 225 288]
    :8 [283 284 285 286 287 225 288 215]
    :9 [283 284 285 286 287 225 288 215 289]}
   :pastel1
   {:3 [331 303 115]
    :4 [331 303 115 332]
    :5 [331 303 115 332 333]
    :6 [331 303 115 332 333 46]
    :7 [331 303 115 332 333 46 334]
    :8 [331 303 115 332 333 46 334 335]
    :9 [331 303 115 332 333 46 334 335 336]}
   :pastel2
   {:3 [362 363 364]
    :4 [362 363 364 365]
    :5 [362 363 364 365 366]
    :6 [362 363 364 365 366 367]
    :7 [362 363 364 365 366 367 368]
    :8 [362 363 364 365 366 367 368 133]}
   :pink-yellow-green
   {:3 [323 20 324]
    :4 [321 314 317 322]
    :5 [321 314 20 317 322]
    :6 [312 323 315 316 324 319]
    :7 [312 323 315 20 316 324 319]
    :8 [312 313 314 315 316 317 318 319]
    :9 [312 313 314 315 20 316 317 318 319]
    :10 [311 312 313 314 315 316 317 318 319 320]
    :11 [311 312 313 314 315 20 316 317 318 319 320]}
   :purple-blue
   {:3 [231 175 113]
    :4 [71 178 232 233]
    :5 [71 178 232 113 234]
    :6 [71 182 175 232 113 234]
    :7 [71 182 175 232 183 233 235]
    :8 [185 231 182 175 232 183 233 235]
    :9 [185 231 182 175 232 183 233 234 236]}
   :purple-blue-green
   {:3 [174 175 176]
    :4 [177 178 179 180]
    :5 [177 178 179 176 181]
    :6 [177 182 175 179 176 181]
    :7 [177 182 175 179 183 180 184]
    :8 [185 174 182 175 179 183 180 184]
    :9 [185 174 182 175 179 183 180 181 186]}
   :purple-green
   {:3 [209 20 210]
    :4 [207 201 204 208]
    :5 [207 201 20 204 208]
    :6 [199 209 202 203 210 206]
    :7 [199 209 202 20 203 210 206]
    :8 [199 200 201 202 203 204 205 206]
    :9 [199 200 201 202 20 203 204 205 206]
    :10 [198 199 200 201 202 203 204 205 206 129]
    :11 [198 199 200 201 202 20 203 204 205 206 129]}
   :purple-orange
   {:3 [28 20 29]
    :4 [26 18 22 27]
    :5 [26 18 20 22 27]
    :6 [16 28 19 21 29 24]
    :7 [16 28 19 20 21 29 24]
    :8 [16 17 18 19 21 22 23 24]
    :9 [16 17 18 19 20 21 22 23 24]
    :10 [15 16 17 18 19 21 22 23 24 25]
    :11 [15 16 17 18 19 20 21 22 23 24 25]}
   :purple-red
   {:3 [68 69 70]
    :4 [71 72 73 74]
    :5 [71 72 73 70 75]
    :6 [71 76 69 73 70 75]
    :7 [71 76 69 73 77 74 78]
    :8 [79 68 76 69 73 77 74 78]
    :9 [79 68 76 69 73 77 74 75 80]}
   :purples
   {:3 [337 338 339]
    :4 [340 341 342 343]
    :5 [340 341 342 339 344]
    :6 [340 345 338 342 339 344]
    :7 [340 345 338 342 346 343 347]
    :8 [348 337 345 338 342 346 343 347]
    :9 [348 337 345 338 342 346 343 344 349]}
   :red-blue
   {:3 [248 20 179]
    :4 [246 239 278 282]
    :5 [246 239 20 278 282]
    :6 [237 248 240 277 179 280]
    :7 [237 248 240 20 277 179 280]
    :8 [237 238 239 240 277 278 279 280]
    :9 [237 238 239 240 20 277 278 279 280]
    :10 [80 237 238 239 240 277 278 279 280 281]
    :11 [80 237 238 239 240 20 277 278 279 280 281]}
   :red-grey
   {:3 [248 139 219]
    :4 [246 239 242 247]
    :5 [246 239 139 242 247]
    :6 [237 248 240 241 219 244]
    :7 [237 248 240 139 241 219 244]
    :8 [237 238 239 240 241 242 243 244]
    :9 [237 238 239 240 139 241 242 243 244]
    :10 [80 237 238 239 240 241 242 243 244 245]
    :11 [80 237 238 239 240 139 241 242 243 244 245]}
   :red-purple
   {:3 [350 351 352]
    :4 [353 354 355 356]
    :5 [353 354 355 352 357]
    :6 [353 358 351 355 352 357]
    :7 [353 358 351 355 359 356 357]
    :8 [360 350 358 351 355 359 356 357]
    :9 [360 350 358 351 355 359 356 357 361]}
   :red-yellow-blue
   {:3 [13 5 150]
    :4 [11 3 145 149]
    :5 [11 3 5 145 149]
    :6 [142 13 143 144 150 147]
    :7 [142 13 143 5 144 150 147]
    :8 [142 2 3 143 144 145 146 147]
    :9 [142 2 3 143 5 144 145 146 147]
    :10 [141 142 2 3 143 144 145 146 147 148]
    :11 [141 142 2 3 143 5 144 145 146 147 148]}
   :red-yellow-green
   {:3 [13 5 173]
    :4 [11 3 169 172]
    :5 [11 3 5 169 172]
    :6 [142 13 4 168 173 171]
    :7 [142 13 4 5 168 173 171]
    :8 [142 2 3 4 168 169 170 171]
    :9 [142 2 3 4 5 168 169 170 171]
    :10 [141 142 2 3 4 168 169 170 171 50]
    :11 [141 142 2 3 4 5 168 169 170 171 50]}
   :reds
   {:3 [264 265 266]
    :4 [267 268 269 270]
    :5 [267 268 269 266 271]
    :6 [267 272 265 269 266 271]
    :7 [267 272 265 269 273 270 274]
    :8 [275 264 272 265 269 273 270 274]
    :9 [275 264 272 265 269 273 270 271 276]}
   :set1
   {:3 [211 212 213]
    :4 [211 212 213 214]
    :5 [211 212 213 214 215]
    :6 [211 212 213 214 215 216]
    :7 [211 212 213 214 215 216 217]
    :8 [211 212 213 214 215 216 217 218]
    :9 [211 212 213 214 215 216 217 218 219]}
   :set2
   {:3 [8 161 162]
    :4 [8 161 162 163]
    :5 [8 161 162 163 164]
    :6 [8 161 162 163 164 165]
    :7 [8 161 162 163 164 165 166]
    :8 [8 161 162 163 164 165 166 167]}
   :set3
   {:3 [369 370 371]
    :4 [369 370 371 372]
    :5 [369 370 371 372 373]
    :6 [369 370 371 372 373 374]
    :7 [369 370 371 372 373 374 375]
    :8 [369 370 371 372 373 374 375 376]
    :9 [369 370 371 372 373 374 375 376 137]
    :10 [369 370 371 372 373 374 375 376 137 377]
    :11 [369 370 371 372 373 374 375 376 137 377 115]
    :12 [369 370 371 372 373 374 375 376 137 377 115 378]}
   :spectral
   {:10 [0 1 2 3 4 6 7 8 9 10]
    :11 [0 1 2 3 4 5 6 7 8 9 10]
    :3 [13 5 14]
    :4 [11 3 7 12]
    :5 [11 3 5 7 12]
    :6 [1 13 4 6 14 9]
    :7 [1 13 4 5 6 14 9]
    :8 [1 2 3 4 6 7 8 9]
    :9 [1 2 3 4 5 6 7 8 9]}
   :yellow-green
   {:3 [43 44 45]
    :4 [46 47 48 49]
    :5 [46 47 48 45 50]
    :6 [46 51 44 48 45 50]
    :7 [46 51 44 48 52 49 53]
    :8 [54 43 51 44 48 52 49 53]
    :9 [54 43 51 44 48 52 49 50 55]}
   :yellow-green-blue
   {:3 [81 82 83]
    :4 [46 84 85 86]
    :5 [46 84 85 83 87]
    :6 [46 88 82 85 83 87]
    :7 [46 88 82 85 89 86 90]
    :8 [91 81 88 82 85 89 86 90]
    :9 [91 81 88 82 85 89 86 87 92]}
   :yellow-orange-brown
   {:3 [187 188 189]
    :4 [190 191 192 193]
    :5 [190 191 192 189 194]
    :6 [190 195 188 192 189 194]
    :7 [190 195 188 192 196 193 104]
    :8 [54 187 195 188 192 196 193 104]
    :9 [54 187 195 188 192 196 193 194 197]}
   :yellow-orange-red
   {:3 [220 221 222]
    :4 [223 224 98 225]
    :5 [223 224 98 222 226]
    :6 [223 227 221 98 222 226]
    :7 [223 227 221 98 228 225 229]
    :8 [46 220 227 221 98 228 225 229]
    :9 [46 220 227 221 98 228 225 226 230]}})

(defn brewer-scheme-int
  [pallette cls]
  (if-let [cols (get-in schemes [pallette (keyword (str cls))])]
    (mapv uniques cols)))

(defn brewer-scheme-rgb
  [pallette cls]
  (if-let [cols (brewer-scheme-int pallette cls)]
    (mapv #(-> % col/int->rgba (subvec 0 3)) cols)))

(defn brewer-scheme-css
  [pallette cls]
  (if-let [cols (brewer-scheme-int pallette cls)]
    (mapv col/int->hex cols)))

;;;;;;;;;;;; This file autogenerated from src/cljx/thi/ng/color/presets/brewer.cljx
