(defproject thi.ng/color "1.3.0"
  :description  "Cross-platform CLJ/CLJS library for color conversion & manipulation."
  :url          "http://thi.ng/color"
  :license      {:name "Apache Software License 2.0"
                 :url "http://www.apache.org/licenses/LICENSE-2.0"
                 :distribution :repo}
  :scm          {:name "git"
                 :url  "https://github.com/thi-ng/color"}

  :min-lein-version "2.4.0"

  :dependencies [[org.clojure/clojure "1.9.0"]
                 [org.clojure/clojurescript "1.10.339"]
                 [thi.ng/math "0.2.1"]
                 [thi.ng/dstruct "0.2.0"]
                 [thi.ng/typedarrays "0.1.3"]
                 [thi.ng/strf "0.2.2"]
                 [thi.ng/xerror "0.1.0"]]

  :profiles     {:dev {:dependencies [[criterium "0.4.4"]]
                       :plugins      [[lein-cljsbuild "1.1.7"]
                                      [com.cemerick/clojurescript.test "0.3.3"]]
                       :global-vars {*warn-on-reflection* true}
                       :jvm-opts ^:replace []
                       :aliases {"cleantest" ["do" "clean," "test," "cljsbuild" "test"]}}}

  :cljsbuild    {:builds [{:source-paths ["src" "test"]
                           :id "simple"
                           :compiler {:output-to "target/color-1.3.0.js"
                                      :optimizations :whitespace
                                      :pretty-print true}}]
                 :test-commands {"unit-tests" ["phantomjs" :runner "target/color-1.3.0.js"]}}

  :pom-addition [:developers [:developer
                              [:name "Karsten Schmidt"]
                              [:url "http://postspectacular.com"]
                              [:timezone "0"]]])
