(defproject thi.ng/common "0.1.2"
  :description "Shared utility belt for thi.ng projects"
  :url "http://code.thi.ng/common"
  :license {:name "Apache Software License"
            :url "http://www.apache.org/licenses/LICENSE-2.0"}
  :dependencies [[org.clojure/clojure "1.6.0-beta2"]
                 [thi.ng/macromath "0.2.1"]]

  :source-paths ["src/cljx"]
  :test-paths ["target/test-classes"]

  :profiles {:dev {:dependencies [[org.clojure/clojurescript "0.0-2173"]
                                  [criterium "0.4.1"]]
                   :plugins [[com.keminglabs/cljx "0.3.2"]
                             [lein-cljsbuild "1.0.2"]
                             [com.cemerick/clojurescript.test "0.2.2"]
                             [com.cemerick/austin "0.1.4"]]
                   :aliases {"cleantest" ["do" "clean," "cljx" "once," "test," "cljsbuild" "test"]}}}

  :cljx {:builds [{:source-paths ["src/cljx"]
                   :output-path "target/classes"
                   :rules :clj}
                  {:source-paths ["src/cljx"]
                   :output-path "target/classes"
                   :rules :cljs}
                  {:source-paths ["test/cljx"]
                   :output-path "target/test-classes"
                   :rules :clj}
                  {:source-paths ["test/cljx"]
                   :output-path "target/test-classes"
                   :rules :cljs}]}

  :cljsbuild {:builds [{:source-paths ["target/classes" "target/test-classes"]
                        :id "simple"
                        :compiler {:output-to "target/common-0.1.2.js"
                                   :optimizations :whitespace
                                   :pretty-print true}}]
              :test-commands {"unit-tests" ["phantomjs" :runner "target/common-0.1.2.js"]}})
