(ns thi.ng.common.data.graph)

(defprotocol PUnionFind
  (canonical [this p])
  (unified? [this p q])
  (members [this p])
  (add-single [this p])
  (union [this [p q]] [this p q]))

(defrecord DisjointSet [canonical components]
  PUnionFind
  (canonical [this k]
    (or (canonical k) (when (components k) k)))
  (unified? [this k1 k2]
    (= (canonical k1 k1) (canonical k2 k2)))
  (members [this p]
    (components (canonical p)))
  (add-single
    [this x]
    (if-not (canonical x)
      (-> this
          (assoc-in [:canonical x] x)
          (assoc-in [:components x] [x]))
      this))
  (union [this [k1 k2]]
    (union this k1 k2))
  (union [this k1 k2]
    (let [canon1 (canonical k1 k1)
          canon2 (canonical k2 k2)]
      (if (= canon1 canon2)
        this
        (let [comp1 (or (components canon1) [canon1])
              comp2 (or (components canon2) [canon2])
              [canon1 canon2 comp1 comp2] (if (<= (count comp1) (count comp2))
                                            [canon1 canon2 comp1 comp2]
                                            [canon2 canon1 comp2 comp1])
              canonical' (into canonical (for [item comp1] [item canon2]))
              components' (-> components
                              (dissoc canon1)
                              (assoc canon2 (into comp2 comp1)))]
          (assoc this :canonical canonical' :components components'))))))

(defn into-set
  [ds xs]
  (reduce
   (fn [ds x]
     (if (and (sequential? x) (= 2 (count x)))
       (union ds x)
       (add-single ds x)))
   ds xs))

(defn disjoint-set
  ([] (DisjointSet. {} {}))
  ([xs] (into-set (DisjointSet. {} {}) xs)))

;;;;;;;;;;;; This file autogenerated from src/cljx/thi/ng/common/data/graph.cljx
