(ns thi.ng.common.stringformat
  (:refer-clojure :exclude [float format]))

(def float
  (memoize
   (fn [prec]
                                           
                                                            
            (fn [x] (.toFixed (js/Number. x) prec)))))

(def pad-left
  (memoize
   (fn [len fill]
     (let [fill (apply str (repeat len fill))]
       (fn [x]
         (let [l (count x)]
           (if (< l len) (str (subs fill 0 (- len l)) x) x)))))))

(def pad-right
  (memoize
   (fn [len fill]
     (let [fill (apply str (repeat len fill))]
       (fn [x]
         (let [l (count x)]
           (if (< l len) (str x (subs fill 0 (- len l))) x)))))))

(defn trim-left
  [len]
  (fn [x]
    (let [l (count x)]
      (if (<= l len) x (subs x 0 len)))))

(defn trim-right
  [len]
  (fn [x]
    (let [l (count x)]
      (if (<= l len) x (subs x (- l len))))))

(def date-formats
  (let [d2 (comp (pad-left 2 "0") str)]
    {:yyyy-mm-dd [str "-" d2 "-" d2]
     :yyyy-mm-dd-hh-mm-ss [str "-" d2 "-" d2 " " d2 ":" d2 ":" d2]
     :dd-mm-yyyy [d2 "/" d2 "/" str]
     :dd-mm-yy   [d2 "/" d2 "/" (comp (trim-right 2) str)]}))

     
            
              
                                                
                           
                     
                                             
                                                                    
                      

      
(defn format
  [fmt & args]
  (loop [s [], fmt fmt, args args]
    (if-let [f (first fmt)]
      (if (string? f)
        (recur (conj s f) (next fmt) args)
        (recur (conj s (f (first args))) (next fmt) (next args)))
      (apply str s))))

;;;;;;;;;;;; This file autogenerated from src/cljx/thi/ng/common/stringformat.cljx
