(ns thi.ng.common.stringformat
  (:refer-clojure :exclude [float format]))

     
               
                               
                                                               

     
                
                               
                                                             

     
                 
                         
                                                         

     
                  
                         
                                                           

     
                   
                                       

      
(defn parse-int
  ([x] (parse-int x 10))
  ([x radix & [default]]
     (let [x' (js/parseInt x radix)]
       (if (js/isNaN x') default x'))))

      
(defn parse-float
  [x & [default]]
  (let [x' (js/parseFloat x)]
    (if (js/isNaN x') default x')))

(def float
  (memoize
   (fn [prec]
                                           
                                                            
            (fn [x] (.toFixed (js/Number. x) prec)))))

(def pad-left
  (memoize
   (fn [len fill]
     (let [fill (apply str (repeat len fill))]
       (fn [x]
         (let [l (count x)]
           (if (< l len) (str (subs fill 0 (- len l)) x) x)))))))

(def pad-right
  (memoize
   (fn [len fill]
     (let [fill (apply str (repeat len fill))]
       (fn [x]
         (let [l (count x)]
           (if (< l len) (str x (subs fill 0 (- len l))) x)))))))

(def hex
  (memoize
   (fn [len]
           
     (let [pad (pad-left len "0")]
       (fn [x] (pad (.toString (js/Number. (bit-or x 0)) 16))))
          
                                  
                                                   )))
       
(defn trunc-left
  [len]
  (fn [x]
    (let [l (count x)]
      (if (<= l len) x (subs x 0 len)))))

(defn trunc-right
  [len]
  (fn [x]
    (let [l (count x)]
      (if (<= l len) x (subs x (- l len))))))

(def date-formats
  (let [d2 (comp (pad-left 2 "0") str)]
    {:yyyy-mm-dd [str "-" d2 "-" d2]
     :yyyy-mm-dd-hh-mm-ss [str "-" d2 "-" d2 " " d2 ":" d2 ":" d2]
     :dd-mm-yyyy [d2 "/" d2 "/" str]
     :dd-mm-yy   [d2 "/" d2 "/" (comp (trunc-right 2) str)]}))

     
            
              
                                                
                           
                     
                                             
                                                                    
                      

      
(defn format
  [fmt & args]
  (loop [s [], fmt fmt, args args]
    (if-let [f (first fmt)]
      (if (string? f)
        (recur (conj s f) (next fmt) args)
        (recur (conj s (f (first args))) (next fmt) (next args)))
      (apply str s))))

;;;;;;;;;;;; This file autogenerated from src/cljx/thi/ng/common/stringformat.cljx
