(ns thi.ng.common.stringformat
  (:refer-clojure :exclude [float format]))

     
(defn parse-int
  [^String x radix & [default]]
  (try (Integer/parseInt x radix) (catch Exception e default)))

     
(defn parse-long
  [^String x radix & [default]]
  (try (Long/parseLong x radix) (catch Exception e default)))

     
(defn parse-float
  [^String x & [default]]
  (try (Float/parseFloat x) (catch Exception e default)))

     
(defn parse-double
  [^String x & [default]]
  (try (Double/parseDouble x) (catch Exception e default)))

     
(defn parse-boolean
  [^String x] (Boolean/parseBoolean x))

      
               
                        
                        
                                    
                                       

      
                 
                 
                             
                                   

(def float
  (memoize
   (fn [prec]
            (let [fmt (str "%1." prec "f")]
              (fn [x] (clojure.core/format fmt (double x))))
                                                   )))

(def pad-left
  (memoize
   (fn [len fill]
     (let [fill (apply str (repeat len fill))]
       (fn [x]
         (let [l (count x)]
           (if (< l len) (str (subs fill 0 (- len l)) x) x)))))))

(def pad-right
  (memoize
   (fn [len fill]
     (let [fill (apply str (repeat len fill))]
       (fn [x]
         (let [l (count x)]
           (if (< l len) (str x (subs fill 0 (- len l))) x)))))))

(def hex
  (memoize
   (fn [len]
           
                                  
                                                               
          
     (let [fmt (str "%0" len "x")]
       (fn [x] (clojure.core/format fmt (long x)))))))
       
(defn trunc-left
  [len]
  (fn [x]
    (let [l (count x)]
      (if (<= l len) x (subs x 0 len)))))

(defn trunc-right
  [len]
  (fn [x]
    (let [l (count x)]
      (if (<= l len) x (subs x (- l len))))))

(def date-formats
  (let [d2 (comp (pad-left 2 "0") str)]
    {:yyyy-mm-dd [str "-" d2 "-" d2]
     :yyyy-mm-dd-hh-mm-ss [str "-" d2 "-" d2 " " d2 ":" d2 ":" d2]
     :dd-mm-yyyy [d2 "/" d2 "/" str]
     :dd-mm-yy   [d2 "/" d2 "/" (comp str #(rem % 100))]}))

     
(defn format
  [fmt & args]
  (loop [s (StringBuilder.), fmt fmt, args args]
    (if-let [f (first fmt)]
      (if (string? f)
        (recur (.append s f) (next fmt) args)
        (recur (.append s (f (first args))) (next fmt) (next args)))
      (.toString s))))

      
            
              
                                  
                           
                     
                                          
                                                                 
                      

;;;;;;;;;;;; This file autogenerated from src/cljx/thi/ng/common/stringformat.cljx
