(defproject thi.ng/domus "0.1.0-SNAPSHOT"
  :description "CLJS DOM utils"
  :url "http://thi.ng/domus"
  :license {:name "Apache Software License 2.0"
            :url "http://www.apache.org/licenses/LICENSE-2.0"}
  :dependencies [[org.clojure/clojure "1.6.0"]
                 [org.clojure/clojurescript "0.0-2657"]
                 [org.clojure/core.async "0.1.346.0-17112a-alpha"]
                 [thi.ng/validate "0.1.0-SNAPSHOT"]]

  :profiles {:dev {:plugins [[lein-cljsbuild "1.0.4"]
                             [com.cemerick/clojurescript.test "0.3.3"]]
                   :aliases {"cleantest" ["do" ["cljsbuild" "clean"] ["cljsbuild" "test"]]}}}

  :cljsbuild {:builds [{:source-paths ["src" "test"]
                        :id "dev"
                        :compiler {:output-to "target/domus-0.1.0-SNAPSHOT.js"
                                   :optimizations :whitespace
                                   :pretty-print true}}
                       {:source-paths ["src" "test"]
                        :id "prod"
                        :compiler {:output-to "target/domus-0.1.0-SNAPSHOT.js"
                                   :optimizations :advanced
                                   :pretty-print false}}]
              :test-commands {"unit-tests" ["phantomjs" :runner "target/domus-0.1.0-SNAPSHOT.js"]}}

  :pom-addition [:developers [:developer
                              [:name "Karsten Schmidt"]
                              [:url "http://postspectacular.com"]
                              [:timezone "0"]]])
