(ns thi.ng.domus.log
 (:require
  [clojure.string]))

(defmacro deflogfn
  [fn-name level]
  (let [prefix (.toUpperCase (name fn-name))]
    `(defn ~fn-name
       [& msg#]
       (when (<= ~'log-level ~level)
         (.log js/console (js/Date.) (clojure.string/join " " (cons ~prefix msg#)))))))
