(ns thi.ng.domus.utils
 (:require
  [thi.ng.common.stringformat :as f]
  [clojure.string :as str]))

(def html-entities
  {\& "&amp;"
   \< "&lt;"
   \> "&gt;"
   \" "&quot;"})

(defn as-str [x]
  (if (or (keyword? x) (symbol? x))
    (name x)
    (str x)))

(defn escape-html
  [x] (str/escape (as-str x) html-entities))

(defn parse-int
  ([x] (parse-int x 10 nil))
  ([x radix nf]
     (let [x' (js/parseInt x radix)]
       (if (js/isNaN x') nf x'))))

(defn parse-float
  ([x] (parse-float x nil))
  ([x nf]
     (let [x' (js/parseFloat x)]
       (if (js/isNaN x') nf x'))))

(def ^:private time-format
  (let [d2 (comp (f/pad-left 2 "0") str)]
    [d2 ":" d2 ":" d2]))

(defn format-date
  [d]
  (f/format
   (:yyyy-mm-dd f/date-formats)
   (.getFullYear d)
   (inc (.getMonth d))
   (.getDate d)))

(defn format-time
  [d]
  (f/format
   (:hh-mm-ss f/date-formats)
   (.getHours d)
   (.getMinutes d)
   (.getSeconds d)))

(defn format-date-time
  [d] (str (format-date d) " " (format-time d)))

(defn now
  [] (.getTime (js/Date.)))

(def ^:private format-16bit-hex (f/pad-left 4 "0"))

(defn rand-bits
  [bits] (int (* (rand) (bit-shift-left 1 bits))))

(defn rand-bits-hex
  [bits] ((f/pad-left (Math/ceil (/ bits 4)) "0") (.toString (rand-bits bits) 16)))

(defn rand-16bits-hex
  [] (format-16bit-hex (.toString (rand-int 0x10000) 16)))

(defn new-uuid
  []
  (str
   (rand-16bits-hex) (rand-16bits-hex)
   "-" (rand-16bits-hex)
   "-" (-> (rand-bits 16) (bit-and 0x0fff) (bit-or 0x4000) (.toString 16) (format-16bit-hex))
   "-" (-> (rand-bits 16) (bit-and 0x3fff) (bit-or 0x8000) (.toString 16) (format-16bit-hex))
   "-" (rand-16bits-hex) (rand-16bits-hex) (rand-16bits-hex)))
