(ns thi.ng.dstruct.bidirindex)

(defprotocol PIndex
  (index-item [_ item])
  (unindex-item [_ item])
  (reindex-item [_ old new]))

(defrecord BidirIndex [v->id id->v id-gen]
  PIndex
  (index-item
      [_ item]
    (let [id (get v->id item)]
      (if id
        [_ id]
        (let [id (id-gen)]
          [(BidirIndex.
            (assoc v->id item id)
            (assoc id->v id item)
            id-gen)
           id]))))
  (unindex-item
      [_ item]
    (let [id (get v->id item)]
      (if id
        (BidirIndex.
         (dissoc v->id item)
         (dissoc id->v id)
         id-gen)
        _)))
  (reindex-item
      [_ item newitem]
    (let [id (get v->id item)]
      (if id
        (BidirIndex.
         (-> v->id (dissoc item) (assoc newitem id))
         (assoc id->v id newitem)
         id-gen)
        _))))

(defn counter
  ([] (counter 0))
  ([start] (let [id (volatile! (dec start))] #(vswap! id inc))))

(defn bidir-index
  ([] (bidir-index (counter)))
  ([id-gen] (BidirIndex. (hash-map) (hash-map) id-gen))
  ([id-gen items] (reduce #(first (index-item %1 %2)) (bidir-index id-gen) items)))

(defn index-items
  [index coll]
  (reduce
   (fn [[idx ids] v]
     (let [[idx id] (index-item idx v)]
       [idx (conj ids id)]))
   [index []] coll))

(defn index-attribs
  [index attribs]
  (reduce
   (fn [[attr aids] [id v]]
     (let [[idx ids] (index-items (or (get attr id) (bidir-index)) v)]
       [(assoc attr id idx) (assoc aids id ids)]))
   [index {}] attribs))

(defn attrib-values
  [index ids] (mapv (:id->v index) ids))
