(ns thi.ng.fabric.core.utils
  (:require
   [thi.ng.fabric.core :as f]))

#?(:clj
   (defn vertices->dot
     ([path vertices flt]
      (vertices->dot
       path vertices flt
       #(format "%d[label=\"%d (%s)\"];\n" (f/vertex-id %) (f/vertex-id %) %2)))
     ([path vertices flt fmt]
      (->> vertices
           (filter flt)
           (sort-by f/vertex-id)
           (mapcat
            (fn [^thi.ng.fabric.core.Vertex v]
              (if-let [outs (seq @(.-outs v))]
                (let [val @v
                      val (pr-str (if (instance? clojure.lang.IDeref val) @val val))]
                  (->> outs
                       (map
                        (fn [[k [_ opts]]]
                          (str (f/vertex-id v) "->" (f/vertex-id k) "[label=\"" (pr-str opts) "\"];\n")))
                       (cons (fmt v val)))))))
           (apply str)
           (format "digraph g {
  node[color=black,style=filled,fontname=Inconsolata,fontcolor=white,fontsize=9];
  edge[fontname=Inconsolata,fontsize=9];
  ranksep=1;
  overlap=scale;
  %s}")
           (spit path)))))

(defn sorted-vertex-values
  [vertices]
  (->> vertices
       (sort-by f/vertex-id)
       (map (juxt f/vertex-id deref))))
