(defproject thi.ng/fabric-core "0.0.386"
  :description  "Signal/Collect inspired compute graph infrastructure"
  :url          "https://github.com/thi-ng/fabric"
  :license      {:name "Apache Software License 2.0"
                 :url "http://www.apache.org/licenses/LICENSE-2.0"
                 :distribution :repo}
  :scm          {:name "git"
                 :url "https://github.com/thi-ng/fabric"}

  :min-lein-vesion "2.4.0"

  :dependencies [[org.clojure/clojure "1.7.0"]
                 [org.clojure/clojurescript "1.7.107"]
                 [org.clojure/core.async "0.1.346.0-17112a-alpha"]
                 [com.taoensso/timbre "4.0.2"]
                 [cljs-log "0.2.1"]
                 [thi.ng/xerror "0.1.0"]]

  :profiles     {:dev {:dependencies [[criterium "0.4.3"]]
                       :plugins      [[lein-cljsbuild "1.0.6"]
                                      [com.cemerick/clojurescript.test "0.3.3"]]
                       :global-vars  {*warn-on-reflection* true}
                       :jvm-opts ^:replace []
                       :aliases {"cleantest" ["do" "clean," "test," "cljsbuild" "test"]}}}

  :cljsbuild    {:builds [{:source-paths ["src" "test"]
                           :id "dev"
                           :compiler {:output-to "target/fabric-core-0.0.386.js"
                                      :optimizations :whitespace
                                      :pretty-print true}}
                          {:source-paths ["src"]
                           :id "prod"
                           :compiler {:output-to "target/fabric-core-0.0.386.js"
                                      :optimizations :advanced
                                      :pretty-print false}}]
                 :test-commands {"unit-tests" ["phantomjs" :runner "target/fabric-core-0.0.386.js"]}}

  :pom-addition [:developers [:developer
                              [:name "Karsten Schmidt"]
                              [:url "http://thi.ng/fabric"]
                              [:timezone "0"]]])
