(defproject thi.ng/fabric-facts "0.0.376"
  :description  "Signal/Collect inspired compute graph infrastructure - fact graph module"
  :url          "https://github.com/thi-ng/fabric"
  :license      {:name "Apache Software License 2.0"
                 :url "http://www.apache.org/licenses/LICENSE-2.0"
                 :distribution :repo}
  :scm          {:name "git"
                 :url "https://github.com/thi-ng/fabric"}

  :min-lein-vesion "2.4.0"

  :dependencies [[org.clojure/clojure "1.7.0"]
                 [org.clojure/clojurescript "1.7.107"]
                 [thi.ng/fabric-core "0.0.376"]
                 [thi.ng/strf "0.2.1"]
                 [thi.ng/dstruct "0.1.1"]
                 [org.clojure/data.int-map "0.2.1"]]

  :profiles     {:dev {:dependencies [[criterium "0.4.3"]]
                       :plugins      [[lein-cljsbuild "1.0.6"]
                                      [com.cemerick/clojurescript.test "0.3.3"]]
                       :global-vars  {*warn-on-reflection* true}
                       :jvm-opts ^:replace []
                       :aliases {"cleantest" ["do" "clean," "test," "cljsbuild" "test"]}}}

  :cljsbuild    {:builds [{:source-paths ["src" "test"]
                           :id "dev"
                           :compiler {:output-to "target/fabric-facts-0.0.376.js"
                                      :optimizations :whitespace
                                      :pretty-print true}}
                          {:source-paths ["src"]
                           :id "prod"
                           :compiler {:output-to "target/fabric-facts-0.0.376.js"
                                      :optimizations :advanced
                                      :pretty-print false}}]
                 :test-commands {"unit-tests" ["phantomjs" :runner "target/fabric-facts-0.0.376.js"]}}

  :pom-addition [:developers [:developer
                              [:name "Karsten Schmidt"]
                              [:url "http://thi.ng/fabric"]
                              [:timezone "0"]]])
