(ns thi.ng.geom.core.bench
  (:require
   [thi.ng.geom.core :as g]
   [thi.ng.geom.core.vector :as v]
   [thi.ng.common.math.core :as m :refer [TWO_PI *eps*]]
   [thi.ng.common.error :as err]))

      
(enable-console-print!)

      
(defn ^:export bench-op0
  [op iter]
  (let [a (v/vec3 1 2 3)]
    (loop [i iter, total 0]
      (if (> i 0)
        (let [t0 (.getTime (js/Date.))
              _ (loop [j 100000]
                  (when (> j 0)
                    (op a)
                    (recur (- j 1))))
              t (- (.getTime (js/Date.)) t0)]
          ;;(.log js/console t)
          (recur (- i 1) (+ total t)))
        (/ total iter)))))

      
(defn ^:export bench-op1
  [op b iter]
  (let [a (v/vec3 1 2 3)]
    (loop [i iter, total 0]
      (if (> i 0)
        (let [t0 (.getTime (js/Date.))
              _ (loop [j 100000]
                  (when (> j 0)
                    (op a b)
                    (recur (- j 1))))
              t (- (.getTime (js/Date.)) t0)]
          ;;(.log js/console t)
          (recur (- i 1) (+ total t)))
        (/ total iter)))))

      
(defn ^:export bench-op2
  [op b c iter]
  (let [a (v/vec3 1 2 3)]
    (loop [i iter, total 0]
      (if (> i 0)
        (let [t0 (.getTime (js/Date.))
              _ (loop [j 100000]
                  (when (> j 0)
                    (op a b c)
                    (recur (- j 1))))
              t (- (.getTime (js/Date.)) t0)]
          ;;(.log js/console t)
          (recur (- i 1) (+ total t)))
        (/ total iter)))))

      
(defn trace
  [pre args t] (prn pre args t) t)

      
(def bench-version-specs
  [:-
   :v :n :s
   :vv :vn :vs
   :nv :nn :ns
   :sv :sn :ss])

      
(defn bench-op-versions
  [pre op v n s i versions]
  (->> [:- []
        :v [v] :n [n] :s [s]
        :vv [v v] :vn [v n] :vs [v s]
        :nv [n v] :nn [n n] :ns [n s]
        :sv [s v] :sn [s n] :ss [s s]]
       (partition 2)
       (reduce
        (fn [acc [v args]]
          (if (versions v)
            (->> (apply (condp = (count args) 0 bench-op0 1 bench-op1 bench-op2) op (conj args i))
                 (trace pre v)
                 (conj acc))
            (conj acc nil)))
        [pre])
       (interpose ",")
       (apply str)))

      
(defn ^:export bench-op-versions-all
  [pre op v n s i]
  (bench-op-versions pre op v n s i (set bench-version-specs)))

      
(defn ^:export bench-op-versions-all-not-self
  [pre op v n s i]
  (bench-op-versions pre op v n s i (disj (set bench-version-specs) :-)))

      
(defn ^:export bench-all
  [i]
  (let [v (v/vec3 10 20 30)
        n 10
        s [10 20 30]
        add (bench-op-versions-all "+" g/+ v n s i)
        sub (bench-op-versions-all "-" g/- v n s i)
        mul (bench-op-versions-all "*" g/* v n s i)
        div (bench-op-versions-all "/" g/div v n s i)
        madd (bench-op-versions "madd" g/madd v n s i #{:vv :vn :vs :nv :nn :ns})
        dot (bench-op-versions "dot" g/dot v n s i #{:v :s})
        cp  (bench-op-versions "cross" g/cross v n s i #{:v :s})
        norm (bench-op-versions "norm" g/normalize v n s i #{:- :n})
        magsq (bench-op-versions "magsq" g/mag-squared v n s i #{:-})
        dist (bench-op-versions "dist" g/dist-squared v n s i #{:v :s})
        refl (bench-op-versions "refl" g/reflect v n s i #{:v :s})
        min  (bench-op-versions-all-not-self "min" g/min v n s i)
        ;;min  (bench-op-versions "min" g/min v n s i #{:v :s :vv :vs :sv :ss})
        max  (bench-op-versions-all-not-self "max" g/max v n s i)
        ;;max  (bench-op-versions "max" g/max v n s i #{:v :s :vv :vs :sv :ss})
        mix  (bench-op-versions "mix" g/mix v n s i #{:v :n :s :vv :vn :vs :nv :nn :ns :sv :sn :ss})
        ;;mix  (bench-op-versions "mix" g/mix v n s i #{:v :s :vn :sn})
        csv (apply str "op," (interpose "," bench-version-specs))
        csv (apply str csv "\n" (interpose "\n" [add sub mul div madd dot cp norm magsq dist refl min max mix]))
        txt (.createElement js/document "textarea")]
    (.appendChild (.-body js/document) txt)
    (set! (.-value txt) csv)))

;;;;;;;;;;;; This file autogenerated from src/cljx/thi/ng/geom/core/bench.cljx
