(ns thi.ng.geom.core.vectorseq
  (:require
   [thi.ng.common.error :as err]
   [thi.ng.common.math.core :as m]
         [clojure.pprint]))

(defn lookup
  ([v idx start end]
     (if (< -1 idx (- end start))
              (.nth v (+ start idx))
                                    
       (err/key-error! idx)))
  ([v idx start end default]
     (if (< -1 idx (- end start))
              (.nth v (+ start idx))
                                    
       default)))

(deftype VectorSeq
           [^long start ^long end
            ^clojure.lang.PersistentVector v
            _meta]
                              
       clojure.lang.IObj
            
                
(       meta              [_] _meta)
(       withMeta                   [_ m] (VectorSeq. start end v m))

       java.util.concurrent.Callable
       (call [_] (.invoke ^clojure.lang.IFn _))

       java.lang.Runnable
       (run [_] (.invoke ^clojure.lang.IFn _))

       clojure.lang.ILookup
              
(       valAt                [_ k] (lookup v (int k) start end))
(       valAt                [_ k nf] (lookup v (int k) start end nf))

       clojure.lang.IFn
          
(       invoke                [_ idx] (lookup v (int idx) start end))
(       invoke                [_ idx default] (lookup v (int idx) start end default))

     
(applyTo [_ args]
  (let [cnt (count args)]
    (if (= 1 cnt)
      (lookup v (int (first args)) start end)
      (if (== 2 cnt)
        (lookup v (int (first args)) start end (second args))
        (err/arity-error! cnt)))))

      clojure.lang.IEditableCollection
      (asTransient [_]
        (loop [v (transient [])
               idx start]
          (if (== end idx)
            v
            (recur (conj! v (.nth v idx)) (inc idx)))))

       clojure.lang.Associative
       clojure.lang.IPersistentVector
               
(       count               [_] (- end start))
       (length [_] (- end start))

                   
              
(       containsKey                       [_ k] (< -1 k (- end start)))
       (entryAt [_ k] (when-let [v (lookup v (int k) start end)] (clojure.lang.MapEntry. k v)))
       (assoc [_ k v] (.assocN _ (int k) v))
                                              
       (assocN [_ k v']
         (VectorSeq.
          start (if (= k end) (inc end) end)
          (.assocN ^clojure.lang.IPersistentVector v (int (+ start k)) v')
          _meta))
                         
                    
                                            
                                         
                 

      java.util.Collection
      (isEmpty [_] (== 0 (- end start)))
      (iterator [_]
        (let [^java.util.Collection l (->> v seq (drop start) (take (- end start)))]
          (.iterator l)))
      (toArray [_]
        (->> v
             seq
             (drop start)
             (take (- end start))
             to-array))
       (size [_] (- end start))

       clojure.lang.IPersistentCollection
       clojure.lang.Indexed
       clojure.lang.Sequential
       clojure.lang.ISeq
       clojure.lang.Seqable
       java.util.List
                           
            
           
                  
             
               
(       seq             [_] _)
(       empty               [_] (with-meta [] _meta))
(       first               [_]
  (when (< 0 (- end start))
           (.nth v start)
                         ))
(       next              [_]
  (let [cnt (- end start)]
    (when (< 1 cnt)
      (VectorSeq. (inc start) end v _meta))))
       (more [_] (if-let [rst (next _)] rst '()))
(      cons              [_ k]
  (VectorSeq.
   start (inc end)
          (.assocN ^clojure.lang.IPersistentVector v end k)
                          
   _meta))
(      peek              [_]
  (when (< 0 (- end start))
           (.nth v (dec end))
                             ))
(      pop             [_]
  (let [cnt (- end start)]
    (if (< 0 cnt)
      (VectorSeq. start (dec end) v _meta)
      (err/throw! "Cannot pop from an empty vector."))))

(      nth             [_ idx nf] (lookup v idx start end nf))
(      nth             [_ idx] (lookup v idx start end))
       (get [_ idx] (lookup v idx start end))

             
(      equiv               [_ x]
  (and
   (sequential? x)
   (== (count _) (count x))
   (loop [idx start, x x]
     (if (== end idx)
       true
       (if (and x
                      (clojure.lang.Util/equiv (.nth v idx) (first x))
                                                 )
         (recur (inc idx) (rest x))
         false)))))

     
(equals [_ x]
  (and
   (sequential? x)
   (== (count _) (count x))
   (loop [idx start, x x]
     (if (== end idx)
       true
       (if (and x (clojure.lang.Util/equals (.nth v idx) (first x)))
         (recur (inc idx) (rest x))
         false)))))

       Comparable
                  
(      compareTo                 [_ x]
  (let [cnt (count x)]
    (if (== (- end start) cnt)
      (- (compare x _))
      (- (- end start) cnt))))

     
(hashCode [_]
  (unchecked-int
   (loop [idx start, h 1]
     (if (== end idx)
       h
       (recur
        (inc idx)
        (unchecked-add-int
         (unchecked-multiply-int 31 h)
         (clojure.lang.Util/hash (.nth v idx))))))))

      clojure.lang.IHashEq
      (hasheq [_]
        (mix-collection-hash
         (unchecked-int
          (loop [idx start, h 1]
            (if (== end idx)
              h
              (recur
               (inc idx)
               (unchecked-add-int
                (unchecked-multiply-int 31 h)
                (clojure.lang.Util/hasheq (.nth v idx)))))))
         (- end start)))

            
                 
                             
                                
                            
               
                    
                        
                                                                
                         
m/PDeltaEquals
(delta=
 [_ o]
 (and (sequential? o)
      (== (count _) (count o))
      (loop [_ _, o o]
        (if _
          (if (m/delta= (first _) (first o))
            (recur (next _) (next o))
            false)
          true))))
(delta=
 [_ o eps]
 (and (sequential? o)
      (== (count _) (count o))
      (loop [_ _, o o]
        (if _
          (if (m/delta= (first _) (first o) eps)
            (recur (next _) (next o))
            false)
          true))))
)

     
(defmethod clojure.pprint/simple-dispatch VectorSeq
  [^VectorSeq o] ((get-method clojure.pprint/simple-dispatch clojure.lang.IPersistentVector) (.-v o)))

     
(defmethod print-method VectorSeq [^VectorSeq o ^java.io.Writer w]
  (.write w (pr-str (vec o))))

(defn vecseq
  ([x] (VectorSeq. 0 (count x) (vec x) nil))
  ([x start end] (VectorSeq. start end (vec x) nil)))

;;;;;;;;;;;; This file autogenerated from src/cljx/thi/ng/geom/core/vectorseq.cljx
