(ns thi.ng.geom.types
  (:require
    [thi.ng.geom.core.vector])
        (:import [thi.ng.geom.core.vector Vec2 Vec3]))

(defrecord Graph [vertices edges])

(defrecord Bezier2 [points])
(defrecord Circle2       [^Vec2 p ^double r]             )
(defrecord Ellipse2       [^Vec2 p ^double rx ^double ry]                 )
(defrecord Line2 [points])
(defrecord LineStrip2 [points])
(defrecord Mesh2 [vertices normals fnormals vnormals edges faces attribs])
(defrecord Path2 [segments])
(defrecord Polygon2 [points])
(defrecord Rect2       [^Vec2 p ^Vec2 size]                )
(defrecord Triangle2 [points])

(defrecord AABB [^Vec3 p size])
(defrecord Cuboid [points])
(defrecord Bezier3 [points])
(defrecord BasicMesh [vertices faces fnormals attribs])
(defrecord GMesh [vertices normals fnormals vnormals edges faces attribs])
(defrecord Line3 [points])
(defrecord LineStrip3 [points])
(defrecord Mesh3 [vertices normals fnormals vnormals edges faces attribs])
(defrecord Plane       [n ^double w]             )
(defrecord Quad3 [points])
(defrecord Sphere       [^Vec3 p ^double r]             )
(defrecord Tetrahedron [points])
(defrecord Triangle3 [points])

;;;;;;;;;;;; This file autogenerated from src/cljx/thi/ng/geom/types.cljx
